/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.context;

import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.ConversationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.context.spi.Context;
import javax.inject.Singleton;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequestEvent;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.context.AbstractContext;
import org.apache.webbeans.context.ApplicationContext;
import org.apache.webbeans.context.ConversationContext;
import org.apache.webbeans.context.CustomContextImpl;
import org.apache.webbeans.context.CustomPassivatingContextImpl;
import org.apache.webbeans.context.DependentContext;
import org.apache.webbeans.context.RequestContext;
import org.apache.webbeans.context.SessionContext;
import org.apache.webbeans.context.SessionContextManager;
import org.apache.webbeans.context.SingletonContext;
import org.apache.webbeans.context.WebBeansContext;
import org.apache.webbeans.context.type.ContextTypes;
import org.apache.webbeans.conversation.ConversationManager;

public final class ContextFactory {
    private static ThreadLocal<RequestContext> requestContext = null;
    private static ThreadLocal<SessionContext> sessionContext = null;
    private static ThreadLocal<ApplicationContext> applicationContext = null;
    private static ThreadLocal<ConversationContext> conversationContext = null;
    private static ThreadLocal<SingletonContext> singletonContext = null;
    private static ThreadLocal<DependentContext> dependentContext = null;
    private static Map<ServletContext, ApplicationContext> currentApplicationContexts = new ConcurrentHashMap<ServletContext, ApplicationContext>();
    private static Map<ServletContext, SingletonContext> currentSingletonContexts = new ConcurrentHashMap<ServletContext, SingletonContext>();
    private static SessionContextManager sessionCtxManager = SessionContextManager.getInstance();
    private static ConversationManager conversationManager = ConversationManager.getInstance();

    private ContextFactory() {
        throw new UnsupportedOperationException();
    }

    public static void initializeThreadLocals() {
        requestContext.remove();
        sessionContext.remove();
        applicationContext.remove();
        conversationContext.remove();
        dependentContext.remove();
        singletonContext.remove();
    }

    public static void initRequestContext(ServletRequestEvent event) {
        HttpServletRequest request;
        RequestContext rq = new RequestContext();
        rq.setActive(true);
        requestContext.set(rq);
        if (event != null && (request = (HttpServletRequest)event.getServletRequest()) != null) {
            HttpSession session = request.getSession(false);
            if (session != null) {
                ContextFactory.initSessionContext(session);
            }
            ContextFactory.initApplicationContext(event.getServletContext());
            ContextFactory.initSingletonContext(event.getServletContext());
        }
    }

    public static Context getCustomContext(Context context) {
        if (BeanManagerImpl.getManager().isPassivatingScope(context.getScope())) {
            return new CustomPassivatingContextImpl(context);
        }
        return new CustomContextImpl(context);
    }

    public static void destroyRequestContext(HttpServletRequest request) {
        if (requestContext != null) {
            RequestContext context = ContextFactory.getRequestContext();
            if (context != null) {
                context.destroy();
            }
            requestContext.remove();
        }
    }

    public static void initSessionContext(HttpSession session) {
        String sessionId = session.getId();
        SessionContext currentSessionContext = sessionCtxManager.getSessionContextWithSessionId(sessionId);
        if (currentSessionContext == null) {
            currentSessionContext = new SessionContext();
            sessionCtxManager.addNewSessionContext(sessionId, currentSessionContext);
        }
        currentSessionContext.setActive(true);
        sessionContext.set(currentSessionContext);
    }

    public static void destroySessionContext(HttpSession session) {
        if (sessionContext != null) {
            SessionContext context = ContextFactory.getSessionContext();
            if (context != null) {
                context.destroy();
            }
            sessionContext.remove();
        }
        sessionCtxManager.destroySessionContextWithSessionId(session.getId());
    }

    public static void initApplicationContext(ServletContext servletContext) {
        if (servletContext != null && currentApplicationContexts.containsKey(servletContext)) {
            applicationContext.set(currentApplicationContexts.get(servletContext));
        } else {
            ApplicationContext currentApplicationContext = new ApplicationContext();
            currentApplicationContext.setActive(true);
            if (servletContext != null) {
                currentApplicationContexts.put(servletContext, currentApplicationContext);
            }
            applicationContext.set(currentApplicationContext);
        }
    }

    public static void destroyApplicationContext(ServletContext servletContext) {
        if (applicationContext != null) {
            ApplicationContext context = ContextFactory.getApplicationContext();
            if (context != null) {
                context.destroy();
            }
            applicationContext.remove();
        }
        if (servletContext != null) {
            currentApplicationContexts.remove(servletContext);
        }
        sessionCtxManager.destroyAllSessions();
        conversationManager.destroyAllConversations();
    }

    public static void initSingletonContext(ServletContext servletContext) {
        if (servletContext != null && currentSingletonContexts.containsKey(servletContext)) {
            singletonContext.set(currentSingletonContexts.get(servletContext));
        } else {
            SingletonContext context = new SingletonContext();
            context.setActive(true);
            if (servletContext != null) {
                currentSingletonContexts.put(servletContext, context);
            }
            singletonContext.set(context);
        }
    }

    public static void destroySingletonContext(ServletContext servletContext) {
        if (singletonContext != null) {
            SingletonContext context = ContextFactory.getSingletonContext();
            if (context != null) {
                context.destroy();
            }
            singletonContext.remove();
        }
        if (servletContext != null) {
            currentSingletonContexts.remove(servletContext);
        }
    }

    public static void initConversationContext(ConversationContext context) {
        if (context == null) {
            if (conversationContext.get() == null) {
                ConversationContext newContext = new ConversationContext();
                newContext.setActive(true);
                conversationContext.set(newContext);
            } else {
                conversationContext.get().setActive(true);
            }
        } else {
            context.setActive(true);
            conversationContext.set(context);
        }
    }

    public static void destroyConversationContext() {
        if (conversationContext != null) {
            ConversationContext context = ContextFactory.getConversationContext();
            if (context != null) {
                context.destroy();
            }
            conversationContext.remove();
        }
    }

    public static WebBeansContext getStandartContext(ContextTypes type) throws ContextNotActiveException {
        AbstractContext context = null;
        switch (type.getCardinal()) {
            case 0: {
                context = ContextFactory.getRequestContext();
                break;
            }
            case 1: {
                context = ContextFactory.getSessionContext();
                break;
            }
            case 2: {
                context = ContextFactory.getApplicationContext();
                break;
            }
            case 3: {
                context = ContextFactory.getConversationContext();
                break;
            }
            case 4: {
                context = ContextFactory.getDependentContext();
                break;
            }
            default: {
                throw new IllegalArgumentException("There is no such a standard context with context id=" + type.getCardinal());
            }
        }
        return context;
    }

    public static WebBeansContext getStandardContext(Class<? extends Annotation> scopeType) {
        AbstractContext context = null;
        if (scopeType.equals(RequestScoped.class)) {
            context = ContextFactory.getRequestContext();
        } else if (scopeType.equals(SessionScoped.class)) {
            context = ContextFactory.getSessionContext();
        } else if (scopeType.equals(ApplicationScoped.class)) {
            context = ContextFactory.getApplicationContext();
        } else if (scopeType.equals(ConversationScoped.class)) {
            context = ContextFactory.getConversationContext();
        } else if (scopeType.equals(Dependent.class)) {
            context = ContextFactory.getDependentContext();
        } else if (scopeType.equals(Singleton.class)) {
            context = ContextFactory.getSingletonContext();
        }
        return context;
    }

    private static RequestContext getRequestContext() {
        return requestContext.get();
    }

    private static SessionContext getSessionContext() {
        return sessionContext.get();
    }

    private static ApplicationContext getApplicationContext() {
        return applicationContext.get();
    }

    private static SingletonContext getSingletonContext() {
        return singletonContext.get();
    }

    private static ConversationContext getConversationContext() {
        return conversationContext.get();
    }

    public static DependentContext getDependentContext() {
        DependentContext dependentCtx = dependentContext.get();
        if (dependentCtx == null) {
            dependentCtx = new DependentContext();
            dependentContext.set(dependentCtx);
        }
        return dependentCtx;
    }

    static {
        requestContext = new ThreadLocal();
        sessionContext = new ThreadLocal();
        applicationContext = new ThreadLocal();
        conversationContext = new ThreadLocal();
        dependentContext = new ThreadLocal();
        singletonContext = new ThreadLocal();
    }
}

