/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.context;

import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.ConversationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import org.apache.webbeans.context.WebBeansContext;
import org.apache.webbeans.context.creational.CreationalContextImpl;
import org.apache.webbeans.context.type.ContextTypes;

public abstract class AbstractContext
implements WebBeansContext {
    protected boolean active;
    protected ContextTypes type;
    protected Map<Contextual<?>, Object> componentInstanceMap = null;
    protected Class<? extends Annotation> scopeType;
    protected Map<Contextual<?>, CreationalContext<?>> creationalContextMap = new ConcurrentHashMap();

    protected AbstractContext() {
    }

    protected AbstractContext(Class<? extends Annotation> scopeType) {
        this.scopeType = scopeType;
        this.setComponentInstanceMap();
    }

    protected AbstractContext(ContextTypes type) {
        this.type = type;
        this.configureScopeType(type);
        this.setComponentInstanceMap();
    }

    private void configureScopeType(ContextTypes type) {
        if (type.equals((Object)ContextTypes.APPLICATION)) {
            this.scopeType = ApplicationScoped.class;
        } else if (type.equals((Object)ContextTypes.SESSION)) {
            this.scopeType = SessionScoped.class;
        } else if (type.equals((Object)ContextTypes.REQUEST)) {
            this.scopeType = RequestScoped.class;
        } else if (type.equals((Object)ContextTypes.DEPENDENT)) {
            this.scopeType = Dependent.class;
        } else if (type.equals((Object)ContextTypes.CONVERSATION)) {
            this.scopeType = ConversationScoped.class;
        } else if (type.equals((Object)ContextTypes.SINGLETON)) {
            this.scopeType = ConversationScoped.class;
        } else {
            throw new IllegalArgumentException("Not known scope type : " + type.toString());
        }
    }

    public <T> T get(Contextual<T> component) {
        this.checkActive();
        return (T)this.componentInstanceMap.get(component);
    }

    public <T> T get(Contextual<T> component, CreationalContext<T> creationalContext) {
        this.checkActive();
        return this.getInstance(component, creationalContext);
    }

    protected <T> T getInstance(Contextual<T> component, CreationalContext<T> creationalContext) {
        CreationalContextImpl cc;
        Object instance = this.componentInstanceMap.get(component);
        if (instance != null) {
            return (T)instance;
        }
        if (creationalContext == null) {
            return null;
        }
        if (creationalContext instanceof CreationalContextImpl && (cc = (CreationalContextImpl)creationalContext).get() != null) {
            instance = cc.get();
        }
        if (instance == null) {
            instance = component.create(creationalContext);
        }
        if (instance != null) {
            this.componentInstanceMap.put(component, instance);
            this.creationalContextMap.put(component, creationalContext);
        }
        return (T)instance;
    }

    private <T> void destroyInstance(Contextual<T> component, T instance, CreationalContext<T> creationalContext) {
        component.destroy(instance, creationalContext);
    }

    @Override
    public void destroy() {
        Set<Map.Entry<Contextual<?>, Object>> entrySet = this.componentInstanceMap.entrySet();
        Iterator<Map.Entry<Contextual<?>, Object>> it = entrySet.iterator();
        Contextual<?> component = null;
        while (it.hasNext()) {
            component = it.next().getKey();
            Object instance = this.componentInstanceMap.get(component);
            CreationalContext<?> cc = this.creationalContextMap.get(component);
            this.destroyInstance(component, instance, cc);
        }
        this.componentInstanceMap.clear();
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public ContextTypes getType() {
        return this.type;
    }

    @Override
    public Map<Contextual<?>, Object> getComponentInstanceMap() {
        return this.componentInstanceMap;
    }

    public Class<? extends Annotation> getScope() {
        return this.scopeType;
    }

    protected abstract void setComponentInstanceMap();

    protected void checkActive() {
        if (!this.active) {
            throw new ContextNotActiveException("WebBeans context with scope annotation @" + this.getScope().getName() + " is not active with respect to the current thread");
        }
    }
}

