/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.component;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import org.apache.webbeans.component.AbstractProducerBean;
import org.apache.webbeans.component.InjectionTargetBean;
import org.apache.webbeans.component.WebBeansType;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.inject.InjectableMethods;
import org.apache.webbeans.util.WebBeansUtil;

public class ProducerMethodBean<T>
extends AbstractProducerBean<T> {
    protected Method creatorMethod;
    protected Method disposalMethod;
    private String passivatingId = null;

    public ProducerMethodBean(InjectionTargetBean<?> parent, Class<T> returnType) {
        super(WebBeansType.PRODUCERMETHOD, returnType, parent);
    }

    public Method getCreatorMethod() {
        return this.creatorMethod;
    }

    public void setCreatorMethod(Method creatorMethod) {
        this.creatorMethod = creatorMethod;
    }

    public Method getDisposalMethod() {
        return this.disposalMethod;
    }

    public void setDisposalMethod(Method disposalMethod) {
        if (this.disposalMethod != null) {
            throw new WebBeansConfigurationException("There are multiple disposal method for producer method component with name : " + this.getName() + " with implementation class " + this.getParent().getReturnType().getName() + " with disposal method name : " + disposalMethod.getName());
        }
        this.disposalMethod = disposalMethod;
    }

    @Override
    public String getId() {
        if (this.passivatingId == null) {
            String id = super.getId();
            this.passivatingId = id + "#" + this.creatorMethod.toGenericString();
        }
        return this.passivatingId;
    }

    public Type[] getActualTypeArguments() {
        Type type = this.creatorMethod.getGenericReturnType();
        if (type instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)type;
            return pType.getActualTypeArguments();
        }
        return new Type[0];
    }

    @Override
    protected T createInstance(CreationalContext<T> creationalContext) {
        Object instance = null;
        instance = this.isProducerSet() ? this.getProducer().produce(creationalContext) : (Object)this.createDefaultInstance(creationalContext);
        this.checkNullInstance(instance);
        this.checkScopeType();
        return (T)instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected T createDefaultInstance(CreationalContext<T> creationalContext) {
        T instance = null;
        Object parentInstance = null;
        CreationalContext parentCreational = null;
        try {
            parentCreational = this.getManager().createCreationalContext((Contextual)this.ownerComponent);
            if (!Modifier.isStatic(this.creatorMethod.getModifiers())) {
                parentInstance = this.getParentInstance(parentCreational);
            }
            InjectableMethods m = new InjectableMethods(this.creatorMethod, parentInstance, this, creationalContext);
            instance = m.doInjection();
            if (!this.getParent().getScope().equals(Dependent.class)) return instance;
        }
        catch (Throwable throwable) {
            if (!this.getParent().getScope().equals(Dependent.class)) throw throwable;
            this.destroyBean(this.getParent(), parentInstance, parentCreational);
            throw throwable;
        }
        this.destroyBean(this.getParent(), parentInstance, parentCreational);
        return instance;
    }

    @Override
    protected void destroyInstance(T instance, CreationalContext<T> creationalContext) {
        this.dispose(instance, creationalContext);
    }

    @Override
    public void dispose(T instance, CreationalContext<T> creationalContext) {
        if (this.isProducerSet()) {
            this.getProducer().dispose(instance);
        } else {
            this.disposeDefault(instance, creationalContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void disposeDefault(T instance, CreationalContext<T> creationalContext) {
        if (this.disposalMethod == null) return;
        Object parentInstance = null;
        CreationalContext parentCreational = null;
        try {
            parentCreational = this.getManager().createCreationalContext((Contextual)this.ownerComponent);
            if (!Modifier.isStatic(this.disposalMethod.getModifiers())) {
                parentInstance = this.getParentInstance(parentCreational);
            }
            InjectableMethods m = new InjectableMethods(this.disposalMethod, parentInstance, this.ownerComponent, creationalContext);
            m.setDisposable(true);
            m.setProducerMethodInstance(instance);
            m.doInjection();
            if (!this.getParent().getScope().equals(Dependent.class)) return;
        }
        catch (Throwable throwable) {
            if (!this.getParent().getScope().equals(Dependent.class)) throw throwable;
            this.destroyBean(this.getParent(), parentInstance, parentCreational);
            throw throwable;
        }
        this.destroyBean(this.getParent(), parentInstance, parentCreational);
    }

    protected void checkNullInstance(Object instance) {
        String errorMessage = "WebBeans producer method : " + this.creatorMethod.getName() + " return type in the component implementation class : " + this.ownerComponent.getReturnType().getName() + " scope type must be @Dependent to create null instance";
        WebBeansUtil.checkNullInstance(instance, this.getScope(), errorMessage);
    }

    protected void checkScopeType() {
        String errorMessage = "WebBeans producer method : " + this.creatorMethod.getName() + " return type in the component implementation class : " + this.ownerComponent.getReturnType().getName() + " with passivating scope @" + this.getScope().getName() + " must be Serializable";
        WebBeansUtil.checkSerializableScopeType(this.getScope(), this.isSerializable(), errorMessage);
    }

    @Override
    public boolean isPassivationCapable() {
        return this.isPassivationCapable(this.creatorMethod.getReturnType(), this.creatorMethod.getModifiers());
    }

    @Override
    public String toString() {
        return super.toString();
    }
}

