/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.ejb.common.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import org.apache.webbeans.component.InjectionTargetWrapper;
import org.apache.webbeans.component.ProducerFieldBean;
import org.apache.webbeans.component.ProducerMethodBean;
import org.apache.webbeans.component.creation.BeanCreator;
import org.apache.webbeans.config.DefinitionUtil;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.ejb.common.component.BaseEjbBean;
import org.apache.webbeans.ejb.common.component.EjbBeanCreatorImpl;
import org.apache.webbeans.event.ObserverMethodImpl;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.portable.AnnotatedElementFactory;
import org.apache.webbeans.portable.events.ProcessAnnotatedTypeImpl;
import org.apache.webbeans.portable.events.generics.GProcessInjectionTarget;
import org.apache.webbeans.portable.events.generics.GProcessProducer;
import org.apache.webbeans.portable.events.generics.GProcessSessionBean;
import org.apache.webbeans.util.WebBeansUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EjbUtility {
    private EjbUtility() {
    }

    public static <T> void fireEvents(Class<T> clazz, BaseEjbBean<T> ejbBean, ProcessAnnotatedType<T> event) {
        WebBeansContext webBeansContext = ejbBean.getWebBeansContext();
        BeanManagerImpl manager = webBeansContext.getBeanManagerImpl();
        AnnotatedElementFactory annotatedElementFactory = webBeansContext.getAnnotatedElementFactory();
        AnnotatedType annotatedType = annotatedElementFactory.newAnnotatedType(clazz);
        ProcessAnnotatedTypeImpl processAnnotatedEvent = (ProcessAnnotatedTypeImpl)event;
        EjbBeanCreatorImpl<T> ejbBeanCreator = new EjbBeanCreatorImpl<T>(ejbBean);
        ejbBeanCreator.checkCreateConditions();
        if (processAnnotatedEvent.isVeto()) {
            return;
        }
        if (processAnnotatedEvent.isModifiedAnnotatedType()) {
            ejbBeanCreator.setMetaDataProvider(BeanCreator.MetaDataProvider.THIRDPARTY);
            ejbBeanCreator.setAnnotatedType(annotatedType);
        }
        ejbBeanCreator.defineSerializable();
        ejbBeanCreator.defineStereoTypes();
        ejbBeanCreator.defineApiType();
        ejbBeanCreator.defineScopeType("Session Bean implementation class : " + clazz.getName() + " stereotypes must declare same @ScopeType annotations", false);
        ejbBeanCreator.defineName(WebBeansUtil.getManagedBeanDefaultName((String)clazz.getSimpleName()));
        ejbBeanCreator.defineQualifier();
        Set producerMethodBeans = ejbBeanCreator.defineProducerMethods();
        EjbUtility.checkProducerMethods(producerMethodBeans, ejbBean);
        Set producerFieldBeans = ejbBeanCreator.defineProducerFields();
        ejbBeanCreator.defineInjectedFields();
        ejbBeanCreator.defineInjectedMethods();
        Set<ObserverMethod<?>> observerMethods = ejbBeanCreator.defineObserverMethods();
        GProcessInjectionTarget processInjectionTargetEvent = webBeansContext.getWebBeansUtil().fireProcessInjectionTargetEvent(ejbBean);
        webBeansContext.getWebBeansUtil().inspectErrorStack("There are errors that are added by ProcessInjectionTarget event observers. Look at logs for further details");
        manager.putInjectionTargetWrapper(ejbBean, new InjectionTargetWrapper(processInjectionTargetEvent.getInjectionTarget()));
        HashMap<ProducerMethodBean, AnnotatedMethod> annotatedMethods = new HashMap<ProducerMethodBean, AnnotatedMethod>();
        for (ProducerMethodBean producerMethod : producerMethodBeans) {
            AnnotatedMethod method = annotatedElementFactory.newAnnotatedMethod(producerMethod.getCreatorMethod(), annotatedType);
            GProcessProducer producerEvent = webBeansContext.getWebBeansUtil().fireProcessProducerEventForMethod(producerMethod, method);
            webBeansContext.getWebBeansUtil().inspectErrorStack("There are errors that are added by ProcessProducer event observers for ProducerMethods. Look at logs for further details");
            annotatedMethods.put(producerMethod, method);
            manager.putInjectionTargetWrapper((Contextual)producerMethod, new InjectionTargetWrapper(producerEvent.getProducer()));
        }
        HashMap<ProducerFieldBean, AnnotatedField> annotatedFields = new HashMap<ProducerFieldBean, AnnotatedField>();
        for (ProducerFieldBean producerField : producerFieldBeans) {
            AnnotatedField field = annotatedElementFactory.newAnnotatedField(producerField.getCreatorField(), annotatedType);
            GProcessProducer producerEvent = webBeansContext.getWebBeansUtil().fireProcessProducerEventForField(producerField, field);
            webBeansContext.getWebBeansUtil().inspectErrorStack("There are errors that are added by ProcessProducer event observers for ProducerFields. Look at logs for further details");
            annotatedFields.put(producerField, field);
            manager.putInjectionTargetWrapper((Contextual)producerField, new InjectionTargetWrapper(producerEvent.getProducer()));
        }
        HashMap observerMethodsMap = new HashMap();
        for (ObserverMethod<?> observerMethod : observerMethods) {
            ObserverMethodImpl impl = (ObserverMethodImpl)observerMethod;
            AnnotatedMethod method = annotatedElementFactory.newAnnotatedMethod(impl.getObserverMethod(), annotatedType);
            observerMethodsMap.put(observerMethod, method);
        }
        GProcessSessionBean processBeanEvent = new GProcessSessionBean(ejbBean, annotatedType, ejbBean.getEjbName(), ejbBean.getEjbType());
        webBeansContext.getBeanManagerImpl().fireEvent((Object)processBeanEvent, new Annotation[0]);
        webBeansContext.getWebBeansUtil().inspectErrorStack("There are errors that are added by ProcessSessionBean event observers for managed beans. Look at logs for further details");
        webBeansContext.getWebBeansUtil().fireProcessProducerMethodBeanEvent(annotatedMethods, annotatedType);
        webBeansContext.getWebBeansUtil().inspectErrorStack("There are errors that are added by ProcessProducerMethod event observers for producer method beans. Look at logs for further details");
        webBeansContext.getWebBeansUtil().fireProcessProducerFieldBeanEvent(annotatedFields);
        webBeansContext.getWebBeansUtil().inspectErrorStack("There are errors that are added by ProcessProducerField event observers for producer field beans. Look at logs for further details");
        webBeansContext.getWebBeansUtil().fireProcessObservableMethodBeanEvent(observerMethodsMap);
        webBeansContext.getWebBeansUtil().inspectErrorStack("There are errors that are added by ProcessObserverMethod event observers for observer methods. Look at logs for further details");
        manager.addBean(ejbBean);
        manager.getBeans().addAll(producerMethodBeans);
        ejbBeanCreator.defineDisposalMethods();
        manager.getBeans().addAll(producerFieldBeans);
    }

    public static <T> void defineSpecializedData(Class<T> clazz, BaseEjbBean<T> ejbBean) {
        String message = "There are errors that are added by %s event observers for %s. Look at logs for further details";
        WebBeansContext webBeansContext = ejbBean.getWebBeansContext();
        BeanManagerImpl manager = webBeansContext.getBeanManagerImpl();
        AnnotatedElementFactory annotatedElementFactory = webBeansContext.getAnnotatedElementFactory();
        AnnotatedType annotatedType = annotatedElementFactory.newAnnotatedType(clazz);
        DefinitionUtil util = webBeansContext.getDefinitionUtil();
        Set producerMethodBeans = util.defineProducerMethods(ejbBean, clazz);
        Set producerFieldBeans = util.defineProducerFields(ejbBean, clazz);
        EjbUtility.checkProducerMethods(producerMethodBeans, ejbBean);
        HashMap<ProducerMethodBean, AnnotatedMethod> annotatedMethods = new HashMap<ProducerMethodBean, AnnotatedMethod>();
        for (ProducerMethodBean producerMethod : producerMethodBeans) {
            AnnotatedMethod method = annotatedElementFactory.newAnnotatedMethod(producerMethod.getCreatorMethod(), annotatedType);
            GProcessProducer producerEvent = webBeansContext.getWebBeansUtil().fireProcessProducerEventForMethod(producerMethod, method);
            webBeansContext.getWebBeansUtil().inspectErrorStack(String.format("There are errors that are added by %s event observers for %s. Look at logs for further details", "ProcessProducer", "ProducerMethods"));
            annotatedMethods.put(producerMethod, method);
            manager.putInjectionTargetWrapper((Contextual)producerMethod, new InjectionTargetWrapper(producerEvent.getProducer()));
        }
        HashMap<ProducerFieldBean, AnnotatedField> annotatedFields = new HashMap<ProducerFieldBean, AnnotatedField>();
        for (ProducerFieldBean producerField : producerFieldBeans) {
            AnnotatedField field = annotatedElementFactory.newAnnotatedField(producerField.getCreatorField(), annotatedType);
            GProcessProducer producerEvent = webBeansContext.getWebBeansUtil().fireProcessProducerEventForField(producerField, field);
            webBeansContext.getWebBeansUtil().inspectErrorStack(String.format("There are errors that are added by %s event observers for %s. Look at logs for further details", "ProcessProducer", "ProducerFields"));
            annotatedFields.put(producerField, field);
            manager.putInjectionTargetWrapper((Contextual)producerField, new InjectionTargetWrapper(producerEvent.getProducer()));
        }
        webBeansContext.getWebBeansUtil().fireProcessProducerMethodBeanEvent(annotatedMethods, annotatedType);
        webBeansContext.getWebBeansUtil().inspectErrorStack(String.format("There are errors that are added by %s event observers for %s. Look at logs for further details", "ProcessProducerMethod", "producer method beans"));
        webBeansContext.getWebBeansUtil().fireProcessProducerFieldBeanEvent(annotatedFields);
        webBeansContext.getWebBeansUtil().inspectErrorStack(String.format("There are errors that are added by %s event observers for %s. Look at logs for further details", "ProcessProducerField", "producer field beans"));
        manager.getBeans().addAll(producerMethodBeans);
        manager.getBeans().addAll(producerFieldBeans);
        util.defineDisposalMethods(ejbBean, clazz);
    }

    private static void checkProducerMethods(Set<ProducerMethodBean<?>> producerMethodBeans, BaseEjbBean<?> bean) {
        for (ProducerMethodBean<?> producerMethodBean : producerMethodBeans) {
            Method producerMethod = producerMethodBean.getCreatorMethod();
            if (Modifier.isStatic(producerMethod.getModifiers()) || EjbUtility.isBusinessMethod(producerMethod, bean)) continue;
            throw new WebBeansConfigurationException("Producer Method Bean must be business method of session bean : " + bean);
        }
    }

    public static boolean isBusinessMethod(Method method, BaseEjbBean<?> bean) {
        List<Class<?>> businessLocals = bean.getBusinessLocalInterfaces();
        for (Class<?> clz : businessLocals) {
            try {
                clz.getMethod(method.getName(), method.getParameterTypes());
                return true;
            }
            catch (SecurityException e) {
                throw new WebBeansException("Security exception", (Throwable)e);
            }
            catch (NoSuchMethodException e) {
            }
        }
        return false;
    }
}

