/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.ejb.common.interceptor;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyFactory;
import javassist.util.proxy.ProxyObject;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.PostActivate;
import javax.ejb.PrePassivate;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.interceptor.AroundInvoke;
import javax.interceptor.InvocationContext;
import org.apache.webbeans.config.OpenWebBeansConfiguration;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.context.ContextFactory;
import org.apache.webbeans.context.creational.CreationalContextImpl;
import org.apache.webbeans.corespi.ServiceLoader;
import org.apache.webbeans.decorator.DelegateHandler;
import org.apache.webbeans.decorator.WebBeansDecoratorConfig;
import org.apache.webbeans.decorator.WebBeansDecoratorInterceptor;
import org.apache.webbeans.ejb.common.component.BaseEjbBean;
import org.apache.webbeans.inject.OWBInjector;
import org.apache.webbeans.intercept.InterceptorData;
import org.apache.webbeans.intercept.InterceptorDataImpl;
import org.apache.webbeans.intercept.InterceptorType;
import org.apache.webbeans.intercept.InterceptorUtil;
import org.apache.webbeans.intercept.InvocationContextImpl;
import org.apache.webbeans.logger.WebBeansLogger;
import org.apache.webbeans.proxy.JavassistProxyFactory;
import org.apache.webbeans.spi.ContextsService;
import org.apache.webbeans.util.SecurityUtil;
import org.apache.webbeans.util.WebBeansUtil;

public class OpenWebBeansEjbInterceptor
implements Serializable {
    private static final long serialVersionUID = -4317127341083031217L;
    private final WebBeansLogger logger = WebBeansLogger.getLogger(OpenWebBeansEjbInterceptor.class);
    private static transient ThreadLocal<BaseEjbBean<?>> threadLocal = new ThreadLocal();
    private static transient ThreadLocal<CreationalContext<?>> threadLocalCreationalContext = new ThreadLocal();
    protected transient Map<Method, List<InterceptorData>> interceptedMethodMap = new WeakHashMap<Method, List<InterceptorData>>();
    protected transient Map<Method, List<InterceptorData>> nonCtxInterceptedMethodMap = new WeakHashMap<Method, List<InterceptorData>>();
    private transient OWBInjector injector;
    private transient Map<Class<?>, BaseEjbBean<?>> resolvedBeans = new HashMap();
    private CreationalContext<?> cc;
    private transient BaseEjbBean<?> contextual;
    private transient BeanManagerImpl manager;
    private CreationalKey ccKey;

    public static void setThreadLocal(BaseEjbBean<?> ejbBean, CreationalContext<?> creationalContext) {
        threadLocal.set(ejbBean);
        threadLocalCreationalContext.set(creationalContext);
    }

    public static void unsetThreadLocal() {
        threadLocal.set(null);
        threadLocalCreationalContext.set(null);
        threadLocal.remove();
        threadLocalCreationalContext.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AroundInvoke
    public Object callToOwbInterceptors(InvocationContext ejbContext) throws Exception {
        boolean requestCreated = false;
        boolean applicationCreated = false;
        boolean requestAlreadyActive = false;
        boolean applicationAlreadyActive = false;
        if (this.logger.wblWillLogDebug()) {
            this.logger.debug("Intercepting EJB method {0} ", new Object[]{ejbContext.getMethod()});
        }
        try {
            int result = this.activateContexts(RequestScoped.class);
            if (result == 1) {
                requestCreated = true;
            } else if (result == -1) {
                requestAlreadyActive = true;
            }
            result = this.activateContexts(ApplicationScoped.class);
            if (result == 1) {
                applicationCreated = true;
            } else if (result == -1) {
                applicationAlreadyActive = true;
            }
            Object object = this.callInterceptorsAndDecorators(ejbContext.getMethod(), ejbContext.getTarget(), ejbContext.getParameters(), ejbContext);
            return object;
        }
        finally {
            if (!requestAlreadyActive) {
                this.deActivateContexts(requestCreated, RequestScoped.class);
            }
            if (!applicationAlreadyActive) {
                this.deActivateContexts(applicationCreated, ApplicationScoped.class);
            }
        }
    }

    public void lifecycleCommon(InvocationContext context, InterceptorType interceptorType) {
        try {
            if (this.contextual != null && WebBeansUtil.isContainsInterceptorMethod((List)this.contextual.getInterceptorStack(), (InterceptorType)interceptorType)) {
                InvocationContextImpl impl = new InvocationContextImpl(this.contextual, context.getTarget(), null, null, InterceptorUtil.getInterceptorMethods((List)this.contextual.getInterceptorStack(), (InterceptorType)interceptorType), interceptorType);
                impl.setCreationalContext(this.cc);
                impl.setEJBInvocationContext(context);
                impl.setCcKey((Object)this.ccKey);
                impl.proceed();
            } else {
                context.proceed();
            }
        }
        catch (Exception e) {
            this.logger.error("ERROR_0008", (Throwable)e, new Object[]{interceptorType});
            throw new RuntimeException(e);
        }
    }

    @PostConstruct
    public void afterConstruct(InvocationContext context) {
        if (this.logger.wblWillLogDebug()) {
            this.logger.debug("entry");
        }
        if (this.manager == null) {
            this.manager = BeanManagerImpl.getManager();
        }
        BaseEjbBean<?> injectionTarget = threadLocal.get();
        this.ccKey = new CreationalKey();
        if (injectionTarget == null) {
            this.contextual = this.findTargetBean(context.getTarget());
            if (this.contextual == null) {
                try {
                    context.proceed();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                return;
            }
        } else {
            this.contextual = injectionTarget;
            OpenWebBeansEjbInterceptor.unsetThreadLocal();
        }
        this.cc = this.manager.createCreationalContext(this.contextual);
        if (this.logger.wblWillLogDebug()) {
            this.logger.debug("manager = {0} interceptor_instance = {1} contextual = {2} ", new Object[]{this.manager, this, this.contextual});
        }
        this.lifecycleCommon(context, InterceptorType.POST_CONSTRUCT);
        if (OpenWebBeansConfiguration.getInstance().isUseEJBInterceptorInjection()) {
            Object instance = context.getTarget();
            this.injector = new OWBInjector();
            try {
                this.injector.inject(instance, this.cc);
            }
            catch (Exception e) {
                this.logger.error("ERROR_0026", (Throwable)e, new Object[]{this.contextual});
            }
        }
    }

    @PreDestroy
    public void preDestroy(InvocationContext context) {
        this.lifecycleCommon(context, InterceptorType.PRE_DESTROY);
        if (this.injector != null) {
            this.injector.destroy();
        }
        this.interceptedMethodMap.clear();
        this.resolvedBeans.clear();
        this.nonCtxInterceptedMethodMap.clear();
        this.cc.release();
    }

    private int activateContexts(Class<? extends Annotation> scopeType) {
        ContextsService service = (ContextsService)ServiceLoader.getService(ContextsService.class);
        Context ctx = service.getCurrentContext(scopeType);
        if (scopeType == RequestScoped.class) {
            if (ctx != null && !ctx.isActive()) {
                ContextFactory.activateContext(scopeType);
                return 0;
            }
            if (ctx == null) {
                ContextFactory.initRequestContext(null);
                return 1;
            }
        }
        if ((ctx = service.getCurrentContext(scopeType)) != null && !ctx.isActive()) {
            ContextFactory.activateContext(scopeType);
            return 0;
        }
        if (ctx == null) {
            ContextFactory.initApplicationContext(null);
            return 1;
        }
        return -1;
    }

    private void deActivateContexts(boolean destroy, Class<? extends Annotation> scopeType) {
        if (scopeType == ApplicationScoped.class) {
            if (destroy) {
                ContextFactory.destroyApplicationContext(null);
            } else {
                ContextFactory.deActivateContext(ApplicationScoped.class);
            }
        } else if (destroy) {
            ContextFactory.destroyRequestContext(null);
        } else {
            ContextFactory.deActivateContext(RequestScoped.class);
        }
    }

    private BaseEjbBean<?> findTargetBean(Object instance) {
        if (instance == null) {
            return null;
        }
        BaseEjbBean ejbBean = this.resolvedBeans.get(instance.getClass());
        if (ejbBean == null) {
            Set beans = this.manager.getComponents();
            for (Bean bean : beans) {
                if (!(bean instanceof BaseEjbBean) || bean.getBeanClass() != instance.getClass()) continue;
                ejbBean = (BaseEjbBean)bean;
                if (this.logger.wblWillLogDebug()) {
                    this.logger.debug("Found managed bean for [{0}] [{1}]", new Object[]{instance.getClass(), ejbBean});
                }
                this.resolvedBeans.put(instance.getClass(), ejbBean);
                break;
            }
        } else if (this.logger.wblWillLogDebug()) {
            this.logger.debug("Managed bean for [{0}] found in cache: [{1}]", new Object[]{instance.getClass(), ejbBean});
        }
        return ejbBean;
    }

    private Object callInterceptorsAndDecorators(Method method, Object instance, Object[] arguments, InvocationContext ejbContext) throws Exception {
        Object rv = null;
        BaseEjbBean<?> injectionTarget = this.contextual;
        InterceptorDataImpl decoratorInterceptorDataImpl = null;
        List decorators = null;
        DelegateHandler delegateHandler = null;
        List decoratorStack = injectionTarget.getDecoratorStack();
        List interceptorStack = injectionTarget.getInterceptorStack();
        if (this.logger.wblWillLogDebug()) {
            this.logger.debug("Decorator stack for target {0}", new Object[]{decoratorStack});
            this.logger.debug("Interceptor stack {0}", new Object[]{interceptorStack});
        }
        if (decoratorStack.size() > 0) {
            Class proxyClass;
            if (this.logger.wblWillLogDebug()) {
                this.logger.debug("Obtaining a delegate");
            }
            if ((proxyClass = (Class)JavassistProxyFactory.getInstance().getInterceptorProxyClasses().get(injectionTarget)) == null) {
                ProxyFactory delegateFactory = JavassistProxyFactory.getInstance().createProxyFactory(injectionTarget);
                proxyClass = JavassistProxyFactory.getInstance().getProxyClass(delegateFactory);
                JavassistProxyFactory.getInstance().getInterceptorProxyClasses().put(injectionTarget, proxyClass);
            }
            Object delegate = proxyClass.newInstance();
            delegateHandler = new DelegateHandler(this.contextual, ejbContext);
            ((ProxyObject)delegate).setHandler((MethodHandler)delegateHandler);
            decorators = WebBeansDecoratorConfig.getDecoratorStack(injectionTarget, (Object)instance, delegate, (CreationalContextImpl)((CreationalContextImpl)this.cc));
            delegateHandler.setDecorators(decorators);
        }
        if (interceptorStack.size() == 0) {
            rv = decoratorStack.size() == 0 ? ejbContext.proceed() : delegateHandler.invoke(instance, method, null, arguments);
        } else {
            ArrayList<InterceptorDataImpl> filteredInterceptorStack;
            if (this.interceptedMethodMap.get(method) == null) {
                filteredInterceptorStack = new ArrayList<InterceptorDataImpl>(interceptorStack);
                InterceptorUtil.filterCommonInterceptorStackList(filteredInterceptorStack, (Method)method);
                InterceptorUtil.filterOverridenAroundInvokeInterceptor((Class)injectionTarget.getBeanClass(), filteredInterceptorStack);
                this.interceptedMethodMap.put(method, filteredInterceptorStack);
            }
            filteredInterceptorStack = new ArrayList(this.interceptedMethodMap.get(method));
            if (delegateHandler != null) {
                WebBeansDecoratorInterceptor lastInterceptor = new WebBeansDecoratorInterceptor(delegateHandler, instance);
                decoratorInterceptorDataImpl = new InterceptorDataImpl(true, lastInterceptor);
                decoratorInterceptorDataImpl.setDefinedInInterceptorClass(true);
                decoratorInterceptorDataImpl.setAroundInvoke(SecurityUtil.doPrivilegedGetDeclaredMethods(lastInterceptor.getClass())[0]);
                filteredInterceptorStack.add(decoratorInterceptorDataImpl);
            }
            rv = InterceptorUtil.callAroundInvokes(this.contextual, (Object)instance, (CreationalContextImpl)((CreationalContextImpl)this.cc), (Method)method, (Object[])arguments, (List)InterceptorUtil.getInterceptorMethods(filteredInterceptorStack, (InterceptorType)InterceptorType.AROUND_INVOKE), (InvocationContext)ejbContext, (Object)this.ccKey);
        }
        return rv;
    }

    @PrePassivate
    public void beforePassivate(InvocationContext context) {
        if (this.logger.wblWillLogDebug()) {
            this.logger.debug("manager = {0} interceptor_instance = {1} contextual = {2} ", new Object[]{this.manager, this, this.contextual});
        }
        this.lifecycleCommon(context, InterceptorType.PRE_PASSIVATE);
    }

    @PostActivate
    public void afterActivate(InvocationContext context) {
        this.contextual = this.findTargetBean(context.getTarget());
        if (this.logger.wblWillLogDebug()) {
            this.logger.debug("manager = {0} interceptor_instance = {1} contextual = {2} ", new Object[]{this.manager, this, this.contextual});
        }
        this.lifecycleCommon(context, InterceptorType.POST_ACTIVATE);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.logger.wblWillLogDebug()) {
            this.logger.debug("manager = {0} interceptor_instance = {1} contextual = {2} ", new Object[]{this.manager, this, this.contextual});
        }
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        if (this.logger.wblWillLogDebug()) {
            this.logger.debug("interceptor instance = " + this.hashCode());
        }
        this.interceptedMethodMap = new WeakHashMap<Method, List<InterceptorData>>();
        this.nonCtxInterceptedMethodMap = new WeakHashMap<Method, List<InterceptorData>>();
        this.resolvedBeans = new HashMap();
        s.defaultReadObject();
        this.manager = BeanManagerImpl.getManager();
        if (this.logger.wblWillLogDebug()) {
            this.logger.debug("manager = {0} interceptor_instance = {1} contextual = {2} ", new Object[]{this.manager, this, this.contextual});
        }
    }

    private class CreationalKey
    implements Serializable {
        private CreationalKey() {
        }
    }
}

