/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.ejb.resource;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import javax.enterprise.inject.Produces;
import org.apache.webbeans.ejb.resource.ResourceFactory;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.logger.WebBeansLogger;
import org.apache.webbeans.spi.ResourceInjectionService;
import org.apache.webbeans.spi.api.ResourceReference;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.SecurityUtil;

public class OpenEjbResourceInjectionService
implements ResourceInjectionService {
    private static final WebBeansLogger logger = WebBeansLogger.getLogger(OpenEjbResourceInjectionService.class);

    public void clear() {
    }

    public <X, T extends Annotation> X getResourceReference(ResourceReference<X, T> resourceReference) {
        try {
            return ResourceFactory.getInstance().getResourceReference(resourceReference);
        }
        catch (Exception e) {
            logger.error("ERROR_0024", (Throwable)e, new Object[]{resourceReference.getResourceType(), resourceReference.getOwnerClass(), resourceReference.getName()});
            throw new WebBeansConfigurationException(MessageFormat.format(logger.getTokenString("ERROR_0024"), resourceReference.getResourceType(), resourceReference.getOwnerClass(), resourceReference.getName()), (Throwable)e);
        }
    }

    public void injectJavaEEResources(Object managedBeanInstance) throws Exception {
        Field[] fields;
        for (Field field : fields = SecurityUtil.doPrivilegedGetDeclaredFields(managedBeanInstance.getClass())) {
            Annotation ann;
            if (field.isAnnotationPresent(Produces.class) || Modifier.isStatic(field.getModifiers()) || (ann = AnnotationUtil.hasOwbInjectableResource((Annotation[])field.getDeclaredAnnotations())) == null) continue;
            ResourceReference resourceRef = new ResourceReference(field.getDeclaringClass(), field.getName(), field.getType(), ann);
            boolean acess = field.isAccessible();
            try {
                SecurityUtil.doPrivilegedSetAccessible((AccessibleObject)field, (boolean)true);
                field.set(managedBeanInstance, this.getResourceReference(resourceRef));
            }
            catch (Exception e) {
                logger.error("ERROR_0025", (Throwable)e, new Object[]{field});
                throw new WebBeansException(MessageFormat.format(logger.getTokenString("ERROR_0025"), field), (Throwable)e);
            }
            finally {
                SecurityUtil.doPrivilegedSetAccessible((AccessibleObject)field, (boolean)acess);
            }
        }
    }
}

