/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.ee.event;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.event.TransactionPhase;
import javax.enterprise.inject.spi.EventMetadata;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.event.OwbObserverMethod;
import org.apache.webbeans.logger.WebBeansLoggerFacade;
import org.apache.webbeans.spi.TransactionService;

public final class TransactionalEventNotifier {
    private static final Logger logger = WebBeansLoggerFacade.getLogger(TransactionalEventNotifier.class);

    private TransactionalEventNotifier() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void registerTransactionSynchronization(TransactionPhase phase, ObserverMethod<? super Object> observer, Object event, EventMetadata metadata) throws Exception {
        TransactionService transactionService = (TransactionService)WebBeansContext.currentInstance().getService(TransactionService.class);
        Transaction transaction = null;
        if (transactionService != null) {
            transaction = transactionService.getTransaction();
        }
        if (transaction != null) {
            if (phase.equals((Object)TransactionPhase.AFTER_COMPLETION)) {
                transaction.registerSynchronization((Synchronization)new AfterCompletion(observer, event, metadata));
                return;
            } else if (phase.equals((Object)TransactionPhase.AFTER_SUCCESS)) {
                transaction.registerSynchronization((Synchronization)new AfterCompletionSuccess(observer, event, metadata));
                return;
            } else if (phase.equals((Object)TransactionPhase.AFTER_FAILURE)) {
                transaction.registerSynchronization((Synchronization)new AfterCompletionFailure(observer, event, metadata));
                return;
            } else {
                if (!phase.equals((Object)TransactionPhase.BEFORE_COMPLETION)) throw new IllegalStateException(WebBeansLoggerFacade.getTokenString((String)"EXCEPT_0007") + phase);
                transaction.registerSynchronization((Synchronization)new BeforeCompletion(observer, event, metadata));
            }
            return;
        } else if (observer instanceof OwbObserverMethod) {
            ((OwbObserverMethod)observer).notify(event, metadata);
            return;
        } else {
            observer.notify(event);
        }
    }

    private static final class AfterCompletionFailure
    extends AbstractSynchronization {
        private AfterCompletionFailure(ObserverMethod observer, Object event, EventMetadata metadata) {
            super(observer, event, metadata);
        }

        @Override
        public void afterCompletion(int i) {
            if (i != 3) {
                this.notifyObserver();
            }
        }
    }

    private static final class AfterCompletionSuccess
    extends AbstractSynchronization {
        private AfterCompletionSuccess(ObserverMethod observer, Object event, EventMetadata metadata) {
            super(observer, event, metadata);
        }

        @Override
        public void afterCompletion(int i) {
            if (i == 3) {
                this.notifyObserver();
            }
        }
    }

    private static final class AfterCompletion
    extends AbstractSynchronization {
        private AfterCompletion(ObserverMethod observer, Object event, EventMetadata metadata) {
            super(observer, event, metadata);
        }

        @Override
        public void afterCompletion(int i) {
            this.notifyObserver();
        }
    }

    private static final class BeforeCompletion
    extends AbstractSynchronization {
        private BeforeCompletion(ObserverMethod observer, Object event, EventMetadata metadata) {
            super(observer, event, metadata);
        }

        @Override
        public void beforeCompletion() {
            this.notifyObserver();
        }
    }

    private static class AbstractSynchronization<T>
    implements Synchronization {
        private final ObserverMethod<T> observer;
        private final T event;
        private final EventMetadata metadata;

        public AbstractSynchronization(ObserverMethod<T> observer, T event, EventMetadata metadata) {
            this.observer = observer;
            this.event = event;
            this.metadata = metadata;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int i) {
        }

        public void notifyObserver() {
            try {
                if (this.observer instanceof OwbObserverMethod) {
                    ((OwbObserverMethod)this.observer).notify(this.event, this.metadata);
                } else {
                    this.observer.notify(this.event);
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "ERROR_0003", e);
            }
        }
    }
}

