/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.meta;

import java.util.Collection;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.StringDistance;
import org.apache.openjpa.lib.util.collections.TreeBidiMap;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.MetaDataContext;
import org.apache.openjpa.util.MetaDataException;

public class ValueStrategies {
    public static final int NONE = 0;
    public static final int NATIVE = 1;
    public static final int SEQUENCE = 2;
    public static final int AUTOASSIGN = 3;
    public static final int INCREMENT = 4;
    public static final int UUID_STRING = 5;
    public static final int UUID_HEX = 6;
    public static final int UUID_TYPE4_STRING = 7;
    public static final int UUID_TYPE4_HEX = 8;
    public static final int UUID_JPA = 9;
    public static final int UUID_TYPE4_CANON = 10;
    private static final Localizer _loc = Localizer.forPackage(ValueStrategies.class);
    private static final TreeBidiMap _map = new TreeBidiMap();

    public static String getName(int strategy) {
        Integer code = strategy;
        String name = (String)((Object)_map.getKey((Object)code));
        if (name != null) {
            return name;
        }
        throw new IllegalArgumentException(((Object)code).toString());
    }

    public static int getCode(String val, Object context) {
        if (val == null) {
            return 0;
        }
        Comparable code = _map.get((Object)val);
        if (code != null) {
            return ((Number)((Object)code)).intValue();
        }
        String closest = StringDistance.getClosestLevenshteinDistance((String)val, (Collection)_map.keySet(), (float)0.5f);
        String msg = closest != null ? _loc.get("bad-value-strategy-hint", new Object[]{context, val, closest, _map.keySet()}).getMessage() : _loc.get("bad-value-strategy", context, (Object)val, (Object)_map.keySet()).getMessage();
        throw new IllegalArgumentException(msg);
    }

    public static void assertSupported(int strategy, MetaDataContext context, String attributeName) {
        OpenJPAConfiguration conf = context.getRepository().getConfiguration();
        boolean supported = true;
        switch (strategy) {
            case 3: {
                supported = conf.supportedOptions().contains("openjpa.option.AutoassignValue");
                break;
            }
            case 4: {
                supported = conf.supportedOptions().contains("openjpa.option.IncrementValue");
                break;
            }
            case 1: {
                supported = context instanceof ClassMetaData;
            }
        }
        if (!supported) {
            throw new MetaDataException(_loc.get("unsupported-value-strategy", (Object)context, (Object)ValueStrategies.getName(strategy), (Object)attributeName));
        }
    }

    static {
        _map.put((Comparable)((Object)"none"), (Comparable)Integer.valueOf(0));
        _map.put((Comparable)((Object)"native"), (Comparable)Integer.valueOf(1));
        _map.put((Comparable)((Object)"sequence"), (Comparable)Integer.valueOf(2));
        _map.put((Comparable)((Object)"autoassign"), (Comparable)Integer.valueOf(3));
        _map.put((Comparable)((Object)"increment"), (Comparable)Integer.valueOf(4));
        _map.put((Comparable)((Object)"uuid-string"), (Comparable)Integer.valueOf(5));
        _map.put((Comparable)((Object)"uuid-hex"), (Comparable)Integer.valueOf(6));
        _map.put((Comparable)((Object)"uuid-type4-string"), (Comparable)Integer.valueOf(7));
        _map.put((Comparable)((Object)"uuid-type4-hex"), (Comparable)Integer.valueOf(8));
        _map.put((Comparable)((Object)"uuid-jpa"), (Comparable)Integer.valueOf(9));
        _map.put((Comparable)((Object)"uuid-type4-canon"), (Comparable)Integer.valueOf(10));
    }
}

