/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.enhance;

import java.util.BitSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.enhance.DynamicStorage;
import org.apache.openjpa.enhance.DynamicStorageGenerator;
import org.apache.openjpa.kernel.AbstractPCData;
import org.apache.openjpa.kernel.FetchConfiguration;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.kernel.PCData;
import org.apache.openjpa.kernel.StoreContext;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.StringUtil;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.asm.AsmHelper;
import org.apache.openjpa.util.asm.ClassNodeTracker;
import org.apache.xbean.asm9.Type;
import org.apache.xbean.asm9.tree.AbstractInsnNode;
import org.apache.xbean.asm9.tree.ClassNode;
import org.apache.xbean.asm9.tree.FieldInsnNode;
import org.apache.xbean.asm9.tree.FieldNode;
import org.apache.xbean.asm9.tree.InsnList;
import org.apache.xbean.asm9.tree.InsnNode;
import org.apache.xbean.asm9.tree.JumpInsnNode;
import org.apache.xbean.asm9.tree.LabelNode;
import org.apache.xbean.asm9.tree.LookupSwitchInsnNode;
import org.apache.xbean.asm9.tree.MethodInsnNode;
import org.apache.xbean.asm9.tree.MethodNode;
import org.apache.xbean.asm9.tree.TypeInsnNode;
import org.apache.xbean.asm9.tree.VarInsnNode;

public class PCDataGenerator
extends DynamicStorageGenerator {
    private static final Localizer _loc = Localizer.forPackage(PCDataGenerator.class);
    protected static final String POSTFIX = "$openjpapcdata";
    private final Map<Class<?>, DynamicStorage> _generated = new ConcurrentHashMap();
    private final OpenJPAConfiguration _conf;
    private final Log _log;

    public PCDataGenerator(OpenJPAConfiguration conf) {
        this._conf = conf;
        this._log = this._conf.getLogFactory().getLog("openjpa.Enhance");
    }

    public OpenJPAConfiguration getConfiguration() {
        return this._conf;
    }

    public PCData generatePCData(Object oid, ClassMetaData meta) {
        if (meta == null) {
            return null;
        }
        Class<?> type = meta.getDescribedType();
        DynamicStorage storage = this._generated.get(type);
        if (storage == null) {
            storage = this.generateStorage(meta);
            this._generated.put(type, storage);
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)_loc.get("pcdata-created", (Object)type.getName(), (Object)meta));
            }
        }
        DynamicPCData data = (DynamicPCData)((Object)storage.newInstance());
        data.setId(oid);
        data.setStorageGenerator(this);
        this.finish(data, meta);
        return data;
    }

    private DynamicStorage generateStorage(ClassMetaData meta) {
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)_loc.get("pcdata-generate", (Object)meta));
        }
        FieldMetaData[] fields = meta.getFields();
        int[] types = new int[fields.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = this.replaceType(fields[i]);
        }
        return this.generateStorage(types, meta);
    }

    protected void finish(DynamicPCData data, ClassMetaData meta) {
    }

    @Override
    protected int getCreateFieldMethods(int typeCode) {
        if (typeCode >= 8) {
            return 2;
        }
        return 1;
    }

    @Override
    protected void declareClasses(ClassNodeTracker bc) {
        super.declareClasses(bc);
        bc.declareInterface(DynamicPCData.class);
        bc.getClassNode().superName = Type.getInternalName(AbstractPCData.class);
    }

    @Override
    protected final String getClassName(Object obj) {
        return this.getUniqueName(((ClassMetaData)obj).getDescribedType());
    }

    protected String getUniqueName(Class<?> type) {
        return type.getName() + "$" + System.identityHashCode(type) + POSTFIX;
    }

    @Override
    protected final void decorate(Object obj, ClassNodeTracker bc, int[] types) {
        super.decorate(obj, bc, types);
        ClassMetaData meta = (ClassMetaData)obj;
        this.enhanceConstructor(bc);
        this.addBaseFields(bc);
        this.addImplDataMethods(bc, meta);
        this.addGetType(bc, meta);
        this.addVersionMethods(bc);
        this.addFieldImplDataMethods(bc, meta);
        this.addLoadMethod(bc, meta);
        this.addLoadWithFieldsMethod(bc, meta);
        this.addStoreMethods(bc, meta);
        this.addNewEmbedded(bc);
        this.addGetData(bc);
        this.decorate(bc, meta);
    }

    protected void decorate(ClassNodeTracker bc, ClassMetaData meta) {
    }

    private void enhanceConstructor(ClassNodeTracker bc) {
        ClassNode classNode = bc.getClassNode();
        MethodNode defaultCt = classNode.methods.stream().filter(m -> m.name.equals("<init>") && m.desc.equals("()V")).findFirst().get();
        InsnList instructions = new InsnList();
        FieldNode loaded = this.addBeanField(bc, "loaded", BitSet.class);
        instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        instructions.add((AbstractInsnNode)new TypeInsnNode(187, Type.getInternalName(BitSet.class)));
        instructions.add((AbstractInsnNode)new InsnNode(89));
        instructions.add(AsmHelper.getLoadConstantInsn(classNode.fields.size()));
        instructions.add((AbstractInsnNode)new MethodInsnNode(183, Type.getInternalName(BitSet.class), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.INT_TYPE})));
        instructions.add((AbstractInsnNode)new FieldInsnNode(181, classNode.name, loaded.name, loaded.desc));
        defaultCt.instructions.insertBefore(defaultCt.instructions.getLast(), instructions);
    }

    private void addGetType(ClassNodeTracker bc, ClassMetaData meta) {
        ClassNode classNode = bc.getClassNode();
        FieldNode typeField = new FieldNode(10, "type", Type.getDescriptor(Class.class), null, null);
        classNode.fields.add(typeField);
        MethodNode getter = new MethodNode(1, "getType", Type.getMethodDescriptor((Type)Type.getType(Class.class), (Type[])new Type[0]), null, null);
        classNode.methods.add(getter);
        InsnList instructions = getter.instructions;
        instructions.add((AbstractInsnNode)new FieldInsnNode(178, classNode.name, typeField.name, typeField.desc));
        LabelNode lblEndIfNN = new LabelNode();
        instructions.add((AbstractInsnNode)new JumpInsnNode(199, lblEndIfNN));
        instructions.add(AsmHelper.getLoadConstantInsn(meta.getDescribedType().getName()));
        instructions.add((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(PCDataGenerator.class), "getType", Type.getMethodDescriptor((Type)Type.getType(Class.class), (Type[])new Type[]{Type.getType(String.class)})));
        instructions.add((AbstractInsnNode)new FieldInsnNode(179, classNode.name, typeField.name, typeField.desc));
        instructions.add((AbstractInsnNode)lblEndIfNN);
        instructions.add((AbstractInsnNode)new FieldInsnNode(178, classNode.name, typeField.name, typeField.desc));
        instructions.add((AbstractInsnNode)new InsnNode(176));
    }

    public static Class<?> getType(String className) {
        try {
            return Class.forName(className, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException cnfe) {
            throw new InternalException();
        }
    }

    private void addBaseFields(ClassNodeTracker bc) {
        this.addBeanField(bc, "id", Object.class);
        FieldNode field = this.addBeanField(bc, "storageGenerator", PCDataGenerator.class);
        field.access |= 0x80;
    }

    private void addImplDataMethods(ClassNodeTracker bc, ClassMetaData meta) {
        ClassNode classNode = bc.getClassNode();
        MethodNode storeM = new MethodNode(1, "storeImplData", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(OpenJPAStateManager.class)}), null, null);
        classNode.methods.add(storeM);
        InsnList instructions = storeM.instructions;
        FieldNode impl = null;
        if (!this.usesImplData(meta)) {
            instructions.add((AbstractInsnNode)new InsnNode(177));
        } else {
            impl = this.addBeanField(bc, "implData", Object.class);
            instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
            instructions.add((AbstractInsnNode)new MethodInsnNode(185, Type.getInternalName(OpenJPAStateManager.class), "isImplDataCacheable", Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[0])));
            LabelNode lblEndIfEq = new LabelNode();
            instructions.add((AbstractInsnNode)new JumpInsnNode(153, lblEndIfEq));
            instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
            instructions.add((AbstractInsnNode)new MethodInsnNode(185, Type.getInternalName(OpenJPAStateManager.class), "getImplData", Type.getMethodDescriptor((Type)AsmHelper.TYPE_OBJECT, (Type[])new Type[0])));
            instructions.add((AbstractInsnNode)new MethodInsnNode(182, classNode.name, "setImplData", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{AsmHelper.TYPE_OBJECT})));
            instructions.add((AbstractInsnNode)lblEndIfEq);
            instructions.add((AbstractInsnNode)new InsnNode(177));
        }
        MethodNode loadM = new MethodNode(1, "loadImplData", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(OpenJPAStateManager.class)}), null, null);
        classNode.methods.add(loadM);
        instructions = loadM.instructions;
        if (!this.usesImplData(meta)) {
            instructions.add((AbstractInsnNode)new InsnNode(177));
        } else {
            instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
            instructions.add((AbstractInsnNode)new MethodInsnNode(185, Type.getInternalName(OpenJPAStateManager.class), "getImplData", Type.getMethodDescriptor((Type)AsmHelper.TYPE_OBJECT, (Type[])new Type[0])));
            LabelNode lblEndIf = new LabelNode();
            instructions.add((AbstractInsnNode)new JumpInsnNode(199, lblEndIf));
            instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            instructions.add((AbstractInsnNode)new FieldInsnNode(180, classNode.name, impl.name, impl.desc));
            LabelNode lblEndIf2 = new LabelNode();
            instructions.add((AbstractInsnNode)new JumpInsnNode(198, lblEndIf2));
            instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
            instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            instructions.add((AbstractInsnNode)new FieldInsnNode(180, classNode.name, impl.name, impl.desc));
            instructions.add(AsmHelper.getLoadConstantInsn(true));
            instructions.add((AbstractInsnNode)new MethodInsnNode(185, Type.getInternalName(OpenJPAStateManager.class), "setImplData", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{AsmHelper.TYPE_OBJECT, Type.BOOLEAN_TYPE})));
            instructions.add((AbstractInsnNode)lblEndIf);
            instructions.add((AbstractInsnNode)lblEndIf2);
            instructions.add((AbstractInsnNode)new InsnNode(177));
        }
    }

    private void addFieldImplDataMethods(ClassNodeTracker cnt, ClassMetaData meta) {
        ClassNode classNode = cnt.getClassNode();
        int count = this.countImplDataFields(meta);
        FieldNode impl = null;
        MethodNode meth = new MethodNode(2, "loadImplData", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(OpenJPAStateManager.class), Type.INT_TYPE}), null, null);
        classNode.methods.add(meth);
        InsnList instructions = meth.instructions;
        if (count == 0) {
            instructions.add((AbstractInsnNode)new InsnNode(177));
        } else {
            impl = new FieldNode(2, "fieldImpl", Type.getDescriptor(Object[].class), null, null);
            classNode.fields.add(impl);
            instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            instructions.add((AbstractInsnNode)new FieldInsnNode(180, classNode.name, impl.name, impl.desc));
            LabelNode lblEndIf = new LabelNode();
            instructions.add((AbstractInsnNode)new JumpInsnNode(199, lblEndIf));
            instructions.add((AbstractInsnNode)new InsnNode(177));
            instructions.add((AbstractInsnNode)lblEndIf);
            int objVarPos = AsmHelper.getLocalVarPos(meth);
            instructions.add((AbstractInsnNode)new InsnNode(1));
            instructions.add((AbstractInsnNode)new VarInsnNode(58, objVarPos));
            LabelNode lblEnd = new LabelNode();
            instructions.add((AbstractInsnNode)new VarInsnNode(21, 2));
            LookupSwitchInsnNode lSwitch = new LookupSwitchInsnNode(lblEnd, null, null);
            FieldMetaData[] fields = meta.getFields();
            int cacheable = 0;
            for (int i = 0; i < fields.length; ++i) {
                if (!this.usesImplData(fields[i])) continue;
                LabelNode lblCase = new LabelNode();
                instructions.add((AbstractInsnNode)lblCase);
                lSwitch.keys.add(i);
                lSwitch.labels.add(lblCase);
                instructions.add((AbstractInsnNode)new FieldInsnNode(180, classNode.name, impl.name, impl.desc));
                instructions.add(AsmHelper.getLoadConstantInsn(cacheable++));
                instructions.add((AbstractInsnNode)new InsnNode(50));
                instructions.add((AbstractInsnNode)new VarInsnNode(58, objVarPos));
                instructions.add((AbstractInsnNode)new JumpInsnNode(167, lblEnd));
            }
            instructions.add((AbstractInsnNode)lblEnd);
            instructions.add((AbstractInsnNode)new VarInsnNode(25, objVarPos));
            lblEndIf = new LabelNode();
            instructions.add((AbstractInsnNode)new JumpInsnNode(199, lblEndIf));
            instructions.add((AbstractInsnNode)new InsnNode(177));
            instructions.add((AbstractInsnNode)lblEndIf);
            instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
            instructions.add((AbstractInsnNode)new VarInsnNode(21, 2));
            instructions.add((AbstractInsnNode)new VarInsnNode(25, objVarPos));
            instructions.add((AbstractInsnNode)new MethodInsnNode(185, Type.getInternalName(OpenJPAStateManager.class), "setImplData", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.INT_TYPE, AsmHelper.TYPE_OBJECT})));
            instructions.add((AbstractInsnNode)new InsnNode(177));
        }
        meth = new MethodNode(2, "storeImplData", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(OpenJPAStateManager.class), Type.INT_TYPE, Type.BOOLEAN_TYPE}), null, null);
        classNode.methods.add(meth);
        instructions = meth.instructions;
        if (count == 0) {
            instructions.add((AbstractInsnNode)new InsnNode(177));
        } else {
            int arrIdxVarPos = AsmHelper.getLocalVarPos(meth);
            instructions.add(AsmHelper.getLoadConstantInsn(-1));
            instructions.add((AbstractInsnNode)new VarInsnNode(54, arrIdxVarPos));
            instructions.add((AbstractInsnNode)new VarInsnNode(21, 2));
            LabelNode lblEnd = new LabelNode();
            LookupSwitchInsnNode lSwitch = new LookupSwitchInsnNode(lblEnd, null, null);
            FieldMetaData[] fields = meta.getFields();
            int cacheable = 0;
            for (int i = 0; i < fields.length; ++i) {
                if (!this.usesImplData(fields[i])) continue;
                LabelNode lblCase = new LabelNode();
                instructions.add((AbstractInsnNode)lblCase);
                lSwitch.keys.add(i);
                lSwitch.labels.add(lblCase);
                instructions.add(AsmHelper.getLoadConstantInsn(cacheable++));
                instructions.add((AbstractInsnNode)new VarInsnNode(54, arrIdxVarPos));
                instructions.add((AbstractInsnNode)new JumpInsnNode(167, lblEnd));
            }
            instructions.add((AbstractInsnNode)lblEnd);
            instructions.add(AsmHelper.getLoadConstantInsn(-1));
            LabelNode lblEndIf = new LabelNode();
            instructions.add((AbstractInsnNode)new JumpInsnNode(160, lblEndIf));
            instructions.add((AbstractInsnNode)new InsnNode(177));
            instructions.add((AbstractInsnNode)lblEndIf);
            instructions.add((AbstractInsnNode)new VarInsnNode(21, 3));
            lblEndIf = new LabelNode();
            instructions.add((AbstractInsnNode)new JumpInsnNode(153, lblEndIf));
            int objVarPos = arrIdxVarPos + 1;
            instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
            instructions.add((AbstractInsnNode)new VarInsnNode(21, 2));
            instructions.add((AbstractInsnNode)new MethodInsnNode(185, Type.getInternalName(OpenJPAStateManager.class), "getImplData", Type.getMethodDescriptor((Type)AsmHelper.TYPE_OBJECT, (Type[])new Type[]{Type.INT_TYPE})));
            instructions.add((AbstractInsnNode)new VarInsnNode(58, objVarPos));
            instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            instructions.add((AbstractInsnNode)new FieldInsnNode(180, classNode.name, impl.name, impl.desc));
            LabelNode lblEndIfNN = new LabelNode();
            instructions.add((AbstractInsnNode)new JumpInsnNode(199, lblEndIfNN));
            instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            instructions.add(AsmHelper.getLoadConstantInsn(count));
            instructions.add((AbstractInsnNode)new TypeInsnNode(189, Type.getInternalName(Object.class)));
            instructions.add((AbstractInsnNode)new FieldInsnNode(181, classNode.name, impl.name, impl.desc));
            instructions.add((AbstractInsnNode)lblEndIfNN);
            instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            instructions.add((AbstractInsnNode)new FieldInsnNode(180, classNode.name, impl.name, impl.desc));
            instructions.add((AbstractInsnNode)new VarInsnNode(21, arrIdxVarPos));
            instructions.add((AbstractInsnNode)new VarInsnNode(25, objVarPos));
            instructions.add((AbstractInsnNode)new InsnNode(83));
            instructions.add((AbstractInsnNode)new InsnNode(177));
            instructions.add((AbstractInsnNode)lblEndIf);
            instructions.add((AbstractInsnNode)new FieldInsnNode(180, classNode.name, impl.name, impl.desc));
            lblEndIfNN = new LabelNode();
            instructions.add((AbstractInsnNode)new JumpInsnNode(199, lblEndIfNN));
            instructions.add((AbstractInsnNode)new InsnNode(177));
            instructions.add((AbstractInsnNode)lblEndIfNN);
            instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            instructions.add((AbstractInsnNode)new FieldInsnNode(180, classNode.name, impl.name, impl.desc));
            instructions.add((AbstractInsnNode)new VarInsnNode(21, arrIdxVarPos));
            instructions.add((AbstractInsnNode)new InsnNode(1));
            instructions.add((AbstractInsnNode)new InsnNode(83));
            instructions.add((AbstractInsnNode)new InsnNode(177));
        }
    }

    protected void addVersionMethods(ClassNodeTracker bc) {
        ClassNode classNode = bc.getClassNode();
        FieldNode versionField = this.addBeanField(bc, "version", Object.class);
        MethodNode storeMeth = new MethodNode(1, "storeVersion", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(OpenJPAStateManager.class)}), null, null);
        classNode.methods.add(storeMeth);
        InsnList instructions = storeMeth.instructions;
        instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
        instructions.add((AbstractInsnNode)new MethodInsnNode(185, Type.getInternalName(OpenJPAStateManager.class), "getVersion", Type.getMethodDescriptor((Type)AsmHelper.TYPE_OBJECT, (Type[])new Type[0])));
        instructions.add((AbstractInsnNode)new FieldInsnNode(181, classNode.name, versionField.name, versionField.desc));
        instructions.add((AbstractInsnNode)new InsnNode(177));
        MethodNode loadMeth = new MethodNode(1, "loadVersion", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(OpenJPAStateManager.class)}), null, null);
        classNode.methods.add(loadMeth);
        instructions = loadMeth.instructions;
        instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
        instructions.add((AbstractInsnNode)new MethodInsnNode(185, Type.getInternalName(OpenJPAStateManager.class), "getVersion", Type.getMethodDescriptor((Type)AsmHelper.TYPE_OBJECT, (Type[])new Type[0])));
        LabelNode lblEndIf = new LabelNode();
        instructions.add((AbstractInsnNode)new JumpInsnNode(199, lblEndIf));
        instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
        instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        instructions.add((AbstractInsnNode)new FieldInsnNode(180, classNode.name, versionField.name, versionField.desc));
        instructions.add((AbstractInsnNode)new MethodInsnNode(185, Type.getInternalName(OpenJPAStateManager.class), "setVersion", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{AsmHelper.TYPE_OBJECT})));
        instructions.add((AbstractInsnNode)lblEndIf);
        instructions.add((AbstractInsnNode)new InsnNode(177));
    }

    private void addLoadMethod(ClassNodeTracker cnt, ClassMetaData meta) {
        ClassNode classNode = cnt.getClassNode();
        MethodNode meth = this.addLoadMethod(cnt, false);
        InsnList instructions = meth.instructions;
        FieldMetaData[] fmds = meta.getFields();
        int localVarPos = AsmHelper.getLocalVarPos(meth);
        instructions.add((AbstractInsnNode)new InsnNode(1));
        instructions.add((AbstractInsnNode)new VarInsnNode(58, localVarPos));
        int interVarPos = localVarPos + 1;
        instructions.add((AbstractInsnNode)new InsnNode(1));
        instructions.add((AbstractInsnNode)new VarInsnNode(58, interVarPos));
        int objectCount = 0;
        LabelNode lblEndIf = null;
        for (int i = 0; i < fmds.length; ++i) {
            if (lblEndIf != null) {
                instructions.add(lblEndIf);
            }
            lblEndIf = new LabelNode();
            boolean intermediate = this.usesIntermediate(fmds[i]);
            instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            instructions.add((AbstractInsnNode)new FieldInsnNode(180, classNode.name, "loaded", Type.getDescriptor(BitSet.class)));
            instructions.add(AsmHelper.getLoadConstantInsn(i));
            instructions.add((AbstractInsnNode)new MethodInsnNode(182, Type.getInternalName(BitSet.class), "get", Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[]{Type.INT_TYPE})));
            instructions.add((AbstractInsnNode)new JumpInsnNode(intermediate ? 154 : 153, lblEndIf));
            if (intermediate) {
                this.addLoadIntermediate(classNode, instructions, i, objectCount, interVarPos);
                LabelNode lblElse = lblEndIf;
                lblEndIf = new LabelNode();
                instructions.add((AbstractInsnNode)new JumpInsnNode(167, lblEndIf));
                instructions.add((AbstractInsnNode)lblElse);
            }
            instructions.add((AbstractInsnNode)new VarInsnNode(25, 2));
            instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
            instructions.add((AbstractInsnNode)new MethodInsnNode(185, Type.getInternalName(OpenJPAStateManager.class), "getMetaData", Type.getMethodDescriptor((Type)Type.getType(ClassMetaData.class), (Type[])new Type[0])));
            instructions.add(AsmHelper.getLoadConstantInsn(fmds[i].getIndex()));
            instructions.add((AbstractInsnNode)new MethodInsnNode(182, Type.getInternalName(ClassMetaData.class), "getField", Type.getMethodDescriptor((Type)Type.getType(FieldMetaData.class), (Type[])new Type[]{Type.INT_TYPE})));
            instructions.add((AbstractInsnNode)new MethodInsnNode(185, Type.getInternalName(FetchConfiguration.class), "requiresFetch", Type.getMethodDescriptor((Type)Type.INT_TYPE, (Type[])new Type[]{Type.getType(FieldMetaData.class)})));
            instructions.add(AsmHelper.getLoadConstantInsn(0));
            instructions.add((AbstractInsnNode)new JumpInsnNode(159, lblEndIf));
            this.addLoad(classNode, instructions, fmds[i], objectCount, localVarPos, false);
            if (this.replaceType(fmds[i]) < 8) continue;
            ++objectCount;
        }
        if (lblEndIf != null) {
            instructions.add(lblEndIf);
        }
        instructions.add((AbstractInsnNode)new InsnNode(177));
    }

    private void addLoadWithFieldsMethod(ClassNodeTracker cnt, ClassMetaData meta) {
        ClassNode classNode = cnt.getClassNode();
        MethodNode meth = this.addLoadMethod(cnt, true);
        InsnList instructions = meth.instructions;
        FieldMetaData[] fmds = meta.getFields();
        int localVarPos = AsmHelper.getLocalVarPos(meth);
        instructions.add((AbstractInsnNode)new InsnNode(1));
        instructions.add((AbstractInsnNode)new VarInsnNode(58, localVarPos));
        int interVarPos = localVarPos + 1;
        instructions.add((AbstractInsnNode)new InsnNode(1));
        instructions.add((AbstractInsnNode)new VarInsnNode(58, interVarPos));
        int objectCount = 0;
        LabelNode lblEndIf = null;
        for (int i = 0; i < fmds.length; ++i) {
            if (lblEndIf != null) {
                instructions.add(lblEndIf);
            }
            lblEndIf = new LabelNode();
            boolean intermediate = this.usesIntermediate(fmds[i]);
            instructions.add((AbstractInsnNode)new VarInsnNode(25, 2));
            instructions.add(AsmHelper.getLoadConstantInsn(i));
            instructions.add((AbstractInsnNode)new MethodInsnNode(182, Type.getInternalName(BitSet.class), "get", Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[]{Type.INT_TYPE})));
            instructions.add((AbstractInsnNode)new JumpInsnNode(153, lblEndIf));
            instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            instructions.add((AbstractInsnNode)new FieldInsnNode(180, classNode.name, "loaded", Type.getDescriptor(BitSet.class)));
            instructions.add(AsmHelper.getLoadConstantInsn(i));
            instructions.add((AbstractInsnNode)new MethodInsnNode(182, Type.getInternalName(BitSet.class), "get", Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[]{Type.INT_TYPE})));
            LabelNode lblEndIf2 = null;
            if (intermediate) {
                lblEndIf2 = new LabelNode();
                instructions.add((AbstractInsnNode)new JumpInsnNode(153, lblEndIf2));
            } else {
                instructions.add((AbstractInsnNode)new JumpInsnNode(153, lblEndIf));
            }
            this.addLoad(classNode, instructions, fmds[i], objectCount, localVarPos, true);
            if (this.usesImplData(fmds[i])) {
                instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
                instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
                instructions.add(AsmHelper.getLoadConstantInsn(i));
                instructions.add((AbstractInsnNode)new MethodInsnNode(182, classNode.name, "loadImplData", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(OpenJPAStateManager.class), Type.INT_TYPE})));
            }
            instructions.add((AbstractInsnNode)new VarInsnNode(25, 2));
            instructions.add(AsmHelper.getLoadConstantInsn(i));
            instructions.add((AbstractInsnNode)new MethodInsnNode(182, Type.getInternalName(BitSet.class), "clear", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.INT_TYPE})));
            if (intermediate) {
                instructions.add((AbstractInsnNode)new JumpInsnNode(167, lblEndIf));
                instructions.add((AbstractInsnNode)lblEndIf2);
                this.addLoadIntermediate(classNode, instructions, i, objectCount, interVarPos);
            }
            if (this.replaceType(fmds[i]) < 8) continue;
            ++objectCount;
        }
        if (lblEndIf != null) {
            instructions.add(lblEndIf);
        }
        instructions.add((AbstractInsnNode)new InsnNode(177));
    }

    private MethodNode addLoadMethod(ClassNodeTracker cnt, boolean fields) {
        String mDesc = fields ? Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(OpenJPAStateManager.class), Type.getType(BitSet.class), Type.getType(FetchConfiguration.class), AsmHelper.TYPE_OBJECT}) : Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(OpenJPAStateManager.class), Type.getType(FetchConfiguration.class), AsmHelper.TYPE_OBJECT});
        MethodNode meth = new MethodNode(1, "load", mDesc, null, null);
        cnt.getClassNode().methods.add(meth);
        meth.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        meth.instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
        meth.instructions.add((AbstractInsnNode)new MethodInsnNode(182, cnt.getClassNode().name, "loadVersion", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(OpenJPAStateManager.class)})));
        meth.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        meth.instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
        meth.instructions.add((AbstractInsnNode)new MethodInsnNode(182, cnt.getClassNode().name, "loadImplData", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(OpenJPAStateManager.class)})));
        return meth;
    }

    private void addLoad(ClassNode classNode, InsnList instructions, FieldMetaData fmd, int objectCount, int localVarPos, boolean fields) {
        int index = fmd.getIndex();
        int typeCode = this.replaceType(fmd);
        if (typeCode < 8) {
            Class type = this.forType(fmd.getTypeCode());
            instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
            instructions.add(AsmHelper.getLoadConstantInsn(index));
            instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            instructions.add((AbstractInsnNode)new FieldInsnNode(180, classNode.name, this.getFieldName(index), Type.getDescriptor((Class)type)));
            instructions.add((AbstractInsnNode)new MethodInsnNode(185, Type.getInternalName(OpenJPAStateManager.class), "store" + StringUtil.capitalize((String)type.getName()), Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.INT_TYPE, Type.getType((Class)type)})));
        } else {
            int offset = fields ? 1 : 0;
            instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
            instructions.add((AbstractInsnNode)new MethodInsnNode(185, Type.getInternalName(OpenJPAStateManager.class), "getMetaData", Type.getMethodDescriptor((Type)Type.getType(ClassMetaData.class), (Type[])new Type[0])));
            instructions.add(AsmHelper.getLoadConstantInsn(index));
            instructions.add((AbstractInsnNode)new MethodInsnNode(182, Type.getInternalName(ClassMetaData.class), "getField", Type.getMethodDescriptor((Type)Type.getType(FieldMetaData.class), (Type[])new Type[]{Type.INT_TYPE})));
            instructions.add((AbstractInsnNode)new VarInsnNode(58, localVarPos));
            instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
            instructions.add(AsmHelper.getLoadConstantInsn(index));
            instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
            instructions.add((AbstractInsnNode)new VarInsnNode(25, localVarPos));
            instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            instructions.add((AbstractInsnNode)new FieldInsnNode(180, classNode.name, "objects", Type.getDescriptor(Object[].class)));
            instructions.add(AsmHelper.getLoadConstantInsn(objectCount));
            instructions.add((AbstractInsnNode)new InsnNode(50));
            instructions.add((AbstractInsnNode)new VarInsnNode(25, 2 + offset));
            instructions.add((AbstractInsnNode)new VarInsnNode(25, 3 + offset));
            instructions.add((AbstractInsnNode)new MethodInsnNode(182, classNode.name, "toField", Type.getMethodDescriptor((Type)AsmHelper.TYPE_OBJECT, (Type[])new Type[]{Type.getType(OpenJPAStateManager.class), Type.getType(FieldMetaData.class), AsmHelper.TYPE_OBJECT, Type.getType(FetchConfiguration.class), AsmHelper.TYPE_OBJECT})));
            instructions.add((AbstractInsnNode)new MethodInsnNode(185, Type.getInternalName(OpenJPAStateManager.class), "storeField", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.INT_TYPE, AsmHelper.TYPE_OBJECT})));
        }
    }

    private void addLoadIntermediate(ClassNode classNode, InsnList instructions, int index, int objectCount, int interVarPos) {
        instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        instructions.add((AbstractInsnNode)new FieldInsnNode(180, classNode.name, "objects", Type.getDescriptor(Object[].class)));
        instructions.add(AsmHelper.getLoadConstantInsn(objectCount));
        instructions.add((AbstractInsnNode)new InsnNode(50));
        instructions.add((AbstractInsnNode)new VarInsnNode(58, interVarPos));
        LabelNode lblEndIf = new LabelNode();
        instructions.add((AbstractInsnNode)new VarInsnNode(25, interVarPos));
        instructions.add((AbstractInsnNode)new JumpInsnNode(198, lblEndIf));
        instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
        instructions.add((AbstractInsnNode)new MethodInsnNode(185, Type.getInternalName(OpenJPAStateManager.class), "getLoaded", Type.getMethodDescriptor((Type)Type.getType(BitSet.class), (Type[])new Type[0])));
        instructions.add(AsmHelper.getLoadConstantInsn(index));
        instructions.add((AbstractInsnNode)new MethodInsnNode(182, Type.getInternalName(BitSet.class), "get", Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[]{Type.INT_TYPE})));
        instructions.add((AbstractInsnNode)new JumpInsnNode(154, lblEndIf));
        instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
        instructions.add(AsmHelper.getLoadConstantInsn(index));
        instructions.add((AbstractInsnNode)new VarInsnNode(25, interVarPos));
        instructions.add((AbstractInsnNode)new MethodInsnNode(185, Type.getInternalName(OpenJPAStateManager.class), "setIntermediate", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.INT_TYPE, AsmHelper.TYPE_OBJECT})));
        instructions.add((AbstractInsnNode)lblEndIf);
    }

    private void addStoreMethods(ClassNodeTracker cnt, ClassMetaData meta) {
        this.addStoreMethod(cnt, meta, true);
        this.addStoreMethod(cnt, meta, false);
    }

    private void addStoreMethod(ClassNodeTracker cnt, ClassMetaData meta, boolean fields) {
        MethodNode store = fields ? new MethodNode(33, "store", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(OpenJPAStateManager.class), Type.getType(BitSet.class)}), null, null) : new MethodNode(33, "store", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(OpenJPAStateManager.class)}), null, null);
        ClassNode classNode = cnt.getClassNode();
        classNode.methods.add(store);
        InsnList instructions = store.instructions;
        instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        instructions.add((AbstractInsnNode)new MethodInsnNode(182, classNode.name, "initialize", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0])));
        instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
        instructions.add((AbstractInsnNode)new MethodInsnNode(182, classNode.name, "storeVersion", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(OpenJPAStateManager.class)})));
        instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
        instructions.add((AbstractInsnNode)new MethodInsnNode(182, classNode.name, "storeImplData", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(OpenJPAStateManager.class)})));
        FieldMetaData[] fmds = meta.getFields();
        int objectCount = 0;
        for (int i = 0; i < fmds.length; ++i) {
            LabelNode lblEndIf = new LabelNode();
            if (fields) {
                instructions.add((AbstractInsnNode)new VarInsnNode(25, 2));
                instructions.add((AbstractInsnNode)new JumpInsnNode(198, lblEndIf));
                instructions.add((AbstractInsnNode)new VarInsnNode(25, 2));
                instructions.add(AsmHelper.getLoadConstantInsn(i));
                instructions.add((AbstractInsnNode)new MethodInsnNode(182, Type.getInternalName(BitSet.class), "get", Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[]{Type.INT_TYPE})));
                instructions.add((AbstractInsnNode)new JumpInsnNode(153, lblEndIf));
            } else {
                instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
                instructions.add((AbstractInsnNode)new MethodInsnNode(185, Type.getInternalName(OpenJPAStateManager.class), "getLoaded", Type.getMethodDescriptor((Type)Type.getType(BitSet.class), (Type[])new Type[0])));
                instructions.add(AsmHelper.getLoadConstantInsn(i));
                instructions.add((AbstractInsnNode)new MethodInsnNode(182, Type.getInternalName(BitSet.class), "get", Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[]{Type.INT_TYPE})));
                instructions.add((AbstractInsnNode)new JumpInsnNode(153, lblEndIf));
            }
            this.addStore(classNode, store, instructions, fmds[i], objectCount);
            if (this.usesIntermediate(fmds[i])) {
                LabelNode lblEndElse = new LabelNode();
                instructions.add((AbstractInsnNode)new JumpInsnNode(167, lblEndElse));
                instructions.add((AbstractInsnNode)lblEndIf);
                lblEndIf = new LabelNode();
                instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
                instructions.add((AbstractInsnNode)new FieldInsnNode(180, classNode.name, "loaded", Type.getDescriptor(BitSet.class)));
                instructions.add(AsmHelper.getLoadConstantInsn(i));
                instructions.add((AbstractInsnNode)new MethodInsnNode(182, Type.getInternalName(BitSet.class), "get", Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[]{Type.INT_TYPE})));
                instructions.add((AbstractInsnNode)new JumpInsnNode(154, lblEndElse));
                instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
                instructions.add(AsmHelper.getLoadConstantInsn(i));
                instructions.add((AbstractInsnNode)new MethodInsnNode(185, Type.getInternalName(OpenJPAStateManager.class), "getIntermediate", Type.getMethodDescriptor((Type)AsmHelper.TYPE_OBJECT, (Type[])new Type[]{Type.INT_TYPE})));
                int localVarPos = AsmHelper.getLocalVarPos(store);
                instructions.add((AbstractInsnNode)new VarInsnNode(58, localVarPos));
                instructions.add((AbstractInsnNode)new VarInsnNode(25, localVarPos));
                instructions.add((AbstractInsnNode)new JumpInsnNode(198, lblEndElse));
                instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
                instructions.add((AbstractInsnNode)new FieldInsnNode(180, classNode.name, "objects", Type.getDescriptor(Object[].class)));
                instructions.add(AsmHelper.getLoadConstantInsn(objectCount));
                instructions.add((AbstractInsnNode)new VarInsnNode(25, localVarPos));
                instructions.add((AbstractInsnNode)new InsnNode(83));
                instructions.add((AbstractInsnNode)lblEndElse);
            }
            if (lblEndIf != null) {
                instructions.add((AbstractInsnNode)lblEndIf);
            }
            if (this.replaceType(fmds[i]) < 8) continue;
            ++objectCount;
        }
        instructions.add((AbstractInsnNode)new InsnNode(177));
    }

    private void addStore(ClassNode classNode, MethodNode meth, InsnList instructions, FieldMetaData fmd, int objectCount) {
        int typeCode = this.replaceType(fmd);
        int index = fmd.getIndex();
        if (typeCode < 8) {
            Class type = this.forType(typeCode);
            instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
            instructions.add(AsmHelper.getLoadConstantInsn(index));
            instructions.add((AbstractInsnNode)new MethodInsnNode(185, Type.getInternalName(OpenJPAStateManager.class), "fetch" + StringUtil.capitalize((String)type.getName()), Type.getMethodDescriptor((Type)Type.getType((Class)type), (Type[])new Type[]{Type.INT_TYPE})));
            instructions.add((AbstractInsnNode)new FieldInsnNode(181, classNode.name, this.getFieldName(index), Type.getDescriptor((Class)type)));
            instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            instructions.add((AbstractInsnNode)new FieldInsnNode(180, classNode.name, "loaded", Type.getDescriptor(BitSet.class)));
            instructions.add(AsmHelper.getLoadConstantInsn(index));
            instructions.add((AbstractInsnNode)new MethodInsnNode(182, Type.getInternalName(BitSet.class), "set", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.INT_TYPE})));
        } else {
            int localVarPos = AsmHelper.getLocalVarPos(meth);
            instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
            instructions.add((AbstractInsnNode)new MethodInsnNode(185, Type.getInternalName(OpenJPAStateManager.class), "getMetaData", Type.getMethodDescriptor((Type)Type.getType(ClassMetaData.class), (Type[])new Type[0])));
            instructions.add(AsmHelper.getLoadConstantInsn(fmd.getIndex()));
            instructions.add((AbstractInsnNode)new MethodInsnNode(182, Type.getInternalName(ClassMetaData.class), "getField", Type.getMethodDescriptor((Type)Type.getType(FieldMetaData.class), (Type[])new Type[]{Type.INT_TYPE})));
            instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
            instructions.add(AsmHelper.getLoadConstantInsn(fmd.getIndex()));
            instructions.add(AsmHelper.getLoadConstantInsn(false));
            instructions.add((AbstractInsnNode)new MethodInsnNode(185, Type.getInternalName(OpenJPAStateManager.class), "fetchField", Type.getMethodDescriptor((Type)AsmHelper.TYPE_OBJECT, (Type[])new Type[]{Type.INT_TYPE, Type.BOOLEAN_TYPE})));
            instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
            instructions.add((AbstractInsnNode)new MethodInsnNode(185, Type.getInternalName(OpenJPAStateManager.class), "getContext", Type.getMethodDescriptor((Type)Type.getType(StoreContext.class), (Type[])new Type[0])));
            instructions.add((AbstractInsnNode)new MethodInsnNode(182, classNode.name, "toData", Type.getMethodDescriptor((Type)AsmHelper.TYPE_OBJECT, (Type[])new Type[]{Type.getType(FieldMetaData.class), AsmHelper.TYPE_OBJECT, Type.getType(StoreContext.class)})));
            instructions.add((AbstractInsnNode)new VarInsnNode(58, localVarPos));
            instructions.add((AbstractInsnNode)new VarInsnNode(25, localVarPos));
            instructions.add((AbstractInsnNode)new FieldInsnNode(178, Type.getInternalName(AbstractPCData.class), "NULL", AsmHelper.TYPE_OBJECT.getDescriptor()));
            LabelNode lblElse = new LabelNode();
            instructions.add((AbstractInsnNode)new JumpInsnNode(166, lblElse));
            instructions.add((AbstractInsnNode)new InsnNode(1));
            instructions.add((AbstractInsnNode)new VarInsnNode(58, localVarPos));
            instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            instructions.add((AbstractInsnNode)new FieldInsnNode(180, classNode.name, "loaded", Type.getDescriptor(BitSet.class)));
            instructions.add(AsmHelper.getLoadConstantInsn(index));
            instructions.add((AbstractInsnNode)new MethodInsnNode(182, Type.getInternalName(BitSet.class), "clear", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.INT_TYPE})));
            LabelNode lblEndIf = new LabelNode();
            instructions.add((AbstractInsnNode)new JumpInsnNode(167, lblEndIf));
            instructions.add((AbstractInsnNode)lblElse);
            instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            instructions.add((AbstractInsnNode)new FieldInsnNode(180, classNode.name, "loaded", Type.getDescriptor(BitSet.class)));
            instructions.add(AsmHelper.getLoadConstantInsn(index));
            instructions.add((AbstractInsnNode)new MethodInsnNode(182, Type.getInternalName(BitSet.class), "set", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.INT_TYPE})));
            instructions.add((AbstractInsnNode)lblEndIf);
            instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            instructions.add((AbstractInsnNode)new FieldInsnNode(180, classNode.name, "objects", Type.getDescriptor(Object[].class)));
            instructions.add(AsmHelper.getLoadConstantInsn(objectCount));
            instructions.add((AbstractInsnNode)new VarInsnNode(25, localVarPos));
            instructions.add((AbstractInsnNode)new InsnNode(83));
        }
        if (!this.usesImplData(fmd)) {
            return;
        }
        instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
        instructions.add(AsmHelper.getLoadConstantInsn(index));
        instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        instructions.add((AbstractInsnNode)new FieldInsnNode(180, classNode.name, "loaded", Type.getDescriptor(BitSet.class)));
        instructions.add(AsmHelper.getLoadConstantInsn(index));
        instructions.add((AbstractInsnNode)new MethodInsnNode(182, Type.getInternalName(BitSet.class), "get", Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[]{Type.INT_TYPE})));
        instructions.add((AbstractInsnNode)new MethodInsnNode(182, classNode.name, "storeImplData", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(OpenJPAStateManager.class), Type.INT_TYPE, Type.BOOLEAN_TYPE})));
    }

    private void addNewEmbedded(ClassNodeTracker cnt) {
        ClassNode classNode = cnt.getClassNode();
        MethodNode meth = new MethodNode(1, "newEmbeddedPCData", Type.getMethodDescriptor((Type)Type.getType(PCData.class), (Type[])new Type[]{Type.getType(OpenJPAStateManager.class)}), null, null);
        classNode.methods.add(meth);
        InsnList instructions = meth.instructions;
        instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        instructions.add((AbstractInsnNode)new FieldInsnNode(180, classNode.name, "storageGenerator", Type.getDescriptor(PCDataGenerator.class)));
        instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
        instructions.add((AbstractInsnNode)new MethodInsnNode(185, Type.getInternalName(OpenJPAStateManager.class), "getId", Type.getMethodDescriptor((Type)AsmHelper.TYPE_OBJECT, (Type[])new Type[0])));
        instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
        instructions.add((AbstractInsnNode)new MethodInsnNode(185, Type.getInternalName(OpenJPAStateManager.class), "getMetaData", Type.getMethodDescriptor((Type)Type.getType(ClassMetaData.class), (Type[])new Type[0])));
        instructions.add((AbstractInsnNode)new MethodInsnNode(182, Type.getInternalName(PCDataGenerator.class), "generatePCData", Type.getMethodDescriptor((Type)Type.getType(PCData.class), (Type[])new Type[]{AsmHelper.TYPE_OBJECT, Type.getType(ClassMetaData.class)})));
        instructions.add((AbstractInsnNode)new InsnNode(176));
    }

    private void addGetData(ClassNodeTracker cnt) {
        ClassNode classNode = cnt.getClassNode();
        MethodNode meth = new MethodNode(1, "getData", Type.getMethodDescriptor((Type)AsmHelper.TYPE_OBJECT, (Type[])new Type[]{Type.INT_TYPE}), null, null);
        classNode.methods.add(meth);
        InsnList instructions = meth.instructions;
        instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        instructions.add((AbstractInsnNode)new VarInsnNode(21, 1));
        instructions.add((AbstractInsnNode)new MethodInsnNode(182, classNode.name, "getObject", Type.getMethodDescriptor((Type)AsmHelper.TYPE_OBJECT, (Type[])new Type[]{Type.INT_TYPE})));
        instructions.add((AbstractInsnNode)new InsnNode(176));
    }

    protected int replaceType(FieldMetaData fmd) {
        if (this.usesIntermediate(fmd)) {
            return 8;
        }
        return fmd.getTypeCode();
    }

    protected boolean usesIntermediate(FieldMetaData fmd) {
        return fmd.usesIntermediate();
    }

    protected boolean usesImplData(ClassMetaData meta) {
        return true;
    }

    protected boolean usesImplData(FieldMetaData fmd) {
        return fmd.usesImplData() == null;
    }

    private int countImplDataFields(ClassMetaData meta) {
        FieldMetaData[] fmds = meta.getFields();
        int count = 0;
        for (FieldMetaData fmd : fmds) {
            if (!this.usesImplData(fmd)) continue;
            ++count;
        }
        return count;
    }

    public static interface DynamicPCData
    extends PCData {
        public void setId(Object var1);

        public void setStorageGenerator(PCDataGenerator var1);
    }
}

