/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.jpa.processor.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public final class ODataJPATombstoneContext {
    private static final ThreadLocal<String> deltaToken = new ThreadLocal();
    private static final ThreadLocal<Long> deltaTokenUTCTimeStamp = new ThreadLocal();
    private static final ThreadLocal<HashMap<String, List<Object>>> deltas = new ThreadLocal();

    public static String getDeltaToken() {
        return deltaToken.get();
    }

    public static void setDeltaToken(String token) {
        deltaToken.set(token);
    }

    public static void addToDeltaResult(Object entity, String entityName) {
        HashMap<String, List<Object>> entityDeltaMap = deltas.get();
        if (entityDeltaMap == null) {
            deltas.set(new HashMap());
        }
        if ((entityDeltaMap = deltas.get()).get(entityName) == null) {
            entityDeltaMap.put(entityName, new ArrayList());
        }
        entityDeltaMap.get(entityName).add(entity);
    }

    public static List<Object> getDeltaResult(String entityName) {
        HashMap<String, List<Object>> entityDeltaMap = deltas.get();
        if (entityDeltaMap != null) {
            return entityDeltaMap.get(entityName);
        }
        return null;
    }

    public static void cleanup() {
        deltas.remove();
        deltaToken.remove();
        deltaTokenUTCTimeStamp.remove();
    }

    public static Long getDeltaTokenUTCTimeStamp() {
        Long timestamp = deltaTokenUTCTimeStamp.get();
        if (timestamp != null) {
            return timestamp;
        }
        if (deltaToken.get() != null) {
            try {
                timestamp = new Long(Long.parseLong(deltaToken.get()));
            }
            catch (NumberFormatException e) {
                return null;
            }
            deltaTokenUTCTimeStamp.set(timestamp);
        } else {
            deltaTokenUTCTimeStamp.set(new Long(0L));
        }
        return deltaTokenUTCTimeStamp.get();
    }
}

