/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.api.prefer;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.olingo.commons.api.format.PreferenceName;
import org.apache.olingo.server.api.prefer.Preferences;

public final class PreferencesApplied {
    private static final Set<String> SAFE_PREFERENCE_NAMES = new HashSet<String>();
    private Map<String, String> applied = new LinkedHashMap<String, String>();

    private PreferencesApplied() {
    }

    public Map<String, String> getAppliedPreferences() {
        return Collections.unmodifiableMap(this.applied);
    }

    public String toValueString() {
        StringBuilder result = new StringBuilder();
        for (Map.Entry<String, String> entry : this.applied.entrySet()) {
            if (result.length() > 0) {
                result.append(',').append(' ');
            }
            String key = entry.getKey();
            result.append(key);
            if (entry.getValue() == null) continue;
            boolean safe = this.isSafe(key);
            result.append('=').append(safe ? "" : Character.valueOf('\"')).append(entry.getValue().replaceAll("\\\\|\"", "\\\\$0")).append(safe ? "" : Character.valueOf('\"'));
        }
        return result.toString();
    }

    private boolean isSafe(String key) {
        if (SAFE_PREFERENCE_NAMES.isEmpty()) {
            SAFE_PREFERENCE_NAMES.add(PreferenceName.ALLOW_ENTITY_REFERENCES.getName());
            SAFE_PREFERENCE_NAMES.add(PreferenceName.CALLBACK.getName());
            SAFE_PREFERENCE_NAMES.add(PreferenceName.CONTINUE_ON_ERROR.getName());
            SAFE_PREFERENCE_NAMES.add(PreferenceName.MAX_PAGE_SIZE.getName());
            SAFE_PREFERENCE_NAMES.add(PreferenceName.TRACK_CHANGES.getName());
            SAFE_PREFERENCE_NAMES.add(PreferenceName.RETURN.getName());
            SAFE_PREFERENCE_NAMES.add(PreferenceName.RESPOND_ASYNC.getName());
            SAFE_PREFERENCE_NAMES.add(PreferenceName.WAIT.getName());
        }
        return SAFE_PREFERENCE_NAMES.contains(key);
    }

    public String toString() {
        return this.toValueString();
    }

    public static Builder with() {
        return new Builder();
    }

    public static final class Builder {
        private final PreferencesApplied preferencesApplied = new PreferencesApplied();

        private Builder() {
        }

        public Builder allowEntityReferences() {
            this.add(PreferenceName.ALLOW_ENTITY_REFERENCES.getName(), null);
            return this;
        }

        public Builder callback() {
            this.add(PreferenceName.CALLBACK.getName(), null);
            return this;
        }

        public Builder continueOnError() {
            this.add(PreferenceName.CONTINUE_ON_ERROR.getName(), null);
            return this;
        }

        public Builder maxPageSize(Integer maxPageSize) {
            this.add(PreferenceName.MAX_PAGE_SIZE.getName(), Integer.toString(maxPageSize));
            return this;
        }

        public Builder trackChanges() {
            this.add(PreferenceName.TRACK_CHANGES.getName(), null);
            return this;
        }

        public Builder returnRepresentation(Preferences.Return returnRepresentation) {
            this.add(PreferenceName.RETURN.getName(), returnRepresentation.name().toLowerCase(Locale.ROOT));
            return this;
        }

        public Builder respondAsync() {
            this.add(PreferenceName.RESPOND_ASYNC.getName(), null);
            return this;
        }

        public Builder waitPreference(Integer wait) {
            this.add(PreferenceName.WAIT.getName(), Integer.toString(wait));
            return this;
        }

        public Builder preference(String name, String value) {
            if (name != null) {
                this.add(name.toLowerCase(Locale.ROOT), value);
            }
            return this;
        }

        public PreferencesApplied build() {
            return this.preferencesApplied;
        }

        private void add(String name, String value) {
            if (!this.preferencesApplied.applied.containsKey(name)) {
                this.preferencesApplied.applied.put(name, value);
            }
        }
    }
}

