/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.text;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.element.text.TextSectionElement;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.simple.Component;
import org.odftoolkit.simple.Document;
import org.odftoolkit.simple.table.AbstractTableContainer;
import org.odftoolkit.simple.table.Table;
import org.odftoolkit.simple.table.TableContainer;
import org.odftoolkit.simple.text.AbstractParagraphContainer;
import org.odftoolkit.simple.text.Paragraph;
import org.odftoolkit.simple.text.ParagraphContainer;
import org.odftoolkit.simple.text.ProtectionKeyDigestProvider;
import org.odftoolkit.simple.text.list.AbstractListContainer;
import org.odftoolkit.simple.text.list.List;
import org.odftoolkit.simple.text.list.ListContainer;
import org.odftoolkit.simple.text.list.ListDecorator;
import org.w3c.dom.Node;
import sun.misc.BASE64Encoder;

public class Section
extends Component
implements ParagraphContainer,
TableContainer,
ListContainer {
    private ParagraphContainerImpl paragraphContainerImpl;
    private TableContainerImpl tableContainerImpl;
    private ListContainerImpl listContainerImpl;
    private TextSectionElement mSectionElement;
    private Document mDocument;
    private ProtectionKeyDigestProvider protectionKeyDigestProvider;

    private Section(Document doc, TextSectionElement element) {
        this.mSectionElement = element;
        this.mDocument = doc;
    }

    public static Section getInstance(TextSectionElement element) {
        return new Section((Document)((OdfFileDom)element.getOwnerDocument()).getDocument(), element);
    }

    @Override
    public Document getOwnerDocument() {
        return this.mDocument;
    }

    public String getName() {
        return this.mSectionElement.getTextNameAttribute();
    }

    public void setName(String name) {
        this.mSectionElement.setTextNameAttribute(name);
    }

    public void remove() {
        this.mDocument.removeElementLinkedResource((OdfElement)this.mSectionElement);
        this.mSectionElement.getParentNode().removeChild((Node)this.mSectionElement);
        this.paragraphContainerImpl = null;
        this.mSectionElement = null;
        this.mDocument = null;
    }

    public TextSectionElement getOdfElement() {
        return this.mSectionElement;
    }

    boolean isInHeaderFooter() {
        try {
            if (this.mSectionElement.getOwnerDocument() == this.mDocument.getStylesDom()) {
                return true;
            }
        }
        catch (Exception e) {
            Logger.getLogger(Section.class.getName()).log(Level.SEVERE, "Failed in isInHeaderFooter", e);
        }
        return false;
    }

    public void setProtected(boolean isProtected) {
        this.mSectionElement.setTextProtectedAttribute(Boolean.valueOf(isProtected));
        if (!isProtected && this.getProtectedPassword() != null) {
            this.setProtectedWithPassword(null);
        }
    }

    public boolean isProtected() {
        return this.mSectionElement.getTextProtectedAttribute();
    }

    public void setProtectedWithPassword(String key) {
        if (key != null && key.length() > 0) {
            this.mSectionElement.setTextProtectionKeyAttribute(this.generateHashKey(key));
            this.mSectionElement.setTextProtectionKeyDigestAlgorithmAttribute(this.getDigestAlgorithm());
            this.setProtected(true);
        } else {
            this.mSectionElement.removeAttributeNS(OdfDocumentNamespace.TEXT.getUri(), "protection-key");
            this.mSectionElement.removeAttributeNS(OdfDocumentNamespace.TEXT.getUri(), "protection-key-digest-algorithm");
        }
    }

    public String getProtectedPassword() {
        return this.mSectionElement.getTextProtectionKeyAttribute();
    }

    public String getProtectionKeyDigestAlgorithm() {
        return this.mSectionElement.getTextProtectionKeyDigestAlgorithmAttribute();
    }

    public void setProtectionKeyDigestProvider(ProtectionKeyDigestProvider provider) {
        this.protectionKeyDigestProvider = provider;
    }

    public ProtectionKeyDigestProvider getProtectionKeyDigestProvier() {
        if (this.protectionKeyDigestProvider == null) {
            this.protectionKeyDigestProvider = this.getDefaultProtectionKeyDigestProvider();
        }
        return this.protectionKeyDigestProvider;
    }

    public ProtectionKeyDigestProvider getDefaultProtectionKeyDigestProvider() {
        return SHA1KeyDigest.getInstance();
    }

    private String generateHashKey(String passwd) {
        return this.getProtectionKeyDigestProvier().generateHashKey(passwd);
    }

    private String getDigestAlgorithm() {
        return this.getProtectionKeyDigestProvier().getProtectionKeyDigestAlgorithm();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Section)) {
            return false;
        }
        Section aSection = (Section)obj;
        if (aSection == this) {
            return true;
        }
        return aSection.getOdfElement().equals((Object)this.mSectionElement);
    }

    @Override
    public Paragraph addParagraph(String textContent) {
        return this.getParagraphContainerImpl().addParagraph(textContent);
    }

    @Override
    public OdfElement getParagraphContainerElement() {
        return this.getParagraphContainerImpl().getParagraphContainerElement();
    }

    @Override
    public boolean removeParagraph(Paragraph para) {
        return this.getParagraphContainerImpl().removeParagraph(para);
    }

    private ParagraphContainerImpl getParagraphContainerImpl() {
        if (this.paragraphContainerImpl == null) {
            this.paragraphContainerImpl = new ParagraphContainerImpl();
        }
        return this.paragraphContainerImpl;
    }

    @Override
    public Paragraph getParagraphByIndex(int index, boolean isEmptyParagraphSkipped) {
        return this.getParagraphContainerImpl().getParagraphByIndex(index, isEmptyParagraphSkipped);
    }

    @Override
    public Paragraph getParagraphByReverseIndex(int reverseIndex, boolean isEmptyParagraphSkipped) {
        return this.getParagraphContainerImpl().getParagraphByReverseIndex(reverseIndex, isEmptyParagraphSkipped);
    }

    @Override
    public Iterator<Paragraph> getParagraphIterator() {
        return this.getParagraphContainerImpl().getParagraphIterator();
    }

    protected TableContainer getTableContainerImpl() {
        if (this.tableContainerImpl == null) {
            this.tableContainerImpl = new TableContainerImpl();
        }
        return this.tableContainerImpl;
    }

    @Override
    public Table addTable() {
        return this.getTableContainerImpl().addTable();
    }

    @Override
    public Table addTable(int numRows, int numCols) {
        return this.getTableContainerImpl().addTable(numRows, numCols);
    }

    @Override
    public Table.TableBuilder getTableBuilder() {
        return this.getTableContainerImpl().getTableBuilder();
    }

    @Override
    public Table getTableByName(String name) {
        return this.getTableContainerImpl().getTableByName(name);
    }

    @Override
    public OdfElement getTableContainerElement() {
        return this.getTableContainerImpl().getTableContainerElement();
    }

    @Override
    public java.util.List<Table> getTableList() {
        return this.getTableContainerImpl().getTableList();
    }

    private ListContainerImpl getListContainerImpl() {
        if (this.listContainerImpl == null) {
            this.listContainerImpl = new ListContainerImpl();
        }
        return this.listContainerImpl;
    }

    @Override
    public List addList() {
        return this.getListContainerImpl().addList();
    }

    @Override
    public List addList(ListDecorator decorator) {
        return this.getListContainerImpl().addList(decorator);
    }

    @Override
    public void clearList() {
        this.getListContainerImpl().clearList();
    }

    @Override
    public OdfElement getListContainerElement() {
        return this.getListContainerImpl().getListContainerElement();
    }

    @Override
    public Iterator<List> getListIterator() {
        return this.getListContainerImpl().getListIterator();
    }

    @Override
    public boolean removeList(List list) {
        return this.getListContainerImpl().removeList(list);
    }

    public Section getEmbeddedSectionByName(String chdSecName) {
        TextSectionElement sectEle = this.getOdfElement();
        TextSectionElement sectChdEle = Section.findChildSectionByName((OdfElement)sectEle, chdSecName);
        if (sectChdEle != null) {
            return new Section((Document)((OdfFileDom)sectEle.getOwnerDocument()).getDocument(), sectChdEle);
        }
        return null;
    }

    private static TextSectionElement findChildSectionByName(OdfElement ele, String sectionName) {
        String name;
        if (ele instanceof TextSectionElement && (name = ((TextSectionElement)ele).getTextNameAttribute()) != null && name.equals(sectionName)) {
            return (TextSectionElement)ele;
        }
        for (Node chdNode = ele.getFirstChild(); chdNode != null; chdNode = chdNode.getNextSibling()) {
            TextSectionElement result;
            if (!(chdNode instanceof OdfElement) || (result = Section.findChildSectionByName((OdfElement)chdNode, sectionName)) == null) continue;
            return result;
        }
        return null;
    }

    private class ListContainerImpl
    extends AbstractListContainer {
        private ListContainerImpl() {
        }

        @Override
        public OdfElement getListContainerElement() {
            return Section.this.mSectionElement;
        }
    }

    private class TableContainerImpl
    extends AbstractTableContainer {
        private TableContainerImpl() {
        }

        @Override
        public OdfElement getTableContainerElement() {
            return Section.this.mSectionElement;
        }
    }

    private class ParagraphContainerImpl
    extends AbstractParagraphContainer {
        private ParagraphContainerImpl() {
        }

        @Override
        public OdfElement getParagraphContainerElement() {
            return Section.this.mSectionElement;
        }
    }

    private static class SHA1KeyDigest
    implements ProtectionKeyDigestProvider {
        private static final String KEY_DIGEST_ALGORITHM = "http://www.w3.org/2000/09/xmldsig#sha1";
        private static SHA1KeyDigest provider;

        private SHA1KeyDigest() {
        }

        static SHA1KeyDigest getInstance() {
            if (provider == null) {
                provider = new SHA1KeyDigest();
            }
            return provider;
        }

        @Override
        public String generateHashKey(String passwd) {
            String hashKey = null;
            if (passwd != null && passwd.length() > 0) {
                try {
                    byte[] pwd = new byte[passwd.length() * 2];
                    for (int i = 0; i < passwd.length(); ++i) {
                        pwd[2 * i] = (byte)(passwd.charAt(i) & 0xFF);
                        pwd[2 * i + 1] = (byte)(passwd.charAt(i) >> 8);
                    }
                    MessageDigest md = MessageDigest.getInstance("SHA-1");
                    byte[] byteCode = md.digest(pwd);
                    BASE64Encoder encoder = new BASE64Encoder();
                    hashKey = encoder.encode(byteCode);
                }
                catch (NoSuchAlgorithmException e) {
                    Logger.getLogger(Section.class.getName(), "Fail to initiate the digest method.");
                }
            }
            return hashKey;
        }

        @Override
        public String getProtectionKeyDigestAlgorithm() {
            return KEY_DIGEST_ALGORITHM;
        }
    }
}

