/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.presentation;

import java.awt.Rectangle;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.attribute.presentation.PresentationClassAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextAnchorTypeAttribute;
import org.odftoolkit.odfdom.dom.element.draw.DrawFrameElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawObjectElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawPageElement;
import org.odftoolkit.odfdom.dom.element.draw.DrawTextBoxElement;
import org.odftoolkit.odfdom.dom.element.presentation.PresentationNotesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleGraphicPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StylePresentationPageLayoutElement;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeStyles;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.type.CellRangeAddressList;
import org.odftoolkit.simple.Component;
import org.odftoolkit.simple.Document;
import org.odftoolkit.simple.PresentationDocument;
import org.odftoolkit.simple.SpreadsheetDocument;
import org.odftoolkit.simple.chart.AbstractChartContainer;
import org.odftoolkit.simple.chart.Chart;
import org.odftoolkit.simple.chart.ChartContainer;
import org.odftoolkit.simple.chart.DataSet;
import org.odftoolkit.simple.draw.AbstractTextboxContainer;
import org.odftoolkit.simple.draw.FrameRectangle;
import org.odftoolkit.simple.draw.Textbox;
import org.odftoolkit.simple.draw.TextboxContainer;
import org.odftoolkit.simple.presentation.Notes;
import org.odftoolkit.simple.table.AbstractTableContainer;
import org.odftoolkit.simple.table.Table;
import org.odftoolkit.simple.table.TableContainer;
import org.odftoolkit.simple.text.list.AbstractListContainer;
import org.odftoolkit.simple.text.list.ListContainer;
import org.odftoolkit.simple.text.list.ListDecorator;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Slide
extends Component
implements ListContainer,
TableContainer,
TextboxContainer,
ChartContainer {
    DrawPageElement maSlideElement;
    private ListContainerImpl listContainerImpl;
    private TableContainerImpl tableContainerImpl;
    private TextboxContainerImpl mTextboxContainerImpl;
    private ChartContainerImpl chartContainerImpl;

    private Slide(DrawPageElement pageElement) {
        this.maSlideElement = pageElement;
    }

    public static Slide getInstance(DrawPageElement pageElement) {
        PresentationDocument ownerDocument = (PresentationDocument)((OdfFileDom)pageElement.getOwnerDocument()).getDocument();
        return ownerDocument.getSlideBuilder().getSlideInstance(pageElement);
    }

    public DrawPageElement getOdfElement() {
        return this.maSlideElement;
    }

    public int getSlideIndex() {
        OdfFileDom contentDom = (OdfFileDom)this.maSlideElement.getOwnerDocument();
        NodeList slideNodes = contentDom.getElementsByTagNameNS(OdfDocumentNamespace.DRAW.getUri(), "page");
        for (int i = 0; i < slideNodes.getLength(); ++i) {
            DrawPageElement slideEle = (DrawPageElement)slideNodes.item(i);
            if (slideEle != this.maSlideElement) continue;
            return i;
        }
        return -1;
    }

    public String getSlideName() {
        String slideName = this.maSlideElement.getDrawNameAttribute();
        if (slideName == null) {
            slideName = this.makeUniqueSlideName();
            this.maSlideElement.setDrawNameAttribute(slideName);
        }
        return slideName;
    }

    public void setSlideName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("slide name is null is not accepted in the presentation document");
        }
        OdfFileDom contentDom = (OdfFileDom)this.maSlideElement.getOwnerDocument();
        NodeList slideNodes = contentDom.getElementsByTagNameNS(OdfDocumentNamespace.DRAW.getUri(), "page");
        for (int i = 0; i < slideNodes.getLength(); ++i) {
            DrawPageElement slideEle = (DrawPageElement)slideNodes.item(i);
            Slide slide = Slide.getInstance(slideEle);
            String slideName = slide.getSlideName();
            if (!slideName.equals(name)) continue;
            throw new IllegalArgumentException("the given slide name is already exist in the current presentation document");
        }
        this.maSlideElement.setDrawNameAttribute(name);
    }

    public Notes getNotesPage() {
        NodeList notesList = this.maSlideElement.getElementsByTagNameNS(OdfDocumentNamespace.PRESENTATION.getUri(), "notes");
        if (notesList.getLength() > 0) {
            PresentationNotesElement noteEle = (PresentationNotesElement)notesList.item(0);
            return Notes.getInstance(noteEle);
        }
        return null;
    }

    private String makeUniqueSlideName() {
        int index = this.getSlideIndex();
        String slideName = "page" + (index + 1) + "-" + String.format("a%06x", (int)(Math.random() * 1.6777215E7));
        return slideName;
    }

    @Override
    public OdfElement getListContainerElement() {
        return this.getListContainerImpl().getListContainerElement();
    }

    @Override
    public org.odftoolkit.simple.text.list.List addList() {
        return this.getListContainerImpl().addList();
    }

    @Override
    public org.odftoolkit.simple.text.list.List addList(ListDecorator decorator) {
        return this.getListContainerImpl().addList(decorator);
    }

    @Override
    public void clearList() {
        this.getListContainerImpl().clearList();
    }

    @Override
    public Iterator<org.odftoolkit.simple.text.list.List> getListIterator() {
        return this.getListContainerImpl().getListIterator();
    }

    @Override
    public boolean removeList(org.odftoolkit.simple.text.list.List list) {
        return this.getListContainerImpl().removeList(list);
    }

    private ListContainerImpl getListContainerImpl() {
        if (this.listContainerImpl == null) {
            this.listContainerImpl = new ListContainerImpl();
        }
        return this.listContainerImpl;
    }

    @Override
    public Table addTable() {
        return this.getTableContainerImpl().addTable();
    }

    @Override
    public Table addTable(int numRows, int numCols) {
        return this.getTableContainerImpl().addTable(numRows, numCols);
    }

    @Override
    public Table getTableByName(String name) {
        return this.getTableContainerImpl().getTableByName(name);
    }

    @Override
    public List<Table> getTableList() {
        return this.getTableContainerImpl().getTableList();
    }

    @Override
    public Table.TableBuilder getTableBuilder() {
        return this.getTableContainerImpl().getTableBuilder();
    }

    @Override
    public OdfElement getTableContainerElement() {
        return this.getTableContainerImpl().getTableContainerElement();
    }

    protected TableContainer getTableContainerImpl() {
        if (this.tableContainerImpl == null) {
            this.tableContainerImpl = new TableContainerImpl();
        }
        return this.tableContainerImpl;
    }

    @Override
    public Textbox addTextbox() {
        return this.getTextboxContainerImpl().addTextbox();
    }

    @Override
    public Iterator<Textbox> getTextboxIterator() {
        return this.getTextboxContainerImpl().getTextboxIterator();
    }

    @Override
    public boolean removeTextbox(Textbox box) {
        return this.getTextboxContainerImpl().removeTextbox(box);
    }

    @Override
    public OdfElement getFrameContainerElement() {
        return this.getTextboxContainerImpl().getFrameContainerElement();
    }

    @Override
    public Textbox addTextbox(FrameRectangle position) {
        return this.getTextboxContainerImpl().addTextbox(position);
    }

    @Override
    public Textbox getTextboxByName(String name) {
        return this.getTextboxContainerImpl().getTextboxByName(name);
    }

    private TextboxContainerImpl getTextboxContainerImpl() {
        if (this.mTextboxContainerImpl == null) {
            this.mTextboxContainerImpl = new TextboxContainerImpl();
        }
        return this.mTextboxContainerImpl;
    }

    @Override
    public List<Textbox> getTextboxByUsage(PresentationDocument.PresentationClass usage) {
        return this.getTextboxContainerImpl().getTextboxByUsage(usage);
    }

    @Override
    public Chart createChart(String title, DataSet dataset, Rectangle rect) {
        return this.getChartContainerImpl().createChart(title, dataset, rect);
    }

    @Override
    public Chart createChart(String title, SpreadsheetDocument document, CellRangeAddressList cellRangeAddr, boolean firstRowAsLabel, boolean firstColumnAsLabel, boolean rowAsDataSeries, Rectangle rect) {
        return this.getChartContainerImpl().createChart(title, document, cellRangeAddr, firstRowAsLabel, firstColumnAsLabel, rowAsDataSeries, rect);
    }

    @Override
    public Chart createChart(String title, String[] labels, String[] legends, double[][] data, Rectangle rect) {
        return this.getChartContainerImpl().createChart(title, labels, legends, data, rect);
    }

    @Override
    public void deleteChartById(String chartId) {
        this.getChartContainerImpl().deleteChartById(chartId);
    }

    @Override
    public void deleteChartByTitle(String title) {
        this.getChartContainerImpl().deleteChartByTitle(title);
    }

    @Override
    public Chart getChartById(String chartId) {
        return this.getChartContainerImpl().getChartById(chartId);
    }

    @Override
    public List<Chart> getChartByTitle(String title) {
        return this.getChartContainerImpl().getChartByTitle(title);
    }

    @Override
    public int getChartCount() {
        return this.getChartContainerImpl().getChartCount();
    }

    private ChartContainerImpl getChartContainerImpl() {
        if (this.chartContainerImpl == null) {
            this.chartContainerImpl = new ChartContainerImpl(this.getOwnerDocument(), this);
        }
        return this.chartContainerImpl;
    }

    private class ChartContainerImpl
    extends AbstractChartContainer {
        DrawPageElement slide;

        protected ChartContainerImpl(Document doc, Slide slide2) {
            super(doc);
            this.slide = slide2.getOdfElement();
        }

        protected DrawFrameElement getChartFrame() throws Exception {
            DrawFrameElement element = (DrawFrameElement)OdfElement.findFirstChildNode(DrawFrameElement.class, (Node)this.slide);
            while (element != null) {
                if ("chart".equals(element.getPresentationClassAttribute())) {
                    DrawObjectElement chartEle = (DrawObjectElement)OdfElement.findFirstChildNode(DrawObjectElement.class, (Node)element);
                    if (chartEle == null) {
                        return element;
                    }
                    String href = chartEle.getXlinkHrefAttribute();
                    if ("".equals(href) || href == null) {
                        return element;
                    }
                }
                element = (DrawFrameElement)OdfElement.findNextChildNode(DrawFrameElement.class, (Node)element);
            }
            return null;
        }
    }

    private class TextboxContainerImpl
    extends AbstractTextboxContainer {
        private TextboxContainerImpl() {
        }

        public OdfElement getFrameContainerElement() {
            return Slide.this.maSlideElement;
        }
    }

    private class TableContainerImpl
    extends AbstractTableContainer {
        private TableContainerImpl() {
        }

        public OdfElement getTableContainerElement() {
            DrawFrameElement frame = null;
            NodeList frameList = Slide.this.maSlideElement.getElementsByTagNameNS(OdfDocumentNamespace.DRAW.getUri(), "frame");
            if (frameList.getLength() > 0) {
                String presentationClass;
                for (int index = frameList.getLength() - 1; index >= 0 && (presentationClass = (frame = (DrawFrameElement)frameList.item(index)).getPresentationClassAttribute()) != null && !"table".equals(presentationClass); --index) {
                    frame = null;
                }
            }
            if (frame == null) {
                frame = Slide.this.maSlideElement.newDrawFrameElement();
                frame.setPresentationClassAttribute("table");
                frame.setDrawLayerAttribute("layout");
                frame.setStyleName("standard");
                frame.setSvgHeightAttribute("1.945cm");
                frame.setSvgWidthAttribute("14.098cm");
                frame.setSvgXAttribute("6.922cm");
                frame.setSvgYAttribute("10.386cm");
            }
            return frame;
        }
    }

    private class ListContainerImpl
    extends AbstractListContainer {
        private ListContainerImpl() {
        }

        public OdfElement getListContainerElement() {
            DrawFrameElement frame = null;
            DrawTextBoxElement textBox = null;
            NodeList frameList = Slide.this.maSlideElement.getElementsByTagNameNS(OdfDocumentNamespace.DRAW.getUri(), "frame");
            if (frameList.getLength() > 0) {
                String presentationClass;
                for (int index = frameList.getLength() - 1; !(index < 0 || (presentationClass = (frame = (DrawFrameElement)frameList.item(index)).getPresentationClassAttribute()) == null || "outline".equals(presentationClass) || "text".equals(presentationClass) || "subtitle".equals(presentationClass)); --index) {
                    frame = null;
                }
            }
            if (frame == null) {
                throw new UnsupportedOperationException("There is no list container in this slide, please chose a proper slide layout.");
            }
            NodeList textBoxList = frame.getElementsByTagNameNS(OdfDocumentNamespace.DRAW.getUri(), "text-box");
            textBox = textBoxList.getLength() <= 0 ? frame.newDrawTextBoxElement() : (DrawTextBoxElement)textBoxList.item(textBoxList.getLength() - 1);
            return textBox;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SlideLayout {
        BLANK("blank"){

            public void apply(DrawPageElement page) {
            }
        }
        ,
        TITLE_ONLY("title_only"){

            public void apply(DrawPageElement page) {
                Document doc = (Document)((OdfFileDom)page.getOwnerDocument()).getDocument();
                OdfOfficeStyles styles = doc.getOrCreateDocumentStyles();
                String layoutName = "AL1T" + SlideLayout.makeUniqueName();
                try {
                    StylePresentationPageLayoutElement layout = styles.newStylePresentationPageLayoutElement(layoutName);
                    layout.newPresentationPlaceholderElement("title", "2.058cm", "1.743cm", "23.91cm", "3.507cm");
                }
                catch (Exception e1) {
                    Logger.getLogger(SlideLayout.class.getName()).log(Level.SEVERE, null, e1);
                }
                page.setPresentationPresentationPageLayoutNameAttribute(layoutName);
                DrawFrameElement frame1 = page.newDrawFrameElement();
                frame1.setProperty(StyleGraphicPropertiesElement.StyleShadow, "true");
                frame1.setProperty(StyleGraphicPropertiesElement.AutoGrowHeight, "true");
                frame1.setProperty(StyleGraphicPropertiesElement.MinHeight, "3.507");
                frame1.setPresentationStyleNameAttribute(frame1.getStyleName());
                frame1.setDrawLayerAttribute("layout");
                frame1.setSvgHeightAttribute("3.006cm");
                frame1.setSvgWidthAttribute("24.299cm");
                frame1.setSvgXAttribute("1.35cm");
                frame1.setSvgYAttribute("0.717cm");
                frame1.setPresentationClassAttribute(PresentationClassAttribute.Value.TITLE.toString());
                frame1.setPresentationPlaceholderAttribute(Boolean.valueOf(true));
                frame1.newDrawTextBoxElement();
            }
        }
        ,
        TITLE_SUBTITLE("title_subtitle"){

            public void apply(DrawPageElement page) {
                Document doc = (Document)((OdfFileDom)page.getOwnerDocument()).getDocument();
                OdfOfficeStyles styles = doc.getOrCreateDocumentStyles();
                String layoutName = "AL1T" + SlideLayout.makeUniqueName();
                try {
                    styles = doc.getStylesDom().getOfficeStyles();
                    if (styles == null) {
                        styles = (OdfOfficeStyles)doc.getStylesDom().newOdfElement(OdfOfficeStyles.class);
                    }
                    StylePresentationPageLayoutElement layout = styles.newStylePresentationPageLayoutElement(layoutName);
                    layout.newPresentationPlaceholderElement("title", "3.507cm", "23.912cm", "2.058cm", "1.743cm");
                    layout.newPresentationPlaceholderElement("subtitle", "13.23cm", "23.912cm", "2.058cm", "5.838cm");
                }
                catch (Exception e1) {
                    Logger.getLogger(SlideLayout.class.getName()).log(Level.SEVERE, null, e1);
                }
                page.setPresentationPresentationPageLayoutNameAttribute(layoutName);
                DrawFrameElement frame1 = page.newDrawFrameElement();
                frame1.setPresentationStyleNameAttribute(frame1.getStyleName());
                frame1.setDrawLayerAttribute("layout");
                frame1.setSvgHeightAttribute("4.244cm");
                frame1.setSvgWidthAttribute("23.848cm");
                frame1.setSvgXAttribute("2.075cm");
                frame1.setSvgYAttribute("6.621cm");
                frame1.setPresentationClassAttribute(PresentationClassAttribute.Value.TITLE.toString());
                frame1.setTextAnchorTypeAttribute(TextAnchorTypeAttribute.Value.PAGE.toString());
                frame1.setPresentationPlaceholderAttribute(Boolean.valueOf(true));
                frame1.newDrawTextBoxElement();
                DrawFrameElement frame2 = page.newDrawFrameElement();
                frame2.setPresentationStyleNameAttribute(frame2.getStyleName());
                frame2.setDrawLayerAttribute("layout");
                frame2.setSvgHeightAttribute("5.097cm");
                frame2.setSvgWidthAttribute("19.631cm");
                frame2.setSvgXAttribute("4.183cm");
                frame2.setSvgYAttribute("12.003cm");
                frame2.setPresentationClassAttribute(PresentationClassAttribute.Value.SUBTITLE.toString());
                frame2.setTextAnchorTypeAttribute(TextAnchorTypeAttribute.Value.PAGE.toString());
                frame2.setPresentationPlaceholderAttribute(Boolean.valueOf(true));
                frame2.newDrawTextBoxElement();
            }
        }
        ,
        TITLE_OUTLINE("title_outline"){

            public void apply(DrawPageElement page) {
                Document doc = (Document)((OdfFileDom)page.getOwnerDocument()).getDocument();
                OdfOfficeStyles styles = doc.getOrCreateDocumentStyles();
                String layoutName = SlideLayout.makeUniqueName();
                try {
                    if (styles == null) {
                        styles = doc.getStylesDom().getOfficeStyles();
                    }
                    if (styles == null) {
                        styles = (OdfOfficeStyles)doc.getStylesDom().newOdfElement(OdfOfficeStyles.class);
                    }
                    StylePresentationPageLayoutElement layout = styles.newStylePresentationPageLayoutElement(layoutName);
                    layout.newPresentationPlaceholderElement("title", "2.058cm", "1.743cm", "23.91cm", "3.507cm");
                    layout.newPresentationPlaceholderElement("outline", "2.058cm", "1.743cm", "23.91cm", "3.507cm");
                }
                catch (Exception e1) {
                    Logger.getLogger(SlideLayout.class.getName()).log(Level.SEVERE, null, e1);
                }
                page.setPresentationPresentationPageLayoutNameAttribute(layoutName);
                DrawFrameElement frame1 = page.newDrawFrameElement();
                frame1.setProperty(StyleGraphicPropertiesElement.StyleShadow, "true");
                frame1.setProperty(StyleGraphicPropertiesElement.AutoGrowHeight, "true");
                frame1.setProperty(StyleGraphicPropertiesElement.MinHeight, "3.507");
                frame1.setPresentationStyleNameAttribute(frame1.getStyleName());
                frame1.setDrawLayerAttribute("layout");
                frame1.setSvgHeightAttribute("3.006cm");
                frame1.setSvgWidthAttribute("24.299cm");
                frame1.setSvgXAttribute("1.35cm");
                frame1.setSvgYAttribute("0.717cm");
                frame1.setPresentationClassAttribute(PresentationClassAttribute.Value.TITLE.toString());
                frame1.setPresentationPlaceholderAttribute(Boolean.valueOf(true));
                frame1.newDrawTextBoxElement();
                DrawFrameElement frame2 = page.newDrawFrameElement();
                frame2.setProperty(StyleGraphicPropertiesElement.FillColor, "#ffffff");
                frame2.setProperty(StyleGraphicPropertiesElement.MinHeight, "13.114");
                frame2.setPresentationStyleNameAttribute(frame2.getStyleName());
                frame2.setDrawLayerAttribute("layout");
                frame2.setSvgHeightAttribute("11.629cm");
                frame2.setSvgWidthAttribute("24.199cm");
                frame2.setSvgXAttribute("1.35cm");
                frame2.setSvgYAttribute("4.337cm");
                frame2.setPresentationClassAttribute(PresentationClassAttribute.Value.OUTLINE.toString());
                frame2.setPresentationPlaceholderAttribute(Boolean.valueOf(true));
                frame2.newDrawTextBoxElement();
            }
        }
        ,
        TITLE_PLUS_TEXT("title_text"){

            public void apply(DrawPageElement page) {
                Document doc = (Document)((OdfFileDom)page.getOwnerDocument()).getDocument();
                OdfOfficeStyles styles = doc.getOrCreateDocumentStyles();
                String layoutName = SlideLayout.makeUniqueName();
                try {
                    if (styles == null) {
                        styles = doc.getStylesDom().getOfficeStyles();
                    }
                    if (styles == null) {
                        styles = (OdfOfficeStyles)doc.getStylesDom().newOdfElement(OdfOfficeStyles.class);
                    }
                    StylePresentationPageLayoutElement layout = styles.newStylePresentationPageLayoutElement(layoutName);
                    layout.newPresentationPlaceholderElement("title", "2.058cm", "1.743cm", "23.91cm", "1.743cm");
                    layout.newPresentationPlaceholderElement("subtitle", "2.058cm", "5.838cm", "23.91cm", "13.23cm");
                }
                catch (Exception e1) {
                    Logger.getLogger(SlideLayout.class.getName()).log(Level.SEVERE, null, e1);
                }
                page.setPresentationPresentationPageLayoutNameAttribute(layoutName);
                DrawFrameElement frame1 = page.newDrawFrameElement();
                frame1.setProperty(StyleGraphicPropertiesElement.AutoGrowHeight, "true");
                frame1.setProperty(StyleGraphicPropertiesElement.MinHeight, "3.507");
                frame1.setPresentationStyleNameAttribute(frame1.getStyleName());
                frame1.setDrawLayerAttribute("layout");
                frame1.setSvgHeightAttribute("3.006cm");
                frame1.setSvgWidthAttribute("24.299cm");
                frame1.setSvgXAttribute("1.35cm");
                frame1.setSvgYAttribute("0.717cm");
                frame1.setPresentationClassAttribute(PresentationClassAttribute.Value.TITLE.toString());
                frame1.setPresentationPlaceholderAttribute(Boolean.valueOf(true));
                frame1.newDrawTextBoxElement();
                DrawFrameElement frame2 = page.newDrawFrameElement();
                frame2.setProperty(StyleGraphicPropertiesElement.AutoGrowHeight, "true");
                frame2.setProperty(StyleGraphicPropertiesElement.MinHeight, "3.507");
                frame2.setPresentationStyleNameAttribute(frame2.getStyleName());
                frame2.setDrawLayerAttribute("layout");
                frame2.setSvgHeightAttribute("11.88cm");
                frame2.setSvgWidthAttribute("24.299cm");
                frame2.setSvgXAttribute("1.35cm");
                frame2.setSvgYAttribute("4.712cm");
                frame2.setPresentationClassAttribute(PresentationClassAttribute.Value.SUBTITLE.toString());
                frame2.setPresentationPlaceholderAttribute(Boolean.valueOf(true));
                frame2.newDrawTextBoxElement();
            }
        }
        ,
        TITLE_PLUS_2_TEXT_BLOCK("title_two_text_block"){

            public void apply(DrawPageElement page) {
                Document doc = (Document)((OdfFileDom)page.getOwnerDocument()).getDocument();
                OdfOfficeStyles styles = doc.getOrCreateDocumentStyles();
                String layoutName = SlideLayout.makeUniqueName();
                try {
                    if (styles == null) {
                        styles = doc.getStylesDom().getOfficeStyles();
                    }
                    if (styles == null) {
                        styles = (OdfOfficeStyles)doc.getStylesDom().newOdfElement(OdfOfficeStyles.class);
                    }
                    StylePresentationPageLayoutElement layout = styles.newStylePresentationPageLayoutElement(layoutName);
                    layout.newPresentationPlaceholderElement("outline", "2.058cm", "1.743cm", "23.91cm", "1.743cm");
                    layout.newPresentationPlaceholderElement("outline", "1.35cm", "4.212cm", "11.857cm", "11.629cm");
                    layout.newPresentationPlaceholderElement("outline", "4.212cm", "13.8cm", "11.857cm", "11.629cm");
                }
                catch (Exception e1) {
                    Logger.getLogger(SlideLayout.class.getName()).log(Level.SEVERE, null, e1);
                }
                page.setPresentationPresentationPageLayoutNameAttribute(layoutName);
                DrawFrameElement frame1 = page.newDrawFrameElement();
                frame1.setProperty(StyleGraphicPropertiesElement.AutoGrowHeight, "true");
                frame1.setProperty(StyleGraphicPropertiesElement.MinHeight, "3.507");
                frame1.setPresentationStyleNameAttribute(frame1.getStyleName());
                frame1.setDrawLayerAttribute("layout");
                frame1.setSvgHeightAttribute("3.006cm");
                frame1.setSvgWidthAttribute("24.299cm");
                frame1.setSvgXAttribute("1.35cm");
                frame1.setSvgYAttribute("0.717cm");
                frame1.setPresentationClassAttribute(PresentationClassAttribute.Value.TITLE.toString());
                frame1.setPresentationPlaceholderAttribute(Boolean.valueOf(true));
                frame1.newDrawTextBoxElement();
                DrawFrameElement frame2 = page.newDrawFrameElement();
                frame2.setProperty(StyleGraphicPropertiesElement.AutoGrowHeight, "true");
                frame2.setProperty(StyleGraphicPropertiesElement.MinHeight, "3.507");
                frame2.setPresentationStyleNameAttribute(frame2.getStyleName());
                frame2.setDrawLayerAttribute("layout");
                frame2.setSvgHeightAttribute("11.629cm");
                frame2.setSvgWidthAttribute("11.857cm");
                frame2.setSvgXAttribute("1.35cm");
                frame2.setSvgYAttribute("4.212cm");
                frame2.setPresentationClassAttribute(PresentationClassAttribute.Value.OUTLINE.toString());
                frame2.setPresentationPlaceholderAttribute(Boolean.valueOf(true));
                frame2.newDrawTextBoxElement();
                DrawFrameElement frame3 = page.newDrawFrameElement();
                frame3.setProperty(StyleGraphicPropertiesElement.AutoGrowHeight, "true");
                frame3.setProperty(StyleGraphicPropertiesElement.MinHeight, "3.507");
                frame3.setPresentationStyleNameAttribute(frame3.getStyleName());
                frame3.setDrawLayerAttribute("layout");
                frame3.setSvgHeightAttribute("11.62cm");
                frame3.setSvgWidthAttribute("11.857cm");
                frame3.setSvgXAttribute("13.8cm");
                frame3.setSvgYAttribute("4.212cm");
                frame3.setPresentationClassAttribute(PresentationClassAttribute.Value.OUTLINE.toString());
                frame3.setPresentationPlaceholderAttribute(Boolean.valueOf(true));
                frame3.newDrawTextBoxElement();
            }
        }
        ,
        TITLE_LEFT_CHART_RIGHT_OUTLINE("title_left_chart_right_outline"){

            public void apply(DrawPageElement page) {
                Document doc = (Document)((OdfFileDom)page.getOwnerDocument()).getDocument();
                OdfOfficeStyles styles = doc.getOrCreateDocumentStyles();
                String layoutName = SlideLayout.makeUniqueName();
                try {
                    styles = doc.getStylesDom().getOfficeStyles();
                    if (styles == null) {
                        styles = (OdfOfficeStyles)doc.getStylesDom().newOdfElement(OdfOfficeStyles.class);
                    }
                    StylePresentationPageLayoutElement layout = styles.newStylePresentationPageLayoutElement(layoutName);
                    layout.newPresentationPlaceholderElement("title", "3.507cm", "25.199cm", "1.4cm", "0.837cm");
                    layout.newPresentationPlaceholderElement("chart", "13.86cm", "12.296cm", "1.4cm", "4.914cm");
                    layout.newPresentationPlaceholderElement("outline", "13.86cm", "12.296cm", "14.311cm", "4.914cm");
                }
                catch (Exception e1) {
                    Logger.getLogger(SlideLayout.class.getName()).log(Level.SEVERE, null, e1);
                }
                page.setPresentationPresentationPageLayoutNameAttribute(layoutName);
                DrawFrameElement frame1 = page.newDrawFrameElement();
                frame1.setPresentationStyleNameAttribute(frame1.getStyleName());
                frame1.setDrawLayerAttribute("layout");
                frame1.setSvgHeightAttribute("3.507cm");
                frame1.setSvgWidthAttribute("25.199cm");
                frame1.setSvgXAttribute("1.4cm");
                frame1.setSvgYAttribute("0.837cm");
                frame1.setPresentationClassAttribute(PresentationClassAttribute.Value.TITLE.toString());
                frame1.setPresentationPlaceholderAttribute(Boolean.valueOf(true));
                frame1.newDrawTextBoxElement();
                DrawFrameElement frame2 = page.newDrawFrameElement();
                frame2.setDrawStyleNameAttribute(frame2.getStyleName());
                frame2.setDrawLayerAttribute("layout");
                frame2.setSvgHeightAttribute("13.86cm");
                frame2.setSvgWidthAttribute("12.296cm");
                frame2.setSvgXAttribute("1.4cm");
                frame2.setSvgYAttribute("4.914cm");
                frame2.setPresentationClassAttribute(PresentationClassAttribute.Value.CHART.toString());
                frame2.setPresentationPlaceholderAttribute(Boolean.valueOf(true));
                frame2.setTextAnchorTypeAttribute(TextAnchorTypeAttribute.Value.PAGE.toString());
                frame2.newDrawObjectElement();
                DrawFrameElement frame3 = page.newDrawFrameElement();
                frame3.setPresentationStyleNameAttribute(frame3.getStyleName());
                frame3.setDrawLayerAttribute("layout");
                frame3.setSvgHeightAttribute("13.86cm");
                frame3.setSvgWidthAttribute("12.296cm");
                frame3.setSvgXAttribute("14.311cm");
                frame3.setSvgYAttribute("4.914cm");
                frame3.setPresentationClassAttribute(PresentationClassAttribute.Value.OUTLINE.toString());
                frame3.setPresentationPlaceholderAttribute(Boolean.valueOf(true));
                frame3.newDrawTextBoxElement();
            }
        }
        ,
        TITLE_PLUS_CHART("title_plus_chart"){

            public void apply(DrawPageElement page) {
                Document doc = (Document)((OdfFileDom)page.getOwnerDocument()).getDocument();
                OdfOfficeStyles styles = doc.getOrCreateDocumentStyles();
                String layoutName = "AL1T" + SlideLayout.makeUniqueName();
                try {
                    styles = doc.getStylesDom().getOfficeStyles();
                    if (styles == null) {
                        styles = (OdfOfficeStyles)doc.getStylesDom().newOdfElement(OdfOfficeStyles.class);
                    }
                    StylePresentationPageLayoutElement layout = styles.newStylePresentationPageLayoutElement(layoutName);
                    layout.newPresentationPlaceholderElement("title", "3.507cm", "25.199cm", "1.4cm", "0.837cm");
                    layout.newPresentationPlaceholderElement("chart", "13.86cm", "25.199cm", "1.4cm", "4.914cm");
                }
                catch (Exception e1) {
                    Logger.getLogger(SlideLayout.class.getName()).log(Level.SEVERE, null, e1);
                }
                page.setPresentationPresentationPageLayoutNameAttribute(layoutName);
                DrawFrameElement frame1 = page.newDrawFrameElement();
                frame1.setPresentationStyleNameAttribute(frame1.getStyleName());
                frame1.setDrawLayerAttribute("layout");
                frame1.setSvgHeightAttribute("3.507cm");
                frame1.setSvgWidthAttribute("25.199cm");
                frame1.setSvgXAttribute("1.4cm");
                frame1.setSvgYAttribute("0.837cm");
                frame1.setPresentationClassAttribute(PresentationClassAttribute.Value.TITLE.toString());
                frame1.setPresentationPlaceholderAttribute(Boolean.valueOf(true));
                frame1.newDrawTextBoxElement();
                DrawFrameElement frame2 = page.newDrawFrameElement();
                frame2.setDrawStyleNameAttribute(frame2.getStyleName());
                frame2.setDrawLayerAttribute("layout");
                frame2.setSvgHeightAttribute("13.86cm");
                frame2.setSvgWidthAttribute("25.199cm");
                frame2.setSvgXAttribute("1.4cm");
                frame2.setSvgYAttribute("4.914cm");
                frame2.setPresentationClassAttribute(PresentationClassAttribute.Value.CHART.toString());
                frame2.setPresentationPlaceholderAttribute(Boolean.valueOf(true));
                frame2.setTextAnchorTypeAttribute(TextAnchorTypeAttribute.Value.PAGE.toString());
                frame2.newDrawObjectElement();
            }
        }
        ,
        TITLE_PLUS_2_CHART("title_plus_2_chart"){

            public void apply(DrawPageElement page) {
                Document doc = (Document)((OdfFileDom)page.getOwnerDocument()).getDocument();
                OdfOfficeStyles styles = doc.getOrCreateDocumentStyles();
                String layoutName = SlideLayout.makeUniqueName();
                try {
                    styles = doc.getStylesDom().getOfficeStyles();
                    if (styles == null) {
                        styles = (OdfOfficeStyles)doc.getStylesDom().newOdfElement(OdfOfficeStyles.class);
                    }
                    StylePresentationPageLayoutElement layout = styles.newStylePresentationPageLayoutElement(layoutName);
                    layout.newPresentationPlaceholderElement("title", "3.507cm", "25.199cm", "1.4cm", "0.837cm");
                    layout.newPresentationPlaceholderElement("chart", "6.61cm", "25.199cm", "1.4cm", "4.914cm");
                    layout.newPresentationPlaceholderElement("chart", "6.61cm", "25.199cm", "1.4cm", "12.153cm");
                }
                catch (Exception e1) {
                    Logger.getLogger(SlideLayout.class.getName()).log(Level.SEVERE, null, e1);
                }
                page.setPresentationPresentationPageLayoutNameAttribute(layoutName);
                DrawFrameElement frame1 = page.newDrawFrameElement();
                frame1.setPresentationStyleNameAttribute(frame1.getStyleName());
                frame1.setDrawLayerAttribute("layout");
                frame1.setSvgHeightAttribute("3.507cm");
                frame1.setSvgWidthAttribute("25.199cm");
                frame1.setSvgXAttribute("1.4cm");
                frame1.setSvgYAttribute("0.837cm");
                frame1.setPresentationClassAttribute(PresentationClassAttribute.Value.TITLE.toString());
                frame1.setPresentationPlaceholderAttribute(Boolean.valueOf(true));
                frame1.newDrawTextBoxElement();
                DrawFrameElement frame2 = page.newDrawFrameElement();
                frame2.setDrawStyleNameAttribute(frame2.getStyleName());
                frame2.setDrawLayerAttribute("layout");
                frame2.setSvgHeightAttribute("6.61cm");
                frame2.setSvgWidthAttribute("25.199cm");
                frame2.setSvgXAttribute("1.4cm");
                frame2.setSvgYAttribute("4.914cm");
                frame2.setPresentationClassAttribute(PresentationClassAttribute.Value.CHART.toString());
                frame2.setPresentationPlaceholderAttribute(Boolean.valueOf(true));
                frame2.setTextAnchorTypeAttribute(TextAnchorTypeAttribute.Value.PAGE.toString());
                frame2.newDrawObjectElement();
                DrawFrameElement frame3 = page.newDrawFrameElement();
                frame3.setDrawStyleNameAttribute(frame3.getStyleName());
                frame3.setDrawLayerAttribute("layout");
                frame3.setSvgHeightAttribute("6.61cm");
                frame3.setSvgWidthAttribute("25.199cm");
                frame3.setSvgXAttribute("1.4cm");
                frame3.setSvgYAttribute("12.153cm");
                frame3.setPresentationClassAttribute(PresentationClassAttribute.Value.CHART.toString());
                frame3.setPresentationPlaceholderAttribute(Boolean.valueOf(true));
                frame2.setTextAnchorTypeAttribute(TextAnchorTypeAttribute.Value.PAGE.toString());
                frame3.newDrawObjectElement();
            }
        }
        ,
        TITLE_PLUS_3_OBJECT("title_plus_three_object"){

            public void apply(DrawPageElement page) {
                Document doc = (Document)((OdfFileDom)page.getOwnerDocument()).getDocument();
                OdfOfficeStyles styles = doc.getOrCreateDocumentStyles();
                String layoutName = SlideLayout.makeUniqueName();
                try {
                    styles = doc.getStylesDom().getOfficeStyles();
                    if (styles == null) {
                        styles = (OdfOfficeStyles)doc.getStylesDom().newOdfElement(OdfOfficeStyles.class);
                    }
                    StylePresentationPageLayoutElement layout = styles.newStylePresentationPageLayoutElement(layoutName);
                    layout.newPresentationPlaceholderElement("title", "3.507cm", "25.199cm", "1.4cm", "0.837cm");
                    layout.newPresentationPlaceholderElement("chart", "6.61cm", "12.296cm", "1.4cm", "4.914cm");
                    layout.newPresentationPlaceholderElement("outline", "6.61cm", "12.296cm", "14.311cm", "4.914cm");
                    layout.newPresentationPlaceholderElement("chart", "6.61cm", "25.199cm", "1.4cm", "12.153cm");
                }
                catch (Exception e1) {
                    Logger.getLogger(SlideLayout.class.getName()).log(Level.SEVERE, null, e1);
                }
                page.setPresentationPresentationPageLayoutNameAttribute(layoutName);
                DrawFrameElement frame1 = page.newDrawFrameElement();
                frame1.setPresentationStyleNameAttribute(frame1.getStyleName());
                frame1.setDrawLayerAttribute("layout");
                frame1.setSvgHeightAttribute("3.507cm");
                frame1.setSvgWidthAttribute("25.199cm");
                frame1.setSvgXAttribute("1.4cm");
                frame1.setSvgYAttribute("0.837cm");
                frame1.setPresentationClassAttribute(PresentationClassAttribute.Value.TITLE.toString());
                frame1.setPresentationPlaceholderAttribute(Boolean.valueOf(true));
                frame1.newDrawTextBoxElement();
                DrawFrameElement frame2 = page.newDrawFrameElement();
                frame2.setDrawStyleNameAttribute(frame2.getStyleName());
                frame2.setDrawLayerAttribute("layout");
                frame2.setSvgHeightAttribute("6.61cm");
                frame2.setSvgWidthAttribute("12.296cm");
                frame2.setSvgXAttribute("1.4cm");
                frame2.setSvgYAttribute("4.914cm");
                frame2.setPresentationClassAttribute(PresentationClassAttribute.Value.CHART.toString());
                frame2.setPresentationPlaceholderAttribute(Boolean.valueOf(true));
                frame2.setTextAnchorTypeAttribute(TextAnchorTypeAttribute.Value.PAGE.toString());
                frame2.newDrawObjectElement();
                DrawFrameElement frame3 = page.newDrawFrameElement();
                frame3.setPresentationStyleNameAttribute(frame3.getStyleName());
                frame3.setDrawLayerAttribute("layout");
                frame3.setSvgHeightAttribute("6.61cm");
                frame3.setSvgWidthAttribute("12.296cm");
                frame3.setSvgXAttribute("14.311cm");
                frame3.setSvgYAttribute("4.914cm");
                frame3.setPresentationClassAttribute(PresentationClassAttribute.Value.OUTLINE.toString());
                frame3.setPresentationPlaceholderAttribute(Boolean.valueOf(true));
                frame3.setTextAnchorTypeAttribute(TextAnchorTypeAttribute.Value.PAGE.toString());
                frame3.newDrawTextBoxElement();
                DrawFrameElement frame4 = page.newDrawFrameElement();
                frame4.setDrawStyleNameAttribute(frame4.getStyleName());
                frame4.setDrawLayerAttribute("layout");
                frame4.setSvgHeightAttribute("6.61cm");
                frame4.setSvgWidthAttribute("25.199cm");
                frame4.setSvgXAttribute("1.4cm");
                frame4.setSvgYAttribute("12.153cm");
                frame4.setPresentationClassAttribute(PresentationClassAttribute.Value.CHART.toString());
                frame4.setTextAnchorTypeAttribute(TextAnchorTypeAttribute.Value.PAGE.toString());
                frame4.setPresentationPlaceholderAttribute(Boolean.valueOf(true));
                frame4.newDrawObjectElement();
            }
        }
        ,
        TITLE_PLUS_4_OBJECT("title_four_object"){

            public void apply(DrawPageElement page) {
                Document doc = (Document)((OdfFileDom)page.getOwnerDocument()).getDocument();
                OdfOfficeStyles styles = doc.getOrCreateDocumentStyles();
                String layoutName = SlideLayout.makeUniqueName();
                try {
                    styles = doc.getStylesDom().getOfficeStyles();
                    if (styles == null) {
                        styles = (OdfOfficeStyles)doc.getStylesDom().newOdfElement(OdfOfficeStyles.class);
                    }
                    StylePresentationPageLayoutElement layout = styles.newStylePresentationPageLayoutElement(layoutName);
                    layout.newPresentationPlaceholderElement("title", "3.507cm", "25.199cm", "1.4cm", "0.837cm");
                    layout.newPresentationPlaceholderElement("chart", "6.61cm", "12.296cm", "1.4cm", "4.914cm");
                    layout.newPresentationPlaceholderElement("outline", "6.61cm", "12.296cm", "14.311cm", "4.914cm");
                    layout.newPresentationPlaceholderElement("chart", "6.61cm", "12.296cm", "1.4cm", "12.153cm");
                    layout.newPresentationPlaceholderElement("chart", "6.61cm", "12.296cm", "14.311cm", "12.153cm");
                }
                catch (Exception e1) {
                    Logger.getLogger(SlideLayout.class.getName()).log(Level.SEVERE, null, e1);
                }
                page.setPresentationPresentationPageLayoutNameAttribute(layoutName);
                DrawFrameElement frame1 = page.newDrawFrameElement();
                frame1.setPresentationStyleNameAttribute(frame1.getStyleName());
                frame1.setDrawLayerAttribute("layout");
                frame1.setSvgHeightAttribute("3.507cm");
                frame1.setSvgWidthAttribute("25.199cm");
                frame1.setSvgXAttribute("1.4cm");
                frame1.setSvgYAttribute("0.837cm");
                frame1.setPresentationClassAttribute(PresentationClassAttribute.Value.TITLE.toString());
                frame1.setPresentationPlaceholderAttribute(Boolean.valueOf(true));
                frame1.newDrawTextBoxElement();
                DrawFrameElement frame2 = page.newDrawFrameElement();
                frame2.setDrawStyleNameAttribute(frame2.getStyleName());
                frame2.setDrawLayerAttribute("layout");
                frame2.setSvgHeightAttribute("6.61cm");
                frame2.setSvgWidthAttribute("12.296cm");
                frame2.setSvgXAttribute("1.4cm");
                frame2.setSvgYAttribute("4.914cm");
                frame2.setPresentationClassAttribute(PresentationClassAttribute.Value.CHART.toString());
                frame2.setTextAnchorTypeAttribute(TextAnchorTypeAttribute.Value.PAGE.toString());
                frame2.setPresentationPlaceholderAttribute(Boolean.valueOf(true));
                frame2.newDrawObjectElement();
                DrawFrameElement frame3 = page.newDrawFrameElement();
                frame3.setPresentationStyleNameAttribute(frame3.getStyleName());
                frame3.setDrawLayerAttribute("layout");
                frame3.setSvgHeightAttribute("6.61cm");
                frame3.setSvgWidthAttribute("12.296cm");
                frame3.setSvgXAttribute("14.311cm");
                frame3.setSvgYAttribute("4.914cm");
                frame3.setPresentationClassAttribute(PresentationClassAttribute.Value.OUTLINE.toString());
                frame3.setTextAnchorTypeAttribute(TextAnchorTypeAttribute.Value.PAGE.toString());
                frame3.setPresentationUserTransformedAttribute(Boolean.valueOf(true));
                frame3.setPresentationPlaceholderAttribute(Boolean.valueOf(true));
                frame3.newDrawTextBoxElement();
                DrawFrameElement frame4 = page.newDrawFrameElement();
                frame4.setDrawStyleNameAttribute(frame4.getStyleName());
                frame4.setDrawLayerAttribute("layout");
                frame4.setSvgHeightAttribute("6.61cm");
                frame4.setSvgWidthAttribute("12.296cm");
                frame4.setSvgXAttribute("1.4cm");
                frame4.setSvgYAttribute("12.153cm");
                frame4.setPresentationClassAttribute(PresentationClassAttribute.Value.CHART.toString());
                frame4.setTextAnchorTypeAttribute(TextAnchorTypeAttribute.Value.PAGE.toString());
                frame4.setPresentationPlaceholderAttribute(Boolean.valueOf(true));
                frame4.newDrawObjectElement();
                DrawFrameElement frame5 = page.newDrawFrameElement();
                frame5.setDrawStyleNameAttribute(frame5.getStyleName());
                frame5.setDrawLayerAttribute("layout");
                frame5.setSvgHeightAttribute("6.61cm");
                frame5.setSvgWidthAttribute("12.296cm");
                frame5.setSvgXAttribute("14.311cm");
                frame5.setSvgYAttribute("12.153cm");
                frame5.setPresentationClassAttribute(PresentationClassAttribute.Value.CHART.toString());
                frame5.setTextAnchorTypeAttribute(TextAnchorTypeAttribute.Value.PAGE.toString());
                frame5.setPresentationPlaceholderAttribute(Boolean.valueOf(true));
                frame5.newDrawObjectElement();
            }
        };

        private String mValue;

        private SlideLayout(String aValue) {
            this.mValue = aValue;
        }

        public abstract void apply(DrawPageElement var1);

        public String toString() {
            return this.mValue;
        }

        public static String toString(SlideLayout aEnum) {
            return aEnum.toString();
        }

        public static SlideLayout enumValueOf(String aString) {
            for (SlideLayout aIter : SlideLayout.values()) {
                if (!aString.equals(aIter.toString())) continue;
                return aIter;
            }
            return null;
        }

        private static String makeUniqueName() {
            return String.format("a%06x", (int)(Math.random() * 1.6777215E7));
        }
    }

    public static class SlideBuilder {
        private final IdentityHashMap<DrawPageElement, Slide> maSlideRepository = new IdentityHashMap();

        public SlideBuilder(PresentationDocument doc) {
            if (doc.getSlideBuilder() != null) {
                throw new IllegalStateException("SlideBuilder only can be created in owner PresentationDocument constructor.");
            }
        }

        public synchronized Slide getSlideInstance(DrawPageElement pageElement) {
            if (this.maSlideRepository.containsKey(pageElement)) {
                return this.maSlideRepository.get(pageElement);
            }
            Slide newSlide = new Slide(pageElement);
            this.maSlideRepository.put(pageElement, newSlide);
            return newSlide;
        }
    }
}

