/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.dom;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.util.ResourceUtils;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.odftoolkit.odfdom.dom.OdfContentDom;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.OdfMetaDom;
import org.odftoolkit.odfdom.dom.OdfSchemaConstraint;
import org.odftoolkit.odfdom.dom.OdfSettingsDom;
import org.odftoolkit.odfdom.dom.OdfStylesDom;
import org.odftoolkit.odfdom.dom.element.office.OfficeBodyElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeMasterStylesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleMasterPageElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableElement;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeMasterStyles;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeStyles;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfPackage;
import org.odftoolkit.odfdom.pkg.OdfPackageDocument;
import org.odftoolkit.odfdom.pkg.OdfValidationException;
import org.odftoolkit.odfdom.pkg.ValidationConstraint;
import org.odftoolkit.odfdom.pkg.rdfa.Util;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public abstract class OdfSchemaDocument
extends OdfPackageDocument {
    protected OdfContentDom mContentDom;
    protected OdfStylesDom mStylesDom;
    protected OdfMetaDom mMetaDom;
    protected OdfSettingsDom mSettingsDom;
    protected OdfOfficeStyles mDocumentStyles;

    protected OdfSchemaDocument(OdfPackage pkg, String internalPath, String mediaTypeString) {
        super(pkg, internalPath, mediaTypeString);
        ErrorHandler errorHandler = pkg.getErrorHandler();
        if (errorHandler != null) {
            if (pkg.getFileEntry(internalPath + "content.xml") == null && pkg.getFileEntry(internalPath + "styles.xml") == null) {
                try {
                    String baseURI = pkg.getBaseURI();
                    if (baseURI == null) {
                        baseURI = internalPath;
                    } else if (!internalPath.equals("")) {
                        baseURI = "/" + internalPath;
                    }
                    errorHandler.error(new OdfValidationException((ValidationConstraint)OdfSchemaConstraint.DOCUMENT_WITHOUT_CONTENT_NOR_STYLES_XML, baseURI, new Object[0]));
                }
                catch (SAXException ex) {
                    Logger.getLogger(OdfPackage.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            InputStream mimetypeStream = pkg.getInputStream(OdfPackage.OdfFile.MEDIA_TYPE.getPath(), true);
            if (internalPath.equals("") && mimetypeStream == null) {
                try {
                    errorHandler.error(new OdfValidationException((ValidationConstraint)OdfSchemaConstraint.PACKAGE_SHALL_CONTAIN_MIMETYPE, pkg.getBaseURI(), new Object[0]));
                }
                catch (SAXException ex) {
                    Logger.getLogger(OdfPackage.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    public InputStream getContentStream() throws Exception {
        String path = this.getXMLFilePath(OdfXMLFile.CONTENT);
        return this.mPackage.getInputStream(path);
    }

    public InputStream getStylesStream() throws Exception {
        return this.mPackage.getInputStream(this.getXMLFilePath(OdfXMLFile.STYLES));
    }

    public InputStream getSettingsStream() throws Exception {
        return this.mPackage.getInputStream(this.getXMLFilePath(OdfXMLFile.SETTINGS));
    }

    public InputStream getMetaStream() throws Exception {
        return this.mPackage.getInputStream(this.getXMLFilePath(OdfXMLFile.META));
    }

    protected String getXMLFilePath(OdfXMLFile file) {
        return file.mFileName;
    }

    public String getBaseURI() {
        return this.mPackage.getBaseURI();
    }

    public OdfContentDom getContentDom() throws Exception {
        if (this.mContentDom == null) {
            this.mContentDom = (OdfContentDom)this.getFileDom(OdfXMLFile.CONTENT);
        }
        return this.mContentDom;
    }

    public OdfStylesDom getStylesDom() throws Exception {
        if (this.mStylesDom == null) {
            this.mStylesDom = (OdfStylesDom)this.getFileDom(OdfXMLFile.STYLES);
        }
        return this.mStylesDom;
    }

    public OdfMetaDom getMetaDom() throws Exception {
        if (this.mMetaDom == null) {
            this.mMetaDom = (OdfMetaDom)this.getFileDom(OdfXMLFile.META);
        }
        return this.mMetaDom;
    }

    public OdfSettingsDom getSettingsDom() throws Exception {
        if (this.mSettingsDom == null) {
            this.mSettingsDom = (OdfSettingsDom)this.getFileDom(OdfXMLFile.SETTINGS);
        }
        return this.mSettingsDom;
    }

    public OdfOfficeStyles getDocumentStyles() {
        if (this.mDocumentStyles == null) {
            try {
                OdfStylesDom stylesDom = this.getStylesDom();
                if (stylesDom == null) {
                    return null;
                }
                this.mDocumentStyles = OdfElement.findFirstChildNode(OdfOfficeStyles.class, stylesDom.getFirstChild());
            }
            catch (Exception ex) {
                Logger.getLogger(OdfSchemaDocument.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return this.mDocumentStyles;
    }

    public OdfOfficeMasterStyles getOfficeMasterStyles() {
        try {
            OdfStylesDom fileDom = this.getStylesDom();
            if (fileDom != null) {
                return OdfElement.findFirstChildNode(OdfOfficeMasterStyles.class, fileDom.getFirstChild());
            }
        }
        catch (Exception ex) {
            Logger.getLogger(OdfSchemaDocument.class.getName()).log(Level.SEVERE, null, ex);
        }
        return null;
    }

    public OdfOfficeStyles getOrCreateDocumentStyles() {
        if (this.mDocumentStyles == null) {
            try {
                Node parent;
                OdfStylesDom stylesDom = this.getStylesDom();
                Node node = parent = stylesDom != null ? stylesDom.getFirstChild() : null;
                if (parent != null) {
                    this.mDocumentStyles = OdfElement.findFirstChildNode(OdfOfficeStyles.class, parent);
                    if (this.mDocumentStyles == null) {
                        this.mDocumentStyles = stylesDom.newOdfElement(OdfOfficeStyles.class);
                        parent.insertBefore((Node)((Object)this.mDocumentStyles), parent.getFirstChild());
                    }
                }
            }
            catch (Exception ex) {
                Logger.getLogger(OdfSchemaDocument.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return this.mDocumentStyles;
    }

    public List<TableTableElement> getTables() {
        List<TableTableElement> tableList = new ArrayList<TableTableElement>();
        try {
            OfficeBodyElement officeBody = OdfElement.findFirstChildNode(OfficeBodyElement.class, (Node)((Object)this.getContentDom().getRootElement()));
            OdfElement contentRoot = OdfElement.findFirstChildNode(OdfElement.class, (Node)((Object)officeBody));
            tableList = this.fillTableList((Element)((Object)contentRoot), tableList);
            Map<String, StyleMasterPageElement> masterPages = this.getMasterPages();
            StyleMasterPageElement defaultMasterPage = masterPages.get("Standard");
            if (defaultMasterPage != null) {
                tableList = this.fillTableList((Element)((Object)defaultMasterPage), tableList);
            }
        }
        catch (Exception ex) {
            Logger.getLogger(OdfSchemaDocument.class.getName()).log(Level.SEVERE, null, ex);
        }
        return tableList;
    }

    private List<TableTableElement> fillTableList(Element startElement, List<TableTableElement> tableList) {
        NodeList childList = startElement.getChildNodes();
        for (int i = 0; i < childList.getLength(); ++i) {
            Node childNode = childList.item(i);
            if (!(childNode instanceof Element)) continue;
            if (childNode instanceof TableTableElement) {
                tableList.add((TableTableElement)((Object)childList.item(i)));
                continue;
            }
            this.fillTableList((Element)childNode, tableList);
        }
        return tableList;
    }

    public Map<String, StyleMasterPageElement> getMasterPages() throws Exception {
        NodeList lstMasterPages;
        OdfStylesDom stylesDoc = this.getStylesDom();
        OfficeMasterStylesElement masterStyles = OdfElement.findFirstChildNode(OfficeMasterStylesElement.class, (Node)((Object)stylesDoc.getRootElement()));
        HashMap<String, StyleMasterPageElement> masterPages = null;
        if (masterStyles != null && (lstMasterPages = stylesDoc.getElementsByTagNameNS(OdfDocumentNamespace.STYLE.getUri(), "master-page")) != null && lstMasterPages.getLength() > 0) {
            masterPages = new HashMap<String, StyleMasterPageElement>();
            for (int i = 0; i < lstMasterPages.getLength(); ++i) {
                StyleMasterPageElement masterPage = (StyleMasterPageElement)((Object)lstMasterPages.item(i));
                String styleName = masterPage.getStyleNameAttribute();
                masterPages.put(styleName, masterPage);
            }
        }
        return masterPages;
    }

    @Override
    public void close() {
        this.mContentDom = null;
        this.mStylesDom = null;
        this.mMetaDom = null;
        this.mSettingsDom = null;
        this.mDocumentStyles = null;
        super.close();
    }

    public OdfFileDom getFileDom(OdfXMLFile file) throws Exception {
        return this.getFileDom(this.getXMLFilePath(file));
    }

    public Model getRDFMetadata() throws Exception {
        Model m = this.getInContentMetadata().union(this.getManifestRDFMetadata());
        return m;
    }

    public Model getInContentMetadata() throws Exception {
        Model documentRDFModel = ModelFactory.createDefaultModel();
        Model fileRDFModel = null;
        block0: for (String internalPath : this.getPackage().getFilePaths()) {
            for (OdfXMLFile file : OdfXMLFile.values()) {
                if (!Util.isSubPathOf(internalPath, this.getDocumentPath()) || !internalPath.endsWith(file.getFileName())) continue;
                fileRDFModel = this.getXMLFileMetadata(internalPath);
                if (fileRDFModel.size() <= 0L) continue block0;
                documentRDFModel = documentRDFModel.union(fileRDFModel);
                continue block0;
            }
        }
        if (fileRDFModel.size() > 0L) {
            documentRDFModel = documentRDFModel.union(fileRDFModel);
        }
        return documentRDFModel;
    }

    public Model getInContentMetadataFromCache() throws Exception {
        Model m = ModelFactory.createDefaultModel();
        for (OdfXMLFile file : OdfXMLFile.values()) {
            for (Model m1 : this.getFileDom(file).getInContentMetadataCache().values()) {
                m = m.union(m1);
            }
        }
        return m;
    }

    public Model getManifestRDFMetadata() throws Exception {
        Model m = ModelFactory.createDefaultModel();
        for (String internalPath : this.getPackage().getFilePaths()) {
            if (!Util.isSubPathOf(internalPath, this.getDocumentPath()) || !this.getPackage().getMediaTypeString(internalPath).endsWith("application/rdf+xml")) continue;
            Model m1 = ModelFactory.createDefaultModel();
            String RDFBaseUri = Util.getRDFBaseUri(this.getPackage().getBaseURI(), internalPath);
            m1.read((Reader)new InputStreamReader(this.getPackage().getInputStream(internalPath), "utf-8"), RDFBaseUri);
            ResourceUtils.renameResource((Resource)m1.getResource(RDFBaseUri), (String)RDFBaseUri.substring(0, RDFBaseUri.length() - 1));
            if (m1.size() <= 0L) continue;
            m = m.union(m1);
        }
        return m;
    }

    public Model getBookmarkRDFMetadata() throws Exception {
        Model m = ModelFactory.createDefaultModel();
        for (OdfXMLFile file : OdfXMLFile.values()) {
            OdfFileDom dom = this.getFileDom(file);
            m = m.union(dom.getBookmarkRDFMetadata());
        }
        return m;
    }

    public static enum OdfXMLFile {
        CONTENT("content.xml"),
        META("meta.xml"),
        SETTINGS("settings.xml"),
        STYLES("styles.xml");

        private final String mFileName;

        public String getFileName() {
            return this.mFileName;
        }

        private OdfXMLFile(String fileName) {
            this.mFileName = fileName;
        }
    }
}

