/*
 * Decompiled with CFR 0.152.
 */
package npanday.assembler.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import npanday.assembler.AssemblyInfoException;
import npanday.model.assembly.plugins.AssemblyPlugin;
import npanday.model.assembly.plugins.AssemblyPluginsModel;
import npanday.model.assembly.plugins.io.xpp3.AssemblyPluginXpp3Reader;
import npanday.registry.NPandayRepositoryException;
import npanday.registry.Repository;
import npanday.registry.RepositoryRegistry;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AssemblyPluginsRepository
implements Repository {
    private List<AssemblyPlugin> assemblyPlugins;

    public void load(InputStream inputStream, Hashtable properties) throws NPandayRepositoryException {
        AssemblyPluginXpp3Reader xpp3Reader = new AssemblyPluginXpp3Reader();
        InputStreamReader reader = new InputStreamReader(inputStream);
        AssemblyPluginsModel plugins = null;
        try {
            plugins = xpp3Reader.read((Reader)reader);
        }
        catch (IOException e) {
            throw new NPandayRepositoryException("NPANDAY-021-000: An error occurred while reading executable-plugins.xml", (Throwable)e);
        }
        catch (XmlPullParserException e) {
            throw new NPandayRepositoryException("NPANDAY-021-001: Could not read plugins-compiler.xml", (Throwable)e);
        }
        this.assemblyPlugins = plugins.getAssemblyPlugins();
        Set<String> languages = this.getAssemblyPluginLanguages();
        if (languages.size() < this.assemblyPlugins.size()) {
            throw new NPandayRepositoryException("NPANDAY-021-002: Duplicate language entries in the assembly-plugins.xml: Total Language Count = " + languages.size() + ", Total Plugins = " + this.assemblyPlugins.size());
        }
    }

    public void setRepositoryRegistry(RepositoryRegistry repositoryRegistry) {
    }

    public void setSourceUri(String fileUri) {
    }

    public void reload() throws IOException {
    }

    public List<AssemblyPlugin> getAssemblyPlugins() {
        return this.assemblyPlugins;
    }

    public AssemblyPlugin getAssemblyPluginFor(String language) throws AssemblyInfoException {
        for (AssemblyPlugin assemblyPlugin : this.assemblyPlugins) {
            if (!assemblyPlugin.getLanguage().trim().equals(language)) continue;
            return assemblyPlugin;
        }
        throw new AssemblyInfoException("NPANDAY-022-002: Unable to locate AssemblyPlugin: Language = " + language);
    }

    private Set<String> getAssemblyPluginLanguages() {
        HashSet<String> set = new HashSet<String>();
        for (AssemblyPlugin assemblyPlugin : this.assemblyPlugins) {
            set.add(assemblyPlugin.getLanguage().trim());
        }
        return set;
    }
}

