/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.websocket;

import java.net.InetSocketAddress;
import java.util.List;
import java.util.Set;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.TriggerSerially;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.websocket.AbstractWebSocketGatewayProcessor;
import org.apache.nifi.websocket.WebSocketServerService;
import org.apache.nifi.websocket.WebSocketService;
import org.apache.nifi.websocket.WebSocketSessionInfo;

@Tags(value={"subscribe", "WebSocket", "consume", "listen"})
@InputRequirement(value=InputRequirement.Requirement.INPUT_FORBIDDEN)
@TriggerSerially
@CapabilityDescription(value="Acts as a WebSocket server endpoint to accept client connections. FlowFiles are transferred to downstream relationships according to received message types as the WebSocket server configured with this processor receives client requests")
@WritesAttributes(value={@WritesAttribute(attribute="websocket.controller.service.id", description="WebSocket Controller Service id."), @WritesAttribute(attribute="websocket.session.id", description="Established WebSocket session id."), @WritesAttribute(attribute="websocket.endpoint.id", description="WebSocket endpoint id."), @WritesAttribute(attribute="websocket.local.address", description="WebSocket server address."), @WritesAttribute(attribute="websocket.remote.address", description="WebSocket client address."), @WritesAttribute(attribute="websocket.message.type", description="TEXT or BINARY.")})
public class ListenWebSocket
extends AbstractWebSocketGatewayProcessor {
    public static final PropertyDescriptor PROP_WEBSOCKET_SERVER_SERVICE = new PropertyDescriptor.Builder().name("websocket-server-controller-service").displayName("WebSocket Server ControllerService").description("A WebSocket SERVER Controller Service which can accept WebSocket requests.").required(true).identifiesControllerService(WebSocketServerService.class).build();
    public static final PropertyDescriptor PROP_SERVER_URL_PATH = new PropertyDescriptor.Builder().name("server-url-path").displayName("Server URL Path").description("The WetSocket URL Path on which this processor listens to. Must starts with '/', e.g. '/example'.").required(true).addValidator(StandardValidators.NON_BLANK_VALIDATOR).addValidator((subject, input, context) -> {
        ValidationResult.Builder result = new ValidationResult.Builder().valid(input.startsWith("/")).subject(subject).explanation("Must starts with '/', e.g. '/example'.");
        return result.build();
    }).build();
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(PROP_WEBSOCKET_SERVER_SERVICE, PROP_SERVER_URL_PATH);
    private static final Set<Relationship> RELATIONSHIPS = ListenWebSocket.getAbstractRelationships();

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    public final List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    protected WebSocketService getWebSocketService(ProcessContext context) {
        return (WebSocketService)context.getProperty(PROP_WEBSOCKET_SERVER_SERVICE).asControllerService(WebSocketService.class);
    }

    @Override
    protected String getEndpointId(ProcessContext context) {
        return context.getProperty(PROP_SERVER_URL_PATH).getValue();
    }

    @Override
    protected String getTransitUri(WebSocketSessionInfo sessionInfo) {
        InetSocketAddress localAddress = sessionInfo.getLocalAddress();
        return (sessionInfo.isSecure() ? "wss:" : "ws:") + localAddress.getHostName() + ":" + localAddress.getPort() + this.endpointId;
    }
}

