/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.util;

import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.core.Configuration;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.nifi.web.util.ObjectMapperResolver;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.jackson.internal.jackson.jaxrs.json.JacksonJaxbJsonProvider;

public final class WebClientUtils {
    private WebClientUtils() {
    }

    public static Client createClient(ClientConfig config) {
        return WebClientUtils.createClientHelper(config, null);
    }

    public static Client createClient(ClientConfig config, SSLContext ctx) {
        return WebClientUtils.createClientHelper(config, ctx);
    }

    private static Client createClientHelper(ClientConfig config, SSLContext ctx) {
        ClientBuilder clientBuilder = ClientBuilder.newBuilder();
        if (config != null) {
            clientBuilder = clientBuilder.withConfig((Configuration)config);
        }
        if (ctx != null) {
            clientBuilder = clientBuilder.sslContext(ctx).hostnameVerifier((HostnameVerifier)new DefaultHostnameVerifier());
        }
        clientBuilder = (ClientBuilder)((ClientBuilder)clientBuilder.register(ObjectMapperResolver.class)).register(JacksonJaxbJsonProvider.class);
        return clientBuilder.build();
    }
}

