/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.configuration;

import jakarta.servlet.http.HttpServletRequest;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.security.NiFiWebAuthenticationDetails;
import org.apache.nifi.web.security.x509.SubjectDnX509PrincipalExtractor;
import org.apache.nifi.web.security.x509.X509AuthenticationFilter;
import org.apache.nifi.web.security.x509.X509AuthenticationProvider;
import org.apache.nifi.web.security.x509.X509CertificateExtractor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.web.authentication.preauth.x509.X509PrincipalExtractor;

@Configuration
public class X509AuthenticationSecurityConfiguration {
    private final NiFiProperties niFiProperties;
    private final Authorizer authorizer;

    @Autowired
    public X509AuthenticationSecurityConfiguration(NiFiProperties niFiProperties, Authorizer authorizer) {
        this.niFiProperties = niFiProperties;
        this.authorizer = authorizer;
    }

    @Bean
    public X509AuthenticationFilter x509AuthenticationFilter(AuthenticationManager authenticationManager, AuthenticationDetailsSource<HttpServletRequest, NiFiWebAuthenticationDetails> authenticationDetailsSource) {
        X509AuthenticationFilter x509AuthenticationFilter = new X509AuthenticationFilter();
        x509AuthenticationFilter.setProperties(this.niFiProperties);
        x509AuthenticationFilter.setCertificateExtractor(this.certificateExtractor());
        x509AuthenticationFilter.setPrincipalExtractor(this.principalExtractor());
        x509AuthenticationFilter.setAuthenticationManager(authenticationManager);
        x509AuthenticationFilter.setAuthenticationDetailsSource(authenticationDetailsSource);
        return x509AuthenticationFilter;
    }

    @Bean
    public X509AuthenticationProvider x509AuthenticationProvider() {
        return new X509AuthenticationProvider(this.authorizer, this.niFiProperties);
    }

    @Bean
    public X509CertificateExtractor certificateExtractor() {
        return new X509CertificateExtractor();
    }

    @Bean
    public X509PrincipalExtractor principalExtractor() {
        return new SubjectDnX509PrincipalExtractor();
    }
}

