/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.configuration;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.authorization.util.IdentityMappingUtil;
import org.apache.nifi.components.state.StateManager;
import org.apache.nifi.components.state.StateManagerProvider;
import org.apache.nifi.encrypt.PropertyEncryptor;
import org.apache.nifi.util.FormatUtils;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.security.StandardAuthenticationEntryPoint;
import org.apache.nifi.web.security.jwt.provider.BearerTokenProvider;
import org.apache.nifi.web.security.logout.LogoutRequestManager;
import org.apache.nifi.web.security.oidc.OidcUrlPath;
import org.apache.nifi.web.security.oidc.client.web.AuthorizedClientExpirationCommand;
import org.apache.nifi.web.security.oidc.client.web.OidcBearerTokenRefreshFilter;
import org.apache.nifi.web.security.oidc.client.web.StandardAuthorizationRequestRepository;
import org.apache.nifi.web.security.oidc.client.web.StandardOAuth2AuthorizationRequestResolver;
import org.apache.nifi.web.security.oidc.client.web.StandardOidcAuthorizedClientRepository;
import org.apache.nifi.web.security.oidc.client.web.converter.AuthenticationResultConverter;
import org.apache.nifi.web.security.oidc.client.web.converter.AuthorizedClientConverter;
import org.apache.nifi.web.security.oidc.client.web.converter.StandardAuthorizedClientConverter;
import org.apache.nifi.web.security.oidc.logout.OidcLogoutFilter;
import org.apache.nifi.web.security.oidc.logout.OidcLogoutSuccessHandler;
import org.apache.nifi.web.security.oidc.revocation.StandardTokenRevocationResponseClient;
import org.apache.nifi.web.security.oidc.revocation.TokenRevocationResponseClient;
import org.apache.nifi.web.security.oidc.userinfo.StandardOidcUserService;
import org.apache.nifi.web.security.oidc.web.authentication.OidcAuthenticationSuccessHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.cache.caffeine.CaffeineCache;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.oauth2.client.endpoint.OAuth2AccessTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.OAuth2AuthorizationCodeGrantRequest;
import org.springframework.security.oauth2.client.endpoint.OAuth2RefreshTokenGrantRequest;
import org.springframework.security.oauth2.client.endpoint.RestClientAuthorizationCodeTokenResponseClient;
import org.springframework.security.oauth2.client.endpoint.RestClientRefreshTokenTokenResponseClient;
import org.springframework.security.oauth2.client.oidc.authentication.OidcAuthorizationCodeAuthenticationProvider;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserService;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.userinfo.DefaultOAuth2UserService;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserService;
import org.springframework.security.oauth2.client.web.AuthorizationRequestRepository;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizationCodeGrantFilter;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizationRequestRedirectFilter;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizationRequestResolver;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizedClientRepository;
import org.springframework.security.oauth2.client.web.OAuth2LoginAuthenticationFilter;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationRequest;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtDecoderFactory;
import org.springframework.security.oauth2.server.resource.web.BearerTokenResolver;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.AuthenticationEntryPointFailureHandler;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.authentication.session.NullAuthenticatedSessionStrategy;
import org.springframework.security.web.authentication.session.SessionAuthenticationStrategy;
import org.springframework.security.web.savedrequest.NullRequestCache;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.web.client.RestClient;
import org.springframework.web.client.RestOperations;

@Configuration
public class OidcSecurityConfiguration {
    private static final Duration REQUEST_EXPIRATION = Duration.ofMinutes(5L);
    private static final long AUTHORIZATION_REQUEST_CACHE_SIZE = 1000L;
    private static final RequestCache nullRequestCache = new NullRequestCache();
    private final Duration keyRotationPeriod;
    private final NiFiProperties properties;
    private final TaskScheduler taskScheduler;
    private final StateManagerProvider stateManagerProvider;
    private final PropertyEncryptor propertyEncryptor;
    private final BearerTokenProvider bearerTokenProvider;
    private final BearerTokenResolver bearerTokenResolver;
    private final ClientRegistrationRepository clientRegistrationRepository;
    private final JwtDecoder jwtDecoder;
    private final JwtDecoderFactory<ClientRegistration> idTokenDecoderFactory;
    private final RestOperations oidcRestOperations;
    private final RestClient oidcRestClient;
    private final LogoutRequestManager logoutRequestManager;

    @Autowired
    public OidcSecurityConfiguration(NiFiProperties properties, TaskScheduler taskScheduler, StateManagerProvider stateManagerProvider, PropertyEncryptor propertyEncryptor, BearerTokenProvider bearerTokenProvider, BearerTokenResolver bearerTokenResolver, ClientRegistrationRepository clientRegistrationRepository, JwtDecoder jwtDecoder, JwtDecoderFactory<ClientRegistration> idTokenDecoderFactory, @Qualifier(value="oidcRestOperations") RestOperations oidcRestOperations, @Qualifier(value="oidcRestClient") RestClient oidcRestClient, LogoutRequestManager logoutRequestManager) {
        this.properties = Objects.requireNonNull(properties, "Properties required");
        this.taskScheduler = Objects.requireNonNull(taskScheduler, "Task Scheduler required");
        this.stateManagerProvider = Objects.requireNonNull(stateManagerProvider, "State Manager Provider required");
        this.propertyEncryptor = Objects.requireNonNull(propertyEncryptor, "Property Encryptor required");
        this.bearerTokenProvider = Objects.requireNonNull(bearerTokenProvider, "Bearer Token Provider required");
        this.bearerTokenResolver = Objects.requireNonNull(bearerTokenResolver, "Bearer Token Resolver required");
        this.clientRegistrationRepository = Objects.requireNonNull(clientRegistrationRepository, "Registration Repository required");
        this.jwtDecoder = Objects.requireNonNull(jwtDecoder, "JWT Decoder required");
        this.idTokenDecoderFactory = Objects.requireNonNull(idTokenDecoderFactory, "ID Token Decoder Factory required");
        this.oidcRestOperations = Objects.requireNonNull(oidcRestOperations, "OIDC REST Operations required");
        this.oidcRestClient = Objects.requireNonNull(oidcRestClient, "OIDC Rest Client required");
        this.logoutRequestManager = Objects.requireNonNull(logoutRequestManager, "Logout Request Manager required");
        this.keyRotationPeriod = properties.getSecurityUserJwsKeyRotationPeriod();
    }

    @Bean
    public OAuth2AuthorizationCodeGrantFilter oAuth2AuthorizationCodeGrantFilter(AuthenticationManager authenticationManager) {
        OAuth2AuthorizationCodeGrantFilter filter = new OAuth2AuthorizationCodeGrantFilter(this.clientRegistrationRepository, (OAuth2AuthorizedClientRepository)this.authorizedClientRepository(), authenticationManager);
        filter.setAuthorizationRequestRepository(this.authorizationRequestRepository());
        filter.setRequestCache(nullRequestCache);
        return filter;
    }

    @Bean
    public OAuth2AuthorizationRequestRedirectFilter oAuth2AuthorizationRequestRedirectFilter() {
        StandardOAuth2AuthorizationRequestResolver authorizationRequestResolver = new StandardOAuth2AuthorizationRequestResolver(this.clientRegistrationRepository);
        OAuth2AuthorizationRequestRedirectFilter filter = new OAuth2AuthorizationRequestRedirectFilter((OAuth2AuthorizationRequestResolver)authorizationRequestResolver);
        filter.setAuthorizationRequestRepository(this.authorizationRequestRepository());
        filter.setRequestCache(nullRequestCache);
        return filter;
    }

    @Bean
    public OAuth2LoginAuthenticationFilter oAuth2LoginAuthenticationFilter(AuthenticationManager authenticationManager, StandardAuthenticationEntryPoint authenticationEntryPoint) {
        OAuth2LoginAuthenticationFilter filter = new OAuth2LoginAuthenticationFilter(this.clientRegistrationRepository, (OAuth2AuthorizedClientRepository)this.authorizedClientRepository(), OidcUrlPath.CALLBACK.getPath());
        filter.setAuthenticationManager(authenticationManager);
        filter.setAuthorizationRequestRepository(this.authorizationRequestRepository());
        filter.setAuthenticationSuccessHandler((AuthenticationSuccessHandler)this.getAuthenticationSuccessHandler());
        filter.setAllowSessionCreation(false);
        filter.setSessionAuthenticationStrategy((SessionAuthenticationStrategy)new NullAuthenticatedSessionStrategy());
        filter.setAuthenticationResultConverter((Converter)new AuthenticationResultConverter());
        AuthenticationEntryPointFailureHandler authenticationFailureHandler = new AuthenticationEntryPointFailureHandler((AuthenticationEntryPoint)authenticationEntryPoint);
        filter.setAuthenticationFailureHandler((AuthenticationFailureHandler)authenticationFailureHandler);
        return filter;
    }

    @Bean
    public OidcBearerTokenRefreshFilter oidcBearerTokenRefreshFilter() {
        RestClientRefreshTokenTokenResponseClient refreshTokenResponseClient = new RestClientRefreshTokenTokenResponseClient();
        refreshTokenResponseClient.setRestClient(this.oidcRestClient);
        String refreshWindowProperty = this.properties.getOidcTokenRefreshWindow();
        double refreshWindowSeconds = FormatUtils.getPreciseTimeDuration((String)refreshWindowProperty, (TimeUnit)TimeUnit.SECONDS);
        Duration refreshWindow = Duration.ofSeconds(Math.round(refreshWindowSeconds));
        return new OidcBearerTokenRefreshFilter(refreshWindow, this.bearerTokenProvider, this.bearerTokenResolver, this.jwtDecoder, this.authorizedClientRepository(), (OAuth2AccessTokenResponseClient<OAuth2RefreshTokenGrantRequest>)refreshTokenResponseClient);
    }

    @Bean
    public OidcLogoutFilter oidcLogoutFilter() {
        return new OidcLogoutFilter(this.oidcLogoutSuccessHandler());
    }

    @Bean
    public LogoutSuccessHandler oidcLogoutSuccessHandler() {
        return new OidcLogoutSuccessHandler(this.logoutRequestManager, this.clientRegistrationRepository, this.authorizedClientRepository(), this.tokenRevocationResponseClient());
    }

    @Bean
    public OidcAuthorizationCodeAuthenticationProvider oidcAuthorizationCodeAuthenticationProvider() {
        OidcAuthorizationCodeAuthenticationProvider provider = new OidcAuthorizationCodeAuthenticationProvider(this.accessTokenResponseClient(), (OAuth2UserService)this.oidcUserService());
        provider.setJwtDecoderFactory(this.idTokenDecoderFactory);
        return provider;
    }

    @Bean
    public OAuth2AccessTokenResponseClient<OAuth2AuthorizationCodeGrantRequest> accessTokenResponseClient() {
        RestClientAuthorizationCodeTokenResponseClient tokenResponseClient = new RestClientAuthorizationCodeTokenResponseClient();
        tokenResponseClient.setRestClient(this.oidcRestClient);
        return tokenResponseClient;
    }

    @Bean
    public OidcUserService oidcUserService() {
        StandardOidcUserService oidcUserService = new StandardOidcUserService(this.getUserClaimNames(), IdentityMappingUtil.getIdentityMappings((NiFiProperties)this.properties));
        DefaultOAuth2UserService userService = new DefaultOAuth2UserService();
        userService.setRestOperations(this.oidcRestOperations);
        oidcUserService.setOauth2UserService((OAuth2UserService)userService);
        return oidcUserService;
    }

    @Bean
    public StandardOidcAuthorizedClientRepository authorizedClientRepository() {
        StateManager stateManager = this.stateManagerProvider.getStateManager(StandardOidcAuthorizedClientRepository.class.getName());
        return new StandardOidcAuthorizedClientRepository(stateManager, this.authorizedClientConverter());
    }

    @Bean
    public AuthorizedClientExpirationCommand authorizedClientExpirationCommand() {
        AuthorizedClientExpirationCommand command = new AuthorizedClientExpirationCommand(this.authorizedClientRepository(), this.tokenRevocationResponseClient());
        this.taskScheduler.scheduleAtFixedRate((Runnable)command, this.keyRotationPeriod);
        return command;
    }

    @Bean
    public AuthorizedClientConverter authorizedClientConverter() {
        return new StandardAuthorizedClientConverter(this.propertyEncryptor, this.clientRegistrationRepository);
    }

    @Bean
    public AuthorizationRequestRepository<OAuth2AuthorizationRequest> authorizationRequestRepository() {
        Cache caffeineCache = Caffeine.newBuilder().maximumSize(1000L).expireAfterWrite(REQUEST_EXPIRATION).build();
        CaffeineCache cache = new CaffeineCache(StandardAuthorizationRequestRepository.class.getSimpleName(), caffeineCache);
        return new StandardAuthorizationRequestRepository((org.springframework.cache.Cache)cache);
    }

    @Bean
    public TokenRevocationResponseClient tokenRevocationResponseClient() {
        return new StandardTokenRevocationResponseClient(this.oidcRestOperations, this.clientRegistrationRepository);
    }

    private OidcAuthenticationSuccessHandler getAuthenticationSuccessHandler() {
        List<String> userClaimNames = this.getUserClaimNames();
        return new OidcAuthenticationSuccessHandler(this.bearerTokenProvider, IdentityMappingUtil.getIdentityMappings((NiFiProperties)this.properties), IdentityMappingUtil.getGroupMappings((NiFiProperties)this.properties), userClaimNames, this.properties.getOidcClaimGroups());
    }

    private List<String> getUserClaimNames() {
        ArrayList<String> userClaimNames = new ArrayList<String>();
        userClaimNames.add(this.properties.getOidcClaimIdentifyingUser());
        userClaimNames.addAll(this.properties.getOidcFallbackClaimsIdentifyingUser());
        return userClaimNames;
    }
}

