/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.configuration;

import jakarta.servlet.http.HttpServletRequest;
import java.security.KeyPairGenerator;
import java.time.Duration;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.security.NiFiWebAuthenticationDetails;
import org.apache.nifi.web.security.StandardAuthenticationEntryPoint;
import org.apache.nifi.web.security.jwt.converter.StandardJwtAuthenticationConverter;
import org.apache.nifi.web.security.jwt.jws.StandardJwsSignerProvider;
import org.apache.nifi.web.security.jwt.key.StandardVerificationKeySelector;
import org.apache.nifi.web.security.jwt.key.command.KeyExpirationCommand;
import org.apache.nifi.web.security.jwt.key.command.KeyGenerationCommand;
import org.apache.nifi.web.security.jwt.key.service.VerificationKeyService;
import org.apache.nifi.web.security.jwt.provider.BearerTokenProvider;
import org.apache.nifi.web.security.jwt.provider.IssuerProvider;
import org.apache.nifi.web.security.jwt.provider.StandardBearerTokenProvider;
import org.apache.nifi.web.security.jwt.provider.StandardIssuerProvider;
import org.apache.nifi.web.security.jwt.resolver.StandardBearerTokenResolver;
import org.apache.nifi.web.security.jwt.revocation.JwtLogoutListener;
import org.apache.nifi.web.security.jwt.revocation.JwtRevocationService;
import org.apache.nifi.web.security.jwt.revocation.StandardJwtLogoutListener;
import org.apache.nifi.web.security.jwt.revocation.command.RevocationExpirationCommand;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationProvider;
import org.springframework.security.oauth2.server.resource.web.BearerTokenAuthenticationEntryPoint;
import org.springframework.security.oauth2.server.resource.web.BearerTokenResolver;
import org.springframework.security.oauth2.server.resource.web.authentication.BearerTokenAuthenticationFilter;
import org.springframework.security.web.AuthenticationEntryPoint;

@Configuration
public class JwtAuthenticationSecurityConfiguration {
    private final NiFiProperties niFiProperties;
    private final TaskScheduler taskScheduler;
    private final Authorizer authorizer;
    private final JwtDecoder jwtDecoder;
    private final JwtRevocationService jwtRevocationService;
    private final StandardVerificationKeySelector verificationKeySelector;
    private final VerificationKeyService verificationKeyService;
    private final Duration keyRotationPeriod;

    @Autowired
    public JwtAuthenticationSecurityConfiguration(NiFiProperties niFiProperties, TaskScheduler taskScheduler, Authorizer authorizer, JwtDecoder jwtDecoder, JwtRevocationService jwtRevocationService, StandardVerificationKeySelector standardVerificationKeySelector, VerificationKeyService verificationKeyService) {
        this.niFiProperties = niFiProperties;
        this.taskScheduler = taskScheduler;
        this.authorizer = authorizer;
        this.jwtDecoder = jwtDecoder;
        this.jwtRevocationService = jwtRevocationService;
        this.verificationKeySelector = standardVerificationKeySelector;
        this.verificationKeyService = verificationKeyService;
        this.keyRotationPeriod = niFiProperties.getSecurityUserJwsKeyRotationPeriod();
    }

    @Bean
    public BearerTokenAuthenticationFilter bearerTokenAuthenticationFilter(AuthenticationManager authenticationManager, AuthenticationDetailsSource<HttpServletRequest, NiFiWebAuthenticationDetails> authenticationDetailsSource) {
        BearerTokenAuthenticationFilter bearerTokenAuthenticationFilter = new BearerTokenAuthenticationFilter(authenticationManager);
        bearerTokenAuthenticationFilter.setAuthenticationDetailsSource(authenticationDetailsSource);
        bearerTokenAuthenticationFilter.setBearerTokenResolver(this.bearerTokenResolver());
        bearerTokenAuthenticationFilter.setAuthenticationEntryPoint((AuthenticationEntryPoint)this.authenticationEntryPoint());
        return bearerTokenAuthenticationFilter;
    }

    @Bean
    public BearerTokenResolver bearerTokenResolver() {
        return new StandardBearerTokenResolver();
    }

    @Bean
    public StandardAuthenticationEntryPoint authenticationEntryPoint() {
        BearerTokenAuthenticationEntryPoint bearerTokenAuthenticationEntryPoint = new BearerTokenAuthenticationEntryPoint();
        return new StandardAuthenticationEntryPoint(bearerTokenAuthenticationEntryPoint);
    }

    @Bean
    public JwtAuthenticationProvider jwtAuthenticationProvider() {
        JwtAuthenticationProvider jwtAuthenticationProvider = new JwtAuthenticationProvider(this.jwtDecoder);
        jwtAuthenticationProvider.setJwtAuthenticationConverter((Converter)this.jwtAuthenticationConverter());
        return jwtAuthenticationProvider;
    }

    @Bean
    public JwtLogoutListener jwtLogoutListener() {
        return new StandardJwtLogoutListener(this.jwtDecoder, this.jwtRevocationService);
    }

    @Bean
    public StandardJwtAuthenticationConverter jwtAuthenticationConverter() {
        return new StandardJwtAuthenticationConverter(this.authorizer, this.niFiProperties);
    }

    @Bean
    public BearerTokenProvider bearerTokenProvider() {
        return new StandardBearerTokenProvider(this.jwsSignerProvider(), this.issuerProvider());
    }

    @Bean
    public IssuerProvider issuerProvider() {
        return new StandardIssuerProvider(this.niFiProperties.getProperty("nifi.web.https.host"), this.niFiProperties.getConfiguredHttpOrHttpsPort());
    }

    @Bean
    public StandardJwsSignerProvider jwsSignerProvider() {
        return new StandardJwsSignerProvider(this.verificationKeySelector);
    }

    @Bean
    public KeyGenerationCommand keyGenerationCommand(KeyPairGenerator keyPairGenerator) {
        KeyGenerationCommand command = new KeyGenerationCommand(this.jwsSignerProvider(), this.verificationKeySelector, keyPairGenerator);
        this.taskScheduler.scheduleAtFixedRate((Runnable)command, this.keyRotationPeriod);
        return command;
    }

    @Bean
    public KeyExpirationCommand keyExpirationCommand() {
        KeyExpirationCommand command = new KeyExpirationCommand(this.verificationKeyService);
        this.taskScheduler.scheduleAtFixedRate((Runnable)command, this.keyRotationPeriod);
        return command;
    }

    @Bean
    public RevocationExpirationCommand revocationExpirationCommand() {
        RevocationExpirationCommand command = new RevocationExpirationCommand(this.jwtRevocationService);
        this.taskScheduler.scheduleAtFixedRate((Runnable)command, this.keyRotationPeriod);
        return command;
    }
}

