/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.saml2.registration;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.apache.nifi.util.FormatUtils;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.client.StandardWebClientService;
import org.apache.nifi.web.client.api.HttpResponseEntity;
import org.apache.nifi.web.client.api.HttpResponseStatus;
import org.apache.nifi.web.client.api.WebClientService;
import org.apache.nifi.web.client.ssl.TlsContext;
import org.apache.nifi.web.security.saml2.SamlConfigurationException;
import org.apache.nifi.web.security.saml2.registration.RegistrationBuilderProvider;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistrations;

class StandardRegistrationBuilderProvider
implements RegistrationBuilderProvider {
    static final String NIFI_TRUST_STORE_STRATEGY = "NIFI";
    private static final String HTTP_SCHEME_PREFIX = "http";
    private static final String TLS_PROTOCOL = "TLS";
    private static final ResourceLoader resourceLoader = new DefaultResourceLoader();
    private final NiFiProperties properties;
    private final X509KeyManager keyManager;
    private final X509TrustManager trustManager;

    public StandardRegistrationBuilderProvider(NiFiProperties properties, X509KeyManager keyManager, X509TrustManager trustManager) {
        this.properties = Objects.requireNonNull(properties, "Properties required");
        this.keyManager = keyManager;
        this.trustManager = trustManager;
    }

    @Override
    public RelyingPartyRegistration.Builder getRegistrationBuilder() {
        RelyingPartyRegistration.Builder builder;
        block8: {
            String metadataUrl = Objects.requireNonNull(this.properties.getSamlIdentityProviderMetadataUrl(), "Metadata URL required");
            InputStream inputStream = this.getInputStream(metadataUrl);
            try {
                builder = RelyingPartyRegistrations.fromMetadata((InputStream)inputStream);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new SamlConfigurationException(String.format("SAML Metadata loading failed [%s]", metadataUrl), e);
                }
            }
            inputStream.close();
        }
        return builder;
    }

    private InputStream getInputStream(String metadataUrl) throws IOException {
        InputStream inputStream = metadataUrl.startsWith(HTTP_SCHEME_PREFIX) ? this.getRemoteInputStream(metadataUrl) : resourceLoader.getResource(metadataUrl).getInputStream();
        return inputStream;
    }

    private InputStream getRemoteInputStream(String metadataUrl) {
        WebClientService webClientService = this.getWebClientService();
        URI uri = URI.create(metadataUrl);
        try {
            HttpResponseEntity responseEntity = webClientService.get().uri(uri).retrieve();
            int statusCode = responseEntity.statusCode();
            if (HttpResponseStatus.OK.getCode() == statusCode) {
                return responseEntity.body();
            }
            responseEntity.close();
            throw new SamlConfigurationException(String.format("SAML Metadata retrieval failed [%s] HTTP %d", metadataUrl, statusCode));
        }
        catch (IOException e) {
            throw new SamlConfigurationException(String.format("SAML Metadata retrieval failed [%s]", metadataUrl), e);
        }
    }

    private WebClientService getWebClientService() {
        Duration connectTimeout = Duration.ofMillis((long)FormatUtils.getPreciseTimeDuration((String)this.properties.getSamlHttpClientConnectTimeout(), (TimeUnit)TimeUnit.MILLISECONDS));
        Duration readTimeout = Duration.ofMillis((long)FormatUtils.getPreciseTimeDuration((String)this.properties.getSamlHttpClientReadTimeout(), (TimeUnit)TimeUnit.MILLISECONDS));
        StandardWebClientService webClientService = new StandardWebClientService();
        webClientService.setConnectTimeout(connectTimeout);
        webClientService.setReadTimeout(readTimeout);
        if (NIFI_TRUST_STORE_STRATEGY.equals(this.properties.getSamlHttpClientTruststoreStrategy())) {
            webClientService.setTlsContext(new TlsContext(){

                public String getProtocol() {
                    return StandardRegistrationBuilderProvider.TLS_PROTOCOL;
                }

                public X509TrustManager getTrustManager() {
                    return StandardRegistrationBuilderProvider.this.trustManager;
                }

                public Optional<X509KeyManager> getKeyManager() {
                    return Optional.ofNullable(StandardRegistrationBuilderProvider.this.keyManager);
                }
            });
        }
        return webClientService;
    }
}

