/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.jwt.converter;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.jwt.PlainJWT;
import java.util.Objects;
import org.apache.nifi.web.security.oidc.client.web.OidcRegistrationProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.jwt.BadJwtException;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtDecoderFactory;
import org.springframework.security.oauth2.jwt.JwtException;

public class StandardIssuerJwtDecoder
implements JwtDecoder {
    private static final Logger logger = LoggerFactory.getLogger(StandardIssuerJwtDecoder.class);
    private final JwtDecoder applicationJwtDecoder;
    private final ClientRegistration clientRegistration;
    private final JwtDecoder clientRegistrationJwtDecoder;

    public StandardIssuerJwtDecoder(JwtDecoder applicationJwtDecoder, JwtDecoderFactory<ClientRegistration> jwtDecoderFactory, ClientRegistrationRepository clientRegistrationRepository) {
        this.applicationJwtDecoder = Objects.requireNonNull(applicationJwtDecoder, "Application JWT Decoder required");
        this.clientRegistration = clientRegistrationRepository.findByRegistrationId(OidcRegistrationProperty.REGISTRATION_ID.getProperty());
        if (this.clientRegistration == null) {
            logger.debug("OIDC Client Registration not configured for JWT Decoder");
            this.clientRegistrationJwtDecoder = null;
        } else {
            Objects.requireNonNull(jwtDecoderFactory, "JWT Decoder Factory required");
            this.clientRegistrationJwtDecoder = jwtDecoderFactory.createDecoder((Object)this.clientRegistration);
        }
    }

    public Jwt decode(String token) throws JwtException {
        JWT parsed;
        String tokenIssuer;
        Jwt decoded = this.clientRegistration == null ? this.applicationJwtDecoder.decode(token) : (this.isIssuerRegistered(tokenIssuer = this.getTokenIssuer(parsed = this.parse(token))) ? this.clientRegistrationJwtDecoder.decode(token) : this.applicationJwtDecoder.decode(token));
        return decoded;
    }

    private boolean isIssuerRegistered(String tokenIssuer) {
        boolean registered;
        if (this.clientRegistration == null) {
            registered = false;
        } else {
            ClientRegistration.ProviderDetails providerDetails = this.clientRegistration.getProviderDetails();
            String issuerUri = providerDetails.getIssuerUri();
            registered = issuerUri.equals(tokenIssuer);
        }
        return registered;
    }

    private String getTokenIssuer(JWT parsed) {
        try {
            JWTClaimsSet claimsSet = parsed.getJWTClaimsSet();
            String issuer = claimsSet.getIssuer();
            if (issuer == null || issuer.isEmpty()) {
                throw new BadJwtException("Token Issuer claim not found");
            }
            return issuer;
        }
        catch (Exception e) {
            throw new BadJwtException("Token Issuer parsing failed", (Throwable)e);
        }
    }

    private JWT parse(String token) {
        if (token == null || token.isEmpty()) {
            throw new BadJwtException("Token not found");
        }
        try {
            JWT parsed = JWTParser.parse((String)token);
            if (parsed instanceof PlainJWT) {
                throw new BadJwtException("Unsigned Token not supported");
            }
            return parsed;
        }
        catch (Exception e) {
            throw new BadJwtException("Token parsing failed", (Throwable)e);
        }
    }
}

