/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.logout;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.servlet.util.matcher.PathPatternRequestMatcher;
import org.springframework.web.filter.OncePerRequestFilter;

public class StandardLogoutFilter
extends OncePerRequestFilter {
    private final PathPatternRequestMatcher requestMatcher;
    private final LogoutSuccessHandler logoutSuccessHandler;

    public StandardLogoutFilter(PathPatternRequestMatcher requestMatcher, LogoutSuccessHandler logoutSuccessHandler) {
        this.requestMatcher = requestMatcher;
        this.logoutSuccessHandler = logoutSuccessHandler;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (this.requestMatcher.matches(request)) {
            SecurityContext securityContext = SecurityContextHolder.getContext();
            Authentication authentication = securityContext.getAuthentication();
            this.logoutSuccessHandler.onLogoutSuccess(request, response, authentication);
        } else {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }
}

