/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.x509.ocsp;

import java.security.cert.X509Certificate;
import java.util.Objects;

public class OcspRequest {
    private final X509Certificate subjectCertificate;
    private final X509Certificate issuerCertificate;

    public OcspRequest(X509Certificate subjectCertificate, X509Certificate issuerCertificate) {
        this.subjectCertificate = subjectCertificate;
        this.issuerCertificate = issuerCertificate;
    }

    public X509Certificate getSubjectCertificate() {
        return this.subjectCertificate;
    }

    public X509Certificate getIssuerCertificate() {
        return this.issuerCertificate;
    }

    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + Objects.hashCode(this.subjectCertificate);
        hash = 67 * hash + Objects.hashCode(this.issuerCertificate);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OcspRequest other = (OcspRequest)obj;
        if (!Objects.equals(this.subjectCertificate, other.subjectCertificate)) {
            return false;
        }
        return Objects.equals(this.issuerCertificate, other.issuerCertificate);
    }

    public String toString() {
        return "NiFi OCSP Request: Subject DN: " + (this.subjectCertificate != null ? this.subjectCertificate.getSubjectX500Principal().getName() : "<null>") + " issued by Issuer DN: " + (this.issuerCertificate != null ? this.issuerCertificate.getSubjectX500Principal().getName() : "<null>");
    }
}

