/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.filter;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.nifi.web.filter.SanitizeContextPathFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatchAllFilter
extends SanitizeContextPathFilter {
    private static final Logger logger = LoggerFactory.getLogger(CatchAllFilter.class);
    private String forwardPath = "";
    private String displayPath = "";

    public void init(FilterConfig filterConfig) throws ServletException {
        this.forwardPath = filterConfig.getInitParameter("forwardPath");
        this.displayPath = filterConfig.getInitParameter("displayPath");
        logger.debug("CatchAllFilter  [" + this.displayPath + "] received provided whitelisted context paths from NiFi properties: " + this.getWhitelistedContextPaths());
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        this.injectContextPathAttribute(request);
        request.getRequestDispatcher(this.forwardPath).forward(request, response);
    }

    public void destroy() {
    }
}

