/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.ServletContext;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.nifi.authorization.AuthorizableLookup;
import org.apache.nifi.authorization.AuthorizeControllerServiceReference;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.ComponentAuthorizable;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.resource.OperationAuthorizable;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.ui.extension.UiExtension;
import org.apache.nifi.ui.extension.UiExtensionMapping;
import org.apache.nifi.web.NiFiServiceFacade;
import org.apache.nifi.web.ResourceNotFoundException;
import org.apache.nifi.web.Revision;
import org.apache.nifi.web.UiExtensionType;
import org.apache.nifi.web.api.ApplicationResource;
import org.apache.nifi.web.api.concurrent.AsyncRequestManager;
import org.apache.nifi.web.api.concurrent.AsynchronousWebRequest;
import org.apache.nifi.web.api.concurrent.RequestManager;
import org.apache.nifi.web.api.concurrent.StandardAsynchronousWebRequest;
import org.apache.nifi.web.api.concurrent.StandardUpdateStep;
import org.apache.nifi.web.api.dto.BundleDTO;
import org.apache.nifi.web.api.dto.ComponentStateDTO;
import org.apache.nifi.web.api.dto.ConfigVerificationResultDTO;
import org.apache.nifi.web.api.dto.ConfigurationAnalysisDTO;
import org.apache.nifi.web.api.dto.PropertyDescriptorDTO;
import org.apache.nifi.web.api.dto.ReportingTaskDTO;
import org.apache.nifi.web.api.dto.VerifyConfigRequestDTO;
import org.apache.nifi.web.api.entity.ComponentEntity;
import org.apache.nifi.web.api.entity.ComponentStateEntity;
import org.apache.nifi.web.api.entity.ConfigurationAnalysisEntity;
import org.apache.nifi.web.api.entity.Entity;
import org.apache.nifi.web.api.entity.PropertyDescriptorEntity;
import org.apache.nifi.web.api.entity.ReportingTaskEntity;
import org.apache.nifi.web.api.entity.ReportingTaskRunStatusEntity;
import org.apache.nifi.web.api.entity.VerifyConfigRequestEntity;
import org.apache.nifi.web.api.request.ClientIdParameter;
import org.apache.nifi.web.api.request.LongParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
@Path(value="/reporting-tasks")
@Tag(name="ReportingTasks")
public class ReportingTaskResource
extends ApplicationResource {
    private static final Logger logger = LoggerFactory.getLogger(ReportingTaskResource.class);
    private static final String VERIFICATION_REQUEST_TYPE = "verification-request";
    private RequestManager<VerifyConfigRequestEntity, List<ConfigVerificationResultDTO>> configVerificationRequestManager = new AsyncRequestManager(100, TimeUnit.MINUTES.toMillis(1L), "Verify Reporting Task Config Thread");
    private NiFiServiceFacade serviceFacade;
    private Authorizer authorizer;
    @Context
    private ServletContext servletContext;

    public Set<ReportingTaskEntity> populateRemainingReportingTaskEntitiesContent(Set<ReportingTaskEntity> reportingTaskEntities) {
        for (ReportingTaskEntity reportingTaskEntity : reportingTaskEntities) {
            this.populateRemainingReportingTaskEntityContent(reportingTaskEntity);
        }
        return reportingTaskEntities;
    }

    public ReportingTaskEntity populateRemainingReportingTaskEntityContent(ReportingTaskEntity reportingTaskEntity) {
        reportingTaskEntity.setUri(this.generateResourceUri(new String[]{"reporting-tasks", reportingTaskEntity.getId()}));
        if (reportingTaskEntity.getComponent() != null) {
            this.populateRemainingReportingTaskContent(reportingTaskEntity.getComponent());
        }
        return reportingTaskEntity;
    }

    public ReportingTaskDTO populateRemainingReportingTaskContent(ReportingTaskDTO reportingTask) {
        BundleDTO bundle = reportingTask.getBundle();
        if (bundle == null) {
            return reportingTask;
        }
        UiExtensionMapping uiExtensionMapping = (UiExtensionMapping)this.servletContext.getAttribute("nifi-ui-extensions");
        if (uiExtensionMapping.hasUiExtension(reportingTask.getType(), bundle.getGroup(), bundle.getArtifact(), bundle.getVersion())) {
            List uiExtensions = uiExtensionMapping.getUiExtension(reportingTask.getType(), bundle.getGroup(), bundle.getArtifact(), bundle.getVersion());
            for (UiExtension uiExtension : uiExtensions) {
                if (!UiExtensionType.ReportingTaskConfiguration.equals((Object)uiExtension.getExtensionType())) continue;
                reportingTask.setCustomUiUrl(this.generateExternalUiUri(new String[]{uiExtension.getContextPath()}));
            }
        }
        return reportingTask;
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}")
    @Operation(summary="Gets a reporting task", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ReportingTaskEntity.class))})}, security={@SecurityRequirement(name="Read - /reporting-tasks/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getReportingTask(@Parameter(description="The reporting task id.", required=true) @PathParam(value="id") String id) {
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable reportingTask = lookup.getReportingTask(id).getAuthorizable();
            reportingTask.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        });
        ReportingTaskEntity reportingTask = this.serviceFacade.getReportingTask(id);
        this.populateRemainingReportingTaskEntityContent(reportingTask);
        return this.generateOkResponse((Object)reportingTask).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}/descriptors")
    @Operation(summary="Gets a reporting task property descriptor", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=PropertyDescriptorEntity.class))})}, security={@SecurityRequirement(name="Read - /reporting-tasks/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getPropertyDescriptor(@Parameter(description="The reporting task id.", required=true) @PathParam(value="id") String id, @Parameter(description="The property name.", required=true) @QueryParam(value="propertyName") String propertyName, @Parameter(description="Property Descriptor requested sensitive status") @QueryParam(value="sensitive") boolean sensitive) {
        if (propertyName == null) {
            throw new IllegalArgumentException("The property name must be specified.");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable reportingTask = lookup.getReportingTask(id).getAuthorizable();
            reportingTask.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        });
        PropertyDescriptorDTO descriptor = this.serviceFacade.getReportingTaskPropertyDescriptor(id, propertyName, sensitive);
        PropertyDescriptorEntity entity = new PropertyDescriptorEntity();
        entity.setPropertyDescriptor(descriptor);
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}/state")
    @Operation(summary="Gets the state for a reporting task", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ComponentStateEntity.class))})}, security={@SecurityRequirement(name="Write - /reporting-tasks/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getState(@Parameter(description="The reporting task id.", required=true) @PathParam(value="id") String id) {
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable reportingTask = lookup.getReportingTask(id).getAuthorizable();
            reportingTask.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        });
        ComponentStateDTO state = this.serviceFacade.getReportingTaskState(id);
        ComponentStateEntity entity = new ComponentStateEntity();
        entity.setComponentState(state);
        return this.generateOkResponse((Object)entity).build();
    }

    @POST
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}/state/clear-requests")
    @Operation(summary="Clears the state for a reporting task", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ComponentStateEntity.class))})}, security={@SecurityRequirement(name="Write - /reporting-tasks/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response clearState(@Parameter(description="The reporting task id.", required=true) @PathParam(value="id") String id) {
        if (this.isReplicateRequest()) {
            return this.replicate("POST");
        }
        ReportingTaskEntity requestReportTaskEntity = new ReportingTaskEntity();
        requestReportTaskEntity.setId(id);
        return this.withWriteLock(this.serviceFacade, (Entity)requestReportTaskEntity, lookup -> {
            Authorizable processor = lookup.getReportingTask(id).getAuthorizable();
            processor.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        }, () -> this.serviceFacade.verifyCanClearReportingTaskState(id), reportingTaskEntity -> {
            this.serviceFacade.clearReportingTaskState(reportingTaskEntity.getId());
            ComponentStateEntity entity = new ComponentStateEntity();
            return this.generateOkResponse((Object)entity).build();
        });
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{id}")
    @Operation(summary="Updates a reporting task", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ReportingTaskEntity.class))})}, security={@SecurityRequirement(name="Write - /reporting-tasks/{uuid}"), @SecurityRequirement(name="Read - any referenced Controller Services if this request changes the reference - /controller-services/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response updateReportingTask(@Parameter(description="The reporting task id.", required=true) @PathParam(value="id") String id, @Parameter(description="The reporting task configuration details.", required=true) ReportingTaskEntity requestReportingTaskEntity) {
        if (requestReportingTaskEntity == null || requestReportingTaskEntity.getComponent() == null) {
            throw new IllegalArgumentException("Reporting task details must be specified.");
        }
        if (requestReportingTaskEntity.getRevision() == null) {
            throw new IllegalArgumentException("Revision must be specified.");
        }
        ReportingTaskDTO requestReportingTaskDTO = requestReportingTaskEntity.getComponent();
        if (!id.equals(requestReportingTaskDTO.getId())) {
            throw new IllegalArgumentException(String.format("The reporting task id (%s) in the request body does not equal the reporting task id of the requested resource (%s).", requestReportingTaskDTO.getId(), id));
        }
        if (this.isReplicateRequest()) {
            return this.replicate("PUT", (Object)requestReportingTaskEntity);
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestReportingTaskEntity.isDisconnectedNodeAcknowledged());
        }
        Revision requestRevision = this.getRevision((ComponentEntity)requestReportingTaskEntity, id);
        return this.withWriteLock(this.serviceFacade, (Entity)requestReportingTaskEntity, requestRevision, lookup -> {
            ComponentAuthorizable authorizable = lookup.getReportingTask(id);
            authorizable.getAuthorizable().authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
            AuthorizeControllerServiceReference.authorizeControllerServiceReferences((Map)requestReportingTaskDTO.getProperties(), (ComponentAuthorizable)authorizable, (Authorizer)this.authorizer, (AuthorizableLookup)lookup);
        }, () -> this.serviceFacade.verifyUpdateReportingTask(requestReportingTaskDTO), (revision, reportingTaskEntity) -> {
            ReportingTaskDTO reportingTaskDTO = reportingTaskEntity.getComponent();
            ReportingTaskEntity entity = this.serviceFacade.updateReportingTask(revision, reportingTaskDTO);
            this.populateRemainingReportingTaskEntityContent(entity);
            return this.generateOkResponse((Object)entity).build();
        });
    }

    @DELETE
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}")
    @Operation(summary="Deletes a reporting task", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ReportingTaskEntity.class))})}, security={@SecurityRequirement(name="Write - /reporting-tasks/{uuid}"), @SecurityRequirement(name="Write - /controller"), @SecurityRequirement(name="Read - any referenced Controller Services - /controller-services/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response removeReportingTask(@Parameter(description="The revision is used to verify the client is working with the latest version of the flow.") @QueryParam(value="version") LongParameter version, @Parameter(description="If the client id is not specified, new one will be generated. This value (whether specified or generated) is included in the response.") @QueryParam(value="clientId") @DefaultValue(value="") ClientIdParameter clientId, @Parameter(description="Acknowledges that this node is disconnected to allow for mutable requests to proceed.") @QueryParam(value="disconnectedNodeAcknowledged") @DefaultValue(value="false") Boolean disconnectedNodeAcknowledged, @Parameter(description="The reporting task id.", required=true) @PathParam(value="id") String id) {
        if (this.isReplicateRequest()) {
            return this.replicate("DELETE");
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(disconnectedNodeAcknowledged);
        }
        ReportingTaskEntity requestReportingTaskEntity = new ReportingTaskEntity();
        requestReportingTaskEntity.setId(id);
        Revision requestRevision = new Revision(version == null ? null : version.getLong(), clientId.getClientId(), id);
        return this.withWriteLock(this.serviceFacade, (Entity)requestReportingTaskEntity, requestRevision, lookup -> {
            ComponentAuthorizable reportingTask = lookup.getReportingTask(id);
            reportingTask.getAuthorizable().authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
            reportingTask.getAuthorizable().getParentAuthorizable().authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
            AuthorizeControllerServiceReference.authorizeControllerServiceReferences((ComponentAuthorizable)reportingTask, (Authorizer)this.authorizer, (AuthorizableLookup)lookup, (boolean)false);
        }, () -> this.serviceFacade.verifyDeleteReportingTask(id), (revision, reportingTaskEntity) -> {
            ReportingTaskEntity entity = this.serviceFacade.deleteReportingTask(revision, reportingTaskEntity.getId());
            return this.generateOkResponse((Object)entity).build();
        });
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{id}/run-status")
    @Operation(summary="Updates run status of a reporting task", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ReportingTaskEntity.class))})}, security={@SecurityRequirement(name="Write - /reporting-tasks/{uuid} or  or /operation/reporting-tasks/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response updateRunStatus(@Parameter(description="The reporting task id.", required=true) @PathParam(value="id") String id, @Parameter(description="The reporting task run status.", required=true) ReportingTaskRunStatusEntity requestRunStatus) {
        if (requestRunStatus == null) {
            throw new IllegalArgumentException("Reporting task run status must be specified.");
        }
        if (requestRunStatus.getRevision() == null) {
            throw new IllegalArgumentException("Revision must be specified.");
        }
        requestRunStatus.validateState();
        if (this.isReplicateRequest()) {
            return this.replicate("PUT", (Object)requestRunStatus);
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestRunStatus.isDisconnectedNodeAcknowledged());
        }
        Revision requestRevision = this.getRevision(requestRunStatus.getRevision(), id);
        return this.withWriteLock(this.serviceFacade, (Entity)requestRunStatus, requestRevision, lookup -> {
            Authorizable authorizable = lookup.getReportingTask(id).getAuthorizable();
            OperationAuthorizable.authorizeOperation((Authorizable)authorizable, (Authorizer)this.authorizer, (NiFiUser)NiFiUserUtils.getNiFiUser());
        }, () -> this.serviceFacade.verifyUpdateReportingTask(this.createDTOWithDesiredRunStatus(id, requestRunStatus.getState())), (revision, reportingTaskRunStatusEntity) -> {
            ReportingTaskEntity entity = this.serviceFacade.updateReportingTask(revision, this.createDTOWithDesiredRunStatus(id, reportingTaskRunStatusEntity.getState()));
            this.populateRemainingReportingTaskEntityContent(entity);
            return this.generateOkResponse((Object)entity).build();
        });
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/{id}/config/analysis")
    @Operation(summary="Performs analysis of the component's configuration, providing information about which attributes are referenced.", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ConfigurationAnalysisEntity.class))})}, security={@SecurityRequirement(name="Read - /reporting-tasks/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response analyzeConfiguration(@Parameter(description="The reporting task id.", required=true) @PathParam(value="id") String reportingTaskId, @Parameter(description="The configuration analysis request.", required=true) ConfigurationAnalysisEntity configurationAnalysis) {
        if (configurationAnalysis == null || configurationAnalysis.getConfigurationAnalysis() == null) {
            throw new IllegalArgumentException("Reporting Tasks's configuration must be specified");
        }
        ConfigurationAnalysisDTO dto = configurationAnalysis.getConfigurationAnalysis();
        if (dto.getComponentId() == null) {
            throw new IllegalArgumentException("Reporting Tasks's identifier must be specified in the request");
        }
        if (!dto.getComponentId().equals(reportingTaskId)) {
            throw new IllegalArgumentException("Reporting Tasks's identifier in the request must match the identifier provided in the URL");
        }
        if (dto.getProperties() == null) {
            throw new IllegalArgumentException("Reporting Tasks's properties must be specified in the request");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("POST", (Object)configurationAnalysis);
        }
        return this.withWriteLock(this.serviceFacade, (Entity)configurationAnalysis, lookup -> {
            ComponentAuthorizable reportingTask = lookup.getReportingTask(reportingTaskId);
            reportingTask.getAuthorizable().authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        }, () -> {}, entity -> {
            ConfigurationAnalysisDTO analysis = entity.getConfigurationAnalysis();
            ConfigurationAnalysisEntity resultsEntity = this.serviceFacade.analyzeReportingTaskConfiguration(analysis.getComponentId(), analysis.getProperties());
            return this.generateOkResponse((Object)resultsEntity).build();
        });
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/{id}/config/verification-requests")
    @Operation(summary="Performs verification of the Reporting Task's configuration", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=VerifyConfigRequestEntity.class))})}, description="This will initiate the process of verifying a given Reporting Task configuration. This may be a long-running task. As a result, this endpoint will immediately return a ReportingTaskConfigVerificationRequestEntity, and the process of performing the verification will occur asynchronously in the background. The client may then periodically poll the status of the request by issuing a GET request to /reporting-tasks/{taskId}/verification-requests/{requestId}. Once the request is completed, the client is expected to issue a DELETE request to /reporting-tasks/{serviceId}/verification-requests/{requestId}.", security={@SecurityRequirement(name="Read - /reporting-tasks/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response submitConfigVerificationRequest(@Parameter(description="The reporting task id.", required=true) @PathParam(value="id") String reportingTaskId, @Parameter(description="The reporting task configuration verification request.", required=true) VerifyConfigRequestEntity reportingTaskConfigRequest) {
        if (reportingTaskConfigRequest == null) {
            throw new IllegalArgumentException("Reporting Task's configuration must be specified");
        }
        VerifyConfigRequestDTO requestDto = reportingTaskConfigRequest.getRequest();
        if (requestDto == null || requestDto.getProperties() == null) {
            throw new IllegalArgumentException("Reporting Task Properties must be specified");
        }
        if (requestDto.getComponentId() == null) {
            throw new IllegalArgumentException("Reporting Task's identifier must be specified in the request");
        }
        if (!requestDto.getComponentId().equals(reportingTaskId)) {
            throw new IllegalArgumentException("Reporting Task's identifier in the request must match the identifier provided in the URL");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("POST", (Object)reportingTaskConfigRequest);
        }
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        return this.withWriteLock(this.serviceFacade, (Entity)reportingTaskConfigRequest, lookup -> {
            ComponentAuthorizable reportingTask = lookup.getReportingTask(reportingTaskId);
            reportingTask.getAuthorizable().authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        }, () -> this.serviceFacade.verifyCanVerifyReportingTaskConfig(reportingTaskId), entity -> this.performAsyncConfigVerification(entity, user));
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}/config/verification-requests/{requestId}")
    @Operation(summary="Returns the Verification Request with the given ID", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=VerifyConfigRequestEntity.class))})}, description="Returns the Verification Request with the given ID. Once an Verification Request has been created, that request can subsequently be retrieved via this endpoint, and the request that is fetched will contain the updated state, such as percent complete, the current state of the request, and any failures. ", security={@SecurityRequirement(name="Only the user that submitted the request can get it")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getVerificationRequest(@Parameter(description="The ID of the Reporting Task") @PathParam(value="id") String reportingTaskId, @Parameter(description="The ID of the Verification Request") @PathParam(value="requestId") String requestId) {
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        AsynchronousWebRequest asyncRequest = this.configVerificationRequestManager.getRequest(VERIFICATION_REQUEST_TYPE, requestId, user);
        VerifyConfigRequestEntity updateRequestEntity = this.createVerifyReportingTaskConfigRequestEntity(asyncRequest, requestId);
        return this.generateOkResponse((Object)updateRequestEntity).build();
    }

    @DELETE
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}/config/verification-requests/{requestId}")
    @Operation(summary="Deletes the Verification Request with the given ID", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=VerifyConfigRequestEntity.class))})}, description="Deletes the Verification Request with the given ID. After a request is created, it is expected that the client will properly clean up the request by DELETE'ing it, once the Verification process has completed. If the request is deleted before the request completes, then the Verification request will finish the step that it is currently performing and then will cancel any subsequent steps.", security={@SecurityRequirement(name="Only the user that submitted the request can remove it")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response deleteVerificationRequest(@Parameter(description="The ID of the Reporting Task") @PathParam(value="id") String reportingTaskId, @Parameter(description="The ID of the Verification Request") @PathParam(value="requestId") String requestId) {
        if (this.isReplicateRequest()) {
            return this.replicate("DELETE");
        }
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        boolean twoPhaseRequest = this.isTwoPhaseRequest(this.httpServletRequest);
        boolean executionPhase = this.isExecutionPhase(this.httpServletRequest);
        if (!twoPhaseRequest || executionPhase) {
            AsynchronousWebRequest asyncRequest = this.configVerificationRequestManager.removeRequest(VERIFICATION_REQUEST_TYPE, requestId, user);
            if (asyncRequest == null) {
                throw new ResourceNotFoundException("Could not find request of type verification-request with ID " + requestId);
            }
            if (!asyncRequest.isComplete()) {
                asyncRequest.cancel();
            }
            VerifyConfigRequestEntity updateRequestEntity = this.createVerifyReportingTaskConfigRequestEntity(asyncRequest, requestId);
            return this.generateOkResponse((Object)updateRequestEntity).build();
        }
        if (this.isValidationPhase(this.httpServletRequest)) {
            this.configVerificationRequestManager.getRequest(VERIFICATION_REQUEST_TYPE, requestId, user);
            return this.generateContinueResponse().build();
        }
        if (this.isCancellationPhase(this.httpServletRequest)) {
            return this.generateOkResponse().build();
        }
        throw new IllegalStateException("This request does not appear to be part of the two phase commit.");
    }

    public Response performAsyncConfigVerification(VerifyConfigRequestEntity configRequest, NiFiUser user) {
        String requestId = this.generateUuid();
        VerifyConfigRequestDTO requestDto = configRequest.getRequest();
        String taskId = requestDto.getComponentId();
        List<StandardUpdateStep> updateSteps = Collections.singletonList(new StandardUpdateStep("Verify Reporting Task Configuration"));
        StandardAsynchronousWebRequest request = new StandardAsynchronousWebRequest(requestId, (Object)configRequest, taskId, user, updateSteps);
        Consumer<AsynchronousWebRequest> updateTask = asyncRequest -> {
            try {
                List results = this.serviceFacade.performReportingTaskConfigVerification(taskId, requestDto.getProperties());
                asyncRequest.markStepComplete((Object)results);
            }
            catch (Exception e) {
                logger.error("Failed to verify Reporting Task configuration", (Throwable)e);
                asyncRequest.fail("Failed to verify Reporting Task configuration due to " + String.valueOf(e));
            }
        };
        this.configVerificationRequestManager.submitRequest(VERIFICATION_REQUEST_TYPE, requestId, (AsynchronousWebRequest)request, updateTask);
        VerifyConfigRequestEntity resultsEntity = this.createVerifyReportingTaskConfigRequestEntity((AsynchronousWebRequest)request, requestId);
        return this.generateOkResponse((Object)resultsEntity).build();
    }

    private VerifyConfigRequestEntity createVerifyReportingTaskConfigRequestEntity(AsynchronousWebRequest<VerifyConfigRequestEntity, List<ConfigVerificationResultDTO>> asyncRequest, String requestId) {
        VerifyConfigRequestDTO requestDto = ((VerifyConfigRequestEntity)asyncRequest.getRequest()).getRequest();
        List resultsList = (List)asyncRequest.getResults();
        VerifyConfigRequestDTO dto = new VerifyConfigRequestDTO();
        dto.setComponentId(requestDto.getComponentId());
        dto.setProperties(requestDto.getProperties());
        dto.setResults(resultsList);
        dto.setComplete(asyncRequest.isComplete());
        dto.setFailureReason(asyncRequest.getFailureReason());
        dto.setLastUpdated(asyncRequest.getLastUpdated());
        dto.setPercentCompleted(asyncRequest.getPercentComplete());
        dto.setRequestId(requestId);
        dto.setState(asyncRequest.getState());
        dto.setUri(this.generateResourceUri(new String[]{"reporting-tasks", requestDto.getComponentId(), "config", "verification-requests", requestId}));
        VerifyConfigRequestEntity entity = new VerifyConfigRequestEntity();
        entity.setRequest(dto);
        return entity;
    }

    private ReportingTaskDTO createDTOWithDesiredRunStatus(String id, String runStatus) {
        ReportingTaskDTO dto = new ReportingTaskDTO();
        dto.setId(id);
        dto.setState(runStatus);
        return dto;
    }

    @Autowired
    public void setServiceFacade(NiFiServiceFacade serviceFacade) {
        this.serviceFacade = serviceFacade;
    }

    @Autowired
    public void setAuthorizer(Authorizer authorizer) {
        this.authorizer = authorizer;
    }
}

