/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.dao.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.components.ConfigVerificationResult;
import org.apache.nifi.components.ConfigurableComponent;
import org.apache.nifi.components.state.Scope;
import org.apache.nifi.components.state.StateManager;
import org.apache.nifi.components.state.StateMap;
import org.apache.nifi.connectable.Position;
import org.apache.nifi.controller.BackoffMechanism;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.NodeTypeProvider;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.ScheduledState;
import org.apache.nifi.controller.exception.ComponentLifeCycleException;
import org.apache.nifi.controller.exception.ProcessorInstantiationException;
import org.apache.nifi.controller.exception.ValidationException;
import org.apache.nifi.documentation.init.NopStateManager;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.logging.GroupedComponent;
import org.apache.nifi.logging.LogLevel;
import org.apache.nifi.logging.LogRepository;
import org.apache.nifi.logging.LoggingContext;
import org.apache.nifi.logging.StandardLoggingContext;
import org.apache.nifi.logging.repository.NopLogRepository;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.parameter.ParameterLookup;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.SimpleProcessLogger;
import org.apache.nifi.processor.StandardProcessContext;
import org.apache.nifi.scheduling.ExecutionNode;
import org.apache.nifi.scheduling.SchedulingStrategy;
import org.apache.nifi.util.BundleUtils;
import org.apache.nifi.util.FormatUtils;
import org.apache.nifi.web.NiFiCoreException;
import org.apache.nifi.web.ResourceNotFoundException;
import org.apache.nifi.web.api.dto.BundleDTO;
import org.apache.nifi.web.api.dto.ConfigVerificationResultDTO;
import org.apache.nifi.web.api.dto.ProcessorConfigDTO;
import org.apache.nifi.web.api.dto.ProcessorDTO;
import org.apache.nifi.web.dao.ComponentStateDAO;
import org.apache.nifi.web.dao.ProcessorDAO;
import org.apache.nifi.web.dao.impl.ComponentDAO;
import org.apache.nifi.web.dao.impl.StandardProcessorDAO;
import org.springframework.scheduling.support.CronExpression;

public class StandardProcessorDAO
extends ComponentDAO
implements ProcessorDAO {
    private FlowController flowController;
    private ComponentStateDAO componentStateDAO;

    private ProcessorNode locateProcessor(String processorId) {
        ProcessGroup rootGroup = this.flowController.getFlowManager().getRootGroup();
        ProcessorNode processor = rootGroup.findProcessor(processorId);
        if (processor == null) {
            throw new ResourceNotFoundException(String.format("Unable to find processor with id '%s'.", processorId));
        }
        return processor;
    }

    public boolean hasProcessor(String id) {
        ProcessGroup rootGroup = this.flowController.getFlowManager().getRootGroup();
        return rootGroup.findProcessor(id) != null;
    }

    public void verifyCreate(ProcessorDTO processorDTO) {
        this.verifyCreate(this.flowController.getExtensionManager(), processorDTO.getType(), processorDTO.getBundle());
    }

    public ProcessorNode createProcessor(String groupId, ProcessorDTO processorDTO) {
        if (processorDTO.getParentGroupId() != null && !this.flowController.getFlowManager().areGroupsSame(groupId, processorDTO.getParentGroupId())) {
            throw new IllegalArgumentException("Cannot specify a different Parent Group ID than the Group to which the Processor is being added.");
        }
        if (processorDTO.getType() == null) {
            throw new IllegalArgumentException("The processor type must be specified.");
        }
        ProcessGroup group = this.locateProcessGroup(this.flowController, groupId);
        try {
            BundleCoordinate bundleCoordinate = BundleUtils.getBundle((ExtensionManager)this.flowController.getExtensionManager(), (String)processorDTO.getType(), (BundleDTO)processorDTO.getBundle());
            ProcessorNode processor = this.flowController.getFlowManager().createProcessor(processorDTO.getType(), processorDTO.getId(), bundleCoordinate);
            this.verifyUpdate(processor, processorDTO);
            group.addProcessor(processor);
            this.configureProcessor(processor, processorDTO);
            StandardProcessContext processContext = new StandardProcessContext(processor, this.flowController.getControllerServiceProvider(), this.flowController.getStateManagerProvider().getStateManager(processor.getProcessor().getIdentifier()), () -> false, (NodeTypeProvider)this.flowController);
            processor.onConfigurationRestored((ProcessContext)processContext);
            return processor;
        }
        catch (IllegalStateException | ComponentLifeCycleException ise) {
            throw new NiFiCoreException(ise.getMessage(), ise);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureProcessor(ProcessorNode processor, ProcessorDTO processorDTO) {
        String name;
        ProcessorConfigDTO config = processorDTO.getConfig();
        if (this.isNotNull((Object)config)) {
            String schedulingStrategy = config.getSchedulingStrategy();
            String executionNode = config.getExecutionNode();
            String comments = config.getComments();
            String annotationData = config.getAnnotationData();
            Integer maxTasks = config.getConcurrentlySchedulableTaskCount();
            Map configProperties = config.getProperties();
            String schedulingPeriod = config.getSchedulingPeriod();
            String penaltyDuration = config.getPenaltyDuration();
            String yieldDuration = config.getYieldDuration();
            Long runDurationMillis = config.getRunDurationMillis();
            String bulletinLevel = config.getBulletinLevel();
            Set undefinedRelationshipsToTerminate = config.getAutoTerminatedRelationships();
            Integer retryCount = config.getRetryCount();
            Set retriedRelationships = config.getRetriedRelationships();
            String backoffMechanism = config.getBackoffMechanism();
            String maxBackoffPeriod = config.getMaxBackoffPeriod();
            processor.pauseValidationTrigger();
            try {
                if (this.isNotNull((Object)schedulingStrategy)) {
                    processor.setSchedulingStrategy(SchedulingStrategy.valueOf((String)schedulingStrategy));
                }
                if (this.isNotNull((Object)executionNode)) {
                    processor.setExecutionNode(ExecutionNode.valueOf((String)executionNode));
                }
                if (this.isNotNull((Object)comments)) {
                    processor.setComments(comments);
                }
                if (this.isNotNull((Object)annotationData)) {
                    processor.setAnnotationData(annotationData);
                }
                if (this.isNotNull((Object)maxTasks)) {
                    processor.setMaxConcurrentTasks(maxTasks.intValue());
                }
                if (this.isNotNull((Object)schedulingPeriod)) {
                    processor.setSchedulingPeriod(schedulingPeriod);
                }
                if (this.isNotNull((Object)penaltyDuration)) {
                    processor.setPenalizationPeriod(penaltyDuration);
                }
                if (this.isNotNull((Object)yieldDuration)) {
                    processor.setYieldPeriod(yieldDuration);
                }
                if (this.isNotNull((Object)runDurationMillis)) {
                    processor.setRunDuration(runDurationMillis.longValue(), TimeUnit.MILLISECONDS);
                }
                if (this.isNotNull((Object)bulletinLevel)) {
                    processor.setBulletinLevel(LogLevel.valueOf((String)bulletinLevel));
                }
                if (this.isNotNull((Object)config.isLossTolerant())) {
                    processor.setLossTolerant(config.isLossTolerant().booleanValue());
                }
                if (this.isNotNull((Object)configProperties)) {
                    Set sensitiveDynamicPropertyNames = config.getSensitiveDynamicPropertyNames();
                    processor.setProperties(configProperties, false, sensitiveDynamicPropertyNames == null ? Collections.emptySet() : sensitiveDynamicPropertyNames);
                }
                if (this.isNotNull((Object)retryCount)) {
                    processor.setRetryCount(retryCount);
                }
                if (this.isNotNull((Object)retriedRelationships)) {
                    processor.setRetriedRelationships(retriedRelationships);
                }
                if (this.isNotNull((Object)backoffMechanism)) {
                    processor.setBackoffMechanism(BackoffMechanism.valueOf((String)backoffMechanism));
                }
                if (this.isNotNull((Object)maxBackoffPeriod)) {
                    processor.setMaxBackoffPeriod(maxBackoffPeriod);
                }
                if (this.isNotNull((Object)undefinedRelationshipsToTerminate)) {
                    HashSet<Relationship> relationships = new HashSet<Relationship>();
                    for (String relName : undefinedRelationshipsToTerminate) {
                        relationships.add(new Relationship.Builder().name(relName).build());
                    }
                    processor.setAutoTerminatedRelationships(relationships);
                }
            }
            finally {
                processor.resumeValidationTrigger();
            }
        }
        if (this.isNotNull((Object)processorDTO.getPosition())) {
            processor.setPosition(new Position(processorDTO.getPosition().getX().doubleValue(), processorDTO.getPosition().getY().doubleValue()));
        }
        if (this.isNotNull((Object)processorDTO.getStyle())) {
            processor.setStyle(processorDTO.getStyle());
        }
        if (this.isNotNull((Object)(name = processorDTO.getName()))) {
            processor.setName(name);
        }
    }

    private List<String> validateProposedConfiguration(ProcessorNode processorNode, ProcessorConfigDTO config) {
        Map properties;
        Set autoTerminatedRelationships;
        Matcher yieldMatcher;
        Matcher penaltyMatcher;
        ArrayList<String> validationErrors = new ArrayList<String>();
        if (this.isNotNull((Object)config.getPenaltyDuration()) && !(penaltyMatcher = FormatUtils.TIME_DURATION_PATTERN.matcher(config.getPenaltyDuration())).matches()) {
            validationErrors.add("Penalty duration is not a valid time duration (ie 30 sec, 5 min)");
        }
        if (this.isNotNull((Object)config.getYieldDuration()) && !(yieldMatcher = FormatUtils.TIME_DURATION_PATTERN.matcher(config.getYieldDuration())).matches()) {
            validationErrors.add("Yield duration is not a valid time duration (ie 30 sec, 5 min)");
        }
        if (this.isNotNull((Object)config.getBulletinLevel())) {
            try {
                LogLevel.valueOf((String)config.getBulletinLevel());
            }
            catch (IllegalArgumentException iae) {
                validationErrors.add(String.format("Bulletin level: Value must be one of [%s]", StringUtils.join((Object[])LogLevel.values(), (String)", ")));
            }
        }
        if (this.isNotNull((Object)config.getExecutionNode())) {
            try {
                ExecutionNode.valueOf((String)config.getExecutionNode());
            }
            catch (IllegalArgumentException iae) {
                validationErrors.add(String.format("Execution node: Value must be one of [%s]", StringUtils.join((Object[])ExecutionNode.values(), (String)", ")));
            }
        }
        SchedulingStrategy schedulingStrategy = processorNode.getSchedulingStrategy();
        if (this.isNotNull((Object)config.getSchedulingStrategy())) {
            try {
                schedulingStrategy = SchedulingStrategy.valueOf((String)config.getSchedulingStrategy());
            }
            catch (IllegalArgumentException iae) {
                validationErrors.add(String.format("Scheduling strategy: Value must be one of [%s]", StringUtils.join((Object[])SchedulingStrategy.values(), (String)", ")));
            }
        }
        if (this.isNotNull((Object)config.getConcurrentlySchedulableTaskCount())) {
            switch (1.$SwitchMap$org$apache$nifi$scheduling$SchedulingStrategy[schedulingStrategy.ordinal()]) {
                case 1: {
                    if (config.getConcurrentlySchedulableTaskCount() > 0) break;
                    validationErrors.add("Concurrent tasks must be greater than 0.");
                }
            }
        }
        String schedulingPeriod = config.getSchedulingPeriod();
        String evaluatedSchedulingPeriod = processorNode.evaluateParameters(schedulingPeriod);
        if (this.isNotNull((Object)schedulingPeriod) && this.isNotNull((Object)evaluatedSchedulingPeriod)) {
            switch (1.$SwitchMap$org$apache$nifi$scheduling$SchedulingStrategy[schedulingStrategy.ordinal()]) {
                case 1: {
                    Matcher schedulingMatcher = FormatUtils.TIME_DURATION_PATTERN.matcher(evaluatedSchedulingPeriod);
                    if (schedulingMatcher.matches()) break;
                    validationErrors.add("Scheduling period is not a valid time duration (ie 30 sec, 5 min)");
                    break;
                }
                case 2: {
                    try {
                        CronExpression.parse((String)evaluatedSchedulingPeriod);
                        break;
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException(String.format("Scheduling Period '%s' is not a valid cron expression: %s", schedulingPeriod, e.getMessage()));
                    }
                }
            }
        }
        if (this.isNotNull((Object)(autoTerminatedRelationships = config.getAutoTerminatedRelationships()))) {
            for (String relationshipName : autoTerminatedRelationships) {
                Relationship relationship = new Relationship.Builder().name(relationshipName).build();
                Set connections = processorNode.getConnections(relationship);
                if (!this.isNotNull((Object)connections) || connections.isEmpty()) continue;
                validationErrors.add("Cannot automatically terminate '" + relationshipName + "' relationship because a Connection already exists with this relationship");
            }
        }
        if (this.isNotNull((Object)(properties = config.getProperties()))) {
            try {
                processorNode.verifyCanUpdateProperties(properties);
            }
            catch (IllegalArgumentException | IllegalStateException iae) {
                validationErrors.add(iae.getMessage());
            }
        }
        return validationErrors;
    }

    public ProcessorNode getProcessor(String id) {
        return this.locateProcessor(id);
    }

    public Set<ProcessorNode> getProcessors(String groupId, boolean includeDescendants) {
        ProcessGroup group = this.locateProcessGroup(this.flowController, groupId);
        if (includeDescendants) {
            return new HashSet<ProcessorNode>(group.findAllProcessors());
        }
        return new HashSet<ProcessorNode>(group.getProcessors());
    }

    public void verifyTerminate(String processorId) {
        ProcessorNode processor = this.locateProcessor(processorId);
        processor.verifyCanTerminate();
    }

    public void terminate(String processorId) {
        ProcessorNode processor = this.locateProcessor(processorId);
        processor.getProcessGroup().terminateProcessor(processor);
    }

    public void verifyConfigVerification(String processorId) {
        ProcessorNode processor = this.locateProcessor(processorId);
        processor.verifyCanPerformVerification();
    }

    public void verifyUpdate(ProcessorDTO processorDTO) {
        this.verifyUpdate(this.locateProcessor(processorDTO.getId()), processorDTO);
    }

    private void verifyUpdate(ProcessorNode processor, ProcessorDTO processorDTO) {
        ProcessorConfigDTO configDTO;
        BundleDTO bundleDTO;
        if (this.isNotNull((Object)processorDTO.getState())) {
            try {
                ScheduledState purposedScheduledState = ScheduledState.valueOf((String)processorDTO.getState());
                if (!purposedScheduledState.equals((Object)processor.getScheduledState())) {
                    block1 : switch (1.$SwitchMap$org$apache$nifi$controller$ScheduledState[purposedScheduledState.ordinal()]) {
                        case 1: 
                        case 3: {
                            processor.getProcessGroup().verifyCanScheduleComponentsIndividually();
                            processor.verifyCanStart();
                            break;
                        }
                        case 4: {
                            switch (1.$SwitchMap$org$apache$nifi$controller$ScheduledState[processor.getScheduledState().ordinal()]) {
                                case 1: {
                                    processor.getProcessGroup().verifyCanScheduleComponentsIndividually();
                                    processor.verifyCanStop();
                                    break block1;
                                }
                                case 2: {
                                    processor.verifyCanEnable();
                                }
                            }
                            break;
                        }
                        case 2: {
                            processor.verifyCanDisable();
                        }
                    }
                }
            }
            catch (IllegalArgumentException iae) {
                throw new IllegalArgumentException(String.format("The specified processor state (%s) is not valid. Valid options are 'RUNNING', 'STOPPED', and 'DISABLED'.", processorDTO.getState()));
            }
        }
        boolean modificationRequest = false;
        if (this.isAnyNotNull(new Object[]{processorDTO.getName(), processorDTO.getBundle()})) {
            modificationRequest = true;
        }
        if ((bundleDTO = processorDTO.getBundle()) != null) {
            BundleCoordinate bundleCoordinate = BundleUtils.getBundle((ExtensionManager)this.flowController.getExtensionManager(), (String)processor.getCanonicalClassName(), (BundleDTO)bundleDTO);
            processor.verifyCanUpdateBundle(bundleCoordinate);
        }
        if ((configDTO = processorDTO.getConfig()) != null) {
            List requestValidation;
            if (this.isAnyNotNull(new Object[]{configDTO.getAnnotationData(), configDTO.getAutoTerminatedRelationships(), configDTO.getBulletinLevel(), configDTO.getComments(), configDTO.getConcurrentlySchedulableTaskCount(), configDTO.getPenaltyDuration(), configDTO.getProperties(), configDTO.getSchedulingPeriod(), configDTO.getSchedulingStrategy(), configDTO.getExecutionNode(), configDTO.getYieldDuration(), configDTO.getRetryCount(), configDTO.getBackoffMechanism(), configDTO.getMaxBackoffPeriod(), configDTO.getRetriedRelationships()})) {
                modificationRequest = true;
            }
            if (!(requestValidation = this.validateProposedConfiguration(processor, configDTO)).isEmpty()) {
                throw new ValidationException(requestValidation);
            }
        }
        if (modificationRequest) {
            processor.verifyCanUpdate();
        }
    }

    public List<ConfigVerificationResultDTO> verifyProcessorConfiguration(String processorId, Map<String, String> properties, Map<String, String> attributes) {
        ProcessorNode processor = this.locateProcessor(processorId);
        StandardProcessContext processContext = new StandardProcessContext(processor, properties, processor.getAnnotationData(), (ParameterLookup)processor.getProcessGroup().getParameterContext(), this.flowController.getControllerServiceProvider(), (StateManager)new NopStateManager(), () -> false, (NodeTypeProvider)this.flowController);
        NopLogRepository logRepository = new NopLogRepository();
        SimpleProcessLogger configVerificationLog = new SimpleProcessLogger((Object)processor, (LogRepository)logRepository, (LoggingContext)new StandardLoggingContext((GroupedComponent)processor));
        ExtensionManager extensionManager = this.flowController.getExtensionManager();
        List verificationResults = processor.verifyConfiguration((ProcessContext)processContext, (ComponentLog)configVerificationLog, attributes, extensionManager);
        List<ConfigVerificationResultDTO> resultsDtos = verificationResults.stream().map(arg_0 -> this.createConfigVerificationResultDto(arg_0)).collect(Collectors.toList());
        return resultsDtos;
    }

    private ConfigVerificationResultDTO createConfigVerificationResultDto(ConfigVerificationResult result) {
        ConfigVerificationResultDTO dto = new ConfigVerificationResultDTO();
        dto.setExplanation(result.getExplanation());
        dto.setOutcome(result.getOutcome().name());
        dto.setVerificationStepName(result.getVerificationStepName());
        return dto;
    }

    public ProcessorNode updateProcessor(ProcessorDTO processorDTO) {
        ScheduledState purposedScheduledState;
        ProcessorNode processor = this.locateProcessor(processorDTO.getId());
        ProcessGroup parentGroup = processor.getProcessGroup();
        this.verifyUpdate(processor, processorDTO);
        this.configureProcessor(processor, processorDTO);
        parentGroup.onComponentModified();
        this.updateBundle(processor, processorDTO);
        if (this.isNotNull((Object)processorDTO.getState()) && !(purposedScheduledState = ScheduledState.valueOf((String)processorDTO.getState())).equals((Object)processor.getScheduledState())) {
            try {
                block1 : switch (1.$SwitchMap$org$apache$nifi$controller$ScheduledState[purposedScheduledState.ordinal()]) {
                    case 1: {
                        parentGroup.startProcessor(processor, true);
                        break;
                    }
                    case 4: {
                        switch (1.$SwitchMap$org$apache$nifi$controller$ScheduledState[processor.getScheduledState().ordinal()]) {
                            case 1: {
                                parentGroup.stopProcessor(processor);
                                break block1;
                            }
                            case 2: {
                                parentGroup.enableProcessor(processor);
                            }
                        }
                        break;
                    }
                    case 2: {
                        parentGroup.disableProcessor(processor);
                        break;
                    }
                    case 3: {
                        parentGroup.runProcessorOnce(processor, () -> parentGroup.stopProcessor(processor));
                    }
                }
            }
            catch (IllegalStateException | ComponentLifeCycleException ise) {
                throw new NiFiCoreException(ise.getMessage(), ise);
            }
            catch (RejectedExecutionException ree) {
                throw new NiFiCoreException("Unable to schedule all tasks for the specified processor.", (Throwable)ree);
            }
            catch (NullPointerException npe) {
                throw new NiFiCoreException("Unable to update processor run state.", (Throwable)npe);
            }
            catch (Exception e) {
                throw new NiFiCoreException("Unable to update processor run state: " + String.valueOf(e), (Throwable)e);
            }
        }
        return processor;
    }

    private void updateBundle(ProcessorNode processor, ProcessorDTO processorDTO) {
        BundleDTO bundleDTO = processorDTO.getBundle();
        if (bundleDTO != null) {
            ExtensionManager extensionManager = this.flowController.getExtensionManager();
            BundleCoordinate incomingCoordinate = BundleUtils.getBundle((ExtensionManager)extensionManager, (String)processor.getCanonicalClassName(), (BundleDTO)bundleDTO);
            BundleCoordinate existingCoordinate = processor.getBundleCoordinate();
            if (!existingCoordinate.getCoordinate().equals(incomingCoordinate.getCoordinate())) {
                try {
                    ConfigurableComponent tempComponent = extensionManager.getTempComponent(processor.getCanonicalClassName(), incomingCoordinate);
                    Set additionalUrls = processor.getAdditionalClasspathResources(tempComponent.getPropertyDescriptors());
                    this.flowController.getReloadComponent().reload(processor, processor.getCanonicalClassName(), incomingCoordinate, additionalUrls);
                }
                catch (ProcessorInstantiationException e) {
                    throw new NiFiCoreException(String.format("Unable to update processor %s from %s to %s due to: %s", processorDTO.getId(), processor.getBundleCoordinate().getCoordinate(), incomingCoordinate.getCoordinate(), e.getMessage()), (Throwable)e);
                }
            }
        }
    }

    public void verifyDelete(String processorId) {
        ProcessorNode processor = this.locateProcessor(processorId);
        processor.verifyCanDelete();
    }

    public void deleteProcessor(String processorId) {
        ProcessorNode processor = this.locateProcessor(processorId);
        try {
            processor.getProcessGroup().removeProcessor(processor);
        }
        catch (ComponentLifeCycleException plce) {
            throw new NiFiCoreException(plce.getMessage(), (Throwable)plce);
        }
    }

    public StateMap getState(String processorId, Scope scope) {
        ProcessorNode processor = this.locateProcessor(processorId);
        return this.componentStateDAO.getState(processor, scope);
    }

    public void verifyClearState(String processorId) {
        ProcessorNode processor = this.locateProcessor(processorId);
        processor.verifyCanClearState();
    }

    public void clearState(String processorId) {
        ProcessorNode processor = this.locateProcessor(processorId);
        this.componentStateDAO.clearState(processor);
    }

    public void setFlowController(FlowController flowController) {
        this.flowController = flowController;
    }

    public void setComponentStateDAO(ComponentStateDAO componentStateDAO) {
        this.componentStateDAO = componentStateDAO;
    }
}

