/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api.concurrent;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.web.api.concurrent.AsynchronousWebRequest;
import org.apache.nifi.web.api.concurrent.UpdateStep;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardAsynchronousWebRequest<R, T>
implements AsynchronousWebRequest<R, T> {
    private static final Logger logger = LoggerFactory.getLogger(StandardAsynchronousWebRequest.class);
    private final String id;
    private final String componentId;
    private final NiFiUser user;
    private final List<UpdateStep> updateSteps;
    private final R request;
    private volatile boolean complete = false;
    private volatile Date lastUpdated = new Date();
    private volatile int percentComplete;
    private volatile String failureReason;
    private volatile boolean cancelled;
    private volatile T results;
    private volatile Runnable cancelCallback;
    private int currentStepIndex = 0;

    public StandardAsynchronousWebRequest(String requestId, R request, String componentId, NiFiUser user, List<UpdateStep> updateSteps) {
        this.id = requestId;
        this.componentId = componentId;
        this.user = user;
        this.updateSteps = updateSteps;
        this.request = request;
    }

    public synchronized UpdateStep getCurrentStep() {
        return this.updateSteps == null || this.updateSteps.size() <= this.currentStepIndex ? null : (UpdateStep)this.updateSteps.get(this.currentStepIndex);
    }

    public R getRequest() {
        return (R)this.request;
    }

    public String getRequestId() {
        return this.id;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public String getComponentId() {
        return this.componentId;
    }

    public void setCancelCallback(Runnable runnable) {
        this.cancelCallback = runnable;
    }

    public void markStepComplete() {
        this.markStepComplete(this.results);
    }

    public synchronized void markStepComplete(T results) {
        if (this.isCancelled() || this.isComplete()) {
            return;
        }
        UpdateStep currentStep = this.getCurrentStep();
        if (currentStep == null) {
            logger.debug("Current step marked complete for {} with results {} but there is no active step", (Object)this.id, results);
        } else {
            logger.debug("Marking active step '{}' with ID {} complete with result {}", new Object[]{currentStep.getDescription(), this.id, results});
            currentStep.markCompleted();
        }
        ++this.currentStepIndex;
        this.complete = this.currentStepIndex >= this.updateSteps.size();
        this.results = results;
        this.lastUpdated = new Date();
        this.percentComplete = this.currentStepIndex * 100 / this.updateSteps.size();
    }

    public synchronized String getState() {
        if (this.isComplete()) {
            return "Complete";
        }
        String failureReason = this.getFailureReason();
        if (failureReason != null) {
            return "Failed: " + failureReason;
        }
        UpdateStep currentStep = this.getCurrentStep();
        return currentStep == null ? "In Progress" : currentStep.getDescription();
    }

    public Date getLastUpdated() {
        return this.lastUpdated;
    }

    public List<UpdateStep> getUpdateSteps() {
        return Collections.unmodifiableList(this.updateSteps);
    }

    public int getPercentComplete() {
        return this.percentComplete;
    }

    public NiFiUser getUser() {
        return this.user;
    }

    public synchronized void fail(String explanation) {
        this.failureReason = Objects.requireNonNull(explanation);
        this.complete = true;
        this.results = null;
        this.lastUpdated = new Date();
        UpdateStep currentStep = this.getCurrentStep();
        if (currentStep != null) {
            currentStep.fail(explanation);
        }
    }

    public synchronized String getFailureReason() {
        return this.failureReason;
    }

    public T getResults() {
        return (T)this.results;
    }

    public void cancel() {
        this.cancelled = true;
        this.percentComplete = 100;
        this.fail("Request cancelled by user");
        if (this.cancelCallback != null) {
            this.cancelCallback.run();
        }
    }

    public boolean isCancelled() {
        return this.cancelled;
    }
}

