/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.List;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.web.NiFiServiceFacade;
import org.apache.nifi.web.api.ApplicationResource;
import org.apache.nifi.web.api.entity.ResourcesEntity;

@Path(value="/resources")
@Tag(name="Resources")
public class ResourceResource
extends ApplicationResource {
    private NiFiServiceFacade serviceFacade;
    private Authorizer authorizer;

    private void authorizeResource() {
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable resource = lookup.getResource();
            resource.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        });
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Operation(summary="Gets the available resources that support access/authorization policies", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ResourcesEntity.class))})}, security={@SecurityRequirement(name="Read - /resources")})
    @ApiResponses(value={@ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request.")})
    public Response getResources() {
        this.authorizeResource();
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        List resources = this.serviceFacade.getResources();
        ResourcesEntity entity = new ResourcesEntity();
        entity.setResources(resources);
        return this.generateOkResponse((Object)entity).build();
    }

    public void setServiceFacade(NiFiServiceFacade serviceFacade) {
        this.serviceFacade = serviceFacade;
    }

    public void setAuthorizer(Authorizer authorizer) {
        this.authorizer = authorizer;
    }
}

