/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.ServletContext;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.authorization.AuthorizableLookup;
import org.apache.nifi.authorization.AuthorizeControllerServiceReference;
import org.apache.nifi.authorization.AuthorizeParameterReference;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.ComponentAuthorizable;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.resource.OperationAuthorizable;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.controller.BackoffMechanism;
import org.apache.nifi.ui.extension.UiExtension;
import org.apache.nifi.ui.extension.UiExtensionMapping;
import org.apache.nifi.util.FormatUtils;
import org.apache.nifi.web.NiFiServiceFacade;
import org.apache.nifi.web.Revision;
import org.apache.nifi.web.UiExtensionType;
import org.apache.nifi.web.api.ApplicationResource;
import org.apache.nifi.web.api.concurrent.AsyncRequestManager;
import org.apache.nifi.web.api.concurrent.AsynchronousWebRequest;
import org.apache.nifi.web.api.concurrent.RequestManager;
import org.apache.nifi.web.api.concurrent.StandardAsynchronousWebRequest;
import org.apache.nifi.web.api.concurrent.StandardUpdateStep;
import org.apache.nifi.web.api.dto.BundleDTO;
import org.apache.nifi.web.api.dto.ComponentStateDTO;
import org.apache.nifi.web.api.dto.ConfigVerificationResultDTO;
import org.apache.nifi.web.api.dto.ConfigurationAnalysisDTO;
import org.apache.nifi.web.api.dto.PositionDTO;
import org.apache.nifi.web.api.dto.ProcessorConfigDTO;
import org.apache.nifi.web.api.dto.ProcessorDTO;
import org.apache.nifi.web.api.dto.PropertyDescriptorDTO;
import org.apache.nifi.web.api.dto.VerifyConfigRequestDTO;
import org.apache.nifi.web.api.entity.ComponentEntity;
import org.apache.nifi.web.api.entity.ComponentStateEntity;
import org.apache.nifi.web.api.entity.ConfigurationAnalysisEntity;
import org.apache.nifi.web.api.entity.Entity;
import org.apache.nifi.web.api.entity.ProcessorDiagnosticsEntity;
import org.apache.nifi.web.api.entity.ProcessorEntity;
import org.apache.nifi.web.api.entity.ProcessorRunStatusEntity;
import org.apache.nifi.web.api.entity.ProcessorsRunStatusDetailsEntity;
import org.apache.nifi.web.api.entity.PropertyDescriptorEntity;
import org.apache.nifi.web.api.entity.RunStatusDetailsRequestEntity;
import org.apache.nifi.web.api.entity.VerifyConfigRequestEntity;
import org.apache.nifi.web.api.request.ClientIdParameter;
import org.apache.nifi.web.api.request.LongParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/processors")
@Tag(name="Processors")
public class ProcessorResource
extends ApplicationResource {
    private static final Logger logger = LoggerFactory.getLogger(ProcessorResource.class);
    private static final String VERIFICATION_REQUEST_TYPE = "verification-request";
    private RequestManager<VerifyConfigRequestEntity, List<ConfigVerificationResultDTO>> configVerificationRequestManager = new AsyncRequestManager(100, TimeUnit.MINUTES.toMillis(1L), "Verify Processor Config Thread");
    private NiFiServiceFacade serviceFacade;
    private Authorizer authorizer;
    @Context
    private ServletContext servletContext;

    public Set<ProcessorEntity> populateRemainingProcessorEntitiesContent(Set<ProcessorEntity> processorEntities) {
        for (ProcessorEntity processorEntity : processorEntities) {
            this.populateRemainingProcessorEntityContent(processorEntity);
        }
        return processorEntities;
    }

    public ProcessorEntity populateRemainingProcessorEntityContent(ProcessorEntity processorEntity) {
        processorEntity.setUri(this.generateResourceUri(new String[]{"processors", processorEntity.getId()}));
        if (processorEntity.getComponent() != null) {
            this.populateRemainingProcessorContent(processorEntity.getComponent());
        }
        return processorEntity;
    }

    public ProcessorDiagnosticsEntity populateRemainingProcessorDiagnosticsEntityContent(ProcessorDiagnosticsEntity processorDiagnosticsEntity) {
        processorDiagnosticsEntity.setUri(this.generateResourceUri(new String[]{"processors", processorDiagnosticsEntity.getId(), "diagnostics"}));
        if (processorDiagnosticsEntity.getComponent() != null && processorDiagnosticsEntity.getComponent().getProcessor() != null) {
            this.populateRemainingProcessorContent(processorDiagnosticsEntity.getComponent().getProcessor());
        }
        return processorDiagnosticsEntity;
    }

    public ProcessorDTO populateRemainingProcessorContent(ProcessorDTO processor) {
        ProcessorConfigDTO config = processor.getConfig();
        if (config != null) {
            String customUiUrl = this.servletContext.getInitParameter(processor.getType());
            if (StringUtils.isNotBlank((CharSequence)customUiUrl)) {
                config.setCustomUiUrl(customUiUrl);
            } else {
                BundleDTO bundle = processor.getBundle();
                UiExtensionMapping uiExtensionMapping = (UiExtensionMapping)this.servletContext.getAttribute("nifi-ui-extensions");
                if (uiExtensionMapping.hasUiExtension(processor.getType(), bundle.getGroup(), bundle.getArtifact(), bundle.getVersion())) {
                    List uiExtensions = uiExtensionMapping.getUiExtension(processor.getType(), bundle.getGroup(), bundle.getArtifact(), bundle.getVersion());
                    for (UiExtension uiExtension : uiExtensions) {
                        if (!UiExtensionType.ProcessorConfiguration.equals((Object)uiExtension.getExtensionType())) continue;
                        config.setCustomUiUrl(uiExtension.getContextPath() + "/configure");
                    }
                }
            }
        }
        return processor;
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="/{id}")
    @Operation(summary="Gets a processor", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ProcessorEntity.class))})}, security={@SecurityRequirement(name="Read - /processors/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getProcessor(@Parameter(description="The processor id.", required=true) @PathParam(value="id") String id) throws InterruptedException {
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable processor = lookup.getProcessor(id).getAuthorizable();
            processor.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        });
        ProcessorEntity entity = this.serviceFacade.getProcessor(id);
        this.populateRemainingProcessorEntityContent(entity);
        return this.generateOkResponse((Object)entity).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/run-status-details/queries")
    @Operation(summary="Submits a query to retrieve the run status details of all processors that are in the given list of Processor IDs", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ProcessorsRunStatusDetailsEntity.class))})}, security={@SecurityRequirement(name="Read - /processors/{uuid} for each processor whose run status information is requested")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getProcessorRunStatusDetails(@Parameter(description="The request for the processors that should be included in the results") RunStatusDetailsRequestEntity requestEntity) {
        if (requestEntity.getProcessorIds() == null) {
            throw new IllegalArgumentException("List of Processor IDs must be provided");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("POST", (Object)requestEntity);
        }
        return this.withWriteLock(this.serviceFacade, (Entity)requestEntity, lookup -> {}, null, providedEntity -> {
            ProcessorsRunStatusDetailsEntity entity = this.serviceFacade.getProcessorsRunStatusDetails(requestEntity.getProcessorIds(), NiFiUserUtils.getNiFiUser());
            return this.generateOkResponse((Object)entity).build();
        });
    }

    @DELETE
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="/{id}/threads")
    @Operation(summary="Terminates a processor, essentially \"deleting\" its threads and any active tasks", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ProcessorEntity.class))})}, security={@SecurityRequirement(name="Write - /processors/{uuid} or /operation/processors/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response terminateProcessor(@Parameter(description="The processor id.", required=true) @PathParam(value="id") String id) {
        if (this.isReplicateRequest()) {
            return this.replicate("DELETE");
        }
        ProcessorEntity requestProcessorEntity = new ProcessorEntity();
        requestProcessorEntity.setId(id);
        return this.withWriteLock(this.serviceFacade, (Entity)requestProcessorEntity, lookup -> {
            Authorizable authorizable = lookup.getProcessor(id).getAuthorizable();
            OperationAuthorizable.authorizeOperation((Authorizable)authorizable, (Authorizer)this.authorizer, (NiFiUser)NiFiUserUtils.getNiFiUser());
        }, () -> this.serviceFacade.verifyTerminateProcessor(id), processorEntity -> {
            ProcessorEntity entity = this.serviceFacade.terminateProcessor(processorEntity.getId());
            this.populateRemainingProcessorEntityContent(entity);
            return this.generateOkResponse((Object)entity).build();
        });
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="/{id}/diagnostics")
    @Operation(summary="Gets diagnostics information about a processor", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ProcessorEntity.class))})}, description="Note: This endpoint is subject to change as NiFi and it's REST API evolve.", security={@SecurityRequirement(name="Read - /processors/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getProcessorDiagnostics(@Parameter(description="The processor id.", required=true) @PathParam(value="id") String id) throws InterruptedException {
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable processor = lookup.getProcessor(id).getAuthorizable();
            processor.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        });
        ProcessorDiagnosticsEntity entity = this.serviceFacade.getProcessorDiagnostics(id);
        this.populateRemainingProcessorDiagnosticsEntityContent(entity);
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="/{id}/descriptors")
    @Operation(summary="Gets the descriptor for a processor property", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=PropertyDescriptorEntity.class))})}, security={@SecurityRequirement(name="Read - /processors/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getPropertyDescriptor(@Parameter(description="If the client id is not specified, new one will be generated. This value (whether specified or generated) is included in the response.") @QueryParam(value="clientId") @DefaultValue(value="") ClientIdParameter clientId, @Parameter(description="The processor id.", required=true) @PathParam(value="id") String id, @Parameter(description="The property name.", required=true) @QueryParam(value="propertyName") String propertyName, @Parameter(description="Property Descriptor requested sensitive status") @QueryParam(value="sensitive") boolean sensitive) throws InterruptedException {
        if (propertyName == null) {
            throw new IllegalArgumentException("The property name must be specified.");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable processor = lookup.getProcessor(id).getAuthorizable();
            processor.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        });
        PropertyDescriptorDTO descriptor = this.serviceFacade.getProcessorPropertyDescriptor(id, propertyName, sensitive);
        PropertyDescriptorEntity entity = new PropertyDescriptorEntity();
        entity.setPropertyDescriptor(descriptor);
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="/{id}/state")
    @Operation(summary="Gets the state for a processor", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ComponentStateEntity.class))})}, security={@SecurityRequirement(name="Write - /processors/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getState(@Parameter(description="The processor id.", required=true) @PathParam(value="id") String id) throws InterruptedException {
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable processor = lookup.getProcessor(id).getAuthorizable();
            processor.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        });
        ComponentStateDTO state = this.serviceFacade.getProcessorState(id);
        ComponentStateEntity entity = new ComponentStateEntity();
        entity.setComponentState(state);
        return this.generateOkResponse((Object)entity).build();
    }

    @POST
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}/state/clear-requests")
    @Operation(summary="Clears the state for a processor", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ComponentStateEntity.class))})}, security={@SecurityRequirement(name="Write - /processors/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response clearState(@Parameter(description="The processor id.", required=true) @PathParam(value="id") String id) throws InterruptedException {
        if (this.isReplicateRequest()) {
            return this.replicate("POST");
        }
        ProcessorEntity requestProcessorEntity = new ProcessorEntity();
        requestProcessorEntity.setId(id);
        return this.withWriteLock(this.serviceFacade, (Entity)requestProcessorEntity, lookup -> {
            Authorizable processor = lookup.getProcessor(id).getAuthorizable();
            processor.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        }, () -> this.serviceFacade.verifyCanClearProcessorState(id), processorEntity -> {
            this.serviceFacade.clearProcessorState(processorEntity.getId());
            ComponentStateEntity entity = new ComponentStateEntity();
            return this.generateOkResponse((Object)entity).build();
        });
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/{id}/config/analysis")
    @Operation(summary="Performs analysis of the component's configuration, providing information about which attributes are referenced.", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ConfigurationAnalysisEntity.class))})}, security={@SecurityRequirement(name="Read - /processors/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response analyzeConfiguration(@Parameter(description="The processor id.", required=true) @PathParam(value="id") String processorId, @Parameter(description="The processor configuration analysis request.", required=true) ConfigurationAnalysisEntity configurationAnalysis) {
        if (configurationAnalysis == null || configurationAnalysis.getConfigurationAnalysis() == null) {
            throw new IllegalArgumentException("Processor's configuration must be specified");
        }
        ConfigurationAnalysisDTO dto = configurationAnalysis.getConfigurationAnalysis();
        if (dto.getComponentId() == null) {
            throw new IllegalArgumentException("Processor's identifier must be specified in the request");
        }
        if (!dto.getComponentId().equals(processorId)) {
            throw new IllegalArgumentException("Processor's identifier in the request must match the identifier provided in the URL");
        }
        if (dto.getProperties() == null) {
            throw new IllegalArgumentException("Processor's properties must be specified in the request");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("POST", (Object)configurationAnalysis);
        }
        return this.withWriteLock(this.serviceFacade, (Entity)configurationAnalysis, lookup -> {
            ComponentAuthorizable processor = lookup.getProcessor(processorId);
            processor.getAuthorizable().authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        }, () -> {}, entity -> {
            ConfigurationAnalysisDTO analysis = entity.getConfigurationAnalysis();
            ConfigurationAnalysisEntity resultsEntity = this.serviceFacade.analyzeProcessorConfiguration(analysis.getComponentId(), analysis.getProperties());
            return this.generateOkResponse((Object)resultsEntity).build();
        });
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/{id}/config/verification-requests")
    @Operation(summary="Performs verification of the Processor's configuration", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=VerifyConfigRequestEntity.class))})}, description="This will initiate the process of verifying a given Processor configuration. This may be a long-running task. As a result, this endpoint will immediately return a ProcessorConfigVerificationRequestEntity, and the process of performing the verification will occur asynchronously in the background. The client may then periodically poll the status of the request by issuing a GET request to /processors/{processorId}/verification-requests/{requestId}. Once the request is completed, the client is expected to issue a DELETE request to /processors/{processorId}/verification-requests/{requestId}.", security={@SecurityRequirement(name="Read - /processors/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response submitProcessorVerificationRequest(@Parameter(description="The processor id.", required=true) @PathParam(value="id") String processorId, @Parameter(description="The processor configuration verification request.", required=true) VerifyConfigRequestEntity processorConfigRequest) {
        if (processorConfigRequest == null) {
            throw new IllegalArgumentException("Processor's configuration must be specified");
        }
        VerifyConfigRequestDTO requestDto = processorConfigRequest.getRequest();
        if (requestDto == null || requestDto.getProperties() == null) {
            throw new IllegalArgumentException("Processor's properties must be specified");
        }
        if (requestDto.getComponentId() == null) {
            throw new IllegalArgumentException("Processor's identifier must be specified in the request");
        }
        if (!requestDto.getComponentId().equals(processorId)) {
            throw new IllegalArgumentException("Processor's identifier in the request must match the identifier provided in the URL");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("POST", (Object)processorConfigRequest);
        }
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        return this.withWriteLock(this.serviceFacade, (Entity)processorConfigRequest, lookup -> {
            ComponentAuthorizable processor = lookup.getProcessor(processorId);
            processor.getAuthorizable().authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        }, () -> this.serviceFacade.verifyCanVerifyProcessorConfig(processorId), entity -> this.performAsyncConfigVerification(entity, user));
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}/config/verification-requests/{requestId}")
    @Operation(summary="Returns the Verification Request with the given ID", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=VerifyConfigRequestEntity.class))})}, description="Returns the Verification Request with the given ID. Once an Verification Request has been created, that request can subsequently be retrieved via this endpoint, and the request that is fetched will contain the updated state, such as percent complete, the current state of the request, and any failures. ", security={@SecurityRequirement(name="Only the user that submitted the request can get it")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getVerificationRequest(@Parameter(description="The ID of the Processor") @PathParam(value="id") String processorId, @Parameter(description="The ID of the Verification Request") @PathParam(value="requestId") String requestId) {
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        AsynchronousWebRequest asyncRequest = this.configVerificationRequestManager.getRequest(VERIFICATION_REQUEST_TYPE, requestId, user);
        VerifyConfigRequestEntity updateRequestEntity = this.createVerifyProcessorConfigRequestEntity(asyncRequest, requestId);
        return this.generateOkResponse((Object)updateRequestEntity).build();
    }

    @DELETE
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}/config/verification-requests/{requestId}")
    @Operation(summary="Deletes the Verification Request with the given ID", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=VerifyConfigRequestEntity.class))})}, description="Deletes the Verification Request with the given ID. After a request is created, it is expected that the client will properly clean up the request by DELETE'ing it, once the Verification process has completed. If the request is deleted before the request completes, then the Verification request will finish the step that it is currently performing and then will cancel any subsequent steps.", security={@SecurityRequirement(name="Only the user that submitted the request can remove it")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response deleteVerificationRequest(@Parameter(description="The ID of the Processor") @PathParam(value="id") String processorId, @Parameter(description="The ID of the Verification Request") @PathParam(value="requestId") String requestId) {
        if (this.isReplicateRequest()) {
            return this.replicate("DELETE");
        }
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        boolean twoPhaseRequest = this.isTwoPhaseRequest(this.httpServletRequest);
        boolean executionPhase = this.isExecutionPhase(this.httpServletRequest);
        if (!twoPhaseRequest || executionPhase) {
            AsynchronousWebRequest asyncRequest = this.configVerificationRequestManager.removeRequest(VERIFICATION_REQUEST_TYPE, requestId, user);
            if (!asyncRequest.isComplete()) {
                asyncRequest.cancel();
            }
            VerifyConfigRequestEntity updateRequestEntity = this.createVerifyProcessorConfigRequestEntity(asyncRequest, requestId);
            return this.generateOkResponse((Object)updateRequestEntity).build();
        }
        if (this.isValidationPhase(this.httpServletRequest)) {
            this.configVerificationRequestManager.getRequest(VERIFICATION_REQUEST_TYPE, requestId, user);
            return this.generateContinueResponse().build();
        }
        if (this.isCancellationPhase(this.httpServletRequest)) {
            return this.generateOkResponse().build();
        }
        throw new IllegalStateException("This request does not appear to be part of the two phase commit.");
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/{id}")
    @Operation(summary="Updates a processor", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ProcessorEntity.class))})}, security={@SecurityRequirement(name="Write - /processors/{uuid}"), @SecurityRequirement(name="Read - any referenced Controller Services if this request changes the reference - /controller-services/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response updateProcessor(@Parameter(description="The processor id.", required=true) @PathParam(value="id") String id, @Parameter(description="The processor configuration details.", required=true) ProcessorEntity requestProcessorEntity) {
        if (requestProcessorEntity == null || requestProcessorEntity.getComponent() == null) {
            throw new IllegalArgumentException("Processor details must be specified.");
        }
        if (requestProcessorEntity.getRevision() == null) {
            throw new IllegalArgumentException("Revision must be specified.");
        }
        ProcessorDTO requestProcessorDTO = requestProcessorEntity.getComponent();
        if (!id.equals(requestProcessorDTO.getId())) {
            throw new IllegalArgumentException(String.format("The processor id (%s) in the request body does not equal the processor id of the requested resource (%s).", requestProcessorDTO.getId(), id));
        }
        PositionDTO proposedPosition = requestProcessorDTO.getPosition();
        if (proposedPosition != null && (proposedPosition.getX() == null || proposedPosition.getY() == null)) {
            throw new IllegalArgumentException("The x and y coordinate of the proposed position must be specified.");
        }
        ProcessorConfigDTO processorConfig = requestProcessorDTO.getConfig();
        if (processorConfig != null) {
            if (processorConfig.getRetryCount() != null && processorConfig.getRetryCount() < 0) {
                throw new IllegalArgumentException("Retry Count should not be less than zero.");
            }
            if (processorConfig.getBackoffMechanism() != null) {
                try {
                    BackoffMechanism.valueOf((String)processorConfig.getBackoffMechanism());
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Backoff Mechanism " + processorConfig.getBackoffMechanism() + " is invalid.");
                }
            }
            if (processorConfig.getMaxBackoffPeriod() != null && !FormatUtils.TIME_DURATION_PATTERN.matcher(processorConfig.getMaxBackoffPeriod()).matches()) {
                throw new IllegalArgumentException("Max Backoff Period should be specified as time, for example 5 mins");
            }
        }
        if (this.isReplicateRequest()) {
            return this.replicate("PUT", (Object)requestProcessorEntity);
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestProcessorEntity.isDisconnectedNodeAcknowledged());
        }
        Revision requestRevision = this.getRevision((ComponentEntity)requestProcessorEntity, id);
        return this.withWriteLock(this.serviceFacade, (Entity)requestProcessorEntity, requestRevision, lookup -> {
            NiFiUser user = NiFiUserUtils.getNiFiUser();
            ComponentAuthorizable authorizable = lookup.getProcessor(id);
            authorizable.getAuthorizable().authorize(this.authorizer, RequestAction.WRITE, user);
            ProcessorConfigDTO config = requestProcessorDTO.getConfig();
            if (config != null) {
                AuthorizeControllerServiceReference.authorizeControllerServiceReferences((Map)config.getProperties(), (ComponentAuthorizable)authorizable, (Authorizer)this.authorizer, (AuthorizableLookup)lookup);
                AuthorizeParameterReference.authorizeParameterReferences((Map)config.getProperties(), (Authorizer)this.authorizer, (Authorizable)authorizable.getParameterContext(), (NiFiUser)user);
            }
        }, () -> this.serviceFacade.verifyUpdateProcessor(requestProcessorDTO), (revision, processorEntity) -> {
            ProcessorDTO processorDTO = processorEntity.getComponent();
            ProcessorEntity entity = this.serviceFacade.updateProcessor(revision, processorDTO);
            this.populateRemainingProcessorEntityContent(entity);
            return this.generateOkResponse((Object)entity).build();
        });
    }

    @DELETE
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="/{id}")
    @Operation(summary="Deletes a processor", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ProcessorEntity.class))})}, security={@SecurityRequirement(name="Write - /processors/{uuid}"), @SecurityRequirement(name="Write - Parent Process Group - /process-groups/{uuid}"), @SecurityRequirement(name="Read - any referenced Controller Services - /controller-services/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response deleteProcessor(@Parameter(description="The revision is used to verify the client is working with the latest version of the flow.") @QueryParam(value="version") LongParameter version, @Parameter(description="If the client id is not specified, new one will be generated. This value (whether specified or generated) is included in the response.") @QueryParam(value="clientId") @DefaultValue(value="") ClientIdParameter clientId, @Parameter(description="Acknowledges that this node is disconnected to allow for mutable requests to proceed.") @QueryParam(value="disconnectedNodeAcknowledged") @DefaultValue(value="false") Boolean disconnectedNodeAcknowledged, @Parameter(description="The processor id.", required=true) @PathParam(value="id") String id) throws InterruptedException {
        if (this.isReplicateRequest()) {
            return this.replicate("DELETE");
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(disconnectedNodeAcknowledged);
        }
        ProcessorEntity requestProcessorEntity = new ProcessorEntity();
        requestProcessorEntity.setId(id);
        Revision requestRevision = new Revision(version == null ? null : version.getLong(), clientId.getClientId(), id);
        return this.withWriteLock(this.serviceFacade, (Entity)requestProcessorEntity, requestRevision, lookup -> {
            ComponentAuthorizable processor = lookup.getProcessor(id);
            processor.getAuthorizable().authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
            processor.getAuthorizable().getParentAuthorizable().authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
            AuthorizeControllerServiceReference.authorizeControllerServiceReferences((ComponentAuthorizable)processor, (Authorizer)this.authorizer, (AuthorizableLookup)lookup, (boolean)false);
        }, () -> this.serviceFacade.verifyDeleteProcessor(id), (revision, processorEntity) -> {
            ProcessorEntity entity = this.serviceFacade.deleteProcessor(revision, processorEntity.getId());
            return this.generateOkResponse((Object)entity).build();
        });
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/{id}/run-status")
    @Operation(summary="Updates run status of a processor", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ProcessorEntity.class))})}, security={@SecurityRequirement(name="Write - /processors/{uuid} or /operation/processors/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response updateRunStatus(@Parameter(description="The processor id.", required=true) @PathParam(value="id") String id, @Parameter(description="The processor run status.", required=true) ProcessorRunStatusEntity requestRunStatus) {
        if (requestRunStatus == null) {
            throw new IllegalArgumentException("Processor run status must be specified.");
        }
        if (requestRunStatus.getRevision() == null) {
            throw new IllegalArgumentException("Revision must be specified.");
        }
        requestRunStatus.validateState();
        if (this.isReplicateRequest()) {
            return this.replicate("PUT", (Object)requestRunStatus);
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestRunStatus.isDisconnectedNodeAcknowledged());
        }
        Revision requestRevision = this.getRevision(requestRunStatus.getRevision(), id);
        return this.withWriteLock(this.serviceFacade, (Entity)requestRunStatus, requestRevision, lookup -> {
            NiFiUser user = NiFiUserUtils.getNiFiUser();
            Authorizable authorizable = lookup.getProcessor(id).getAuthorizable();
            OperationAuthorizable.authorizeOperation((Authorizable)authorizable, (Authorizer)this.authorizer, (NiFiUser)user);
        }, () -> this.serviceFacade.verifyUpdateProcessor(this.createDTOWithDesiredRunStatus(id, requestRunStatus.getState())), (revision, runStatusEntity) -> {
            ProcessorEntity entity = this.serviceFacade.updateProcessor(revision, this.createDTOWithDesiredRunStatus(id, runStatusEntity.getState()));
            this.populateRemainingProcessorEntityContent(entity);
            return this.generateOkResponse((Object)entity).build();
        });
    }

    private ProcessorDTO createDTOWithDesiredRunStatus(String id, String runStatus) {
        ProcessorDTO dto = new ProcessorDTO();
        dto.setId(id);
        dto.setState(runStatus);
        return dto;
    }

    public Response performAsyncConfigVerification(VerifyConfigRequestEntity processorConfigRequest, NiFiUser user) {
        String requestId = this.generateUuid();
        logger.debug("Generated Config Verification Request with ID {} for Processor {}", (Object)requestId, (Object)processorConfigRequest.getRequest().getComponentId());
        VerifyConfigRequestDTO requestDto = processorConfigRequest.getRequest();
        String processorId = requestDto.getComponentId();
        List<StandardUpdateStep> updateSteps = Collections.singletonList(new StandardUpdateStep("Verify Processor Configuration"));
        StandardAsynchronousWebRequest request = new StandardAsynchronousWebRequest(requestId, (Object)processorConfigRequest, processorId, user, updateSteps);
        Consumer<AsynchronousWebRequest> updateTask = asyncRequest -> {
            try {
                Map attributes = requestDto.getAttributes() == null ? Collections.emptyMap() : requestDto.getAttributes();
                List results = this.serviceFacade.performProcessorConfigVerification(processorId, requestDto.getProperties(), attributes);
                asyncRequest.markStepComplete((Object)results);
            }
            catch (Exception e) {
                logger.error("Failed to verify Processor configuration", (Throwable)e);
                asyncRequest.fail("Failed to verify Processor configuration due to " + String.valueOf(e));
            }
        };
        this.configVerificationRequestManager.submitRequest(VERIFICATION_REQUEST_TYPE, requestId, (AsynchronousWebRequest)request, updateTask);
        VerifyConfigRequestEntity resultsEntity = this.createVerifyProcessorConfigRequestEntity((AsynchronousWebRequest)request, requestId);
        return this.generateOkResponse((Object)resultsEntity).build();
    }

    private VerifyConfigRequestEntity createVerifyProcessorConfigRequestEntity(AsynchronousWebRequest<VerifyConfigRequestEntity, List<ConfigVerificationResultDTO>> asyncRequest, String requestId) {
        VerifyConfigRequestDTO requestDto = ((VerifyConfigRequestEntity)asyncRequest.getRequest()).getRequest();
        List resultsList = (List)asyncRequest.getResults();
        VerifyConfigRequestDTO dto = new VerifyConfigRequestDTO();
        dto.setComponentId(requestDto.getComponentId());
        dto.setProperties(requestDto.getProperties());
        dto.setResults(resultsList);
        dto.setComplete(asyncRequest.isComplete());
        dto.setFailureReason(asyncRequest.getFailureReason());
        dto.setLastUpdated(asyncRequest.getLastUpdated());
        dto.setPercentCompleted(asyncRequest.getPercentComplete());
        dto.setRequestId(requestId);
        dto.setState(asyncRequest.getState());
        dto.setUri(this.generateResourceUri(new String[]{"processors", requestDto.getComponentId(), "config", "verification-requests", requestId}));
        VerifyConfigRequestEntity entity = new VerifyConfigRequestEntity();
        entity.setRequest(dto);
        return entity;
    }

    public void setServiceFacade(NiFiServiceFacade serviceFacade) {
        this.serviceFacade = serviceFacade;
    }

    public void setAuthorizer(Authorizer authorizer) {
        this.authorizer = authorizer;
    }
}

