/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.Set;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.web.NiFiServiceFacade;
import org.apache.nifi.web.Revision;
import org.apache.nifi.web.api.ApplicationResource;
import org.apache.nifi.web.api.dto.LabelDTO;
import org.apache.nifi.web.api.dto.PositionDTO;
import org.apache.nifi.web.api.entity.ComponentEntity;
import org.apache.nifi.web.api.entity.Entity;
import org.apache.nifi.web.api.entity.LabelEntity;
import org.apache.nifi.web.api.request.ClientIdParameter;
import org.apache.nifi.web.api.request.LongParameter;

@Path(value="/labels")
@Tag(name="Labels")
public class LabelResource
extends ApplicationResource {
    private NiFiServiceFacade serviceFacade;
    private Authorizer authorizer;

    public Set<LabelEntity> populateRemainingLabelEntitiesContent(Set<LabelEntity> labelEntities) {
        for (LabelEntity labelEntity : labelEntities) {
            this.populateRemainingLabelEntityContent(labelEntity);
        }
        return labelEntities;
    }

    public LabelEntity populateRemainingLabelEntityContent(LabelEntity labelEntity) {
        labelEntity.setUri(this.generateResourceUri(new String[]{"labels", labelEntity.getId()}));
        return labelEntity;
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}")
    @Operation(summary="Gets a label", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=LabelEntity.class))})}, security={@SecurityRequirement(name="Read - /labels/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getLabel(@Parameter(description="The label id.", required=true) @PathParam(value="id") String id) {
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable label = lookup.getLabel(id);
            label.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        });
        LabelEntity entity = this.serviceFacade.getLabel(id);
        this.populateRemainingLabelEntityContent(entity);
        return this.generateOkResponse((Object)entity).build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{id}")
    @Operation(summary="Updates a label", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=LabelEntity.class))})}, security={@SecurityRequirement(name="Write - /labels/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response updateLabel(@Parameter(description="The label id.", required=true) @PathParam(value="id") String id, @Parameter(description="The label configuration details.", required=true) LabelEntity requestLabelEntity) {
        if (requestLabelEntity == null || requestLabelEntity.getComponent() == null) {
            throw new IllegalArgumentException("Label details must be specified.");
        }
        if (requestLabelEntity.getRevision() == null) {
            throw new IllegalArgumentException("Revision must be specified.");
        }
        LabelDTO requestLabelDTO = requestLabelEntity.getComponent();
        if (!id.equals(requestLabelDTO.getId())) {
            throw new IllegalArgumentException(String.format("The label id (%s) in the request body does not equal the label id of the requested resource (%s).", requestLabelDTO.getId(), id));
        }
        PositionDTO proposedPosition = requestLabelDTO.getPosition();
        if (proposedPosition != null && (proposedPosition.getX() == null || proposedPosition.getY() == null)) {
            throw new IllegalArgumentException("The x and y coordinate of the proposed position must be specified.");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("PUT", (Object)requestLabelEntity);
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestLabelEntity.isDisconnectedNodeAcknowledged());
        }
        Revision requestRevision = this.getRevision((ComponentEntity)requestLabelEntity, id);
        return this.withWriteLock(this.serviceFacade, (Entity)requestLabelEntity, requestRevision, lookup -> {
            Authorizable authorizable = lookup.getLabel(id);
            authorizable.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        }, null, (revision, labelEntity) -> {
            LabelDTO labelDTO = labelEntity.getComponent();
            LabelEntity entity = this.serviceFacade.updateLabel(revision, labelDTO);
            this.populateRemainingLabelEntityContent(entity);
            return this.generateOkResponse((Object)entity).build();
        });
    }

    @DELETE
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}")
    @Operation(summary="Deletes a label", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=LabelEntity.class))})}, security={@SecurityRequirement(name="Write - /labels/{uuid}"), @SecurityRequirement(name="Write - Parent Process Group - /process-groups/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response removeLabel(@Parameter(description="The revision is used to verify the client is working with the latest version of the flow.") @QueryParam(value="version") LongParameter version, @Parameter(description="If the client id is not specified, new one will be generated. This value (whether specified or generated) is included in the response.") @QueryParam(value="clientId") @DefaultValue(value="") ClientIdParameter clientId, @Parameter(description="Acknowledges that this node is disconnected to allow for mutable requests to proceed.") @QueryParam(value="disconnectedNodeAcknowledged") @DefaultValue(value="false") Boolean disconnectedNodeAcknowledged, @Parameter(description="The label id.", required=true) @PathParam(value="id") String id) {
        if (this.isReplicateRequest()) {
            return this.replicate("DELETE");
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(disconnectedNodeAcknowledged);
        }
        LabelEntity requestLabelEntity = new LabelEntity();
        requestLabelEntity.setId(id);
        Revision requestRevision = new Revision(version == null ? null : version.getLong(), clientId.getClientId(), id);
        return this.withWriteLock(this.serviceFacade, (Entity)requestLabelEntity, requestRevision, lookup -> {
            Authorizable label = lookup.getLabel(id);
            label.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
            label.getParentAuthorizable().authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        }, null, (revision, labelEntity) -> {
            LabelEntity entity = this.serviceFacade.deleteLabel(revision, labelEntity.getId());
            return this.generateOkResponse((Object)entity).build();
        });
    }

    public void setServiceFacade(NiFiServiceFacade serviceFacade) {
        this.serviceFacade = serviceFacade;
    }

    public void setAuthorizer(Authorizer authorizer) {
        this.authorizer = authorizer;
    }
}

