/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.AuthorizerCapabilityDetection;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.cluster.coordination.ClusterCoordinator;
import org.apache.nifi.cluster.coordination.http.replication.RequestReplicator;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.NiFiServiceFacade;
import org.apache.nifi.web.Revision;
import org.apache.nifi.web.api.ApplicationResource;
import org.apache.nifi.web.api.dto.AccessPolicyDTO;
import org.apache.nifi.web.api.dto.RevisionDTO;
import org.apache.nifi.web.api.entity.AccessPolicyEntity;
import org.apache.nifi.web.api.entity.ComponentEntity;
import org.apache.nifi.web.api.entity.Entity;
import org.apache.nifi.web.api.request.ClientIdParameter;
import org.apache.nifi.web.api.request.LongParameter;

@Path(value="/policies")
@Tag(name="Policies")
public class AccessPolicyResource
extends ApplicationResource {
    private final NiFiServiceFacade serviceFacade;
    private final Authorizer authorizer;

    public AccessPolicyResource(NiFiServiceFacade serviceFacade, Authorizer authorizer, NiFiProperties properties, RequestReplicator requestReplicator, ClusterCoordinator clusterCoordinator, FlowController flowController) {
        this.serviceFacade = serviceFacade;
        this.authorizer = authorizer;
        this.setProperties(properties);
        this.setRequestReplicator(requestReplicator);
        this.setClusterCoordinator(clusterCoordinator);
        this.setFlowController(flowController);
    }

    public AccessPolicyEntity populateRemainingAccessPolicyEntityContent(AccessPolicyEntity accessPolicyEntity) {
        accessPolicyEntity.setUri(this.generateResourceUri(new String[]{"policies", accessPolicyEntity.getId()}));
        return accessPolicyEntity;
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{action}/{resource: .+}")
    @Operation(summary="Gets an access policy for the specified action and resource", description="Will return the effective policy if no component specific policy exists for the specified action and resource. Must have Read permissions to the policy with the desired action and resource. Permissions for the policy that is returned will be indicated in the response. This means the client could be authorized to get the policy for a given component but the effective policy may be inherited from an ancestor Process Group. If the client does not have permissions to that policy, the response will not include the policy and the permissions in the response will be marked accordingly. If the client does not have permissions to the policy of the desired action and resource a 403 response will be returned.", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=AccessPolicyEntity.class))})}, security={@SecurityRequirement(name="Read - /policies/{resource}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getAccessPolicyForResource(@Parameter(description="The request action.", required=true) @PathParam(value="action") String action, @Parameter(description="The resource of the policy.", required=true) @PathParam(value="resource") String rawResource) {
        if (!AuthorizerCapabilityDetection.isManagedAuthorizer((Authorizer)this.authorizer)) {
            throw new IllegalStateException("This NiFi is not configured to internally manage users, groups, or policies.  Please contact your system administrator.");
        }
        RequestAction requestAction = RequestAction.valueOfValue((String)action);
        String resource = "/" + rawResource;
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable accessPolicy = lookup.getAccessPolicyByResource(resource);
            accessPolicy.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        });
        AccessPolicyEntity entity = this.serviceFacade.getAccessPolicy(requestAction, resource);
        this.populateRemainingAccessPolicyEntityContent(entity);
        return this.generateOkResponse((Object)entity).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Creates an access policy", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=AccessPolicyEntity.class))})}, security={@SecurityRequirement(name="Write - /policies/{resource}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response createAccessPolicy(@Parameter(description="The access policy configuration details.", required=true) AccessPolicyEntity requestAccessPolicyEntity) {
        if (!AuthorizerCapabilityDetection.isConfigurableAccessPolicyProvider((Authorizer)this.authorizer)) {
            throw new IllegalStateException("This NiFi is not configured to allow configurable policies. Please contact your system administrator.");
        }
        if (requestAccessPolicyEntity == null || requestAccessPolicyEntity.getComponent() == null) {
            throw new IllegalArgumentException("Access policy details must be specified.");
        }
        if (requestAccessPolicyEntity.getRevision() == null || requestAccessPolicyEntity.getRevision().getVersion() == null || requestAccessPolicyEntity.getRevision().getVersion() != 0L) {
            throw new IllegalArgumentException("A revision of 0 must be specified when creating a new Policy.");
        }
        AccessPolicyDTO requestAccessPolicy = requestAccessPolicyEntity.getComponent();
        if (requestAccessPolicy.getId() != null) {
            throw new IllegalArgumentException("Access policy ID cannot be specified.");
        }
        if (requestAccessPolicy.getResource() == null) {
            throw new IllegalArgumentException("Access policy resource must be specified.");
        }
        RequestAction.valueOfValue((String)requestAccessPolicy.getAction());
        if (this.isReplicateRequest()) {
            return this.replicate("POST", (Object)requestAccessPolicyEntity);
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestAccessPolicyEntity.isDisconnectedNodeAcknowledged());
        }
        return this.withWriteLock(this.serviceFacade, (Entity)requestAccessPolicyEntity, lookup -> {
            Authorizable accessPolicies = lookup.getAccessPolicyByResource(requestAccessPolicy.getResource());
            accessPolicies.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        }, null, accessPolicyEntity -> {
            AccessPolicyDTO accessPolicy = accessPolicyEntity.getComponent();
            accessPolicy.setId(this.generateUuid());
            RevisionDTO revisionDTO = accessPolicyEntity.getRevision();
            Revision revision = new Revision(revisionDTO.getVersion(), revisionDTO.getClientId(), accessPolicyEntity.getComponent().getId());
            AccessPolicyEntity entity = this.serviceFacade.createAccessPolicy(revision, accessPolicyEntity.getComponent());
            this.populateRemainingAccessPolicyEntityContent(entity);
            return this.generateCreatedResponse(URI.create(entity.getUri()), (Object)entity).build();
        });
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}")
    @Operation(summary="Gets an access policy", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=AccessPolicyEntity.class))})}, security={@SecurityRequirement(name="Read - /policies/{resource}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getAccessPolicy(@Parameter(description="The access policy id.", required=true) @PathParam(value="id") String id) {
        if (!AuthorizerCapabilityDetection.isManagedAuthorizer((Authorizer)this.authorizer)) {
            throw new IllegalStateException("This NiFi is not configured to internally manage users, groups, or policies.  Please contact your system administrator.");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable authorizable = lookup.getAccessPolicyById(id);
            authorizable.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        });
        AccessPolicyEntity entity = this.serviceFacade.getAccessPolicy(id);
        this.populateRemainingAccessPolicyEntityContent(entity);
        return this.generateOkResponse((Object)entity).build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{id}")
    @Operation(summary="Updates a access policy", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=AccessPolicyEntity.class))})}, security={@SecurityRequirement(name="Write - /policies/{resource}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response updateAccessPolicy(@Parameter(description="The access policy id.", required=true) @PathParam(value="id") String id, @Parameter(description="The access policy configuration details.", required=true) AccessPolicyEntity requestAccessPolicyEntity) {
        if (!AuthorizerCapabilityDetection.isConfigurableAccessPolicyProvider((Authorizer)this.authorizer)) {
            throw new IllegalStateException("This NiFi is not configured to allow configurable policies. Please contact your system administrator.");
        }
        if (requestAccessPolicyEntity == null || requestAccessPolicyEntity.getComponent() == null) {
            throw new IllegalArgumentException("Access policy details must be specified.");
        }
        if (requestAccessPolicyEntity.getRevision() == null) {
            throw new IllegalArgumentException("Revision must be specified.");
        }
        AccessPolicyDTO requestAccessPolicyDTO = requestAccessPolicyEntity.getComponent();
        if (!id.equals(requestAccessPolicyDTO.getId())) {
            throw new IllegalArgumentException(String.format("The access policy id (%s) in the request body does not equal the access policy id of the requested resource (%s).", requestAccessPolicyDTO.getId(), id));
        }
        if (this.isReplicateRequest()) {
            return this.replicate("PUT", (Object)requestAccessPolicyEntity);
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestAccessPolicyEntity.isDisconnectedNodeAcknowledged());
        }
        Revision requestRevision = this.getRevision((ComponentEntity)requestAccessPolicyEntity, id);
        return this.withWriteLock(this.serviceFacade, (Entity)requestAccessPolicyEntity, requestRevision, lookup -> {
            Authorizable authorizable = lookup.getAccessPolicyById(id);
            authorizable.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        }, null, (revision, accessPolicyEntity) -> {
            AccessPolicyDTO accessPolicyDTO = accessPolicyEntity.getComponent();
            AccessPolicyEntity entity = this.serviceFacade.updateAccessPolicy(revision, accessPolicyDTO);
            this.populateRemainingAccessPolicyEntityContent(entity);
            return this.generateOkResponse((Object)entity).build();
        });
    }

    @DELETE
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}")
    @Operation(summary="Deletes an access policy", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=AccessPolicyEntity.class))})}, security={@SecurityRequirement(name="Write - /policies/{resource}"), @SecurityRequirement(name="Write - Policy of the parent resource - /policies/{resource}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response removeAccessPolicy(@Parameter(description="The revision is used to verify the client is working with the latest version of the flow.") @QueryParam(value="version") LongParameter version, @Parameter(description="If the client id is not specified, new one will be generated. This value (whether specified or generated) is included in the response.") @QueryParam(value="clientId") @DefaultValue(value="") ClientIdParameter clientId, @Parameter(description="Acknowledges that this node is disconnected to allow for mutable requests to proceed.") @QueryParam(value="disconnectedNodeAcknowledged") @DefaultValue(value="false") Boolean disconnectedNodeAcknowledged, @Parameter(description="The access policy id.", required=true) @PathParam(value="id") String id) {
        if (!AuthorizerCapabilityDetection.isConfigurableAccessPolicyProvider((Authorizer)this.authorizer)) {
            throw new IllegalStateException("This NiFi is not configured to allow configurable policies. Please contact your system administrator.");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("DELETE");
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(disconnectedNodeAcknowledged);
        }
        AccessPolicyEntity requestAccessPolicyEntity = new AccessPolicyEntity();
        requestAccessPolicyEntity.setId(id);
        Revision requestRevision = new Revision(version == null ? null : version.getLong(), clientId.getClientId(), id);
        return this.withWriteLock(this.serviceFacade, (Entity)requestAccessPolicyEntity, requestRevision, lookup -> {
            Authorizable accessPolicy = lookup.getAccessPolicyById(id);
            accessPolicy.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
            accessPolicy.getParentAuthorizable().authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        }, null, (revision, accessPolicyEntity) -> {
            AccessPolicyEntity entity = this.serviceFacade.deleteAccessPolicy(revision, accessPolicyEntity.getId());
            return this.generateOkResponse((Object)entity).build();
        });
    }
}

