/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web;

import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class NiFiServiceFacadeLock {
    private static final Logger logger = LoggerFactory.getLogger(NiFiServiceFacadeLock.class);
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();

    @Around(value="within(org.apache.nifi.web.NiFiServiceFacade+) && execution(* create*(..))")
    public Object createLock(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        return this.proceedWithWriteLock(proceedingJoinPoint);
    }

    @Around(value="within(org.apache.nifi.web.NiFiServiceFacade+) && execution(* clear*(..))")
    public Object clearLock(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        return this.proceedWithWriteLock(proceedingJoinPoint);
    }

    @Around(value="within(org.apache.nifi.web.NiFiServiceFacade+) && execution(* delete*(..))")
    public Object deleteLock(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        return this.proceedWithWriteLock(proceedingJoinPoint);
    }

    @Around(value="within(org.apache.nifi.web.NiFiServiceFacade+) && execution(* remove*(..))")
    public Object removeLock(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        return this.proceedWithWriteLock(proceedingJoinPoint);
    }

    @Around(value="within(org.apache.nifi.web.NiFiServiceFacade+) && execution(* update*(..))")
    public Object updateLock(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        return this.proceedWithWriteLock(proceedingJoinPoint);
    }

    @Around(value="within(org.apache.nifi.web.NiFiServiceFacade+) && execution(* set*(..))")
    public Object setLock(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        return this.proceedWithWriteLock(proceedingJoinPoint);
    }

    @Around(value="within(org.apache.nifi.web.NiFiServiceFacade+) && execution(* copy*(..))")
    public Object copyLock(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        return this.proceedWithWriteLock(proceedingJoinPoint);
    }

    @Around(value="within(org.apache.nifi.web.NiFiServiceFacade+) && execution(* import*(..))")
    public Object importLock(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        return this.proceedWithWriteLock(proceedingJoinPoint);
    }

    @Around(value="within(org.apache.nifi.web.NiFiServiceFacade+) && execution(* export*(..))")
    public Object exportLock(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        return this.proceedWithWriteLock(proceedingJoinPoint);
    }

    @Around(value="within(org.apache.nifi.web.NiFiServiceFacade+) && execution(* submit*(..))")
    public Object submitLock(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        return this.proceedWithWriteLock(proceedingJoinPoint);
    }

    @Around(value="within(org.apache.nifi.web.NiFiServiceFacade+) && execution(* schedule*(..))")
    public Object scheduleLock(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        return this.proceedWithWriteLock(proceedingJoinPoint);
    }

    @Around(value="within(org.apache.nifi.web.NiFiServiceFacade+) && execution(* activate*(..))")
    public Object activateLock(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        return this.proceedWithWriteLock(proceedingJoinPoint);
    }

    @Around(value="within(org.apache.nifi.web.NiFiServiceFacade+) && execution(* populate*(..))")
    public Object populateLock(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        return this.proceedWithWriteLock(proceedingJoinPoint);
    }

    @Around(value="within(org.apache.nifi.web.NiFiServiceFacade+) && execution(* get*(..))")
    public Object getLock(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        return this.proceedWithReadLock(proceedingJoinPoint);
    }

    @Around(value="within(org.apache.nifi.web.NiFiServiceFacade+) && execution(* is*(..))")
    public Object isLock(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        return this.proceedWithReadLock(proceedingJoinPoint);
    }

    @Around(value="within(org.apache.nifi.web.NiFiServiceFacade+) && execution(* search*(..))")
    public Object searchLock(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        return this.proceedWithReadLock(proceedingJoinPoint);
    }

    @Around(value="within(org.apache.nifi.web.NiFiServiceFacade+) && execution(* verify*(..))")
    public Object verifyLock(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        return this.proceedWithReadLock(proceedingJoinPoint);
    }

    @Around(value="within(org.apache.nifi.web.NiFiServiceFacade+) && execution(* register*(..))")
    public Object registerLock(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        return this.proceedWithReadLock(proceedingJoinPoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object proceedWithReadLock(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        Object object;
        long beforeLock = System.nanoTime();
        long afterLock = 0L;
        this.readLock.lock();
        try {
            afterLock = System.nanoTime();
            object = proceedingJoinPoint.proceed();
            this.readLock.unlock();
        }
        catch (Throwable throwable) {
            this.readLock.unlock();
            long afterProcedure = System.nanoTime();
            String procedure = proceedingJoinPoint.getSignature().toLongString();
            logger.debug("In order to perform procedure {}, it took {} nanos to obtain the Read Lock {} and {} nanos to invoke the method", new Object[]{procedure, afterLock - beforeLock, this.readLock, afterProcedure - afterLock});
            throw throwable;
        }
        long afterProcedure = System.nanoTime();
        String procedure = proceedingJoinPoint.getSignature().toLongString();
        logger.debug("In order to perform procedure {}, it took {} nanos to obtain the Read Lock {} and {} nanos to invoke the method", new Object[]{procedure, afterLock - beforeLock, this.readLock, afterProcedure - afterLock});
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object proceedWithWriteLock(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        Object object;
        long beforeLock = System.nanoTime();
        long afterLock = 0L;
        this.writeLock.lock();
        try {
            afterLock = System.nanoTime();
            object = proceedingJoinPoint.proceed();
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            this.writeLock.unlock();
            long afterProcedure = System.nanoTime();
            String procedure = proceedingJoinPoint.getSignature().toLongString();
            logger.debug("In order to perform procedure {}, it took {} nanos to obtain the Write Lock {} and {} nanos to invoke the method", new Object[]{procedure, afterLock - beforeLock, this.writeLock, afterProcedure - afterLock});
            throw throwable;
        }
        long afterProcedure = System.nanoTime();
        String procedure = proceedingJoinPoint.getSignature().toLongString();
        logger.debug("In order to perform procedure {}, it took {} nanos to obtain the Write Lock {} and {} nanos to invoke the method", new Object[]{procedure, afterLock - beforeLock, this.writeLock, afterProcedure - afterLock});
        return object;
    }
}

