/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api.dto;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.ws.rs.WebApplicationException;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.action.Action;
import org.apache.nifi.action.component.details.ComponentDetails;
import org.apache.nifi.action.component.details.ExtensionDetails;
import org.apache.nifi.action.component.details.FlowChangeExtensionDetails;
import org.apache.nifi.action.component.details.FlowChangeRemoteProcessGroupDetails;
import org.apache.nifi.action.component.details.RemoteProcessGroupDetails;
import org.apache.nifi.action.details.ActionDetails;
import org.apache.nifi.action.details.ConfigureDetails;
import org.apache.nifi.action.details.ConnectDetails;
import org.apache.nifi.action.details.FlowChangeConfigureDetails;
import org.apache.nifi.action.details.FlowChangeConnectDetails;
import org.apache.nifi.action.details.FlowChangeMoveDetails;
import org.apache.nifi.action.details.FlowChangePurgeDetails;
import org.apache.nifi.action.details.MoveDetails;
import org.apache.nifi.action.details.PurgeDetails;
import org.apache.nifi.annotation.behavior.Restricted;
import org.apache.nifi.annotation.behavior.Stateful;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.DeprecationNotice;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.authorization.AccessPolicy;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.AuthorizerCapabilityDetection;
import org.apache.nifi.authorization.Group;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.Resource;
import org.apache.nifi.authorization.User;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.resource.ComponentAuthorizable;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.bundle.Bundle;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.bundle.BundleDetails;
import org.apache.nifi.cluster.coordination.heartbeat.NodeHeartbeat;
import org.apache.nifi.cluster.coordination.node.NodeConnectionStatus;
import org.apache.nifi.cluster.event.NodeEvent;
import org.apache.nifi.cluster.manager.StatusMerger;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.state.Scope;
import org.apache.nifi.components.state.StateMap;
import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.connectable.ConnectableType;
import org.apache.nifi.connectable.Connection;
import org.apache.nifi.connectable.Funnel;
import org.apache.nifi.connectable.Port;
import org.apache.nifi.connectable.Position;
import org.apache.nifi.controller.ConfiguredComponent;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.Counter;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.ReportingTaskNode;
import org.apache.nifi.controller.Snippet;
import org.apache.nifi.controller.Template;
import org.apache.nifi.controller.label.Label;
import org.apache.nifi.controller.queue.DropFlowFileState;
import org.apache.nifi.controller.queue.DropFlowFileStatus;
import org.apache.nifi.controller.queue.FlowFileSummary;
import org.apache.nifi.controller.queue.ListFlowFileState;
import org.apache.nifi.controller.queue.ListFlowFileStatus;
import org.apache.nifi.controller.queue.QueueSize;
import org.apache.nifi.controller.repository.FlowFileRecord;
import org.apache.nifi.controller.repository.claim.ContentClaim;
import org.apache.nifi.controller.repository.claim.ResourceClaim;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.controller.state.SortedStateUtils;
import org.apache.nifi.controller.status.ConnectionStatus;
import org.apache.nifi.controller.status.PortStatus;
import org.apache.nifi.controller.status.ProcessGroupStatus;
import org.apache.nifi.controller.status.ProcessorStatus;
import org.apache.nifi.controller.status.RemoteProcessGroupStatus;
import org.apache.nifi.diagnostics.GarbageCollection;
import org.apache.nifi.diagnostics.StorageUsage;
import org.apache.nifi.diagnostics.SystemDiagnostics;
import org.apache.nifi.flowfile.FlowFilePrioritizer;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.groups.ProcessGroupCounts;
import org.apache.nifi.groups.RemoteProcessGroup;
import org.apache.nifi.history.History;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.nar.NarClassLoaders;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.provenance.lineage.ComputeLineageResult;
import org.apache.nifi.provenance.lineage.ComputeLineageSubmission;
import org.apache.nifi.provenance.lineage.LineageEdge;
import org.apache.nifi.provenance.lineage.LineageNode;
import org.apache.nifi.provenance.lineage.ProvenanceEventLineageNode;
import org.apache.nifi.registry.ComponentVariableRegistry;
import org.apache.nifi.registry.VariableDescriptor;
import org.apache.nifi.registry.variable.VariableRegistryUpdateRequest;
import org.apache.nifi.registry.variable.VariableRegistryUpdateStep;
import org.apache.nifi.remote.RemoteGroupPort;
import org.apache.nifi.remote.RootGroupPort;
import org.apache.nifi.reporting.Bulletin;
import org.apache.nifi.reporting.BulletinRepository;
import org.apache.nifi.reporting.ReportingTask;
import org.apache.nifi.scheduling.SchedulingStrategy;
import org.apache.nifi.util.FormatUtils;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.FlowModification;
import org.apache.nifi.web.Revision;
import org.apache.nifi.web.api.dto.AccessPolicyDTO;
import org.apache.nifi.web.api.dto.AccessPolicySummaryDTO;
import org.apache.nifi.web.api.dto.AffectedComponentDTO;
import org.apache.nifi.web.api.dto.AllowableValueDTO;
import org.apache.nifi.web.api.dto.BatchSettingsDTO;
import org.apache.nifi.web.api.dto.BulletinBoardDTO;
import org.apache.nifi.web.api.dto.BulletinDTO;
import org.apache.nifi.web.api.dto.BundleDTO;
import org.apache.nifi.web.api.dto.ComponentReferenceDTO;
import org.apache.nifi.web.api.dto.ComponentStateDTO;
import org.apache.nifi.web.api.dto.ConnectableDTO;
import org.apache.nifi.web.api.dto.ConnectionDTO;
import org.apache.nifi.web.api.dto.ControllerConfigurationDTO;
import org.apache.nifi.web.api.dto.ControllerServiceApiDTO;
import org.apache.nifi.web.api.dto.ControllerServiceDTO;
import org.apache.nifi.web.api.dto.ControllerServiceReferencingComponentDTO;
import org.apache.nifi.web.api.dto.CounterDTO;
import org.apache.nifi.web.api.dto.CountersSnapshotDTO;
import org.apache.nifi.web.api.dto.DocumentedTypeDTO;
import org.apache.nifi.web.api.dto.DropRequestDTO;
import org.apache.nifi.web.api.dto.DtoFactory;
import org.apache.nifi.web.api.dto.EntityFactory;
import org.apache.nifi.web.api.dto.FlowConfigurationDTO;
import org.apache.nifi.web.api.dto.FlowFileDTO;
import org.apache.nifi.web.api.dto.FlowFileSummaryDTO;
import org.apache.nifi.web.api.dto.FlowSnippetDTO;
import org.apache.nifi.web.api.dto.FunnelDTO;
import org.apache.nifi.web.api.dto.LabelDTO;
import org.apache.nifi.web.api.dto.ListingRequestDTO;
import org.apache.nifi.web.api.dto.NodeDTO;
import org.apache.nifi.web.api.dto.NodeEventDTO;
import org.apache.nifi.web.api.dto.PermissionsDTO;
import org.apache.nifi.web.api.dto.PortDTO;
import org.apache.nifi.web.api.dto.PositionDTO;
import org.apache.nifi.web.api.dto.ProcessGroupDTO;
import org.apache.nifi.web.api.dto.ProcessorConfigDTO;
import org.apache.nifi.web.api.dto.ProcessorDTO;
import org.apache.nifi.web.api.dto.PropertyDescriptorDTO;
import org.apache.nifi.web.api.dto.QueueSizeDTO;
import org.apache.nifi.web.api.dto.RelationshipDTO;
import org.apache.nifi.web.api.dto.RemoteProcessGroupContentsDTO;
import org.apache.nifi.web.api.dto.RemoteProcessGroupDTO;
import org.apache.nifi.web.api.dto.RemoteProcessGroupPortDTO;
import org.apache.nifi.web.api.dto.ReportingTaskDTO;
import org.apache.nifi.web.api.dto.ResourceDTO;
import org.apache.nifi.web.api.dto.RevisionDTO;
import org.apache.nifi.web.api.dto.SnippetDTO;
import org.apache.nifi.web.api.dto.StateEntryDTO;
import org.apache.nifi.web.api.dto.StateMapDTO;
import org.apache.nifi.web.api.dto.SystemDiagnosticsDTO;
import org.apache.nifi.web.api.dto.SystemDiagnosticsSnapshotDTO;
import org.apache.nifi.web.api.dto.TemplateDTO;
import org.apache.nifi.web.api.dto.TenantDTO;
import org.apache.nifi.web.api.dto.UserDTO;
import org.apache.nifi.web.api.dto.UserGroupDTO;
import org.apache.nifi.web.api.dto.VariableDTO;
import org.apache.nifi.web.api.dto.VariableRegistryDTO;
import org.apache.nifi.web.api.dto.VariableRegistryUpdateRequestDTO;
import org.apache.nifi.web.api.dto.VariableRegistryUpdateStepDTO;
import org.apache.nifi.web.api.dto.action.ActionDTO;
import org.apache.nifi.web.api.dto.action.HistoryDTO;
import org.apache.nifi.web.api.dto.action.component.details.ComponentDetailsDTO;
import org.apache.nifi.web.api.dto.action.component.details.ExtensionDetailsDTO;
import org.apache.nifi.web.api.dto.action.component.details.RemoteProcessGroupDetailsDTO;
import org.apache.nifi.web.api.dto.action.details.ActionDetailsDTO;
import org.apache.nifi.web.api.dto.action.details.ConfigureDetailsDTO;
import org.apache.nifi.web.api.dto.action.details.ConnectDetailsDTO;
import org.apache.nifi.web.api.dto.action.details.MoveDetailsDTO;
import org.apache.nifi.web.api.dto.action.details.PurgeDetailsDTO;
import org.apache.nifi.web.api.dto.flow.FlowBreadcrumbDTO;
import org.apache.nifi.web.api.dto.flow.FlowDTO;
import org.apache.nifi.web.api.dto.flow.ProcessGroupFlowDTO;
import org.apache.nifi.web.api.dto.provenance.lineage.LineageDTO;
import org.apache.nifi.web.api.dto.provenance.lineage.LineageRequestDTO;
import org.apache.nifi.web.api.dto.provenance.lineage.LineageResultsDTO;
import org.apache.nifi.web.api.dto.provenance.lineage.ProvenanceLinkDTO;
import org.apache.nifi.web.api.dto.provenance.lineage.ProvenanceNodeDTO;
import org.apache.nifi.web.api.dto.status.ConnectionStatusDTO;
import org.apache.nifi.web.api.dto.status.ConnectionStatusSnapshotDTO;
import org.apache.nifi.web.api.dto.status.PortStatusDTO;
import org.apache.nifi.web.api.dto.status.PortStatusSnapshotDTO;
import org.apache.nifi.web.api.dto.status.ProcessGroupStatusDTO;
import org.apache.nifi.web.api.dto.status.ProcessGroupStatusSnapshotDTO;
import org.apache.nifi.web.api.dto.status.ProcessorStatusDTO;
import org.apache.nifi.web.api.dto.status.ProcessorStatusSnapshotDTO;
import org.apache.nifi.web.api.dto.status.RemoteProcessGroupStatusDTO;
import org.apache.nifi.web.api.dto.status.RemoteProcessGroupStatusSnapshotDTO;
import org.apache.nifi.web.api.entity.AccessPolicySummaryEntity;
import org.apache.nifi.web.api.entity.AffectedComponentEntity;
import org.apache.nifi.web.api.entity.AllowableValueEntity;
import org.apache.nifi.web.api.entity.BulletinEntity;
import org.apache.nifi.web.api.entity.ComponentReferenceEntity;
import org.apache.nifi.web.api.entity.ConnectionStatusSnapshotEntity;
import org.apache.nifi.web.api.entity.FlowBreadcrumbEntity;
import org.apache.nifi.web.api.entity.PortStatusSnapshotEntity;
import org.apache.nifi.web.api.entity.ProcessGroupStatusSnapshotEntity;
import org.apache.nifi.web.api.entity.ProcessorStatusSnapshotEntity;
import org.apache.nifi.web.api.entity.RemoteProcessGroupStatusSnapshotEntity;
import org.apache.nifi.web.api.entity.TenantEntity;
import org.apache.nifi.web.api.entity.VariableEntity;
import org.apache.nifi.web.controller.ControllerFacade;
import org.apache.nifi.web.revision.RevisionManager;

public final class DtoFactory {
    private static final Comparator<Class> CLASS_NAME_COMPARATOR = new /* Unavailable Anonymous Inner Class!! */;
    public static final String SENSITIVE_VALUE_MASK = "********";
    private BulletinRepository bulletinRepository;
    private ControllerServiceProvider controllerServiceProvider;
    private EntityFactory entityFactory;
    private Authorizer authorizer;
    private NiFiProperties properties;

    public ControllerConfigurationDTO createControllerConfigurationDto(ControllerFacade controllerFacade) {
        ControllerConfigurationDTO dto = new ControllerConfigurationDTO();
        dto.setMaxTimerDrivenThreadCount(Integer.valueOf(controllerFacade.getMaxTimerDrivenThreadCount()));
        dto.setMaxEventDrivenThreadCount(Integer.valueOf(controllerFacade.getMaxEventDrivenThreadCount()));
        return dto;
    }

    public FlowConfigurationDTO createFlowConfigurationDto(String autoRefreshInterval) {
        FlowConfigurationDTO dto = new FlowConfigurationDTO();
        long refreshInterval = FormatUtils.getTimeDuration((String)autoRefreshInterval, (TimeUnit)TimeUnit.SECONDS);
        dto.setAutoRefreshIntervalSeconds(Long.valueOf(refreshInterval));
        dto.setSupportsManagedAuthorizer(Boolean.valueOf(AuthorizerCapabilityDetection.isManagedAuthorizer((Authorizer)this.authorizer)));
        dto.setSupportsConfigurableUsersAndGroups(Boolean.valueOf(AuthorizerCapabilityDetection.isConfigurableUserGroupProvider((Authorizer)this.authorizer)));
        dto.setSupportsConfigurableAuthorizer(Boolean.valueOf(AuthorizerCapabilityDetection.isConfigurableAccessPolicyProvider((Authorizer)this.authorizer)));
        Date now = new Date();
        dto.setTimeOffset(Integer.valueOf(TimeZone.getDefault().getOffset(now.getTime())));
        dto.setCurrentTime(now);
        return dto;
    }

    public ActionDTO createActionDto(Action action) {
        ActionDTO actionDto = new ActionDTO();
        actionDto.setId(action.getId());
        actionDto.setSourceId(action.getSourceId());
        actionDto.setSourceName(action.getSourceName());
        actionDto.setSourceType(action.getSourceType().name());
        actionDto.setTimestamp(action.getTimestamp());
        actionDto.setUserIdentity(action.getUserIdentity());
        actionDto.setOperation(action.getOperation().name());
        actionDto.setActionDetails(this.createActionDetailsDto(action.getActionDetails()));
        actionDto.setComponentDetails(this.createComponentDetailsDto(action.getComponentDetails()));
        return actionDto;
    }

    private ActionDetailsDTO createActionDetailsDto(ActionDetails actionDetails) {
        if (actionDetails == null) {
            return null;
        }
        if (actionDetails instanceof FlowChangeConfigureDetails) {
            ConfigureDetailsDTO configureDetails = new ConfigureDetailsDTO();
            configureDetails.setName(((ConfigureDetails)actionDetails).getName());
            configureDetails.setPreviousValue(((ConfigureDetails)actionDetails).getPreviousValue());
            configureDetails.setValue(((ConfigureDetails)actionDetails).getValue());
            return configureDetails;
        }
        if (actionDetails instanceof FlowChangeConnectDetails) {
            ConnectDetailsDTO connectDetails = new ConnectDetailsDTO();
            connectDetails.setSourceId(((ConnectDetails)actionDetails).getSourceId());
            connectDetails.setSourceName(((ConnectDetails)actionDetails).getSourceName());
            connectDetails.setSourceType(((ConnectDetails)actionDetails).getSourceType().toString());
            connectDetails.setRelationship(((ConnectDetails)actionDetails).getRelationship());
            connectDetails.setDestinationId(((ConnectDetails)actionDetails).getDestinationId());
            connectDetails.setDestinationName(((ConnectDetails)actionDetails).getDestinationName());
            connectDetails.setDestinationType(((ConnectDetails)actionDetails).getDestinationType().toString());
            return connectDetails;
        }
        if (actionDetails instanceof FlowChangeMoveDetails) {
            MoveDetailsDTO moveDetails = new MoveDetailsDTO();
            moveDetails.setPreviousGroup(((MoveDetails)actionDetails).getPreviousGroup());
            moveDetails.setPreviousGroupId(((MoveDetails)actionDetails).getPreviousGroupId());
            moveDetails.setGroup(((MoveDetails)actionDetails).getGroup());
            moveDetails.setGroupId(((MoveDetails)actionDetails).getGroupId());
            return moveDetails;
        }
        if (actionDetails instanceof FlowChangePurgeDetails) {
            PurgeDetailsDTO purgeDetails = new PurgeDetailsDTO();
            purgeDetails.setEndDate(((PurgeDetails)actionDetails).getEndDate());
            return purgeDetails;
        }
        throw new WebApplicationException((Throwable)new IllegalArgumentException(String.format("Unrecognized type of action details encountered %s during serialization.", actionDetails.toString())));
    }

    private ComponentDetailsDTO createComponentDetailsDto(ComponentDetails componentDetails) {
        if (componentDetails == null) {
            return null;
        }
        if (componentDetails instanceof FlowChangeExtensionDetails) {
            ExtensionDetailsDTO processorDetails = new ExtensionDetailsDTO();
            processorDetails.setType(((ExtensionDetails)componentDetails).getType());
            return processorDetails;
        }
        if (componentDetails instanceof FlowChangeRemoteProcessGroupDetails) {
            RemoteProcessGroupDetailsDTO remoteProcessGroupDetails = new RemoteProcessGroupDetailsDTO();
            remoteProcessGroupDetails.setUri(((RemoteProcessGroupDetails)componentDetails).getUri());
            return remoteProcessGroupDetails;
        }
        throw new WebApplicationException((Throwable)new IllegalArgumentException(String.format("Unrecognized type of component details encountered %s during serialization. ", componentDetails.toString())));
    }

    public HistoryDTO createHistoryDto(History history) {
        HistoryDTO historyDto = new HistoryDTO();
        historyDto.setTotal(history.getTotal());
        historyDto.setLastRefreshed(history.getLastRefreshed());
        return historyDto;
    }

    public ComponentStateDTO createComponentStateDTO(String componentId, Class<?> componentClass, StateMap localState, StateMap clusterState) {
        ComponentStateDTO dto = new ComponentStateDTO();
        dto.setComponentId(componentId);
        dto.setStateDescription(this.getStateDescription(componentClass));
        dto.setLocalState(this.createStateMapDTO(Scope.LOCAL, localState));
        dto.setClusterState(this.createStateMapDTO(Scope.CLUSTER, clusterState));
        return dto;
    }

    private String getStateDescription(Class<?> componentClass) {
        Stateful capabilityDesc = componentClass.getAnnotation(Stateful.class);
        if (capabilityDesc != null) {
            return capabilityDesc.description();
        }
        return null;
    }

    public StateMapDTO createStateMapDTO(Scope scope, StateMap stateMap) {
        if (stateMap == null) {
            return null;
        }
        StateMapDTO dto = new StateMapDTO();
        dto.setScope(scope.toString());
        TreeMap sortedState = new TreeMap(SortedStateUtils.getKeyComparator());
        Map state = stateMap.toMap();
        sortedState.putAll(state);
        int count = 0;
        ArrayList<StateEntryDTO> stateEntries = new ArrayList<StateEntryDTO>();
        Set entrySet = sortedState.entrySet();
        Iterator iter = entrySet.iterator();
        while (iter.hasNext() && count++ < 500) {
            Map.Entry entry = iter.next();
            StateEntryDTO entryDTO = new StateEntryDTO();
            entryDTO.setKey((String)entry.getKey());
            entryDTO.setValue((String)entry.getValue());
            stateEntries.add(entryDTO);
        }
        dto.setTotalEntryCount(state.size());
        dto.setState(stateEntries);
        return dto;
    }

    public CountersSnapshotDTO createCountersDto(Collection<CounterDTO> counterDtos) {
        CountersSnapshotDTO dto = new CountersSnapshotDTO();
        dto.setCounters(counterDtos);
        dto.setGenerated(new Date());
        return dto;
    }

    public CounterDTO createCounterDto(Counter counter) {
        CounterDTO dto = new CounterDTO();
        dto.setId(counter.getIdentifier());
        dto.setContext(counter.getContext());
        dto.setName(counter.getName());
        dto.setValueCount(Long.valueOf(counter.getValue()));
        dto.setValue(FormatUtils.formatCount((long)counter.getValue()));
        return dto;
    }

    public PositionDTO createPositionDto(Position position) {
        return new PositionDTO(Double.valueOf(position.getX()), Double.valueOf(position.getY()));
    }

    private boolean isDropRequestComplete(DropFlowFileState state) {
        return DropFlowFileState.COMPLETE.equals((Object)state) || DropFlowFileState.CANCELED.equals((Object)state) || DropFlowFileState.FAILURE.equals((Object)state);
    }

    public DropRequestDTO createDropRequestDTO(DropFlowFileStatus dropRequest) {
        DropRequestDTO dto = new DropRequestDTO();
        dto.setId(dropRequest.getRequestIdentifier());
        dto.setSubmissionTime(new Date(dropRequest.getRequestSubmissionTime()));
        dto.setLastUpdated(new Date(dropRequest.getLastUpdated()));
        dto.setState(dropRequest.getState().toString());
        dto.setFailureReason(dropRequest.getFailureReason());
        dto.setFinished(Boolean.valueOf(this.isDropRequestComplete(dropRequest.getState())));
        QueueSize dropped = dropRequest.getDroppedSize();
        dto.setDroppedCount(Integer.valueOf(dropped.getObjectCount()));
        dto.setDroppedSize(Long.valueOf(dropped.getByteCount()));
        dto.setDropped(FormatUtils.formatCount((long)dropped.getObjectCount()) + " / " + FormatUtils.formatDataSize((double)dropped.getByteCount()));
        QueueSize current = dropRequest.getCurrentSize();
        dto.setCurrentCount(Integer.valueOf(current.getObjectCount()));
        dto.setCurrentSize(Long.valueOf(current.getByteCount()));
        dto.setCurrent(FormatUtils.formatCount((long)current.getObjectCount()) + " / " + FormatUtils.formatDataSize((double)current.getByteCount()));
        QueueSize original = dropRequest.getOriginalSize();
        dto.setOriginalCount(Integer.valueOf(original.getObjectCount()));
        dto.setOriginalSize(Long.valueOf(original.getByteCount()));
        dto.setOriginal(FormatUtils.formatCount((long)original.getObjectCount()) + " / " + FormatUtils.formatDataSize((double)original.getByteCount()));
        if (this.isDropRequestComplete(dropRequest.getState())) {
            dto.setPercentCompleted(Integer.valueOf(100));
        } else {
            dto.setPercentCompleted(Integer.valueOf(dropped.getObjectCount() * 100 / original.getObjectCount()));
        }
        return dto;
    }

    private boolean isListingRequestComplete(ListFlowFileState state) {
        return ListFlowFileState.COMPLETE.equals((Object)state) || ListFlowFileState.CANCELED.equals((Object)state) || ListFlowFileState.FAILURE.equals((Object)state);
    }

    private QueueSizeDTO createQueueSizeDTO(QueueSize queueSize) {
        QueueSizeDTO dto = new QueueSizeDTO();
        dto.setByteCount(queueSize.getByteCount());
        dto.setObjectCount(queueSize.getObjectCount());
        return dto;
    }

    public ListingRequestDTO createListingRequestDTO(ListFlowFileStatus listingRequest) {
        List flowFileSummaries;
        ListingRequestDTO dto = new ListingRequestDTO();
        dto.setId(listingRequest.getRequestIdentifier());
        dto.setSubmissionTime(new Date(listingRequest.getRequestSubmissionTime()));
        dto.setLastUpdated(new Date(listingRequest.getLastUpdated()));
        dto.setState(listingRequest.getState().toString());
        dto.setFailureReason(listingRequest.getFailureReason());
        dto.setFinished(Boolean.valueOf(this.isListingRequestComplete(listingRequest.getState())));
        dto.setMaxResults(Integer.valueOf(listingRequest.getMaxResults()));
        dto.setPercentCompleted(Integer.valueOf(listingRequest.getCompletionPercentage()));
        dto.setQueueSize(this.createQueueSizeDTO(listingRequest.getQueueSize()));
        if (this.isListingRequestComplete(listingRequest.getState()) && (flowFileSummaries = listingRequest.getFlowFileSummaries()) != null) {
            Date now = new Date();
            ArrayList<FlowFileSummaryDTO> summaryDtos = new ArrayList<FlowFileSummaryDTO>(flowFileSummaries.size());
            for (FlowFileSummary summary : flowFileSummaries) {
                summaryDtos.add(this.createFlowFileSummaryDTO(summary, now));
            }
            dto.setFlowFileSummaries(summaryDtos);
        }
        return dto;
    }

    public FlowFileSummaryDTO createFlowFileSummaryDTO(FlowFileSummary summary, Date now) {
        FlowFileSummaryDTO dto = new FlowFileSummaryDTO();
        dto.setUuid(summary.getUuid());
        dto.setFilename(summary.getFilename());
        dto.setPenalized(Boolean.valueOf(summary.isPenalized()));
        dto.setPosition(Integer.valueOf(summary.getPosition()));
        dto.setSize(Long.valueOf(summary.getSize()));
        long queuedDuration = now.getTime() - summary.getLastQueuedTime();
        dto.setQueuedDuration(Long.valueOf(queuedDuration));
        long age = now.getTime() - summary.getLineageStartDate();
        dto.setLineageDuration(Long.valueOf(age));
        return dto;
    }

    public FlowFileDTO createFlowFileDTO(FlowFileRecord record) {
        Date now = new Date();
        FlowFileDTO dto = new FlowFileDTO();
        dto.setUuid(record.getAttribute(CoreAttributes.UUID.key()));
        dto.setFilename(record.getAttribute(CoreAttributes.FILENAME.key()));
        dto.setPenalized(Boolean.valueOf(record.isPenalized()));
        dto.setSize(Long.valueOf(record.getSize()));
        dto.setAttributes(record.getAttributes());
        long queuedDuration = now.getTime() - record.getLastQueueDate();
        dto.setQueuedDuration(Long.valueOf(queuedDuration));
        long age = now.getTime() - record.getLineageStartDate();
        dto.setLineageDuration(Long.valueOf(age));
        ContentClaim contentClaim = record.getContentClaim();
        if (contentClaim != null) {
            ResourceClaim resourceClaim = contentClaim.getResourceClaim();
            dto.setContentClaimSection(resourceClaim.getSection());
            dto.setContentClaimContainer(resourceClaim.getContainer());
            dto.setContentClaimIdentifier(resourceClaim.getId());
            dto.setContentClaimOffset(Long.valueOf(contentClaim.getOffset() + record.getContentClaimOffset()));
            dto.setContentClaimFileSizeBytes(Long.valueOf(record.getSize()));
            dto.setContentClaimFileSize(FormatUtils.formatDataSize((double)record.getSize()));
        }
        return dto;
    }

    public ConnectionDTO createConnectionDto(Connection connection) {
        if (connection == null) {
            return null;
        }
        ConnectionDTO dto = new ConnectionDTO();
        dto.setId(connection.getIdentifier());
        dto.setParentGroupId(connection.getProcessGroup().getIdentifier());
        ArrayList<PositionDTO> bendPoints = new ArrayList<PositionDTO>();
        for (Position bendPoint : connection.getBendPoints()) {
            bendPoints.add(this.createPositionDto(bendPoint));
        }
        dto.setBends(bendPoints);
        dto.setName(connection.getName());
        dto.setLabelIndex(Integer.valueOf(connection.getLabelIndex()));
        dto.setzIndex(Long.valueOf(connection.getZIndex()));
        dto.setSource(this.createConnectableDto(connection.getSource()));
        dto.setDestination(this.createConnectableDto(connection.getDestination()));
        dto.setBackPressureObjectThreshold(Long.valueOf(connection.getFlowFileQueue().getBackPressureObjectThreshold()));
        dto.setBackPressureDataSizeThreshold(connection.getFlowFileQueue().getBackPressureDataSizeThreshold());
        dto.setFlowFileExpiration(connection.getFlowFileQueue().getFlowFileExpiration());
        dto.setPrioritizers(new ArrayList());
        for (FlowFilePrioritizer comparator : connection.getFlowFileQueue().getPriorities()) {
            dto.getPrioritizers().add(comparator.getClass().getCanonicalName());
        }
        for (Relationship selectedRelationship : connection.getRelationships()) {
            if (Relationship.ANONYMOUS.equals((Object)selectedRelationship)) continue;
            if (dto.getSelectedRelationships() == null) {
                dto.setSelectedRelationships(new TreeSet<Object>(Collator.getInstance(Locale.US)));
            }
            dto.getSelectedRelationships().add(selectedRelationship.getName());
        }
        for (Relationship availableRelationship : connection.getSource().getRelationships()) {
            if (Relationship.ANONYMOUS.equals((Object)availableRelationship)) continue;
            if (dto.getAvailableRelationships() == null) {
                dto.setAvailableRelationships(new TreeSet<Object>(Collator.getInstance(Locale.US)));
            }
            dto.getAvailableRelationships().add(availableRelationship.getName());
        }
        return dto;
    }

    public ConnectableDTO createConnectableDto(Connectable connectable) {
        if (connectable == null) {
            return null;
        }
        boolean isAuthorized = connectable.isAuthorized(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        ConnectableDTO dto = new ConnectableDTO();
        dto.setId(connectable.getIdentifier());
        dto.setName(isAuthorized ? connectable.getName() : connectable.getIdentifier());
        dto.setType(connectable.getConnectableType().name());
        if (connectable instanceof RemoteGroupPort) {
            RemoteGroupPort remoteGroupPort = (RemoteGroupPort)connectable;
            RemoteProcessGroup remoteGroup = remoteGroupPort.getRemoteProcessGroup();
            dto.setGroupId(remoteGroup.getIdentifier());
            dto.setRunning(Boolean.valueOf(remoteGroupPort.isTargetRunning()));
            dto.setTransmitting(Boolean.valueOf(remoteGroupPort.isRunning()));
            dto.setExists(Boolean.valueOf(remoteGroupPort.getTargetExists()));
            if (isAuthorized) {
                dto.setComments(remoteGroup.getComments());
            }
        } else {
            dto.setGroupId(connectable.getProcessGroup().getIdentifier());
            dto.setRunning(Boolean.valueOf(connectable.isRunning()));
            if (isAuthorized) {
                dto.setComments(connectable.getComments());
            }
        }
        return dto;
    }

    public LabelDTO createLabelDto(Label label) {
        if (label == null) {
            return null;
        }
        LabelDTO dto = new LabelDTO();
        dto.setId(label.getIdentifier());
        dto.setPosition(this.createPositionDto(label.getPosition()));
        dto.setStyle(label.getStyle());
        dto.setHeight(Double.valueOf(label.getSize().getHeight()));
        dto.setWidth(Double.valueOf(label.getSize().getWidth()));
        dto.setLabel(label.getValue());
        dto.setParentGroupId(label.getProcessGroup().getIdentifier());
        return dto;
    }

    public UserDTO createUserDto(User user, Set<TenantEntity> groups, Set<AccessPolicySummaryEntity> accessPolicies) {
        if (user == null) {
            return null;
        }
        UserDTO dto = new UserDTO();
        dto.setId(user.getIdentifier());
        dto.setUserGroups(groups);
        dto.setIdentity(user.getIdentity());
        dto.setConfigurable(Boolean.valueOf(AuthorizerCapabilityDetection.isUserConfigurable((Authorizer)this.authorizer, (User)user)));
        dto.setAccessPolicies(accessPolicies);
        return dto;
    }

    public TenantDTO createTenantDTO(User user) {
        if (user == null) {
            return null;
        }
        TenantDTO dto = new TenantDTO();
        dto.setId(user.getIdentifier());
        dto.setIdentity(user.getIdentity());
        dto.setConfigurable(Boolean.valueOf(AuthorizerCapabilityDetection.isUserConfigurable((Authorizer)this.authorizer, (User)user)));
        return dto;
    }

    public UserGroupDTO createUserGroupDto(Group userGroup, Set<TenantEntity> users, Set<AccessPolicySummaryEntity> accessPolicies) {
        if (userGroup == null) {
            return null;
        }
        Set policies = accessPolicies.stream().map(summaryEntity -> {
            AccessPolicyDTO policy = new AccessPolicyDTO();
            policy.setId(summaryEntity.getId());
            if (summaryEntity.getPermissions().getCanRead().booleanValue()) {
                AccessPolicySummaryDTO summary = summaryEntity.getComponent();
                policy.setResource(summary.getResource());
                policy.setAction(summary.getAction());
                policy.setConfigurable(summary.getConfigurable());
                policy.setComponentReference(summary.getComponentReference());
            }
            return this.entityFactory.createAccessPolicyEntity(policy, summaryEntity.getRevision(), summaryEntity.getPermissions());
        }).collect(Collectors.toSet());
        UserGroupDTO dto = new UserGroupDTO();
        dto.setId(userGroup.getIdentifier());
        dto.setUsers(users);
        dto.setIdentity(userGroup.getName());
        dto.setConfigurable(Boolean.valueOf(AuthorizerCapabilityDetection.isGroupConfigurable((Authorizer)this.authorizer, (Group)userGroup)));
        dto.setAccessPolicies(policies);
        return dto;
    }

    public TenantDTO createTenantDTO(Group userGroup) {
        if (userGroup == null) {
            return null;
        }
        TenantDTO dto = new TenantDTO();
        dto.setId(userGroup.getIdentifier());
        dto.setIdentity(userGroup.getName());
        dto.setConfigurable(Boolean.valueOf(AuthorizerCapabilityDetection.isGroupConfigurable((Authorizer)this.authorizer, (Group)userGroup)));
        return dto;
    }

    public FunnelDTO createFunnelDto(Funnel funnel) {
        if (funnel == null) {
            return null;
        }
        FunnelDTO dto = new FunnelDTO();
        dto.setId(funnel.getIdentifier());
        dto.setPosition(this.createPositionDto(funnel.getPosition()));
        dto.setParentGroupId(funnel.getProcessGroup().getIdentifier());
        return dto;
    }

    public SnippetDTO createSnippetDto(Snippet snippet) {
        SnippetDTO dto = new SnippetDTO();
        dto.setId(snippet.getId());
        dto.setParentGroupId(snippet.getParentGroupId());
        dto.setConnections(this.mapRevisionToDto(snippet.getConnections()));
        dto.setFunnels(this.mapRevisionToDto(snippet.getFunnels()));
        dto.setInputPorts(this.mapRevisionToDto(snippet.getInputPorts()));
        dto.setLabels(this.mapRevisionToDto(snippet.getLabels()));
        dto.setOutputPorts(this.mapRevisionToDto(snippet.getOutputPorts()));
        dto.setProcessGroups(this.mapRevisionToDto(snippet.getProcessGroups()));
        dto.setProcessors(this.mapRevisionToDto(snippet.getProcessors()));
        dto.setRemoteProcessGroups(this.mapRevisionToDto(snippet.getRemoteProcessGroups()));
        return dto;
    }

    private Map<String, RevisionDTO> mapRevisionToDto(Map<String, Revision> revisionMap) {
        HashMap<String, RevisionDTO> dtos = new HashMap<String, RevisionDTO>(revisionMap.size());
        for (Map.Entry<String, Revision> entry : revisionMap.entrySet()) {
            Revision revision = entry.getValue();
            RevisionDTO revisionDto = new RevisionDTO();
            revisionDto.setClientId(revision.getClientId());
            revisionDto.setVersion(revision.getVersion());
            dtos.put(entry.getKey(), revisionDto);
        }
        return dtos;
    }

    public TemplateDTO createTemplateDTO(Template template) {
        if (template == null) {
            return null;
        }
        TemplateDTO original = template.getDetails();
        TemplateDTO copy = new TemplateDTO();
        copy.setId(original.getId());
        copy.setGroupId(template.getProcessGroup().getIdentifier());
        copy.setName(original.getName());
        copy.setDescription(original.getDescription());
        copy.setTimestamp(original.getTimestamp());
        copy.setUri(original.getUri());
        copy.setEncodingVersion(original.getEncodingVersion());
        return copy;
    }

    public RemoteProcessGroupStatusDTO createRemoteProcessGroupStatusDto(RemoteProcessGroupStatus remoteProcessGroupStatus) {
        RemoteProcessGroupStatusDTO dto = new RemoteProcessGroupStatusDTO();
        dto.setId(remoteProcessGroupStatus.getId());
        dto.setGroupId(remoteProcessGroupStatus.getGroupId());
        dto.setTargetUri(remoteProcessGroupStatus.getTargetUri());
        dto.setName(remoteProcessGroupStatus.getName());
        dto.setTransmissionStatus(remoteProcessGroupStatus.getTransmissionStatus().toString());
        dto.setStatsLastRefreshed(new Date());
        RemoteProcessGroupStatusSnapshotDTO snapshot = new RemoteProcessGroupStatusSnapshotDTO();
        dto.setAggregateSnapshot(snapshot);
        snapshot.setId(remoteProcessGroupStatus.getId());
        snapshot.setGroupId(remoteProcessGroupStatus.getGroupId());
        snapshot.setName(remoteProcessGroupStatus.getName());
        snapshot.setTargetUri(remoteProcessGroupStatus.getTargetUri());
        snapshot.setTransmissionStatus(remoteProcessGroupStatus.getTransmissionStatus().toString());
        snapshot.setActiveThreadCount(remoteProcessGroupStatus.getActiveThreadCount());
        snapshot.setFlowFilesSent(remoteProcessGroupStatus.getSentCount());
        snapshot.setBytesSent(remoteProcessGroupStatus.getSentContentSize());
        snapshot.setFlowFilesReceived(remoteProcessGroupStatus.getReceivedCount());
        snapshot.setBytesReceived(remoteProcessGroupStatus.getReceivedContentSize());
        StatusMerger.updatePrettyPrintedFields((RemoteProcessGroupStatusSnapshotDTO)snapshot);
        return dto;
    }

    public ProcessGroupStatusDTO createConciseProcessGroupStatusDto(ProcessGroupStatus processGroupStatus) {
        ProcessGroupStatusDTO processGroupStatusDto = new ProcessGroupStatusDTO();
        processGroupStatusDto.setId(processGroupStatus.getId());
        processGroupStatusDto.setName(processGroupStatus.getName());
        processGroupStatusDto.setStatsLastRefreshed(new Date());
        ProcessGroupStatusSnapshotDTO snapshot = new ProcessGroupStatusSnapshotDTO();
        processGroupStatusDto.setAggregateSnapshot(snapshot);
        snapshot.setId(processGroupStatus.getId());
        snapshot.setName(processGroupStatus.getName());
        snapshot.setFlowFilesQueued(processGroupStatus.getQueuedCount());
        snapshot.setBytesQueued(processGroupStatus.getQueuedContentSize());
        snapshot.setBytesRead(processGroupStatus.getBytesRead());
        snapshot.setBytesWritten(processGroupStatus.getBytesWritten());
        snapshot.setFlowFilesIn(processGroupStatus.getInputCount());
        snapshot.setBytesIn(processGroupStatus.getInputContentSize());
        snapshot.setFlowFilesOut(processGroupStatus.getOutputCount());
        snapshot.setBytesOut(processGroupStatus.getOutputContentSize());
        snapshot.setFlowFilesTransferred(Integer.valueOf(processGroupStatus.getFlowFilesTransferred()));
        snapshot.setBytesTransferred(Long.valueOf(processGroupStatus.getBytesTransferred()));
        snapshot.setFlowFilesSent(Integer.valueOf(processGroupStatus.getFlowFilesSent()));
        snapshot.setBytesSent(Long.valueOf(processGroupStatus.getBytesSent()));
        snapshot.setFlowFilesReceived(Integer.valueOf(processGroupStatus.getFlowFilesReceived()));
        snapshot.setBytesReceived(Long.valueOf(processGroupStatus.getBytesReceived()));
        snapshot.setActiveThreadCount(processGroupStatus.getActiveThreadCount());
        StatusMerger.updatePrettyPrintedFields((ProcessGroupStatusSnapshotDTO)snapshot);
        return processGroupStatusDto;
    }

    public ProcessGroupStatusDTO createProcessGroupStatusDto(ProcessGroup processGroup, ProcessGroupStatus processGroupStatus) {
        ProcessGroupStatusDTO processGroupStatusDto = this.createConciseProcessGroupStatusDto(processGroupStatus);
        ProcessGroupStatusSnapshotDTO snapshot = processGroupStatusDto.getAggregateSnapshot();
        ArrayList<ProcessorStatusSnapshotEntity> processorStatusSnapshotEntities = new ArrayList<ProcessorStatusSnapshotEntity>();
        snapshot.setProcessorStatusSnapshots(processorStatusSnapshotEntities);
        Collection processorStatusCollection = processGroupStatus.getProcessorStatus();
        if (processorStatusCollection != null) {
            for (ProcessorStatus processorStatus : processorStatusCollection) {
                ProcessorStatusDTO processorStatusDto = this.createProcessorStatusDto(processorStatus);
                ProcessorNode processor = processGroup.findProcessor(processorStatusDto.getId());
                PermissionsDTO processorPermissions = this.createPermissionsDto((Authorizable)processor);
                processorStatusSnapshotEntities.add(this.entityFactory.createProcessorStatusSnapshotEntity(processorStatusDto.getAggregateSnapshot(), processorPermissions));
            }
        }
        ArrayList<ConnectionStatusSnapshotEntity> connectionStatusDtoCollection = new ArrayList<ConnectionStatusSnapshotEntity>();
        snapshot.setConnectionStatusSnapshots(connectionStatusDtoCollection);
        Collection connectionStatusCollection = processGroupStatus.getConnectionStatus();
        if (connectionStatusCollection != null) {
            for (ConnectionStatus connectionStatus : connectionStatusCollection) {
                ConnectionStatusDTO connectionStatusDto = this.createConnectionStatusDto(connectionStatus);
                Connection connection = processGroup.findConnection(connectionStatusDto.getId());
                PermissionsDTO connectionPermissions = this.createPermissionsDto((Authorizable)connection);
                connectionStatusDtoCollection.add(this.entityFactory.createConnectionStatusSnapshotEntity(connectionStatusDto.getAggregateSnapshot(), connectionPermissions));
            }
        }
        ArrayList<ProcessGroupStatusSnapshotEntity> childProcessGroupStatusDtoCollection = new ArrayList<ProcessGroupStatusSnapshotEntity>();
        snapshot.setProcessGroupStatusSnapshots(childProcessGroupStatusDtoCollection);
        Collection childProcessGroupStatusCollection = processGroupStatus.getProcessGroupStatus();
        if (childProcessGroupStatusCollection != null) {
            for (ProcessGroupStatus childProcessGroupStatus : childProcessGroupStatusCollection) {
                ProcessGroupStatusDTO childProcessGroupStatusDto = this.createProcessGroupStatusDto(processGroup, childProcessGroupStatus);
                ProcessGroup childProcessGroup = processGroup.findProcessGroup(childProcessGroupStatusDto.getId());
                PermissionsDTO childProcessGroupPermissions = this.createPermissionsDto((Authorizable)childProcessGroup);
                childProcessGroupStatusDtoCollection.add(this.entityFactory.createProcessGroupStatusSnapshotEntity(childProcessGroupStatusDto.getAggregateSnapshot(), childProcessGroupPermissions));
            }
        }
        ArrayList<RemoteProcessGroupStatusSnapshotEntity> childRemoteProcessGroupStatusDtoCollection = new ArrayList<RemoteProcessGroupStatusSnapshotEntity>();
        snapshot.setRemoteProcessGroupStatusSnapshots(childRemoteProcessGroupStatusDtoCollection);
        Collection childRemoteProcessGroupStatusCollection = processGroupStatus.getRemoteProcessGroupStatus();
        if (childRemoteProcessGroupStatusCollection != null) {
            for (RemoteProcessGroupStatus childRemoteProcessGroupStatus : childRemoteProcessGroupStatusCollection) {
                RemoteProcessGroupStatusDTO childRemoteProcessGroupStatusDto = this.createRemoteProcessGroupStatusDto(childRemoteProcessGroupStatus);
                RemoteProcessGroup remoteProcessGroup = processGroup.findRemoteProcessGroup(childRemoteProcessGroupStatusDto.getId());
                PermissionsDTO remoteProcessGroupPermissions = this.createPermissionsDto((Authorizable)remoteProcessGroup);
                childRemoteProcessGroupStatusDtoCollection.add(this.entityFactory.createRemoteProcessGroupStatusSnapshotEntity(childRemoteProcessGroupStatusDto.getAggregateSnapshot(), remoteProcessGroupPermissions));
            }
        }
        ArrayList<PortStatusSnapshotEntity> inputPortStatusDtoCollection = new ArrayList<PortStatusSnapshotEntity>();
        snapshot.setInputPortStatusSnapshots(inputPortStatusDtoCollection);
        Collection inputPortStatusCollection = processGroupStatus.getInputPortStatus();
        if (inputPortStatusCollection != null) {
            for (PortStatus portStatus : inputPortStatusCollection) {
                PortStatusDTO portStatusDto = this.createPortStatusDto(portStatus);
                Port inputPort = processGroup.findInputPort(portStatus.getId());
                PermissionsDTO inputPortPermissions = this.createPermissionsDto((Authorizable)inputPort);
                inputPortStatusDtoCollection.add(this.entityFactory.createPortStatusSnapshotEntity(portStatusDto.getAggregateSnapshot(), inputPortPermissions));
            }
        }
        ArrayList<PortStatusSnapshotEntity> outputPortStatusDtoCollection = new ArrayList<PortStatusSnapshotEntity>();
        snapshot.setOutputPortStatusSnapshots(outputPortStatusDtoCollection);
        Collection outputPortStatusCollection = processGroupStatus.getOutputPortStatus();
        if (outputPortStatusCollection != null) {
            for (PortStatus portStatus : outputPortStatusCollection) {
                PortStatusDTO portStatusDto = this.createPortStatusDto(portStatus);
                Port outputPort = processGroup.findOutputPort(portStatus.getId());
                PermissionsDTO outputPortPermissions = this.createPermissionsDto((Authorizable)outputPort);
                outputPortStatusDtoCollection.add(this.entityFactory.createPortStatusSnapshotEntity(portStatusDto.getAggregateSnapshot(), outputPortPermissions));
            }
        }
        return processGroupStatusDto;
    }

    public ConnectionStatusDTO createConnectionStatusDto(ConnectionStatus connectionStatus) {
        ConnectionStatusDTO connectionStatusDto = new ConnectionStatusDTO();
        connectionStatusDto.setGroupId(connectionStatus.getGroupId());
        connectionStatusDto.setId(connectionStatus.getId());
        connectionStatusDto.setName(connectionStatus.getName());
        connectionStatusDto.setSourceId(connectionStatus.getSourceId());
        connectionStatusDto.setSourceName(connectionStatus.getSourceName());
        connectionStatusDto.setDestinationId(connectionStatus.getDestinationId());
        connectionStatusDto.setDestinationName(connectionStatus.getDestinationName());
        connectionStatusDto.setStatsLastRefreshed(new Date());
        ConnectionStatusSnapshotDTO snapshot = new ConnectionStatusSnapshotDTO();
        connectionStatusDto.setAggregateSnapshot(snapshot);
        snapshot.setId(connectionStatus.getId());
        snapshot.setGroupId(connectionStatus.getGroupId());
        snapshot.setName(connectionStatus.getName());
        snapshot.setSourceName(connectionStatus.getSourceName());
        snapshot.setDestinationName(connectionStatus.getDestinationName());
        snapshot.setFlowFilesQueued(Integer.valueOf(connectionStatus.getQueuedCount()));
        snapshot.setBytesQueued(Long.valueOf(connectionStatus.getQueuedBytes()));
        snapshot.setFlowFilesIn(Integer.valueOf(connectionStatus.getInputCount()));
        snapshot.setBytesIn(Long.valueOf(connectionStatus.getInputBytes()));
        snapshot.setFlowFilesOut(Integer.valueOf(connectionStatus.getOutputCount()));
        snapshot.setBytesOut(Long.valueOf(connectionStatus.getOutputBytes()));
        if (connectionStatus.getBackPressureObjectThreshold() > 0L) {
            snapshot.setPercentUseCount(Integer.valueOf(Math.min(100, StatusMerger.getUtilization((double)connectionStatus.getQueuedCount(), (double)connectionStatus.getBackPressureObjectThreshold()))));
        }
        if (connectionStatus.getBackPressureBytesThreshold() > 0L) {
            snapshot.setPercentUseBytes(Integer.valueOf(Math.min(100, StatusMerger.getUtilization((double)connectionStatus.getQueuedBytes(), (double)connectionStatus.getBackPressureBytesThreshold()))));
        }
        StatusMerger.updatePrettyPrintedFields((ConnectionStatusSnapshotDTO)snapshot);
        return connectionStatusDto;
    }

    public ProcessorStatusDTO createProcessorStatusDto(ProcessorStatus procStatus) {
        ProcessorStatusDTO dto = new ProcessorStatusDTO();
        dto.setId(procStatus.getId());
        dto.setGroupId(procStatus.getGroupId());
        dto.setName(procStatus.getName());
        dto.setStatsLastRefreshed(new Date());
        ProcessorStatusSnapshotDTO snapshot = new ProcessorStatusSnapshotDTO();
        dto.setAggregateSnapshot(snapshot);
        snapshot.setId(procStatus.getId());
        snapshot.setGroupId(procStatus.getGroupId());
        snapshot.setName(procStatus.getName());
        snapshot.setFlowFilesOut(Integer.valueOf(procStatus.getOutputCount()));
        snapshot.setBytesOut(Long.valueOf(procStatus.getOutputBytes()));
        snapshot.setFlowFilesIn(Integer.valueOf(procStatus.getInputCount()));
        snapshot.setBytesIn(Long.valueOf(procStatus.getInputBytes()));
        snapshot.setBytesRead(Long.valueOf(procStatus.getBytesRead()));
        snapshot.setBytesWritten(Long.valueOf(procStatus.getBytesWritten()));
        snapshot.setTaskCount(Integer.valueOf(procStatus.getInvocations()));
        snapshot.setTasksDurationNanos(Long.valueOf(procStatus.getProcessingNanos()));
        snapshot.setTasksDuration(FormatUtils.formatHoursMinutesSeconds((long)procStatus.getProcessingNanos(), (TimeUnit)TimeUnit.NANOSECONDS));
        snapshot.setRunStatus(procStatus.getRunStatus().toString());
        snapshot.setActiveThreadCount(Integer.valueOf(procStatus.getActiveThreadCount()));
        snapshot.setType(procStatus.getType());
        StatusMerger.updatePrettyPrintedFields((ProcessorStatusSnapshotDTO)snapshot);
        return dto;
    }

    public PortStatusDTO createPortStatusDto(PortStatus portStatus) {
        PortStatusDTO dto = new PortStatusDTO();
        dto.setId(portStatus.getId());
        dto.setGroupId(portStatus.getGroupId());
        dto.setName(portStatus.getName());
        dto.setRunStatus(portStatus.getRunStatus().toString());
        dto.setTransmitting(portStatus.isTransmitting());
        dto.setStatsLastRefreshed(new Date());
        PortStatusSnapshotDTO snapshot = new PortStatusSnapshotDTO();
        dto.setAggregateSnapshot(snapshot);
        snapshot.setId(portStatus.getId());
        snapshot.setGroupId(portStatus.getGroupId());
        snapshot.setName(portStatus.getName());
        snapshot.setRunStatus(portStatus.getRunStatus().toString());
        snapshot.setActiveThreadCount(portStatus.getActiveThreadCount());
        snapshot.setFlowFilesOut(Integer.valueOf(portStatus.getOutputCount()));
        snapshot.setBytesOut(Long.valueOf(portStatus.getOutputBytes()));
        snapshot.setFlowFilesIn(Integer.valueOf(portStatus.getInputCount()));
        snapshot.setBytesIn(Long.valueOf(portStatus.getInputBytes()));
        StatusMerger.updatePrettyPrintedFields((PortStatusSnapshotDTO)snapshot);
        return dto;
    }

    public FlowSnippetDTO copySnippetContents(FlowSnippetDTO originalSnippet) {
        FlowSnippetDTO copySnippet = new FlowSnippetDTO();
        if (originalSnippet.getConnections() != null) {
            for (ConnectionDTO connection : originalSnippet.getConnections()) {
                copySnippet.getConnections().add(this.copy(connection));
            }
        }
        if (originalSnippet.getInputPorts() != null) {
            for (PortDTO port : originalSnippet.getInputPorts()) {
                copySnippet.getInputPorts().add(this.copy(port));
            }
        }
        if (originalSnippet.getOutputPorts() != null) {
            for (PortDTO port : originalSnippet.getOutputPorts()) {
                copySnippet.getOutputPorts().add(this.copy(port));
            }
        }
        if (originalSnippet.getProcessGroups() != null) {
            for (ProcessGroupDTO processGroup : originalSnippet.getProcessGroups()) {
                copySnippet.getProcessGroups().add(this.copy(processGroup, true));
            }
        }
        if (originalSnippet.getProcessors() != null) {
            for (ProcessorDTO processor : originalSnippet.getProcessors()) {
                copySnippet.getProcessors().add(this.copy(processor));
            }
        }
        if (originalSnippet.getLabels() != null) {
            for (LabelDTO label : originalSnippet.getLabels()) {
                copySnippet.getLabels().add(this.copy(label));
            }
        }
        if (originalSnippet.getFunnels() != null) {
            for (FunnelDTO funnel : originalSnippet.getFunnels()) {
                copySnippet.getFunnels().add(this.copy(funnel));
            }
        }
        if (originalSnippet.getRemoteProcessGroups() != null) {
            for (RemoteProcessGroupDTO remoteGroup : originalSnippet.getRemoteProcessGroups()) {
                copySnippet.getRemoteProcessGroups().add(this.copy(remoteGroup));
            }
        }
        if (originalSnippet.getControllerServices() != null) {
            for (ControllerServiceDTO controllerService : originalSnippet.getControllerServices()) {
                copySnippet.getControllerServices().add(this.copy(controllerService));
            }
        }
        return copySnippet;
    }

    public PortDTO createPortDto(Port port) {
        Collection validationErrors;
        if (port == null) {
            return null;
        }
        PortDTO dto = new PortDTO();
        dto.setId(port.getIdentifier());
        dto.setPosition(this.createPositionDto(port.getPosition()));
        dto.setName(port.getName());
        dto.setComments(port.getComments());
        dto.setConcurrentlySchedulableTaskCount(Integer.valueOf(port.getMaxConcurrentTasks()));
        dto.setParentGroupId(port.getProcessGroup().getIdentifier());
        dto.setState(port.getScheduledState().toString());
        dto.setType(port.getConnectableType().name());
        if (port instanceof RootGroupPort) {
            RootGroupPort rootGroupPort = (RootGroupPort)port;
            dto.setTransmitting(Boolean.valueOf(rootGroupPort.isTransmitting()));
            dto.setGroupAccessControl(rootGroupPort.getGroupAccessControl());
            dto.setUserAccessControl(rootGroupPort.getUserAccessControl());
        }
        if ((validationErrors = port.getValidationErrors()) != null && !validationErrors.isEmpty()) {
            ArrayList<String> errors = new ArrayList<String>();
            for (ValidationResult validationResult : validationErrors) {
                errors.add(validationResult.toString());
            }
            dto.setValidationErrors(errors);
        }
        return dto;
    }

    public ReportingTaskDTO createReportingTaskDto(ReportingTaskNode reportingTaskNode) {
        BundleCoordinate bundleCoordinate = reportingTaskNode.getBundleCoordinate();
        List compatibleBundles = ExtensionManager.getBundles((String)reportingTaskNode.getCanonicalClassName()).stream().filter(bundle -> {
            BundleCoordinate coordinate = bundle.getBundleDetails().getCoordinate();
            return bundleCoordinate.getGroup().equals(coordinate.getGroup()) && bundleCoordinate.getId().equals(coordinate.getId());
        }).collect(Collectors.toList());
        ReportingTaskDTO dto = new ReportingTaskDTO();
        dto.setId(reportingTaskNode.getIdentifier());
        dto.setName(reportingTaskNode.getName());
        dto.setType(reportingTaskNode.getCanonicalClassName());
        dto.setBundle(this.createBundleDto(bundleCoordinate));
        dto.setSchedulingStrategy(reportingTaskNode.getSchedulingStrategy().name());
        dto.setSchedulingPeriod(reportingTaskNode.getSchedulingPeriod());
        dto.setState(reportingTaskNode.getScheduledState().name());
        dto.setActiveThreadCount(Integer.valueOf(reportingTaskNode.getActiveThreadCount()));
        dto.setAnnotationData(reportingTaskNode.getAnnotationData());
        dto.setComments(reportingTaskNode.getComments());
        dto.setPersistsState(Boolean.valueOf(reportingTaskNode.getReportingTask().getClass().isAnnotationPresent(Stateful.class)));
        dto.setRestricted(Boolean.valueOf(reportingTaskNode.isRestricted()));
        dto.setDeprecated(Boolean.valueOf(reportingTaskNode.isDeprecated()));
        dto.setExtensionMissing(Boolean.valueOf(reportingTaskNode.isExtensionMissing()));
        dto.setMultipleVersionsAvailable(Boolean.valueOf(compatibleBundles.size() > 1));
        HashMap<String, String> defaultSchedulingPeriod = new HashMap<String, String>();
        defaultSchedulingPeriod.put(SchedulingStrategy.TIMER_DRIVEN.name(), SchedulingStrategy.TIMER_DRIVEN.getDefaultSchedulingPeriod());
        defaultSchedulingPeriod.put(SchedulingStrategy.CRON_DRIVEN.name(), SchedulingStrategy.CRON_DRIVEN.getDefaultSchedulingPeriod());
        dto.setDefaultSchedulingPeriod(defaultSchedulingPeriod);
        TreeMap sortedProperties = new TreeMap(new /* Unavailable Anonymous Inner Class!! */);
        sortedProperties.putAll(reportingTaskNode.getProperties());
        ReportingTask reportingTask = reportingTaskNode.getReportingTask();
        LinkedHashMap orderedProperties = new LinkedHashMap();
        List descriptors = reportingTask.getPropertyDescriptors();
        if (descriptors != null && !descriptors.isEmpty()) {
            for (PropertyDescriptor propertyDescriptor : descriptors) {
                orderedProperties.put(propertyDescriptor, null);
            }
        }
        orderedProperties.putAll(sortedProperties);
        dto.setDescriptors(new LinkedHashMap());
        dto.setProperties(new LinkedHashMap());
        for (Map.Entry entry : orderedProperties.entrySet()) {
            PropertyDescriptor descriptor = (PropertyDescriptor)entry.getKey();
            dto.getDescriptors().put(descriptor.getName(), this.createPropertyDescriptorDto(descriptor, null));
            String propertyValue = (String)entry.getValue();
            if (propertyValue != null && descriptor.isSensitive()) {
                propertyValue = SENSITIVE_VALUE_MASK;
            }
            dto.getProperties().put(descriptor.getName(), propertyValue);
        }
        Collection validationErrors = reportingTaskNode.getValidationErrors();
        if (validationErrors != null && !validationErrors.isEmpty()) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (ValidationResult validationResult : validationErrors) {
                arrayList.add(validationResult.toString());
            }
            dto.setValidationErrors(arrayList);
        }
        return dto;
    }

    public ControllerServiceDTO createControllerServiceDto(ControllerServiceNode controllerServiceNode) {
        BundleCoordinate bundleCoordinate = controllerServiceNode.getBundleCoordinate();
        List compatibleBundles = ExtensionManager.getBundles((String)controllerServiceNode.getCanonicalClassName()).stream().filter(bundle -> {
            BundleCoordinate coordinate = bundle.getBundleDetails().getCoordinate();
            return bundleCoordinate.getGroup().equals(coordinate.getGroup()) && bundleCoordinate.getId().equals(coordinate.getId());
        }).collect(Collectors.toList());
        ControllerServiceDTO dto = new ControllerServiceDTO();
        dto.setId(controllerServiceNode.getIdentifier());
        dto.setParentGroupId(controllerServiceNode.getProcessGroup() == null ? null : controllerServiceNode.getProcessGroup().getIdentifier());
        dto.setName(controllerServiceNode.getName());
        dto.setType(controllerServiceNode.getCanonicalClassName());
        dto.setBundle(this.createBundleDto(bundleCoordinate));
        dto.setControllerServiceApis(this.createControllerServiceApiDto(controllerServiceNode.getControllerServiceImplementation().getClass()));
        dto.setState(controllerServiceNode.getState().name());
        dto.setAnnotationData(controllerServiceNode.getAnnotationData());
        dto.setComments(controllerServiceNode.getComments());
        dto.setPersistsState(Boolean.valueOf(controllerServiceNode.getControllerServiceImplementation().getClass().isAnnotationPresent(Stateful.class)));
        dto.setRestricted(Boolean.valueOf(controllerServiceNode.isRestricted()));
        dto.setDeprecated(Boolean.valueOf(controllerServiceNode.isDeprecated()));
        dto.setExtensionMissing(Boolean.valueOf(controllerServiceNode.isExtensionMissing()));
        dto.setMultipleVersionsAvailable(Boolean.valueOf(compatibleBundles.size() > 1));
        TreeMap sortedProperties = new TreeMap(new /* Unavailable Anonymous Inner Class!! */);
        sortedProperties.putAll(controllerServiceNode.getProperties());
        ControllerService controllerService = controllerServiceNode.getControllerServiceImplementation();
        LinkedHashMap orderedProperties = new LinkedHashMap();
        List descriptors = controllerService.getPropertyDescriptors();
        if (descriptors != null && !descriptors.isEmpty()) {
            for (PropertyDescriptor propertyDescriptor : descriptors) {
                orderedProperties.put(propertyDescriptor, null);
            }
        }
        orderedProperties.putAll(sortedProperties);
        dto.setDescriptors(new LinkedHashMap());
        dto.setProperties(new LinkedHashMap());
        for (Map.Entry entry : orderedProperties.entrySet()) {
            PropertyDescriptor descriptor = (PropertyDescriptor)entry.getKey();
            String groupId = controllerServiceNode.getProcessGroup() == null ? null : controllerServiceNode.getProcessGroup().getIdentifier();
            dto.getDescriptors().put(descriptor.getName(), this.createPropertyDescriptorDto(descriptor, groupId));
            String propertyValue = (String)entry.getValue();
            if (propertyValue != null && descriptor.isSensitive()) {
                propertyValue = SENSITIVE_VALUE_MASK;
            }
            dto.getProperties().put(descriptor.getName(), propertyValue);
        }
        Collection validationErrors = controllerServiceNode.getValidationErrors();
        if (validationErrors != null && !validationErrors.isEmpty()) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (ValidationResult validationResult : validationErrors) {
                arrayList.add(validationResult.toString());
            }
            dto.setValidationErrors(arrayList);
        }
        return dto;
    }

    public ControllerServiceReferencingComponentDTO createControllerServiceReferencingComponentDTO(ConfiguredComponent component) {
        ProcessorNode node;
        ControllerServiceReferencingComponentDTO dto = new ControllerServiceReferencingComponentDTO();
        dto.setId(component.getIdentifier());
        dto.setName(component.getName());
        String processGroupId = null;
        List propertyDescriptors = null;
        Collection validationErrors = null;
        if (component instanceof ProcessorNode) {
            node = (ProcessorNode)component;
            dto.setGroupId(node.getProcessGroup().getIdentifier());
            dto.setState(node.getScheduledState().name());
            dto.setActiveThreadCount(Integer.valueOf(node.getActiveThreadCount()));
            dto.setType(node.getComponentType());
            dto.setReferenceType(Processor.class.getSimpleName());
            propertyDescriptors = node.getProcessor().getPropertyDescriptors();
            validationErrors = node.getValidationErrors();
            processGroupId = node.getProcessGroup().getIdentifier();
        } else if (component instanceof ControllerServiceNode) {
            node = (ControllerServiceNode)component;
            dto.setState(node.getState().name());
            dto.setType(node.getComponentType());
            dto.setReferenceType(ControllerService.class.getSimpleName());
            propertyDescriptors = node.getControllerServiceImplementation().getPropertyDescriptors();
            validationErrors = node.getValidationErrors();
            processGroupId = node.getProcessGroup() == null ? null : node.getProcessGroup().getIdentifier();
        } else if (component instanceof ReportingTaskNode) {
            node = (ReportingTaskNode)component;
            dto.setState(node.getScheduledState().name());
            dto.setActiveThreadCount(Integer.valueOf(node.getActiveThreadCount()));
            dto.setType(node.getComponentType());
            dto.setReferenceType(ReportingTask.class.getSimpleName());
            propertyDescriptors = node.getReportingTask().getPropertyDescriptors();
            validationErrors = node.getValidationErrors();
            processGroupId = null;
        }
        if (propertyDescriptors != null && !propertyDescriptors.isEmpty()) {
            TreeMap sortedProperties = new TreeMap(new /* Unavailable Anonymous Inner Class!! */);
            sortedProperties.putAll(component.getProperties());
            LinkedHashMap orderedProperties = new LinkedHashMap();
            for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
                orderedProperties.put(propertyDescriptor, null);
            }
            orderedProperties.putAll(sortedProperties);
            dto.setDescriptors(new LinkedHashMap());
            dto.setProperties(new LinkedHashMap());
            for (Map.Entry entry : orderedProperties.entrySet()) {
                PropertyDescriptor descriptor = (PropertyDescriptor)entry.getKey();
                dto.getDescriptors().put(descriptor.getName(), this.createPropertyDescriptorDto(descriptor, processGroupId));
                String propertyValue = (String)entry.getValue();
                if (propertyValue != null && descriptor.isSensitive()) {
                    propertyValue = SENSITIVE_VALUE_MASK;
                }
                dto.getProperties().put(descriptor.getName(), propertyValue);
            }
        }
        if (validationErrors != null && !validationErrors.isEmpty()) {
            ArrayList<String> errors = new ArrayList<String>();
            for (ValidationResult validationResult : validationErrors) {
                errors.add(validationResult.toString());
            }
            dto.setValidationErrors(errors);
        }
        return dto;
    }

    public RemoteProcessGroupPortDTO createRemoteProcessGroupPortDto(RemoteGroupPort port) {
        if (port == null) {
            return null;
        }
        RemoteProcessGroupPortDTO dto = new RemoteProcessGroupPortDTO();
        dto.setId(port.getIdentifier());
        dto.setName(port.getName());
        dto.setComments(port.getComments());
        dto.setTransmitting(Boolean.valueOf(port.isRunning()));
        dto.setTargetRunning(Boolean.valueOf(port.isTargetRunning()));
        dto.setConcurrentlySchedulableTaskCount(Integer.valueOf(port.getMaxConcurrentTasks()));
        dto.setUseCompression(Boolean.valueOf(port.isUseCompression()));
        dto.setExists(Boolean.valueOf(port.getTargetExists()));
        BatchSettingsDTO batchDTO = new BatchSettingsDTO();
        batchDTO.setCount(port.getBatchCount());
        batchDTO.setSize(port.getBatchSize());
        batchDTO.setDuration(port.getBatchDuration());
        dto.setBatchSettings(batchDTO);
        if (ConnectableType.REMOTE_OUTPUT_PORT.equals((Object)port.getConnectableType())) {
            dto.setConnected(Boolean.valueOf(!port.getConnections().isEmpty()));
        } else {
            dto.setConnected(Boolean.valueOf(port.hasIncomingConnection()));
        }
        return dto;
    }

    public RemoteProcessGroupDTO createRemoteProcessGroupDto(RemoteProcessGroup group) {
        Collection validationErrors;
        if (group == null) {
            return null;
        }
        TreeSet<RemoteProcessGroupPortDTO> inputPorts = new TreeSet<RemoteProcessGroupPortDTO>((Comparator<RemoteProcessGroupPortDTO>)new SortedRemoteGroupPortComparator(null));
        TreeSet<RemoteProcessGroupPortDTO> outputPorts = new TreeSet<RemoteProcessGroupPortDTO>((Comparator<RemoteProcessGroupPortDTO>)new SortedRemoteGroupPortComparator(null));
        int activeRemoteInputPortCount = 0;
        int inactiveRemoteInputPortCount = 0;
        for (Port port : group.getInputPorts()) {
            inputPorts.add(this.createRemoteProcessGroupPortDto((RemoteGroupPort)port));
            if (!port.hasIncomingConnection()) continue;
            if (port.isRunning()) {
                ++activeRemoteInputPortCount;
                continue;
            }
            ++inactiveRemoteInputPortCount;
        }
        int activeRemoteOutputPortCount = 0;
        int inactiveRemoteOutputPortCount = 0;
        for (Port port : group.getOutputPorts()) {
            outputPorts.add(this.createRemoteProcessGroupPortDto((RemoteGroupPort)port));
            if (port.getConnections().isEmpty()) continue;
            if (port.isRunning()) {
                ++activeRemoteOutputPortCount;
                continue;
            }
            ++inactiveRemoteOutputPortCount;
        }
        RemoteProcessGroupContentsDTO contents = new RemoteProcessGroupContentsDTO();
        contents.setInputPorts(inputPorts);
        contents.setOutputPorts(outputPorts);
        RemoteProcessGroupDTO dto = new RemoteProcessGroupDTO();
        dto.setId(group.getIdentifier());
        dto.setName(group.getName());
        dto.setPosition(this.createPositionDto(group.getPosition()));
        dto.setComments(group.getComments());
        dto.setTransmitting(Boolean.valueOf(group.isTransmitting()));
        dto.setCommunicationsTimeout(group.getCommunicationsTimeout());
        dto.setYieldDuration(group.getYieldDuration());
        dto.setParentGroupId(group.getProcessGroup().getIdentifier());
        dto.setTargetUris(group.getTargetUris());
        dto.setFlowRefreshed(group.getLastRefreshTime());
        dto.setContents(contents);
        dto.setTransportProtocol(group.getTransportProtocol().name());
        dto.setProxyHost(group.getProxyHost());
        dto.setProxyPort(group.getProxyPort());
        dto.setProxyUser(group.getProxyUser());
        if (!StringUtils.isEmpty((CharSequence)group.getProxyPassword())) {
            dto.setProxyPassword(SENSITIVE_VALUE_MASK);
        }
        if (group.isSiteToSiteEnabled()) {
            dto.setTargetSecure(group.getSecureFlag());
        }
        if (group.getAuthorizationIssue() != null) {
            dto.setAuthorizationIssues(Arrays.asList(group.getAuthorizationIssue()));
        }
        if ((validationErrors = group.validate()) != null && !validationErrors.isEmpty()) {
            ArrayList<String> errors = new ArrayList<String>();
            for (ValidationResult validationResult : validationErrors) {
                errors.add(validationResult.toString());
            }
            dto.setValidationErrors(errors);
        }
        dto.setLocalNetworkInterface(group.getNetworkInterface());
        dto.setActiveRemoteInputPortCount(Integer.valueOf(activeRemoteInputPortCount));
        dto.setInactiveRemoteInputPortCount(Integer.valueOf(inactiveRemoteInputPortCount));
        dto.setActiveRemoteOutputPortCount(Integer.valueOf(activeRemoteOutputPortCount));
        dto.setInactiveRemoteOutputPortCount(Integer.valueOf(inactiveRemoteOutputPortCount));
        ProcessGroupCounts counts = group.getCounts();
        if (counts != null) {
            dto.setInputPortCount(Integer.valueOf(counts.getInputPortCount()));
            dto.setOutputPortCount(Integer.valueOf(counts.getOutputPortCount()));
        }
        return dto;
    }

    private FlowBreadcrumbEntity createBreadcrumbEntity(ProcessGroup group) {
        if (group == null) {
            return null;
        }
        FlowBreadcrumbDTO dto = this.createBreadcrumbDto(group);
        PermissionsDTO permissions = this.createPermissionsDto((Authorizable)group);
        FlowBreadcrumbEntity entity = this.entityFactory.createFlowBreadcrumbEntity(dto, permissions);
        if (group.getParent() != null) {
            entity.setParentBreadcrumb(this.createBreadcrumbEntity(group.getParent()));
        }
        return entity;
    }

    private FlowBreadcrumbDTO createBreadcrumbDto(ProcessGroup group) {
        if (group == null) {
            return null;
        }
        FlowBreadcrumbDTO dto = new FlowBreadcrumbDTO();
        dto.setId(group.getIdentifier());
        dto.setName(group.getName());
        return dto;
    }

    public ComponentReferenceDTO createComponentReferenceDto(Authorizable authorizable) {
        if (authorizable == null || !(authorizable instanceof ComponentAuthorizable)) {
            return null;
        }
        ComponentAuthorizable componentAuthorizable = (ComponentAuthorizable)authorizable;
        ComponentReferenceDTO dto = new ComponentReferenceDTO();
        dto.setId(componentAuthorizable.getIdentifier());
        dto.setParentGroupId(componentAuthorizable.getProcessGroupIdentifier());
        dto.setName(authorizable.getResource().getName());
        return dto;
    }

    public AccessPolicySummaryDTO createAccessPolicySummaryDto(AccessPolicy accessPolicy, ComponentReferenceEntity componentReference) {
        if (accessPolicy == null) {
            return null;
        }
        AccessPolicySummaryDTO dto = new AccessPolicySummaryDTO();
        dto.setId(accessPolicy.getIdentifier());
        dto.setResource(accessPolicy.getResource());
        dto.setAction(accessPolicy.getAction().toString());
        dto.setConfigurable(Boolean.valueOf(AuthorizerCapabilityDetection.isAccessPolicyConfigurable((Authorizer)this.authorizer, (AccessPolicy)accessPolicy)));
        dto.setComponentReference(componentReference);
        return dto;
    }

    public AccessPolicyDTO createAccessPolicyDto(AccessPolicy accessPolicy, Set<TenantEntity> userGroups, Set<TenantEntity> users, ComponentReferenceEntity componentReference) {
        if (accessPolicy == null) {
            return null;
        }
        AccessPolicyDTO dto = new AccessPolicyDTO();
        dto.setUserGroups(userGroups);
        dto.setUsers(users);
        dto.setId(accessPolicy.getIdentifier());
        dto.setResource(accessPolicy.getResource());
        dto.setAction(accessPolicy.getAction().toString());
        dto.setConfigurable(Boolean.valueOf(AuthorizerCapabilityDetection.isAccessPolicyConfigurable((Authorizer)this.authorizer, (AccessPolicy)accessPolicy)));
        dto.setComponentReference(componentReference);
        return dto;
    }

    public PermissionsDTO createPermissionsDto(Authorizable authorizable) {
        return this.createPermissionsDto(authorizable, NiFiUserUtils.getNiFiUser());
    }

    public PermissionsDTO createPermissionsDto(Authorizable authorizable, NiFiUser user) {
        PermissionsDTO dto = new PermissionsDTO();
        dto.setCanRead(Boolean.valueOf(authorizable.isAuthorized(this.authorizer, RequestAction.READ, user)));
        dto.setCanWrite(Boolean.valueOf(authorizable.isAuthorized(this.authorizer, RequestAction.WRITE, user)));
        return dto;
    }

    public AffectedComponentDTO createAffectedComponentDto(ConfiguredComponent component) {
        ProcessorNode node;
        AffectedComponentDTO dto = new AffectedComponentDTO();
        dto.setId(component.getIdentifier());
        dto.setName(component.getName());
        dto.setProcessGroupId(component.getProcessGroupIdentifier());
        if (component instanceof ProcessorNode) {
            node = (ProcessorNode)component;
            dto.setState(node.getScheduledState().name());
            dto.setActiveThreadCount(Integer.valueOf(node.getActiveThreadCount()));
            dto.setReferenceType("PROCESSOR");
        } else if (component instanceof ControllerServiceNode) {
            node = (ControllerServiceNode)component;
            dto.setState(node.getState().name());
            dto.setReferenceType("CONTROLLER_SERVICE");
        }
        Collection validationErrors = component.getValidationErrors();
        if (validationErrors != null && !validationErrors.isEmpty()) {
            ArrayList<String> errors = new ArrayList<String>();
            for (ValidationResult validationResult : validationErrors) {
                errors.add(validationResult.toString());
            }
            dto.setValidationErrors(errors);
        }
        return dto;
    }

    public ProcessGroupDTO createProcessGroupDto(ProcessGroup group) {
        return this.createProcessGroupDto(group, false);
    }

    public ProcessGroupFlowDTO createProcessGroupFlowDto(ProcessGroup group, ProcessGroupStatus groupStatus, RevisionManager revisionManager, Function<ProcessGroup, List<BulletinEntity>> getProcessGroupBulletins) {
        ProcessGroupFlowDTO dto = new ProcessGroupFlowDTO();
        dto.setId(group.getIdentifier());
        dto.setLastRefreshed(new Date());
        dto.setBreadcrumb(this.createBreadcrumbEntity(group));
        dto.setFlow(this.createFlowDto(group, groupStatus, revisionManager, getProcessGroupBulletins));
        ProcessGroup parent = group.getParent();
        if (parent != null) {
            dto.setParentGroupId(parent.getIdentifier());
        }
        return dto;
    }

    public FlowDTO createFlowDto(ProcessGroup group, ProcessGroupStatus groupStatus, FlowSnippetDTO snippet, RevisionManager revisionManager, Function<ProcessGroup, List<BulletinEntity>> getProcessGroupBulletins) {
        List bulletinEntities;
        List bulletins;
        PermissionsDTO permissions;
        ConnectionStatusDTO status;
        PermissionsDTO accessPolicy;
        RevisionDTO revision;
        ConnectionDTO dto;
        if (snippet == null) {
            return null;
        }
        FlowDTO flow = new FlowDTO();
        for (ConnectionDTO snippetConnection : snippet.getConnections()) {
            Connection connection = group.getConnection(snippetConnection.getId());
            dto = this.createConnectionDto(connection);
            revision = this.createRevisionDTO(revisionManager.getRevision(connection.getIdentifier()));
            accessPolicy = this.createPermissionsDto((Authorizable)connection);
            status = (ConnectionStatusDTO)this.getComponentStatus(() -> groupStatus.getConnectionStatus().stream().filter(connectionStatus -> connection.getIdentifier().equals(connectionStatus.getId())).findFirst().orElse(null), connectionStatus -> this.createConnectionStatusDto(connectionStatus));
            flow.getConnections().add(this.entityFactory.createConnectionEntity(dto, revision, accessPolicy, status));
        }
        for (FunnelDTO snippetFunnel : snippet.getFunnels()) {
            Funnel funnel = group.getFunnel(snippetFunnel.getId());
            dto = this.createFunnelDto(funnel);
            revision = this.createRevisionDTO(revisionManager.getRevision(funnel.getIdentifier()));
            accessPolicy = this.createPermissionsDto((Authorizable)funnel);
            flow.getFunnels().add(this.entityFactory.createFunnelEntity((FunnelDTO)dto, revision, accessPolicy));
        }
        for (PortDTO snippetInputPort : snippet.getInputPorts()) {
            Port inputPort = group.getInputPort(snippetInputPort.getId());
            dto = this.createPortDto(inputPort);
            revision = this.createRevisionDTO(revisionManager.getRevision(inputPort.getIdentifier()));
            permissions = this.createPermissionsDto((Authorizable)inputPort);
            status = (PortStatusDTO)this.getComponentStatus(() -> groupStatus.getInputPortStatus().stream().filter(inputPortStatus -> inputPort.getIdentifier().equals(inputPortStatus.getId())).findFirst().orElse(null), inputPortStatus -> this.createPortStatusDto(inputPortStatus));
            bulletins = this.createBulletinDtos(this.bulletinRepository.findBulletinsForSource(inputPort.getIdentifier()));
            bulletinEntities = bulletins.stream().map(bulletin -> this.entityFactory.createBulletinEntity(bulletin, permissions.getCanRead().booleanValue())).collect(Collectors.toList());
            flow.getInputPorts().add(this.entityFactory.createPortEntity((PortDTO)dto, revision, permissions, (PortStatusDTO)status, bulletinEntities));
        }
        for (PortDTO snippetOutputPort : snippet.getOutputPorts()) {
            Port outputPort = group.getOutputPort(snippetOutputPort.getId());
            dto = this.createPortDto(outputPort);
            revision = this.createRevisionDTO(revisionManager.getRevision(outputPort.getIdentifier()));
            permissions = this.createPermissionsDto((Authorizable)outputPort);
            status = (PortStatusDTO)this.getComponentStatus(() -> groupStatus.getOutputPortStatus().stream().filter(outputPortStatus -> outputPort.getIdentifier().equals(outputPortStatus.getId())).findFirst().orElse(null), outputPortStatus -> this.createPortStatusDto(outputPortStatus));
            bulletins = this.createBulletinDtos(this.bulletinRepository.findBulletinsForSource(outputPort.getIdentifier()));
            bulletinEntities = bulletins.stream().map(bulletin -> this.entityFactory.createBulletinEntity(bulletin, permissions.getCanRead().booleanValue())).collect(Collectors.toList());
            flow.getOutputPorts().add(this.entityFactory.createPortEntity((PortDTO)dto, revision, permissions, (PortStatusDTO)status, bulletinEntities));
        }
        for (LabelDTO snippetLabel : snippet.getLabels()) {
            Label label = group.getLabel(snippetLabel.getId());
            dto = this.createLabelDto(label);
            revision = this.createRevisionDTO(revisionManager.getRevision(label.getIdentifier()));
            accessPolicy = this.createPermissionsDto((Authorizable)label);
            flow.getLabels().add(this.entityFactory.createLabelEntity((LabelDTO)dto, revision, accessPolicy));
        }
        for (ProcessGroupDTO snippetProcessGroup : snippet.getProcessGroups()) {
            ProcessGroup processGroup = group.getProcessGroup(snippetProcessGroup.getId());
            dto = this.createProcessGroupDto(processGroup);
            revision = this.createRevisionDTO(revisionManager.getRevision(processGroup.getIdentifier()));
            permissions = this.createPermissionsDto((Authorizable)processGroup);
            status = (ProcessGroupStatusDTO)this.getComponentStatus(() -> groupStatus.getProcessGroupStatus().stream().filter(processGroupStatus -> processGroup.getIdentifier().equals(processGroupStatus.getId())).findFirst().orElse(null), processGroupStatus -> this.createConciseProcessGroupStatusDto(processGroupStatus));
            bulletins = getProcessGroupBulletins.apply(processGroup);
            flow.getProcessGroups().add(this.entityFactory.createProcessGroupEntity((ProcessGroupDTO)dto, revision, permissions, (ProcessGroupStatusDTO)status, bulletins));
        }
        for (ProcessorDTO snippetProcessor : snippet.getProcessors()) {
            ProcessorNode processor = group.getProcessor(snippetProcessor.getId());
            dto = this.createProcessorDto(processor);
            revision = this.createRevisionDTO(revisionManager.getRevision(processor.getIdentifier()));
            permissions = this.createPermissionsDto((Authorizable)processor);
            status = (ProcessorStatusDTO)this.getComponentStatus(() -> groupStatus.getProcessorStatus().stream().filter(processorStatus -> processor.getIdentifier().equals(processorStatus.getId())).findFirst().orElse(null), processorStatus -> this.createProcessorStatusDto(processorStatus));
            bulletins = this.createBulletinDtos(this.bulletinRepository.findBulletinsForSource(processor.getIdentifier()));
            bulletinEntities = bulletins.stream().map(bulletin -> this.entityFactory.createBulletinEntity(bulletin, permissions.getCanRead().booleanValue())).collect(Collectors.toList());
            flow.getProcessors().add(this.entityFactory.createProcessorEntity((ProcessorDTO)dto, revision, permissions, (ProcessorStatusDTO)status, bulletinEntities));
        }
        for (RemoteProcessGroupDTO snippetRemoteProcessGroup : snippet.getRemoteProcessGroups()) {
            RemoteProcessGroup remoteProcessGroup = group.getRemoteProcessGroup(snippetRemoteProcessGroup.getId());
            dto = this.createRemoteProcessGroupDto(remoteProcessGroup);
            revision = this.createRevisionDTO(revisionManager.getRevision(remoteProcessGroup.getIdentifier()));
            permissions = this.createPermissionsDto((Authorizable)remoteProcessGroup);
            status = (RemoteProcessGroupStatusDTO)this.getComponentStatus(() -> groupStatus.getRemoteProcessGroupStatus().stream().filter(rpgStatus -> remoteProcessGroup.getIdentifier().equals(rpgStatus.getId())).findFirst().orElse(null), remoteProcessGroupStatus -> this.createRemoteProcessGroupStatusDto(remoteProcessGroupStatus));
            bulletins = this.createBulletinDtos(this.bulletinRepository.findBulletinsForSource(remoteProcessGroup.getIdentifier()));
            bulletinEntities = bulletins.stream().map(bulletin -> this.entityFactory.createBulletinEntity(bulletin, permissions.getCanRead().booleanValue())).collect(Collectors.toList());
            flow.getRemoteProcessGroups().add(this.entityFactory.createRemoteProcessGroupEntity((RemoteProcessGroupDTO)dto, revision, permissions, (RemoteProcessGroupStatusDTO)status, bulletinEntities));
        }
        return flow;
    }

    private <T, S> T getComponentStatus(Supplier<S> getComponentStatus, Function<S, T> convertToDto) {
        S status = getComponentStatus.get();
        T statusDTO = status != null ? (T)convertToDto.apply(status) : null;
        return statusDTO;
    }

    public FlowDTO createFlowDto(ProcessGroup group, ProcessGroupStatus groupStatus, RevisionManager revisionManager, Function<ProcessGroup, List<BulletinEntity>> getProcessGroupBulletins) {
        List bulletinEntities;
        List bulletins;
        ProcessorStatusDTO status;
        PermissionsDTO permissions;
        RevisionDTO revision;
        FlowDTO dto = new FlowDTO();
        for (ProcessorNode procNode : group.getProcessors()) {
            revision = this.createRevisionDTO(revisionManager.getRevision(procNode.getIdentifier()));
            permissions = this.createPermissionsDto((Authorizable)procNode);
            status = (ProcessorStatusDTO)this.getComponentStatus(() -> groupStatus.getProcessorStatus().stream().filter(processorStatus -> procNode.getIdentifier().equals(processorStatus.getId())).findFirst().orElse(null), processorStatus -> this.createProcessorStatusDto(processorStatus));
            bulletins = this.createBulletinDtos(this.bulletinRepository.findBulletinsForSource(procNode.getIdentifier()));
            bulletinEntities = bulletins.stream().map(bulletin -> this.entityFactory.createBulletinEntity(bulletin, permissions.getCanRead().booleanValue())).collect(Collectors.toList());
            dto.getProcessors().add(this.entityFactory.createProcessorEntity(this.createProcessorDto(procNode), revision, permissions, status, bulletinEntities));
        }
        for (Connection connNode : group.getConnections()) {
            revision = this.createRevisionDTO(revisionManager.getRevision(connNode.getIdentifier()));
            permissions = this.createPermissionsDto((Authorizable)connNode);
            status = (ConnectionStatusDTO)this.getComponentStatus(() -> groupStatus.getConnectionStatus().stream().filter(connectionStatus -> connNode.getIdentifier().equals(connectionStatus.getId())).findFirst().orElse(null), connectionStatus -> this.createConnectionStatusDto(connectionStatus));
            dto.getConnections().add(this.entityFactory.createConnectionEntity(this.createConnectionDto(connNode), revision, permissions, (ConnectionStatusDTO)status));
        }
        for (Label label : group.getLabels()) {
            revision = this.createRevisionDTO(revisionManager.getRevision(label.getIdentifier()));
            permissions = this.createPermissionsDto((Authorizable)label);
            dto.getLabels().add(this.entityFactory.createLabelEntity(this.createLabelDto(label), revision, permissions));
        }
        for (Funnel funnel : group.getFunnels()) {
            revision = this.createRevisionDTO(revisionManager.getRevision(funnel.getIdentifier()));
            permissions = this.createPermissionsDto((Authorizable)funnel);
            dto.getFunnels().add(this.entityFactory.createFunnelEntity(this.createFunnelDto(funnel), revision, permissions));
        }
        for (ProcessGroup childGroup : group.getProcessGroups()) {
            revision = this.createRevisionDTO(revisionManager.getRevision(childGroup.getIdentifier()));
            permissions = this.createPermissionsDto((Authorizable)childGroup);
            status = (ProcessGroupStatusDTO)this.getComponentStatus(() -> groupStatus.getProcessGroupStatus().stream().filter(processGroupStatus -> childGroup.getIdentifier().equals(processGroupStatus.getId())).findFirst().orElse(null), processGroupStatus -> this.createConciseProcessGroupStatusDto(processGroupStatus));
            bulletins = getProcessGroupBulletins.apply(childGroup);
            dto.getProcessGroups().add(this.entityFactory.createProcessGroupEntity(this.createProcessGroupDto(childGroup), revision, permissions, (ProcessGroupStatusDTO)status, bulletins));
        }
        for (RemoteProcessGroup rpg : group.getRemoteProcessGroups()) {
            revision = this.createRevisionDTO(revisionManager.getRevision(rpg.getIdentifier()));
            permissions = this.createPermissionsDto((Authorizable)rpg);
            status = (RemoteProcessGroupStatusDTO)this.getComponentStatus(() -> groupStatus.getRemoteProcessGroupStatus().stream().filter(remoteProcessGroupStatus -> rpg.getIdentifier().equals(remoteProcessGroupStatus.getId())).findFirst().orElse(null), remoteProcessGroupStatus -> this.createRemoteProcessGroupStatusDto(remoteProcessGroupStatus));
            bulletins = this.createBulletinDtos(this.bulletinRepository.findBulletinsForSource(rpg.getIdentifier()));
            bulletinEntities = bulletins.stream().map(bulletin -> this.entityFactory.createBulletinEntity(bulletin, permissions.getCanRead().booleanValue())).collect(Collectors.toList());
            dto.getRemoteProcessGroups().add(this.entityFactory.createRemoteProcessGroupEntity(this.createRemoteProcessGroupDto(rpg), revision, permissions, (RemoteProcessGroupStatusDTO)status, bulletinEntities));
        }
        for (Port inputPort : group.getInputPorts()) {
            revision = this.createRevisionDTO(revisionManager.getRevision(inputPort.getIdentifier()));
            permissions = this.createPermissionsDto((Authorizable)inputPort);
            status = (PortStatusDTO)this.getComponentStatus(() -> groupStatus.getInputPortStatus().stream().filter(inputPortStatus -> inputPort.getIdentifier().equals(inputPortStatus.getId())).findFirst().orElse(null), inputPortStatus -> this.createPortStatusDto(inputPortStatus));
            bulletins = this.createBulletinDtos(this.bulletinRepository.findBulletinsForSource(inputPort.getIdentifier()));
            bulletinEntities = bulletins.stream().map(bulletin -> this.entityFactory.createBulletinEntity(bulletin, permissions.getCanRead().booleanValue())).collect(Collectors.toList());
            dto.getInputPorts().add(this.entityFactory.createPortEntity(this.createPortDto(inputPort), revision, permissions, (PortStatusDTO)status, bulletinEntities));
        }
        for (Port outputPort : group.getOutputPorts()) {
            revision = this.createRevisionDTO(revisionManager.getRevision(outputPort.getIdentifier()));
            permissions = this.createPermissionsDto((Authorizable)outputPort);
            status = (PortStatusDTO)this.getComponentStatus(() -> groupStatus.getOutputPortStatus().stream().filter(outputPortStatus -> outputPort.getIdentifier().equals(outputPortStatus.getId())).findFirst().orElse(null), outputPortStatus -> this.createPortStatusDto(outputPortStatus));
            bulletins = this.createBulletinDtos(this.bulletinRepository.findBulletinsForSource(outputPort.getIdentifier()));
            bulletinEntities = bulletins.stream().map(bulletin -> this.entityFactory.createBulletinEntity(bulletin, permissions.getCanRead().booleanValue())).collect(Collectors.toList());
            dto.getOutputPorts().add(this.entityFactory.createPortEntity(this.createPortDto(outputPort), revision, permissions, (PortStatusDTO)status, bulletinEntities));
        }
        return dto;
    }

    public ProcessGroupDTO createProcessGroupDto(ProcessGroup group, boolean recurse) {
        ProcessGroupDTO dto = this.createConciseProcessGroupDto(group);
        dto.setContents(this.createProcessGroupContentsDto(group, recurse));
        return dto;
    }

    private ProcessGroupDTO createConciseProcessGroupDto(ProcessGroup group) {
        if (group == null) {
            return null;
        }
        ProcessGroupDTO dto = new ProcessGroupDTO();
        dto.setId(group.getIdentifier());
        dto.setPosition(this.createPositionDto(group.getPosition()));
        dto.setComments(group.getComments());
        dto.setName(group.getName());
        Map<String, String> variables = group.getVariableRegistry().getVariableMap().entrySet().stream().collect(Collectors.toMap(entry -> ((VariableDescriptor)entry.getKey()).getName(), entry -> (String)entry.getValue()));
        group.setVariables(variables);
        ProcessGroup parentGroup = group.getParent();
        if (parentGroup != null) {
            dto.setParentGroupId(parentGroup.getIdentifier());
        }
        ProcessGroupCounts counts = group.getCounts();
        dto.setRunningCount(Integer.valueOf(counts.getRunningCount()));
        dto.setStoppedCount(Integer.valueOf(counts.getStoppedCount()));
        dto.setInvalidCount(Integer.valueOf(counts.getInvalidCount()));
        dto.setDisabledCount(Integer.valueOf(counts.getDisabledCount()));
        dto.setInputPortCount(Integer.valueOf(counts.getInputPortCount()));
        dto.setOutputPortCount(Integer.valueOf(counts.getOutputPortCount()));
        dto.setActiveRemotePortCount(Integer.valueOf(counts.getActiveRemotePortCount()));
        dto.setInactiveRemotePortCount(Integer.valueOf(counts.getInactiveRemotePortCount()));
        return dto;
    }

    private FlowSnippetDTO createProcessGroupContentsDto(ProcessGroup group, boolean recurse) {
        if (group == null) {
            return null;
        }
        FlowSnippetDTO dto = new FlowSnippetDTO();
        for (ProcessorNode procNode : group.getProcessors()) {
            dto.getProcessors().add(this.createProcessorDto(procNode));
        }
        for (Connection connNode : group.getConnections()) {
            dto.getConnections().add(this.createConnectionDto(connNode));
        }
        for (Label label : group.getLabels()) {
            dto.getLabels().add(this.createLabelDto(label));
        }
        for (Funnel funnel : group.getFunnels()) {
            dto.getFunnels().add(this.createFunnelDto(funnel));
        }
        for (ProcessGroup childGroup : group.getProcessGroups()) {
            if (recurse) {
                dto.getProcessGroups().add(this.createProcessGroupDto(childGroup, recurse));
                continue;
            }
            dto.getProcessGroups().add(this.createConciseProcessGroupDto(childGroup));
        }
        for (RemoteProcessGroup remoteProcessGroup : group.getRemoteProcessGroups()) {
            dto.getRemoteProcessGroups().add(this.createRemoteProcessGroupDto(remoteProcessGroup));
        }
        for (Port inputPort : group.getInputPorts()) {
            dto.getInputPorts().add(this.createPortDto(inputPort));
        }
        for (Port outputPort : group.getOutputPorts()) {
            dto.getOutputPorts().add(this.createPortDto(outputPort));
        }
        return dto;
    }

    private String getUsageRestriction(Class<?> cls) {
        Restricted restriction = cls.getAnnotation(Restricted.class);
        return restriction == null ? null : restriction.value();
    }

    private String getDeprecationReason(Class<?> cls) {
        DeprecationNotice deprecationNotice = cls.getAnnotation(DeprecationNotice.class);
        return deprecationNotice == null ? null : deprecationNotice.reason();
    }

    public Set<AffectedComponentEntity> createAffectedComponentEntities(Set<ConfiguredComponent> affectedComponents, RevisionManager revisionManager) {
        return affectedComponents.stream().map(component -> {
            AffectedComponentDTO affectedComponent = this.createAffectedComponentDto(component);
            PermissionsDTO permissions = this.createPermissionsDto((Authorizable)component);
            RevisionDTO revision = this.createRevisionDTO(revisionManager.getRevision(component.getIdentifier()));
            return this.entityFactory.createAffectedComponentEntity(affectedComponent, revision, permissions);
        }).collect(Collectors.toSet());
    }

    public VariableRegistryDTO createVariableRegistryDto(ProcessGroup processGroup, RevisionManager revisionManager) {
        ComponentVariableRegistry variableRegistry = processGroup.getVariableRegistry();
        List variableNames = variableRegistry.getVariableMap().keySet().stream().map(descriptor -> descriptor.getName()).collect(Collectors.toList());
        LinkedHashSet<VariableEntity> variableEntities = new LinkedHashSet<VariableEntity>();
        for (String variableName : variableNames) {
            VariableDTO variableDto = new VariableDTO();
            variableDto.setName(variableName);
            variableDto.setValue(variableRegistry.getVariableValue(variableName));
            variableDto.setProcessGroupId(processGroup.getIdentifier());
            Set affectedComponentEntities = this.createAffectedComponentEntities(processGroup.getComponentsAffectedByVariable(variableName), revisionManager);
            boolean canWrite = true;
            for (AffectedComponentEntity affectedComponent : affectedComponentEntities) {
                PermissionsDTO permissions = affectedComponent.getPermissions();
                if (permissions.getCanRead().booleanValue() && permissions.getCanWrite().booleanValue()) continue;
                canWrite = false;
                break;
            }
            variableDto.setAffectedComponents(affectedComponentEntities);
            VariableEntity variableEntity = new VariableEntity();
            variableEntity.setVariable(variableDto);
            variableEntity.setCanWrite(Boolean.valueOf(canWrite));
            variableEntities.add(variableEntity);
        }
        VariableRegistryDTO registryDto = new VariableRegistryDTO();
        registryDto.setProcessGroupId(processGroup.getIdentifier());
        registryDto.setVariables(variableEntities);
        return registryDto;
    }

    public VariableRegistryUpdateRequestDTO createVariableRegistryUpdateRequestDto(VariableRegistryUpdateRequest request) {
        VariableRegistryUpdateRequestDTO dto = new VariableRegistryUpdateRequestDTO();
        dto.setComplete(request.isComplete());
        dto.setFailureReason(request.getFailureReason());
        dto.setLastUpdated(request.getLastUpdated());
        dto.setProcessGroupId(request.getProcessGroupId());
        dto.setRequestId(request.getRequestId());
        dto.setSubmissionTime(request.getSubmissionTime());
        ArrayList<VariableRegistryUpdateStepDTO> updateSteps = new ArrayList<VariableRegistryUpdateStepDTO>();
        updateSteps.add(this.createVariableRegistryUpdateStepDto(request.getIdentifyRelevantComponentsStep()));
        updateSteps.add(this.createVariableRegistryUpdateStepDto(request.getStopProcessorsStep()));
        updateSteps.add(this.createVariableRegistryUpdateStepDto(request.getDisableServicesStep()));
        updateSteps.add(this.createVariableRegistryUpdateStepDto(request.getApplyUpdatesStep()));
        updateSteps.add(this.createVariableRegistryUpdateStepDto(request.getEnableServicesStep()));
        updateSteps.add(this.createVariableRegistryUpdateStepDto(request.getStartProcessorsStep()));
        dto.setUpdateSteps(updateSteps);
        dto.setAffectedComponents(new HashSet(request.getAffectedComponents().values()));
        return dto;
    }

    public VariableRegistryUpdateStepDTO createVariableRegistryUpdateStepDto(VariableRegistryUpdateStep step) {
        VariableRegistryUpdateStepDTO dto = new VariableRegistryUpdateStepDTO();
        dto.setComplete(step.isComplete());
        dto.setDescription(step.getDescription());
        dto.setFailureReason(step.getFailureReason());
        return dto;
    }

    public VariableRegistryDTO populateAffectedComponents(VariableRegistryDTO variableRegistry, ProcessGroup group, RevisionManager revisionManager) {
        if (!group.getIdentifier().equals(variableRegistry.getProcessGroupId())) {
            throw new IllegalArgumentException("Variable Registry does not have the same Group ID as the given Process Group");
        }
        LinkedHashSet<VariableEntity> variableEntities = new LinkedHashSet<VariableEntity>();
        if (variableRegistry.getVariables() != null) {
            for (VariableEntity inputEntity : variableRegistry.getVariables()) {
                VariableEntity entity = new VariableEntity();
                VariableDTO inputDto = inputEntity.getVariable();
                VariableDTO variableDto = new VariableDTO();
                variableDto.setName(inputDto.getName());
                variableDto.setValue(inputDto.getValue());
                variableDto.setProcessGroupId(group.getIdentifier());
                Set affectedComponentEntities = this.createAffectedComponentEntities(group.getComponentsAffectedByVariable(variableDto.getName()), revisionManager);
                boolean canWrite = true;
                for (AffectedComponentEntity affectedComponent : affectedComponentEntities) {
                    PermissionsDTO permissions = affectedComponent.getPermissions();
                    if (permissions.getCanRead().booleanValue() && permissions.getCanWrite().booleanValue()) continue;
                    canWrite = false;
                    break;
                }
                variableDto.setAffectedComponents(affectedComponentEntities);
                entity.setCanWrite(Boolean.valueOf(canWrite));
                entity.setVariable(inputDto);
                variableEntities.add(entity);
            }
        }
        VariableRegistryDTO registryDto = new VariableRegistryDTO();
        registryDto.setProcessGroupId(group.getIdentifier());
        registryDto.setVariables(variableEntities);
        return registryDto;
    }

    private String getCapabilityDescription(Class<?> cls) {
        CapabilityDescription capabilityDesc = cls.getAnnotation(CapabilityDescription.class);
        return capabilityDesc == null ? null : capabilityDesc.value();
    }

    private Set<String> getTags(Class<?> cls) {
        HashSet<String> tags = new HashSet<String>();
        Tags tagsAnnotation = cls.getAnnotation(Tags.class);
        if (tagsAnnotation != null) {
            for (String tag : tagsAnnotation.value()) {
                tags.add(tag);
            }
        }
        return tags;
    }

    public BundleDTO createBundleDto(BundleCoordinate coordinate) {
        BundleDTO dto = new BundleDTO();
        dto.setGroup(coordinate.getGroup());
        dto.setArtifact(coordinate.getId());
        dto.setVersion(coordinate.getVersion());
        return dto;
    }

    private List<ControllerServiceApiDTO> createControllerServiceApiDto(Class cls) {
        HashSet<Class> serviceApis = new HashSet<Class>();
        if (ControllerService.class.isAssignableFrom(cls)) {
            List interfaces = ClassUtils.getAllInterfaces((Class)cls);
            for (Class i : interfaces) {
                if (!ControllerService.class.isAssignableFrom(i) || ControllerService.class.equals((Object)i)) continue;
                serviceApis.add(i);
            }
            ArrayList<ControllerServiceApiDTO> dtos = new ArrayList<ControllerServiceApiDTO>();
            for (Class serviceApi : serviceApis) {
                Bundle bundle = ExtensionManager.getBundle((ClassLoader)serviceApi.getClassLoader());
                BundleCoordinate bundleCoordinate = bundle.getBundleDetails().getCoordinate();
                ControllerServiceApiDTO dto = new ControllerServiceApiDTO();
                dto.setType(serviceApi.getName());
                dto.setBundle(this.createBundleDto(bundleCoordinate));
                dtos.add(dto);
            }
            return dtos;
        }
        return null;
    }

    public Set<DocumentedTypeDTO> fromDocumentedTypes(Map<Class, Bundle> classes, String bundleGroupFilter, String bundleArtifactFilter, String typeFilter) {
        LinkedHashSet<DocumentedTypeDTO> types = new LinkedHashSet<DocumentedTypeDTO>();
        ArrayList<Class> sortedClasses = new ArrayList<Class>(classes.keySet());
        Collections.sort(sortedClasses, CLASS_NAME_COMPARATOR);
        for (Class cls : sortedClasses) {
            Bundle bundle = classes.get(cls);
            BundleCoordinate coordinate = bundle.getBundleDetails().getCoordinate();
            if (bundleGroupFilter != null && !bundleGroupFilter.equals(coordinate.getGroup()) || bundleArtifactFilter != null && !bundleArtifactFilter.equals(coordinate.getId()) || typeFilter != null && !typeFilter.equals(cls.getName())) continue;
            DocumentedTypeDTO dto = new DocumentedTypeDTO();
            dto.setType(cls.getName());
            dto.setBundle(this.createBundleDto(coordinate));
            dto.setControllerServiceApis(this.createControllerServiceApiDto(cls));
            dto.setDescription(this.getCapabilityDescription(cls));
            dto.setUsageRestriction(this.getUsageRestriction(cls));
            dto.setDeprecationReason(this.getDeprecationReason(cls));
            dto.setTags(this.getTags(cls));
            types.add(dto);
        }
        return types;
    }

    public Set<DocumentedTypeDTO> fromDocumentedTypes(Set<Class> classes, String bundleGroupFilter, String bundleArtifactFilter, String typeFilter) {
        HashMap<Class, Bundle> classBundles = new HashMap<Class, Bundle>();
        for (Class cls : classes) {
            classBundles.put(cls, ExtensionManager.getBundle((ClassLoader)cls.getClassLoader()));
        }
        return this.fromDocumentedTypes(classBundles, bundleGroupFilter, bundleArtifactFilter, typeFilter);
    }

    public ProcessorDTO createProcessorDto(ProcessorNode node) {
        if (node == null) {
            return null;
        }
        BundleCoordinate bundleCoordinate = node.getBundleCoordinate();
        List compatibleBundles = ExtensionManager.getBundles((String)node.getCanonicalClassName()).stream().filter(bundle -> {
            BundleCoordinate coordinate = bundle.getBundleDetails().getCoordinate();
            return bundleCoordinate.getGroup().equals(coordinate.getGroup()) && bundleCoordinate.getId().equals(coordinate.getId());
        }).collect(Collectors.toList());
        ProcessorDTO dto = new ProcessorDTO();
        dto.setId(node.getIdentifier());
        dto.setPosition(this.createPositionDto(node.getPosition()));
        dto.setStyle(node.getStyle());
        dto.setParentGroupId(node.getProcessGroup().getIdentifier());
        dto.setInputRequirement(node.getInputRequirement().name());
        dto.setPersistsState(Boolean.valueOf(node.getProcessor().getClass().isAnnotationPresent(Stateful.class)));
        dto.setRestricted(Boolean.valueOf(node.isRestricted()));
        dto.setDeprecated(Boolean.valueOf(node.isDeprecated()));
        dto.setExtensionMissing(Boolean.valueOf(node.isExtensionMissing()));
        dto.setMultipleVersionsAvailable(Boolean.valueOf(compatibleBundles.size() > 1));
        dto.setType(node.getCanonicalClassName());
        dto.setBundle(this.createBundleDto(bundleCoordinate));
        dto.setName(node.getName());
        dto.setState(node.getScheduledState().toString());
        ArrayList<RelationshipDTO> relationships = new ArrayList<RelationshipDTO>();
        for (Relationship rel : node.getRelationships()) {
            RelationshipDTO relationshipDTO = new RelationshipDTO();
            relationshipDTO.setDescription(rel.getDescription());
            relationshipDTO.setName(rel.getName());
            relationshipDTO.setAutoTerminate(Boolean.valueOf(node.isAutoTerminated(rel)));
            relationships.add(relationshipDTO);
        }
        Collections.sort(relationships, new /* Unavailable Anonymous Inner Class!! */);
        dto.setRelationships(relationships);
        dto.setDescription(this.getCapabilityDescription(node.getClass()));
        dto.setSupportsParallelProcessing(Boolean.valueOf(!node.isTriggeredSerially()));
        dto.setSupportsEventDriven(Boolean.valueOf(node.isEventDrivenSupported()));
        dto.setSupportsBatching(Boolean.valueOf(node.isHighThroughputSupported()));
        dto.setConfig(this.createProcessorConfigDto(node));
        Collection validationErrors = node.getValidationErrors();
        if (validationErrors != null && !validationErrors.isEmpty()) {
            ArrayList<String> errors = new ArrayList<String>();
            for (ValidationResult validationResult : validationErrors) {
                errors.add(validationResult.toString());
            }
            dto.setValidationErrors(errors);
        }
        return dto;
    }

    public BulletinBoardDTO createBulletinBoardDto(List<BulletinEntity> bulletins) {
        Collections.sort(bulletins, new /* Unavailable Anonymous Inner Class!! */);
        BulletinBoardDTO bulletinBoard = new BulletinBoardDTO();
        bulletinBoard.setBulletins(bulletins);
        bulletinBoard.setGenerated(new Date());
        return bulletinBoard;
    }

    public List<BulletinDTO> createBulletinDtos(List<Bulletin> bulletins) {
        ArrayList<BulletinDTO> bulletinDtos = new ArrayList<BulletinDTO>(bulletins.size());
        for (Bulletin bulletin : bulletins) {
            bulletinDtos.add(this.createBulletinDto(bulletin));
        }
        return bulletinDtos;
    }

    public BulletinDTO createBulletinDto(Bulletin bulletin) {
        BulletinDTO dto = new BulletinDTO();
        dto.setId(Long.valueOf(bulletin.getId()));
        dto.setNodeAddress(bulletin.getNodeAddress());
        dto.setTimestamp(bulletin.getTimestamp());
        dto.setGroupId(bulletin.getGroupId());
        dto.setSourceId(bulletin.getSourceId());
        dto.setSourceName(bulletin.getSourceName());
        dto.setCategory(bulletin.getCategory());
        dto.setLevel(bulletin.getLevel());
        dto.setMessage(bulletin.getMessage());
        return dto;
    }

    public ProvenanceNodeDTO createProvenanceEventNodeDTO(ProvenanceEventLineageNode node) {
        ProvenanceNodeDTO dto = new ProvenanceNodeDTO();
        dto.setId(node.getIdentifier());
        dto.setType("EVENT");
        dto.setEventType(node.getEventType().toString());
        dto.setTimestamp(new Date(node.getTimestamp()));
        dto.setMillis(Long.valueOf(node.getTimestamp()));
        dto.setFlowFileUuid(node.getFlowFileUuid());
        dto.setParentUuids(node.getParentUuids());
        dto.setChildUuids(node.getChildUuids());
        return dto;
    }

    public ProvenanceNodeDTO createFlowFileNodeDTO(LineageNode node) {
        ProvenanceNodeDTO dto = new ProvenanceNodeDTO();
        dto.setId(node.getIdentifier());
        dto.setType("FLOWFILE");
        dto.setTimestamp(new Date(node.getTimestamp()));
        dto.setMillis(Long.valueOf(node.getTimestamp()));
        dto.setFlowFileUuid(node.getFlowFileUuid());
        return dto;
    }

    public ProvenanceLinkDTO createProvenanceLinkDTO(LineageEdge edge) {
        LineageNode source = edge.getSource();
        LineageNode target = edge.getDestination();
        ProvenanceLinkDTO dto = new ProvenanceLinkDTO();
        dto.setTimestamp(new Date(target.getTimestamp()));
        dto.setMillis(Long.valueOf(target.getTimestamp()));
        dto.setFlowFileUuid(edge.getUuid());
        dto.setSourceId(source.getIdentifier());
        dto.setTargetId(target.getIdentifier());
        return dto;
    }

    public LineageDTO createLineageDto(ComputeLineageSubmission computeLineageSubmission) {
        LineageDTO dto = new LineageDTO();
        LineageRequestDTO requestDto = new LineageRequestDTO();
        LineageResultsDTO resultsDto = new LineageResultsDTO();
        dto.setRequest(requestDto);
        dto.setResults(resultsDto);
        switch (9.$SwitchMap$org$apache$nifi$provenance$lineage$LineageComputationType[computeLineageSubmission.getLineageComputationType().ordinal()]) {
            case 1: {
                requestDto.setEventId(computeLineageSubmission.getExpandedEventId());
                requestDto.setLineageRequestType(LineageRequestDTO.LineageRequestType.CHILDREN);
                break;
            }
            case 2: {
                requestDto.setEventId(computeLineageSubmission.getExpandedEventId());
                requestDto.setLineageRequestType(LineageRequestDTO.LineageRequestType.PARENTS);
                break;
            }
            case 3: {
                Collection uuids = computeLineageSubmission.getLineageFlowFileUuids();
                if (uuids.size() == 1) {
                    requestDto.setUuid((String)uuids.iterator().next());
                }
                requestDto.setEventId(computeLineageSubmission.getExpandedEventId());
                requestDto.setLineageRequestType(LineageRequestDTO.LineageRequestType.FLOWFILE);
            }
        }
        dto.setId(computeLineageSubmission.getLineageIdentifier());
        dto.setSubmissionTime(computeLineageSubmission.getSubmissionTime());
        ComputeLineageResult results = computeLineageSubmission.getResult();
        dto.setFinished(Boolean.valueOf(results.isFinished()));
        dto.setPercentCompleted(Integer.valueOf(results.getPercentComplete()));
        dto.setExpiration(results.getExpiration());
        List nodes = results.getNodes();
        List edges = results.getEdges();
        ArrayList<ProvenanceNodeDTO> nodeDtos = new ArrayList<ProvenanceNodeDTO>();
        if (results.isFinished()) {
            for (LineageNode node : nodes) {
                switch (9.$SwitchMap$org$apache$nifi$provenance$lineage$LineageNodeType[node.getNodeType().ordinal()]) {
                    case 1: {
                        nodeDtos.add(this.createFlowFileNodeDTO(node));
                        break;
                    }
                    case 2: {
                        nodeDtos.add(this.createProvenanceEventNodeDTO((ProvenanceEventLineageNode)node));
                    }
                }
            }
        }
        resultsDto.setNodes(nodeDtos);
        if (results.getError() != null) {
            HashSet<String> errors = new HashSet<String>();
            errors.add(results.getError());
            resultsDto.setErrors(errors);
        }
        ArrayList<ProvenanceLinkDTO> linkDtos = new ArrayList<ProvenanceLinkDTO>();
        for (LineageEdge edge : edges) {
            linkDtos.add(this.createProvenanceLinkDTO(edge));
        }
        resultsDto.setLinks(linkDtos);
        return dto;
    }

    public SystemDiagnosticsDTO createSystemDiagnosticsDto(SystemDiagnostics sysDiagnostics) {
        SystemDiagnosticsDTO dto = new SystemDiagnosticsDTO();
        SystemDiagnosticsSnapshotDTO snapshot = new SystemDiagnosticsSnapshotDTO();
        dto.setAggregateSnapshot(snapshot);
        snapshot.setStatsLastRefreshed(new Date(sysDiagnostics.getCreationTimestamp()));
        snapshot.setAvailableProcessors(Integer.valueOf(sysDiagnostics.getAvailableProcessors()));
        snapshot.setProcessorLoadAverage(sysDiagnostics.getProcessorLoadAverage());
        snapshot.setDaemonThreads(Integer.valueOf(sysDiagnostics.getDaemonThreads()));
        snapshot.setTotalThreads(Integer.valueOf(sysDiagnostics.getTotalThreads()));
        snapshot.setMaxHeap(FormatUtils.formatDataSize((double)sysDiagnostics.getMaxHeap()));
        snapshot.setMaxHeapBytes(Long.valueOf(sysDiagnostics.getMaxHeap()));
        snapshot.setTotalHeap(FormatUtils.formatDataSize((double)sysDiagnostics.getTotalHeap()));
        snapshot.setTotalHeapBytes(Long.valueOf(sysDiagnostics.getTotalHeap()));
        snapshot.setUsedHeap(FormatUtils.formatDataSize((double)sysDiagnostics.getUsedHeap()));
        snapshot.setUsedHeapBytes(Long.valueOf(sysDiagnostics.getUsedHeap()));
        snapshot.setFreeHeap(FormatUtils.formatDataSize((double)sysDiagnostics.getFreeHeap()));
        snapshot.setFreeHeapBytes(Long.valueOf(sysDiagnostics.getFreeHeap()));
        if (sysDiagnostics.getHeapUtilization() != -1) {
            snapshot.setHeapUtilization(FormatUtils.formatUtilization((double)sysDiagnostics.getHeapUtilization()));
        }
        snapshot.setMaxNonHeap(FormatUtils.formatDataSize((double)sysDiagnostics.getMaxNonHeap()));
        snapshot.setMaxNonHeapBytes(Long.valueOf(sysDiagnostics.getMaxNonHeap()));
        snapshot.setTotalNonHeap(FormatUtils.formatDataSize((double)sysDiagnostics.getTotalNonHeap()));
        snapshot.setTotalNonHeapBytes(Long.valueOf(sysDiagnostics.getTotalNonHeap()));
        snapshot.setUsedNonHeap(FormatUtils.formatDataSize((double)sysDiagnostics.getUsedNonHeap()));
        snapshot.setUsedNonHeapBytes(Long.valueOf(sysDiagnostics.getUsedNonHeap()));
        snapshot.setFreeNonHeap(FormatUtils.formatDataSize((double)sysDiagnostics.getFreeNonHeap()));
        snapshot.setFreeNonHeapBytes(Long.valueOf(sysDiagnostics.getFreeNonHeap()));
        if (sysDiagnostics.getNonHeapUtilization() != -1) {
            snapshot.setNonHeapUtilization(FormatUtils.formatUtilization((double)sysDiagnostics.getNonHeapUtilization()));
        }
        SystemDiagnosticsSnapshotDTO.StorageUsageDTO flowFileRepositoryStorageUsageDto = this.createStorageUsageDTO(null, sysDiagnostics.getFlowFileRepositoryStorageUsage());
        snapshot.setFlowFileRepositoryStorageUsage(flowFileRepositoryStorageUsageDto);
        LinkedHashSet<SystemDiagnosticsSnapshotDTO.StorageUsageDTO> contentRepositoryStorageUsageDtos = new LinkedHashSet<SystemDiagnosticsSnapshotDTO.StorageUsageDTO>();
        snapshot.setContentRepositoryStorageUsage(contentRepositoryStorageUsageDtos);
        for (Map.Entry entry : sysDiagnostics.getContentRepositoryStorageUsage().entrySet()) {
            contentRepositoryStorageUsageDtos.add(this.createStorageUsageDTO((String)entry.getKey(), (StorageUsage)entry.getValue()));
        }
        LinkedHashSet<SystemDiagnosticsSnapshotDTO.StorageUsageDTO> provenanceRepositoryStorageUsageDtos = new LinkedHashSet<SystemDiagnosticsSnapshotDTO.StorageUsageDTO>();
        snapshot.setProvenanceRepositoryStorageUsage(provenanceRepositoryStorageUsageDtos);
        for (Map.Entry entry : sysDiagnostics.getProvenanceRepositoryStorageUsage().entrySet()) {
            provenanceRepositoryStorageUsageDtos.add(this.createStorageUsageDTO((String)entry.getKey(), (StorageUsage)entry.getValue()));
        }
        LinkedHashSet<SystemDiagnosticsSnapshotDTO.GarbageCollectionDTO> linkedHashSet = new LinkedHashSet<SystemDiagnosticsSnapshotDTO.GarbageCollectionDTO>();
        snapshot.setGarbageCollection(linkedHashSet);
        for (Map.Entry entry : sysDiagnostics.getGarbageCollection().entrySet()) {
            linkedHashSet.add(this.createGarbageCollectionDTO((String)entry.getKey(), (GarbageCollection)entry.getValue()));
        }
        SystemDiagnosticsSnapshotDTO.VersionInfoDTO versionInfoDTO = this.createVersionInfoDTO();
        snapshot.setVersionInfo(versionInfoDTO);
        snapshot.setUptime(FormatUtils.formatHoursMinutesSeconds((long)sysDiagnostics.getUptime(), (TimeUnit)TimeUnit.MILLISECONDS));
        return dto;
    }

    public SystemDiagnosticsSnapshotDTO.StorageUsageDTO createStorageUsageDTO(String identifier, StorageUsage storageUsage) {
        SystemDiagnosticsSnapshotDTO.StorageUsageDTO dto = new SystemDiagnosticsSnapshotDTO.StorageUsageDTO();
        dto.setIdentifier(identifier);
        dto.setFreeSpace(FormatUtils.formatDataSize((double)storageUsage.getFreeSpace()));
        dto.setTotalSpace(FormatUtils.formatDataSize((double)storageUsage.getTotalSpace()));
        dto.setUsedSpace(FormatUtils.formatDataSize((double)storageUsage.getUsedSpace()));
        dto.setFreeSpaceBytes(Long.valueOf(storageUsage.getFreeSpace()));
        dto.setTotalSpaceBytes(Long.valueOf(storageUsage.getTotalSpace()));
        dto.setUsedSpaceBytes(Long.valueOf(storageUsage.getUsedSpace()));
        dto.setUtilization(FormatUtils.formatUtilization((double)storageUsage.getDiskUtilization()));
        return dto;
    }

    public SystemDiagnosticsSnapshotDTO.GarbageCollectionDTO createGarbageCollectionDTO(String name, GarbageCollection garbageCollection) {
        SystemDiagnosticsSnapshotDTO.GarbageCollectionDTO dto = new SystemDiagnosticsSnapshotDTO.GarbageCollectionDTO();
        dto.setName(name);
        dto.setCollectionCount(garbageCollection.getCollectionCount());
        dto.setCollectionTime(FormatUtils.formatHoursMinutesSeconds((long)garbageCollection.getCollectionTime(), (TimeUnit)TimeUnit.MILLISECONDS));
        dto.setCollectionMillis(Long.valueOf(garbageCollection.getCollectionTime()));
        return dto;
    }

    public SystemDiagnosticsSnapshotDTO.VersionInfoDTO createVersionInfoDTO() {
        SystemDiagnosticsSnapshotDTO.VersionInfoDTO dto = new SystemDiagnosticsSnapshotDTO.VersionInfoDTO();
        dto.setJavaVendor(System.getProperty("java.vendor"));
        dto.setJavaVersion(System.getProperty("java.version"));
        dto.setOsName(System.getProperty("os.name"));
        dto.setOsVersion(System.getProperty("os.version"));
        dto.setOsArchitecture(System.getProperty("os.arch"));
        Bundle frameworkBundle = NarClassLoaders.getInstance().getFrameworkBundle();
        if (frameworkBundle != null) {
            BundleDetails frameworkDetails = frameworkBundle.getBundleDetails();
            dto.setNiFiVersion(frameworkDetails.getCoordinate().getVersion());
            dto.setBuildTag(frameworkDetails.getBuildTag());
            dto.setBuildRevision(frameworkDetails.getBuildRevision());
            dto.setBuildBranch(frameworkDetails.getBuildBranch());
            dto.setBuildTimestamp(frameworkDetails.getBuildTimestampDate());
        }
        return dto;
    }

    public ResourceDTO createResourceDto(Resource resource) {
        ResourceDTO dto = new ResourceDTO();
        dto.setIdentifier(resource.getIdentifier());
        dto.setName(resource.getName());
        return dto;
    }

    public ProcessorConfigDTO createProcessorConfigDto(ProcessorNode procNode) {
        if (procNode == null) {
            return null;
        }
        ProcessorConfigDTO dto = new ProcessorConfigDTO();
        TreeMap sortedProperties = new TreeMap(new /* Unavailable Anonymous Inner Class!! */);
        sortedProperties.putAll(procNode.getProperties());
        Processor processor = procNode.getProcessor();
        LinkedHashMap orderedProperties = new LinkedHashMap();
        List descriptors = processor.getPropertyDescriptors();
        if (descriptors != null && !descriptors.isEmpty()) {
            for (PropertyDescriptor propertyDescriptor : descriptors) {
                orderedProperties.put(propertyDescriptor, null);
            }
        }
        orderedProperties.putAll(sortedProperties);
        dto.setDescriptors(new LinkedHashMap());
        dto.setProperties(new LinkedHashMap());
        for (Map.Entry entry : orderedProperties.entrySet()) {
            PropertyDescriptor descriptor = (PropertyDescriptor)entry.getKey();
            dto.getDescriptors().put(descriptor.getName(), this.createPropertyDescriptorDto(descriptor, procNode.getProcessGroup().getIdentifier()));
            String propertyValue = (String)entry.getValue();
            if (propertyValue != null && descriptor.isSensitive()) {
                propertyValue = SENSITIVE_VALUE_MASK;
            } else if (propertyValue == null && descriptor.getDefaultValue() != null) {
                propertyValue = descriptor.getDefaultValue();
            }
            dto.getProperties().put(descriptor.getName(), propertyValue);
        }
        dto.setSchedulingPeriod(procNode.getSchedulingPeriod());
        dto.setPenaltyDuration(procNode.getPenalizationPeriod());
        dto.setYieldDuration(procNode.getYieldPeriod());
        dto.setRunDurationMillis(Long.valueOf(procNode.getRunDuration(TimeUnit.MILLISECONDS)));
        dto.setConcurrentlySchedulableTaskCount(Integer.valueOf(procNode.getMaxConcurrentTasks()));
        dto.setLossTolerant(Boolean.valueOf(procNode.isLossTolerant()));
        dto.setComments(procNode.getComments());
        dto.setBulletinLevel(procNode.getBulletinLevel().name());
        dto.setSchedulingStrategy(procNode.getSchedulingStrategy().name());
        dto.setExecutionNode(procNode.getExecutionNode().name());
        dto.setAnnotationData(procNode.getAnnotationData());
        HashMap<String, String> defaultConcurrentTasks = new HashMap<String, String>();
        defaultConcurrentTasks.put(SchedulingStrategy.TIMER_DRIVEN.name(), String.valueOf(SchedulingStrategy.TIMER_DRIVEN.getDefaultConcurrentTasks()));
        defaultConcurrentTasks.put(SchedulingStrategy.EVENT_DRIVEN.name(), String.valueOf(SchedulingStrategy.EVENT_DRIVEN.getDefaultConcurrentTasks()));
        defaultConcurrentTasks.put(SchedulingStrategy.CRON_DRIVEN.name(), String.valueOf(SchedulingStrategy.CRON_DRIVEN.getDefaultConcurrentTasks()));
        dto.setDefaultConcurrentTasks(defaultConcurrentTasks);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(SchedulingStrategy.TIMER_DRIVEN.name(), SchedulingStrategy.TIMER_DRIVEN.getDefaultSchedulingPeriod());
        hashMap.put(SchedulingStrategy.CRON_DRIVEN.name(), SchedulingStrategy.CRON_DRIVEN.getDefaultSchedulingPeriod());
        dto.setDefaultSchedulingPeriod(hashMap);
        return dto;
    }

    public PropertyDescriptorDTO createPropertyDescriptorDto(PropertyDescriptor propertyDescriptor, String groupId) {
        ArrayList<AllowableValueEntity> allowableValues;
        if (propertyDescriptor == null) {
            return null;
        }
        PropertyDescriptorDTO dto = new PropertyDescriptorDTO();
        dto.setName(propertyDescriptor.getName());
        dto.setDisplayName(propertyDescriptor.getDisplayName());
        dto.setRequired(Boolean.valueOf(propertyDescriptor.isRequired()));
        dto.setSensitive(Boolean.valueOf(propertyDescriptor.isSensitive()));
        dto.setDynamic(Boolean.valueOf(propertyDescriptor.isDynamic()));
        dto.setDescription(propertyDescriptor.getDescription());
        dto.setDefaultValue(propertyDescriptor.getDefaultValue());
        dto.setSupportsEl(Boolean.valueOf(propertyDescriptor.isExpressionLanguageSupported()));
        if (propertyDescriptor.getControllerServiceDefinition() != null) {
            Class serviceClass = propertyDescriptor.getControllerServiceDefinition();
            Bundle serviceBundle = ExtensionManager.getBundle((ClassLoader)serviceClass.getClassLoader());
            dto.setIdentifiesControllerService(serviceClass.getName());
            dto.setIdentifiesControllerServiceBundle(this.createBundleDto(serviceBundle.getBundleDetails().getCoordinate()));
        }
        Class serviceDefinition = propertyDescriptor.getControllerServiceDefinition();
        if (propertyDescriptor.getAllowableValues() == null) {
            if (serviceDefinition == null) {
                dto.setAllowableValues(null);
            } else {
                allowableValues = new ArrayList();
                ArrayList controllerServiceIdentifiers = new ArrayList(this.controllerServiceProvider.getControllerServiceIdentifiers(serviceDefinition, groupId));
                Collections.sort(controllerServiceIdentifiers, Collator.getInstance(Locale.US));
                for (String serviceIdentifier : controllerServiceIdentifiers) {
                    ControllerServiceNode service = this.controllerServiceProvider.getControllerServiceNode(serviceIdentifier);
                    boolean isServiceAuthorized = service.isAuthorized(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
                    String displayName = isServiceAuthorized ? service.getName() : serviceIdentifier;
                    AllowableValueDTO allowableValue = new AllowableValueDTO();
                    allowableValue.setDisplayName(displayName);
                    allowableValue.setValue(serviceIdentifier);
                    allowableValues.add(this.entityFactory.createAllowableValueEntity(allowableValue, isServiceAuthorized));
                }
                dto.setAllowableValues(allowableValues);
            }
        } else {
            allowableValues = new ArrayList<AllowableValueEntity>();
            for (AllowableValue allowableValue : propertyDescriptor.getAllowableValues()) {
                AllowableValueDTO allowableValueDto = new AllowableValueDTO();
                allowableValueDto.setDisplayName(allowableValue.getDisplayName());
                allowableValueDto.setValue(allowableValue.getValue());
                allowableValueDto.setDescription(allowableValue.getDescription());
                allowableValues.add(this.entityFactory.createAllowableValueEntity(allowableValueDto, true));
            }
            dto.setAllowableValues(allowableValues);
        }
        return dto;
    }

    public LabelDTO copy(LabelDTO original) {
        LabelDTO copy = new LabelDTO();
        copy.setId(original.getId());
        copy.setParentGroupId(original.getParentGroupId());
        copy.setLabel(original.getLabel());
        copy.setStyle(this.copy(original.getStyle()));
        copy.setPosition(original.getPosition());
        copy.setWidth(original.getWidth());
        copy.setHeight(original.getHeight());
        return copy;
    }

    public ControllerServiceDTO copy(ControllerServiceDTO original) {
        ControllerServiceDTO copy = new ControllerServiceDTO();
        copy.setAnnotationData(original.getAnnotationData());
        copy.setControllerServiceApis(original.getControllerServiceApis());
        copy.setComments(original.getComments());
        copy.setCustomUiUrl(original.getCustomUiUrl());
        copy.setDescriptors(this.copy(original.getDescriptors()));
        copy.setId(original.getId());
        copy.setParentGroupId(original.getParentGroupId());
        copy.setName(original.getName());
        copy.setProperties(this.copy(original.getProperties()));
        copy.setReferencingComponents(this.copy(original.getReferencingComponents()));
        copy.setState(original.getState());
        copy.setType(original.getType());
        copy.setBundle(this.copy(original.getBundle()));
        copy.setExtensionMissing(original.getExtensionMissing());
        copy.setMultipleVersionsAvailable(original.getMultipleVersionsAvailable());
        copy.setPersistsState(original.getPersistsState());
        copy.setValidationErrors((Collection)this.copy(original.getValidationErrors()));
        return copy;
    }

    public FunnelDTO copy(FunnelDTO original) {
        FunnelDTO copy = new FunnelDTO();
        copy.setId(original.getId());
        copy.setParentGroupId(original.getParentGroupId());
        copy.setPosition(original.getPosition());
        return copy;
    }

    private <T> List<T> copy(List<T> original) {
        if (original == null) {
            return null;
        }
        return new ArrayList<T>(original);
    }

    private <T> List<T> copy(Collection<T> original) {
        if (original == null) {
            return null;
        }
        return new ArrayList<T>(original);
    }

    private <T> Set<T> copy(Set<T> original) {
        if (original == null) {
            return null;
        }
        return new LinkedHashSet<T>(original);
    }

    private <S, T> Map<S, T> copy(Map<S, T> original) {
        if (original == null) {
            return null;
        }
        return new LinkedHashMap<S, T>(original);
    }

    public BundleDTO copy(BundleDTO original) {
        if (original == null) {
            return null;
        }
        BundleDTO copy = new BundleDTO();
        copy.setGroup(original.getGroup());
        copy.setArtifact(original.getArtifact());
        copy.setVersion(original.getVersion());
        return copy;
    }

    public ProcessorDTO copy(ProcessorDTO original) {
        ProcessorDTO copy = new ProcessorDTO();
        copy.setConfig(this.copy(original.getConfig()));
        copy.setPosition(original.getPosition());
        copy.setId(original.getId());
        copy.setName(original.getName());
        copy.setDescription(original.getDescription());
        copy.setParentGroupId(original.getParentGroupId());
        copy.setRelationships(this.copy(original.getRelationships()));
        copy.setState(original.getState());
        copy.setStyle(this.copy(original.getStyle()));
        copy.setType(original.getType());
        copy.setBundle(this.copy(original.getBundle()));
        copy.setSupportsParallelProcessing(original.getSupportsParallelProcessing());
        copy.setSupportsEventDriven(original.getSupportsEventDriven());
        copy.setSupportsBatching(original.getSupportsBatching());
        copy.setPersistsState(original.getPersistsState());
        copy.setExtensionMissing(original.getExtensionMissing());
        copy.setMultipleVersionsAvailable(original.getMultipleVersionsAvailable());
        copy.setValidationErrors((Collection)this.copy(original.getValidationErrors()));
        return copy;
    }

    private ProcessorConfigDTO copy(ProcessorConfigDTO original) {
        ProcessorConfigDTO copy = new ProcessorConfigDTO();
        copy.setAnnotationData(original.getAnnotationData());
        copy.setAutoTerminatedRelationships(this.copy(original.getAutoTerminatedRelationships()));
        copy.setComments(original.getComments());
        copy.setSchedulingStrategy(original.getSchedulingStrategy());
        copy.setExecutionNode(original.getExecutionNode());
        copy.setConcurrentlySchedulableTaskCount(original.getConcurrentlySchedulableTaskCount());
        copy.setCustomUiUrl(original.getCustomUiUrl());
        copy.setDescriptors(this.copy(original.getDescriptors()));
        copy.setProperties(this.copy(original.getProperties()));
        copy.setSchedulingPeriod(original.getSchedulingPeriod());
        copy.setPenaltyDuration(original.getPenaltyDuration());
        copy.setYieldDuration(original.getYieldDuration());
        copy.setRunDurationMillis(original.getRunDurationMillis());
        copy.setBulletinLevel(original.getBulletinLevel());
        copy.setDefaultConcurrentTasks(original.getDefaultConcurrentTasks());
        copy.setDefaultSchedulingPeriod(original.getDefaultSchedulingPeriod());
        copy.setLossTolerant(original.isLossTolerant());
        return copy;
    }

    public ConnectionDTO copy(ConnectionDTO original) {
        ConnectionDTO copy = new ConnectionDTO();
        copy.setAvailableRelationships(this.copy(original.getAvailableRelationships()));
        copy.setDestination(original.getDestination());
        copy.setPosition(original.getPosition());
        copy.setId(original.getId());
        copy.setName(original.getName());
        copy.setParentGroupId(original.getParentGroupId());
        copy.setSelectedRelationships(this.copy(original.getSelectedRelationships()));
        copy.setFlowFileExpiration(original.getFlowFileExpiration());
        copy.setBackPressureObjectThreshold(original.getBackPressureObjectThreshold());
        copy.setBackPressureDataSizeThreshold(original.getBackPressureDataSizeThreshold());
        copy.setPrioritizers(this.copy(original.getPrioritizers()));
        copy.setSource(original.getSource());
        copy.setzIndex(original.getzIndex());
        copy.setLabelIndex(original.getLabelIndex());
        copy.setBends(this.copy(original.getBends()));
        return copy;
    }

    public BulletinDTO copy(BulletinDTO original) {
        BulletinDTO copy = new BulletinDTO();
        copy.setId(original.getId());
        copy.setTimestamp(original.getTimestamp());
        copy.setGroupId(original.getGroupId());
        copy.setSourceId(original.getSourceId());
        copy.setSourceName(original.getSourceName());
        copy.setCategory(original.getCategory());
        copy.setLevel(original.getLevel());
        copy.setMessage(original.getMessage());
        copy.setNodeAddress(original.getNodeAddress());
        return copy;
    }

    public PortDTO copy(PortDTO original) {
        PortDTO copy = new PortDTO();
        copy.setPosition(original.getPosition());
        copy.setId(original.getId());
        copy.setName(original.getName());
        copy.setComments(original.getComments());
        copy.setParentGroupId(original.getParentGroupId());
        copy.setState(original.getState());
        copy.setType(original.getType());
        copy.setTransmitting(original.isTransmitting());
        copy.setConcurrentlySchedulableTaskCount(original.getConcurrentlySchedulableTaskCount());
        copy.setUserAccessControl(this.copy(original.getUserAccessControl()));
        copy.setGroupAccessControl(this.copy(original.getGroupAccessControl()));
        copy.setValidationErrors((Collection)this.copy(original.getValidationErrors()));
        return copy;
    }

    public RemoteProcessGroupPortDTO copy(RemoteProcessGroupPortDTO original) {
        RemoteProcessGroupPortDTO copy = new RemoteProcessGroupPortDTO();
        copy.setId(original.getId());
        copy.setGroupId(original.getGroupId());
        copy.setName(original.getName());
        copy.setComments(original.getComments());
        copy.setConnected(original.isConnected());
        copy.setTargetRunning(original.isTargetRunning());
        copy.setTransmitting(original.isTransmitting());
        copy.setConcurrentlySchedulableTaskCount(original.getConcurrentlySchedulableTaskCount());
        copy.setUseCompression(original.getUseCompression());
        copy.setExists(original.getExists());
        BatchSettingsDTO batchOrg = original.getBatchSettings();
        if (batchOrg != null) {
            BatchSettingsDTO batchCopy = new BatchSettingsDTO();
            batchCopy.setCount(batchOrg.getCount());
            batchCopy.setSize(batchOrg.getSize());
            batchCopy.setDuration(batchOrg.getDuration());
        }
        return copy;
    }

    public ProcessGroupDTO copy(ProcessGroupDTO original, boolean deep) {
        ProcessGroupDTO copy = new ProcessGroupDTO();
        copy.setComments(original.getComments());
        copy.setContents(this.copy(original.getContents(), deep));
        copy.setPosition(original.getPosition());
        copy.setId(original.getId());
        copy.setInputPortCount(original.getInputPortCount());
        copy.setInvalidCount(original.getInvalidCount());
        copy.setName(original.getName());
        copy.setOutputPortCount(original.getOutputPortCount());
        copy.setParentGroupId(original.getParentGroupId());
        copy.setRunningCount(original.getRunningCount());
        copy.setStoppedCount(original.getStoppedCount());
        copy.setDisabledCount(original.getDisabledCount());
        copy.setActiveRemotePortCount(original.getActiveRemotePortCount());
        copy.setInactiveRemotePortCount(original.getInactiveRemotePortCount());
        if (original.getVariables() != null) {
            copy.setVariables(new HashMap(original.getVariables()));
        }
        return copy;
    }

    public RemoteProcessGroupDTO copy(RemoteProcessGroupDTO original) {
        RemoteProcessGroupContentsDTO originalContents = original.getContents();
        RemoteProcessGroupContentsDTO copyContents = new RemoteProcessGroupContentsDTO();
        if (originalContents.getInputPorts() != null) {
            HashSet<RemoteProcessGroupPortDTO> inputPorts = new HashSet<RemoteProcessGroupPortDTO>();
            for (RemoteProcessGroupPortDTO port : originalContents.getInputPorts()) {
                inputPorts.add(this.copy(port));
            }
            copyContents.setInputPorts(inputPorts);
        }
        if (originalContents.getOutputPorts() != null) {
            HashSet<RemoteProcessGroupPortDTO> outputPorts = new HashSet<RemoteProcessGroupPortDTO>();
            for (RemoteProcessGroupPortDTO port : originalContents.getOutputPorts()) {
                outputPorts.add(this.copy(port));
            }
            copyContents.setOutputPorts(outputPorts);
        }
        RemoteProcessGroupDTO copy = new RemoteProcessGroupDTO();
        copy.setComments(original.getComments());
        copy.setPosition(original.getPosition());
        copy.setId(original.getId());
        copy.setCommunicationsTimeout(original.getCommunicationsTimeout());
        copy.setYieldDuration(original.getYieldDuration());
        copy.setName(original.getName());
        copy.setInputPortCount(original.getInputPortCount());
        copy.setOutputPortCount(original.getOutputPortCount());
        copy.setActiveRemoteInputPortCount(original.getActiveRemoteInputPortCount());
        copy.setInactiveRemoteInputPortCount(original.getInactiveRemoteInputPortCount());
        copy.setActiveRemoteOutputPortCount(original.getActiveRemoteOutputPortCount());
        copy.setInactiveRemoteOutputPortCount(original.getInactiveRemoteOutputPortCount());
        copy.setParentGroupId(original.getParentGroupId());
        copy.setTargetUris(original.getTargetUris());
        copy.setTransportProtocol(original.getTransportProtocol());
        copy.setProxyHost(original.getProxyHost());
        copy.setProxyPort(original.getProxyPort());
        copy.setProxyUser(original.getProxyUser());
        copy.setProxyPassword(original.getProxyPassword());
        copy.setLocalNetworkInterface(original.getLocalNetworkInterface());
        copy.setContents(copyContents);
        return copy;
    }

    public ConnectableDTO createConnectableDto(PortDTO port, ConnectableType type) {
        ConnectableDTO connectable = new ConnectableDTO();
        connectable.setGroupId(port.getParentGroupId());
        connectable.setId(port.getId());
        connectable.setName(port.getName());
        connectable.setType(type.name());
        return connectable;
    }

    public ConnectableDTO createConnectableDto(ProcessorDTO processor) {
        ConnectableDTO connectable = new ConnectableDTO();
        connectable.setGroupId(processor.getParentGroupId());
        connectable.setId(processor.getId());
        connectable.setName(processor.getName());
        connectable.setType(ConnectableType.PROCESSOR.name());
        return connectable;
    }

    public ConnectableDTO createConnectableDto(FunnelDTO funnel) {
        ConnectableDTO connectable = new ConnectableDTO();
        connectable.setGroupId(funnel.getParentGroupId());
        connectable.setId(funnel.getId());
        connectable.setType(ConnectableType.FUNNEL.name());
        return connectable;
    }

    public ConnectableDTO createConnectableDto(RemoteProcessGroupPortDTO remoteGroupPort, ConnectableType type) {
        ConnectableDTO connectable = new ConnectableDTO();
        connectable.setGroupId(remoteGroupPort.getGroupId());
        connectable.setId(remoteGroupPort.getId());
        connectable.setName(remoteGroupPort.getName());
        connectable.setType(type.name());
        return connectable;
    }

    private FlowSnippetDTO copy(FlowSnippetDTO original, boolean deep) {
        FlowSnippetDTO copy = new FlowSnippetDTO();
        LinkedHashSet<ConnectionDTO> connections = new LinkedHashSet<ConnectionDTO>();
        LinkedHashSet<ProcessGroupDTO> groups = new LinkedHashSet<ProcessGroupDTO>();
        LinkedHashSet<PortDTO> inputPorts = new LinkedHashSet<PortDTO>();
        LinkedHashSet<PortDTO> outputPorts = new LinkedHashSet<PortDTO>();
        LinkedHashSet<LabelDTO> labels = new LinkedHashSet<LabelDTO>();
        LinkedHashSet<ProcessorDTO> processors = new LinkedHashSet<ProcessorDTO>();
        LinkedHashSet<RemoteProcessGroupDTO> remoteProcessGroups = new LinkedHashSet<RemoteProcessGroupDTO>();
        LinkedHashSet<FunnelDTO> funnels = new LinkedHashSet<FunnelDTO>();
        LinkedHashSet<ControllerServiceDTO> controllerServices = new LinkedHashSet<ControllerServiceDTO>();
        if (deep) {
            for (ProcessGroupDTO group : original.getProcessGroups()) {
                groups.add(this.copy(group, deep));
            }
            for (PortDTO port : original.getInputPorts()) {
                inputPorts.add(this.copy(port));
            }
            for (PortDTO port : original.getOutputPorts()) {
                outputPorts.add(this.copy(port));
            }
            for (LabelDTO label : original.getLabels()) {
                labels.add(this.copy(label));
            }
            for (ProcessorDTO processor : original.getProcessors()) {
                processors.add(this.copy(processor));
            }
            for (RemoteProcessGroupDTO remoteGroup : original.getRemoteProcessGroups()) {
                remoteProcessGroups.add(this.copy(remoteGroup));
            }
            for (FunnelDTO funnel : original.getFunnels()) {
                funnels.add(this.copy(funnel));
            }
            for (ConnectionDTO connection : original.getConnections()) {
                connections.add(this.copy(connection));
            }
            for (ControllerServiceDTO controllerService : original.getControllerServices()) {
                controllerServices.add(this.copy(controllerService));
            }
        } else {
            if (original.getConnections() != null) {
                connections.addAll(this.copy(original.getConnections()));
            }
            if (original.getProcessGroups() != null) {
                groups.addAll(this.copy(original.getProcessGroups()));
            }
            if (original.getInputPorts() != null) {
                inputPorts.addAll(this.copy(original.getInputPorts()));
            }
            if (original.getOutputPorts() != null) {
                outputPorts.addAll(this.copy(original.getOutputPorts()));
            }
            if (original.getLabels() != null) {
                labels.addAll(this.copy(original.getLabels()));
            }
            if (original.getProcessors() != null) {
                processors.addAll(this.copy(original.getProcessors()));
            }
            if (original.getRemoteProcessGroups() != null) {
                remoteProcessGroups.addAll(this.copy(original.getRemoteProcessGroups()));
            }
            if (original.getFunnels() != null) {
                funnels.addAll(this.copy(original.getFunnels()));
            }
            if (original.getControllerServices() != null) {
                controllerServices.addAll(this.copy(original.getControllerServices()));
            }
        }
        copy.setConnections(connections);
        copy.setProcessGroups(groups);
        copy.setInputPorts(inputPorts);
        copy.setLabels(labels);
        copy.setOutputPorts(outputPorts);
        copy.setProcessors(processors);
        copy.setRemoteProcessGroups(remoteProcessGroups);
        copy.setFunnels(funnels);
        copy.setControllerServices(controllerServices);
        return copy;
    }

    public RevisionDTO createRevisionDTO(FlowModification lastMod) {
        Revision revision = lastMod.getRevision();
        RevisionDTO revisionDTO = new RevisionDTO();
        revisionDTO.setVersion(revision.getVersion());
        revisionDTO.setClientId(revision.getClientId());
        revisionDTO.setLastModifier(lastMod.getLastModifier());
        return revisionDTO;
    }

    public RevisionDTO createRevisionDTO(Revision revision) {
        RevisionDTO dto = new RevisionDTO();
        dto.setVersion(revision.getVersion());
        dto.setClientId(revision.getClientId());
        return dto;
    }

    public NodeDTO createNodeDTO(NodeIdentifier nodeId, NodeConnectionStatus status, NodeHeartbeat nodeHeartbeat, List<NodeEvent> events, Set<String> roles) {
        NodeDTO nodeDto = new NodeDTO();
        nodeDto.setNodeId(nodeId.getId());
        nodeDto.setAddress(nodeId.getApiAddress());
        nodeDto.setApiPort(Integer.valueOf(nodeId.getApiPort()));
        nodeDto.setStatus(status.getState().name());
        nodeDto.setRoles(roles);
        if (status.getConnectionRequestTime() != null) {
            Date connectionRequested = new Date(status.getConnectionRequestTime());
            nodeDto.setConnectionRequested(connectionRequested);
        }
        if (nodeHeartbeat != null) {
            Date heartbeat = new Date(nodeHeartbeat.getTimestamp());
            nodeDto.setHeartbeat(heartbeat);
            nodeDto.setNodeStartTime(new Date(nodeHeartbeat.getSystemStartTime()));
            nodeDto.setActiveThreadCount(Integer.valueOf(nodeHeartbeat.getActiveThreadCount()));
            nodeDto.setQueued(FormatUtils.formatCount((long)nodeHeartbeat.getFlowFileCount()) + " / " + FormatUtils.formatDataSize((double)nodeHeartbeat.getFlowFileBytes()));
        }
        ArrayList<NodeEvent> nodeEvents = new ArrayList<NodeEvent>(events);
        Collections.sort(nodeEvents, new /* Unavailable Anonymous Inner Class!! */);
        ArrayList<NodeEventDTO> nodeEventDtos = new ArrayList<NodeEventDTO>();
        for (NodeEvent event : nodeEvents) {
            NodeEventDTO nodeEventDto = new NodeEventDTO();
            nodeEventDtos.add(nodeEventDto);
            nodeEventDto.setMessage(event.getMessage());
            nodeEventDto.setCategory(event.getSeverity().name());
            nodeEventDto.setTimestamp(new Date(event.getTimestamp()));
        }
        nodeDto.setEvents(nodeEventDtos);
        return nodeDto;
    }

    public void setControllerServiceProvider(ControllerServiceProvider controllerServiceProvider) {
        this.controllerServiceProvider = controllerServiceProvider;
    }

    public void setAuthorizer(Authorizer authorizer) {
        this.authorizer = authorizer;
    }

    public void setEntityFactory(EntityFactory entityFactory) {
        this.entityFactory = entityFactory;
    }

    public void setBulletinRepository(BulletinRepository bulletinRepository) {
        this.bulletinRepository = bulletinRepository;
    }

    public void setProperties(NiFiProperties properties) {
        this.properties = properties;
    }
}

