/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import com.wordnik.swagger.annotations.Authorization;
import java.net.URI;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.nifi.cluster.coordination.ClusterCoordinator;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.controller.repository.claim.ContentDirection;
import org.apache.nifi.web.DownloadableContent;
import org.apache.nifi.web.NiFiServiceFacade;
import org.apache.nifi.web.api.ApplicationResource;
import org.apache.nifi.web.api.ProvenanceEventResource;
import org.apache.nifi.web.api.dto.provenance.ProvenanceEventDTO;
import org.apache.nifi.web.api.entity.ProvenanceEventEntity;
import org.apache.nifi.web.api.entity.SubmitReplayRequestEntity;
import org.apache.nifi.web.api.request.LongParameter;

@Path(value="/provenance-events")
@Api(value="/provenance-events", description="Endpoint for accessing data flow provenance.")
public class ProvenanceEventResource
extends ApplicationResource {
    private NiFiServiceFacade serviceFacade;

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"*/*"})
    @Path(value="{id}/content/input")
    @ApiOperation(value="Gets the input content for a provenance event", response=StreamingOutput.class, authorizations={@Authorization(value="Read Component Data - /data/{component-type}/{uuid}", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getInputContent(@ApiParam(value="The id of the node where the content exists if clustered.", required=false) @QueryParam(value="clusterNodeId") String clusterNodeId, @ApiParam(value="The provenance event id.", required=true) @PathParam(value="id") LongParameter id) {
        if (id == null) {
            throw new IllegalArgumentException("The event id must be specified.");
        }
        if (this.isReplicateRequest()) {
            if (clusterNodeId == null) {
                throw new IllegalArgumentException("The id of the node in the cluster is required.");
            }
            return this.replicate("GET", clusterNodeId);
        }
        String uri = this.generateResourceUri(new String[]{"provenance", "events", String.valueOf(id.getLong()), "content", "input"});
        DownloadableContent content = this.serviceFacade.getContent(id.getLong(), uri, ContentDirection.INPUT);
        1 response = new /* Unavailable Anonymous Inner Class!! */;
        String contentType = content.getType();
        if (contentType == null) {
            contentType = "application/octet-stream";
        }
        return this.generateOkResponse((Object)response).type(contentType).header("Content-Disposition", (Object)String.format("attachment; filename=\"%s\"", content.getFilename())).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"*/*"})
    @Path(value="{id}/content/output")
    @ApiOperation(value="Gets the output content for a provenance event", response=StreamingOutput.class, authorizations={@Authorization(value="Read Component Data - /data/{component-type}/{uuid}", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getOutputContent(@ApiParam(value="The id of the node where the content exists if clustered.", required=false) @QueryParam(value="clusterNodeId") String clusterNodeId, @ApiParam(value="The provenance event id.", required=true) @PathParam(value="id") LongParameter id) {
        if (id == null) {
            throw new IllegalArgumentException("The event id must be specified.");
        }
        if (this.isReplicateRequest()) {
            if (clusterNodeId == null) {
                throw new IllegalArgumentException("The id of the node in the cluster is required.");
            }
            return this.replicate("GET", clusterNodeId);
        }
        String uri = this.generateResourceUri(new String[]{"provenance", "events", String.valueOf(id.getLong()), "content", "output"});
        DownloadableContent content = this.serviceFacade.getContent(id.getLong(), uri, ContentDirection.OUTPUT);
        2 response = new /* Unavailable Anonymous Inner Class!! */;
        String contentType = content.getType();
        if (contentType == null) {
            contentType = "application/octet-stream";
        }
        return this.generateOkResponse((Object)response).type(contentType).header("Content-Disposition", (Object)String.format("attachment; filename=\"%s\"", content.getFilename())).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}")
    @ApiOperation(value="Gets a provenance event", response=ProvenanceEventEntity.class, authorizations={@Authorization(value="Read Component Data - /data/{component-type}/{uuid}", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getProvenanceEvent(@ApiParam(value="The id of the node where this event exists if clustered.", required=false) @QueryParam(value="clusterNodeId") String clusterNodeId, @ApiParam(value="The provenance event id.", required=true) @PathParam(value="id") LongParameter id) {
        if (id == null) {
            throw new IllegalArgumentException("Provenance event id must be specified.");
        }
        if (this.isReplicateRequest()) {
            if (clusterNodeId == null) {
                throw new IllegalArgumentException("The cluster node identifier must be specified.");
            }
            return this.replicate("GET", clusterNodeId);
        }
        ProvenanceEventDTO event = this.serviceFacade.getProvenanceEvent(id.getLong());
        event.setClusterNodeId(clusterNodeId);
        ClusterCoordinator coordinator = this.getClusterCoordinator();
        if (coordinator != null) {
            NodeIdentifier nodeId = coordinator.getNodeIdentifier(clusterNodeId);
            event.setClusterNodeAddress(nodeId.getApiAddress() + ":" + nodeId.getApiPort());
        }
        ProvenanceEventEntity entity = new ProvenanceEventEntity();
        entity.setProvenanceEvent(event);
        return this.generateOkResponse((Object)entity).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="replays")
    @ApiOperation(value="Replays content from a provenance event", response=ProvenanceEventEntity.class, authorizations={@Authorization(value="Read Component Data - /data/{component-type}/{uuid}", type=""), @Authorization(value="Write Component Data - /data/{component-type}/{uuid}", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response submitReplay(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The replay request.", required=true) SubmitReplayRequestEntity replayRequestEntity) {
        if (replayRequestEntity == null || replayRequestEntity.getEventId() == null) {
            throw new IllegalArgumentException("The id of the event must be specified.");
        }
        if (this.isReplicateRequest()) {
            if (replayRequestEntity.getClusterNodeId() == null) {
                throw new IllegalArgumentException("The id of the node in the cluster is required.");
            }
            return this.replicate("POST", (Object)replayRequestEntity, replayRequestEntity.getClusterNodeId());
        }
        String expects = httpServletRequest.getHeader("X-Validation-Expects");
        if (expects != null) {
            return this.generateContinueResponse().build();
        }
        ProvenanceEventDTO event = this.serviceFacade.submitReplay(replayRequestEntity.getEventId());
        event.setClusterNodeId(replayRequestEntity.getClusterNodeId());
        ClusterCoordinator coordinator = this.getClusterCoordinator();
        if (coordinator != null) {
            NodeIdentifier nodeId = coordinator.getNodeIdentifier(replayRequestEntity.getClusterNodeId());
            event.setClusterNodeAddress(nodeId.getApiAddress() + ":" + nodeId.getApiPort());
        }
        ProvenanceEventEntity entity = new ProvenanceEventEntity();
        entity.setProvenanceEvent(event);
        URI uri = URI.create(this.generateResourceUri(new String[]{"provenance-events", event.getId()}));
        return this.generateCreatedResponse(uri, (Object)entity).build();
    }

    public void setServiceFacade(NiFiServiceFacade serviceFacade) {
        this.serviceFacade = serviceFacade;
    }
}

