/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.dao.impl;

import java.util.List;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.web.ResourceNotFoundException;
import org.apache.nifi.web.api.dto.BundleDTO;

public abstract class ComponentDAO {
    protected <T> boolean isNotNull(T object) {
        return object != null;
    }

    protected <T> boolean isAnyNotNull(T ... objects) {
        for (T object : objects) {
            if (object == null) continue;
            return true;
        }
        return false;
    }

    protected ProcessGroup locateProcessGroup(FlowController flowController, String groupId) {
        ProcessGroup group = flowController.getGroup(groupId);
        if (group == null) {
            throw new ResourceNotFoundException(String.format("Unable to locate group with id '%s'.", groupId));
        }
        return group;
    }

    protected void verifyCreate(String type, BundleDTO bundle) {
        List bundles = ExtensionManager.getBundles((String)type);
        if (bundle != null) {
            BundleCoordinate coordinate = new BundleCoordinate(bundle.getGroup(), bundle.getArtifact(), bundle.getVersion());
            if (bundles.stream().filter(b -> b.getBundleDetails().getCoordinate().equals((Object)coordinate)).count() == 0L) {
                throw new IllegalStateException(String.format("%s is not known to this NiFi instance.", coordinate.toString()));
            }
        } else {
            if (bundles.isEmpty()) {
                throw new IllegalStateException(String.format("%s is not known to this NiFi instance.", type));
            }
            if (bundles.size() > 1) {
                throw new IllegalStateException(String.format("Multiple versions of %s exist. Please specify the desired bundle.", type));
            }
        }
    }
}

