/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api;

import com.sun.jersey.api.core.ResourceContext;
import com.sun.jersey.multipart.FormDataParam;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import com.wordnik.swagger.annotations.Authorization;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.authorization.AuthorizableLookup;
import org.apache.nifi.authorization.AuthorizeControllerServiceReference;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.ComponentAuthorizable;
import org.apache.nifi.authorization.ProcessGroupAuthorizable;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.SnippetAuthorizable;
import org.apache.nifi.authorization.TemplateContentsAuthorizable;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.connectable.ConnectableType;
import org.apache.nifi.controller.serialization.FlowEncodingVersion;
import org.apache.nifi.remote.util.SiteToSiteRestApiClient;
import org.apache.nifi.util.BundleUtils;
import org.apache.nifi.web.NiFiServiceFacade;
import org.apache.nifi.web.ResourceNotFoundException;
import org.apache.nifi.web.Revision;
import org.apache.nifi.web.api.ApplicationResource;
import org.apache.nifi.web.api.ConnectionResource;
import org.apache.nifi.web.api.ControllerServiceResource;
import org.apache.nifi.web.api.FunnelResource;
import org.apache.nifi.web.api.InputPortResource;
import org.apache.nifi.web.api.LabelResource;
import org.apache.nifi.web.api.OutputPortResource;
import org.apache.nifi.web.api.ProcessorResource;
import org.apache.nifi.web.api.RemoteProcessGroupResource;
import org.apache.nifi.web.api.TemplateResource;
import org.apache.nifi.web.api.dto.BundleDTO;
import org.apache.nifi.web.api.dto.ConnectionDTO;
import org.apache.nifi.web.api.dto.ControllerServiceDTO;
import org.apache.nifi.web.api.dto.FlowSnippetDTO;
import org.apache.nifi.web.api.dto.PositionDTO;
import org.apache.nifi.web.api.dto.ProcessGroupDTO;
import org.apache.nifi.web.api.dto.ProcessorConfigDTO;
import org.apache.nifi.web.api.dto.ProcessorDTO;
import org.apache.nifi.web.api.dto.RemoteProcessGroupDTO;
import org.apache.nifi.web.api.dto.TemplateDTO;
import org.apache.nifi.web.api.dto.flow.FlowDTO;
import org.apache.nifi.web.api.entity.ComponentEntity;
import org.apache.nifi.web.api.entity.ConnectionEntity;
import org.apache.nifi.web.api.entity.ConnectionsEntity;
import org.apache.nifi.web.api.entity.ControllerServiceEntity;
import org.apache.nifi.web.api.entity.CopySnippetRequestEntity;
import org.apache.nifi.web.api.entity.CreateTemplateRequestEntity;
import org.apache.nifi.web.api.entity.Entity;
import org.apache.nifi.web.api.entity.FlowEntity;
import org.apache.nifi.web.api.entity.FlowSnippetEntity;
import org.apache.nifi.web.api.entity.FunnelEntity;
import org.apache.nifi.web.api.entity.FunnelsEntity;
import org.apache.nifi.web.api.entity.InputPortsEntity;
import org.apache.nifi.web.api.entity.InstantiateTemplateRequestEntity;
import org.apache.nifi.web.api.entity.LabelEntity;
import org.apache.nifi.web.api.entity.LabelsEntity;
import org.apache.nifi.web.api.entity.OutputPortsEntity;
import org.apache.nifi.web.api.entity.PortEntity;
import org.apache.nifi.web.api.entity.ProcessGroupEntity;
import org.apache.nifi.web.api.entity.ProcessGroupsEntity;
import org.apache.nifi.web.api.entity.ProcessorEntity;
import org.apache.nifi.web.api.entity.ProcessorsEntity;
import org.apache.nifi.web.api.entity.RemoteProcessGroupEntity;
import org.apache.nifi.web.api.entity.RemoteProcessGroupsEntity;
import org.apache.nifi.web.api.entity.TemplateEntity;
import org.apache.nifi.web.api.request.ClientIdParameter;
import org.apache.nifi.web.api.request.LongParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/process-groups")
@Api(value="/process-groups", description="Endpoint for managing a Process Group.")
public class ProcessGroupResource
extends ApplicationResource {
    private static final Logger logger = LoggerFactory.getLogger(ProcessGroupResource.class);
    @Context
    private ResourceContext resourceContext;
    private NiFiServiceFacade serviceFacade;
    private Authorizer authorizer;
    private ProcessorResource processorResource;
    private InputPortResource inputPortResource;
    private OutputPortResource outputPortResource;
    private FunnelResource funnelResource;
    private LabelResource labelResource;
    private RemoteProcessGroupResource remoteProcessGroupResource;
    private ConnectionResource connectionResource;
    private TemplateResource templateResource;
    private ControllerServiceResource controllerServiceResource;

    public Set<ProcessGroupEntity> populateRemainingProcessGroupEntitiesContent(Set<ProcessGroupEntity> processGroupEntities) {
        for (ProcessGroupEntity processGroupEntity : processGroupEntities) {
            this.populateRemainingProcessGroupEntityContent(processGroupEntity);
        }
        return processGroupEntities;
    }

    public ProcessGroupEntity populateRemainingProcessGroupEntityContent(ProcessGroupEntity processGroupEntity) {
        processGroupEntity.setUri(this.generateResourceUri(new String[]{"process-groups", processGroupEntity.getId()}));
        return processGroupEntity;
    }

    private FlowDTO populateRemainingSnippetContent(FlowDTO flow) {
        this.processorResource.populateRemainingProcessorEntitiesContent(flow.getProcessors());
        this.connectionResource.populateRemainingConnectionEntitiesContent(flow.getConnections());
        this.inputPortResource.populateRemainingInputPortEntitiesContent(flow.getInputPorts());
        this.outputPortResource.populateRemainingOutputPortEntitiesContent(flow.getOutputPorts());
        this.remoteProcessGroupResource.populateRemainingRemoteProcessGroupEntitiesContent(flow.getRemoteProcessGroups());
        this.funnelResource.populateRemainingFunnelEntitiesContent(flow.getFunnels());
        this.labelResource.populateRemainingLabelEntitiesContent(flow.getLabels());
        if (flow.getProcessGroups() != null) {
            this.populateRemainingProcessGroupEntitiesContent(flow.getProcessGroups());
        }
        return flow;
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}")
    @ApiOperation(value="Gets a process group", response=ProcessGroupEntity.class, authorizations={@Authorization(value="Read - /process-groups/{uuid}", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getProcessGroup(@ApiParam(value="The process group id.", required=false) @PathParam(value="id") String groupId) {
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable processGroup = lookup.getProcessGroup(groupId).getAuthorizable();
            processGroup.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        });
        ProcessGroupEntity entity = this.serviceFacade.getProcessGroup(groupId);
        this.populateRemainingProcessGroupEntityContent(entity);
        if (entity.getComponent() != null) {
            entity.getComponent().setContents(null);
        }
        return this.clusterContext(this.generateOkResponse((Object)entity)).build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{id}")
    @ApiOperation(value="Updates a process group", response=ProcessGroupEntity.class, authorizations={@Authorization(value="Write - /process-groups/{uuid}", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response updateProcessGroup(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The process group id.", required=true) @PathParam(value="id") String id, @ApiParam(value="The process group configuration details.", required=true) ProcessGroupEntity requestProcessGroupEntity) {
        if (requestProcessGroupEntity == null || requestProcessGroupEntity.getComponent() == null) {
            throw new IllegalArgumentException("Process group details must be specified.");
        }
        if (requestProcessGroupEntity.getRevision() == null) {
            throw new IllegalArgumentException("Revision must be specified.");
        }
        ProcessGroupDTO requestProcessGroupDTO = requestProcessGroupEntity.getComponent();
        if (!id.equals(requestProcessGroupDTO.getId())) {
            throw new IllegalArgumentException(String.format("The process group id (%s) in the request body does not equal the process group id of the requested resource (%s).", requestProcessGroupDTO.getId(), id));
        }
        PositionDTO proposedPosition = requestProcessGroupDTO.getPosition();
        if (proposedPosition != null && (proposedPosition.getX() == null || proposedPosition.getY() == null)) {
            throw new IllegalArgumentException("The x and y coordinate of the proposed position must be specified.");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("PUT", (Object)requestProcessGroupEntity);
        }
        Revision requestRevision = this.getRevision((ComponentEntity)requestProcessGroupEntity, id);
        return this.withWriteLock(this.serviceFacade, (Entity)requestProcessGroupEntity, requestRevision, lookup -> {
            Authorizable authorizable = lookup.getProcessGroup(id).getAuthorizable();
            authorizable.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        }, null, (revision, processGroupEntity) -> {
            ProcessGroupEntity entity = this.serviceFacade.updateProcessGroup(revision, processGroupEntity.getComponent());
            this.populateRemainingProcessGroupEntityContent(entity);
            return this.clusterContext(this.generateOkResponse((Object)entity)).build();
        });
    }

    @DELETE
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}")
    @ApiOperation(value="Deletes a process group", response=ProcessGroupEntity.class, authorizations={@Authorization(value="Write - /process-groups/{uuid}", type=""), @Authorization(value="Write - Parent Process Group - /process-groups/{uuid}", type=""), @Authorization(value="Read - any referenced Controller Services by any encapsulated components - /controller-services/{uuid}", type=""), @Authorization(value="Write - /{component-type}/{uuid} - For all encapsulated components", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response removeProcessGroup(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The revision is used to verify the client is working with the latest version of the flow.", required=false) @QueryParam(value="version") LongParameter version, @ApiParam(value="If the client id is not specified, new one will be generated. This value (whether specified or generated) is included in the response.", required=false) @QueryParam(value="clientId") @DefaultValue(value="") ClientIdParameter clientId, @ApiParam(value="The process group id.", required=true) @PathParam(value="id") String id) {
        if (this.isReplicateRequest()) {
            return this.replicate("DELETE");
        }
        ProcessGroupEntity requestProcessGroupEntity = new ProcessGroupEntity();
        requestProcessGroupEntity.setId(id);
        Revision requestRevision = new Revision(version == null ? null : version.getLong(), clientId.getClientId(), id);
        return this.withWriteLock(this.serviceFacade, (Entity)requestProcessGroupEntity, requestRevision, lookup -> {
            ProcessGroupAuthorizable processGroupAuthorizable = lookup.getProcessGroup(id);
            this.authorizeProcessGroup(processGroupAuthorizable, this.authorizer, lookup, RequestAction.WRITE, true, true, true, false);
            Authorizable parentAuthorizable = processGroupAuthorizable.getAuthorizable().getParentAuthorizable();
            if (parentAuthorizable != null) {
                parentAuthorizable.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
            }
        }, () -> this.serviceFacade.verifyDeleteProcessGroup(id), (revision, processGroupEntity) -> {
            ProcessGroupEntity entity = this.serviceFacade.deleteProcessGroup(revision, processGroupEntity.getId());
            return this.clusterContext(this.generateOkResponse((Object)entity)).build();
        });
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{id}/process-groups")
    @ApiOperation(value="Creates a process group", response=ProcessGroupEntity.class, authorizations={@Authorization(value="Write - /process-groups/{uuid}", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response createProcessGroup(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The process group id.", required=true) @PathParam(value="id") String groupId, @ApiParam(value="The process group configuration details.", required=true) ProcessGroupEntity requestProcessGroupEntity) {
        if (requestProcessGroupEntity == null || requestProcessGroupEntity.getComponent() == null) {
            throw new IllegalArgumentException("Process group details must be specified.");
        }
        if (requestProcessGroupEntity.getRevision() == null || requestProcessGroupEntity.getRevision().getVersion() == null || requestProcessGroupEntity.getRevision().getVersion() != 0L) {
            throw new IllegalArgumentException("A revision of 0 must be specified when creating a new Process group.");
        }
        if (requestProcessGroupEntity.getComponent().getId() != null) {
            throw new IllegalArgumentException("Process group ID cannot be specified.");
        }
        PositionDTO proposedPosition = requestProcessGroupEntity.getComponent().getPosition();
        if (proposedPosition != null && (proposedPosition.getX() == null || proposedPosition.getY() == null)) {
            throw new IllegalArgumentException("The x and y coordinate of the proposed position must be specified.");
        }
        if (requestProcessGroupEntity.getComponent().getParentGroupId() != null && !groupId.equals(requestProcessGroupEntity.getComponent().getParentGroupId())) {
            throw new IllegalArgumentException(String.format("If specified, the parent process group id %s must be the same as specified in the URI %s", requestProcessGroupEntity.getComponent().getParentGroupId(), groupId));
        }
        requestProcessGroupEntity.getComponent().setParentGroupId(groupId);
        if (this.isReplicateRequest()) {
            return this.replicate("POST", (Object)requestProcessGroupEntity);
        }
        return this.withWriteLock(this.serviceFacade, (Entity)requestProcessGroupEntity, lookup -> {
            Authorizable processGroup = lookup.getProcessGroup(groupId).getAuthorizable();
            processGroup.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        }, null, processGroupGroupEntity -> {
            processGroupGroupEntity.getComponent().setId(this.generateUuid());
            Revision revision = this.getRevision((ComponentEntity)processGroupGroupEntity, processGroupGroupEntity.getComponent().getId());
            ProcessGroupEntity entity = this.serviceFacade.createProcessGroup(revision, groupId, processGroupGroupEntity.getComponent());
            this.populateRemainingProcessGroupEntityContent(entity);
            String uri = entity.getUri();
            return this.clusterContext(this.generateCreatedResponse(URI.create(uri), (Object)entity)).build();
        });
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}/process-groups")
    @ApiOperation(value="Gets all process groups", response=ProcessorsEntity.class, authorizations={@Authorization(value="Read - /process-groups/{uuid}", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getProcessGroups(@ApiParam(value="The process group id.", required=true) @PathParam(value="id") String groupId) {
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable processGroup = lookup.getProcessGroup(groupId).getAuthorizable();
            processGroup.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        });
        Set entities = this.serviceFacade.getProcessGroups(groupId);
        for (ProcessGroupEntity entity : entities) {
            if (entity.getComponent() == null) continue;
            entity.getComponent().setContents(null);
        }
        ProcessGroupsEntity entity = new ProcessGroupsEntity();
        entity.setProcessGroups(this.populateRemainingProcessGroupEntitiesContent(entities));
        return this.clusterContext(this.generateOkResponse((Object)entity)).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{id}/processors")
    @ApiOperation(value="Creates a new processor", response=ProcessorEntity.class, authorizations={@Authorization(value="Write - /process-groups/{uuid}", type=""), @Authorization(value="Read - any referenced Controller Services - /controller-services/{uuid}", type=""), @Authorization(value="Write - if the Processor is restricted - /restricted-components", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response createProcessor(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The process group id.", required=true) @PathParam(value="id") String groupId, @ApiParam(value="The processor configuration details.", required=true) ProcessorEntity requestProcessorEntity) {
        if (requestProcessorEntity == null || requestProcessorEntity.getComponent() == null) {
            throw new IllegalArgumentException("Processor details must be specified.");
        }
        if (requestProcessorEntity.getRevision() == null || requestProcessorEntity.getRevision().getVersion() == null || requestProcessorEntity.getRevision().getVersion() != 0L) {
            throw new IllegalArgumentException("A revision of 0 must be specified when creating a new Processor.");
        }
        ProcessorDTO requestProcessor = requestProcessorEntity.getComponent();
        if (requestProcessor.getId() != null) {
            throw new IllegalArgumentException("Processor ID cannot be specified.");
        }
        if (StringUtils.isBlank((CharSequence)requestProcessor.getType())) {
            throw new IllegalArgumentException("The type of processor to create must be specified.");
        }
        PositionDTO proposedPosition = requestProcessor.getPosition();
        if (proposedPosition != null && (proposedPosition.getX() == null || proposedPosition.getY() == null)) {
            throw new IllegalArgumentException("The x and y coordinate of the proposed position must be specified.");
        }
        if (requestProcessor.getParentGroupId() != null && !groupId.equals(requestProcessor.getParentGroupId())) {
            throw new IllegalArgumentException(String.format("If specified, the parent process group id %s must be the same as specified in the URI %s", requestProcessor.getParentGroupId(), groupId));
        }
        requestProcessor.setParentGroupId(groupId);
        if (this.isReplicateRequest()) {
            return this.replicate("POST", (Object)requestProcessorEntity);
        }
        return this.withWriteLock(this.serviceFacade, (Entity)requestProcessorEntity, lookup -> {
            NiFiUser user = NiFiUserUtils.getNiFiUser();
            Authorizable processGroup = lookup.getProcessGroup(groupId).getAuthorizable();
            processGroup.authorize(this.authorizer, RequestAction.WRITE, user);
            ComponentAuthorizable authorizable = null;
            try {
                ProcessorConfigDTO config;
                authorizable = lookup.getConfigurableComponent(requestProcessor.getType(), requestProcessor.getBundle());
                if (authorizable.isRestricted()) {
                    lookup.getRestrictedComponents().authorize(this.authorizer, RequestAction.WRITE, user);
                }
                if ((config = requestProcessor.getConfig()) != null && config.getProperties() != null) {
                    AuthorizeControllerServiceReference.authorizeControllerServiceReferences((Map)config.getProperties(), (ComponentAuthorizable)authorizable, (Authorizer)this.authorizer, (AuthorizableLookup)lookup);
                }
            }
            finally {
                if (authorizable != null) {
                    authorizable.cleanUpResources();
                }
            }
        }, () -> this.serviceFacade.verifyCreateProcessor(requestProcessor), processorEntity -> {
            ProcessorDTO processor = processorEntity.getComponent();
            processor.setId(this.generateUuid());
            Revision revision = this.getRevision((ComponentEntity)processorEntity, processor.getId());
            ProcessorEntity entity = this.serviceFacade.createProcessor(revision, groupId, processor);
            this.processorResource.populateRemainingProcessorEntityContent(entity);
            String uri = entity.getUri();
            return this.clusterContext(this.generateCreatedResponse(URI.create(uri), (Object)entity)).build();
        });
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}/processors")
    @ApiOperation(value="Gets all processors", response=ProcessorsEntity.class, authorizations={@Authorization(value="Read - /process-groups/{uuid}", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getProcessors(@ApiParam(value="The process group id.", required=true) @PathParam(value="id") String groupId) {
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable processGroup = lookup.getProcessGroup(groupId).getAuthorizable();
            processGroup.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        });
        Set processors = this.serviceFacade.getProcessors(groupId);
        ProcessorsEntity entity = new ProcessorsEntity();
        entity.setProcessors(this.processorResource.populateRemainingProcessorEntitiesContent(processors));
        return this.clusterContext(this.generateOkResponse((Object)entity)).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{id}/input-ports")
    @ApiOperation(value="Creates an input port", response=PortEntity.class, authorizations={@Authorization(value="Write - /process-groups/{uuid}", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response createInputPort(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The process group id.", required=true) @PathParam(value="id") String groupId, @ApiParam(value="The input port configuration details.", required=true) PortEntity requestPortEntity) {
        if (requestPortEntity == null || requestPortEntity.getComponent() == null) {
            throw new IllegalArgumentException("Port details must be specified.");
        }
        if (requestPortEntity.getRevision() == null || requestPortEntity.getRevision().getVersion() == null || requestPortEntity.getRevision().getVersion() != 0L) {
            throw new IllegalArgumentException("A revision of 0 must be specified when creating a new Input port.");
        }
        if (requestPortEntity.getComponent().getId() != null) {
            throw new IllegalArgumentException("Input port ID cannot be specified.");
        }
        PositionDTO proposedPosition = requestPortEntity.getComponent().getPosition();
        if (proposedPosition != null && (proposedPosition.getX() == null || proposedPosition.getY() == null)) {
            throw new IllegalArgumentException("The x and y coordinate of the proposed position must be specified.");
        }
        if (requestPortEntity.getComponent().getParentGroupId() != null && !groupId.equals(requestPortEntity.getComponent().getParentGroupId())) {
            throw new IllegalArgumentException(String.format("If specified, the parent process group id %s must be the same as specified in the URI %s", requestPortEntity.getComponent().getParentGroupId(), groupId));
        }
        requestPortEntity.getComponent().setParentGroupId(groupId);
        if (this.isReplicateRequest()) {
            return this.replicate("POST", (Object)requestPortEntity);
        }
        return this.withWriteLock(this.serviceFacade, (Entity)requestPortEntity, lookup -> {
            Authorizable processGroup = lookup.getProcessGroup(groupId).getAuthorizable();
            processGroup.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        }, null, portEntity -> {
            portEntity.getComponent().setId(this.generateUuid());
            Revision revision = this.getRevision((ComponentEntity)portEntity, portEntity.getComponent().getId());
            PortEntity entity = this.serviceFacade.createInputPort(revision, groupId, portEntity.getComponent());
            this.inputPortResource.populateRemainingInputPortEntityContent(entity);
            return this.clusterContext(this.generateCreatedResponse(URI.create(entity.getUri()), (Object)entity)).build();
        });
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}/input-ports")
    @ApiOperation(value="Gets all input ports", response=InputPortsEntity.class, authorizations={@Authorization(value="Read - /process-groups/{uuid}", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getInputPorts(@ApiParam(value="The process group id.", required=true) @PathParam(value="id") String groupId) {
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable processGroup = lookup.getProcessGroup(groupId).getAuthorizable();
            processGroup.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        });
        Set inputPorts = this.serviceFacade.getInputPorts(groupId);
        InputPortsEntity entity = new InputPortsEntity();
        entity.setInputPorts(this.inputPortResource.populateRemainingInputPortEntitiesContent(inputPorts));
        return this.clusterContext(this.generateOkResponse((Object)entity)).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{id}/output-ports")
    @ApiOperation(value="Creates an output port", response=PortEntity.class, authorizations={@Authorization(value="Write - /process-groups/{uuid}", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response createOutputPort(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The process group id.", required=true) @PathParam(value="id") String groupId, @ApiParam(value="The output port configuration.", required=true) PortEntity requestPortEntity) {
        if (requestPortEntity == null || requestPortEntity.getComponent() == null) {
            throw new IllegalArgumentException("Port details must be specified.");
        }
        if (requestPortEntity.getRevision() == null || requestPortEntity.getRevision().getVersion() == null || requestPortEntity.getRevision().getVersion() != 0L) {
            throw new IllegalArgumentException("A revision of 0 must be specified when creating a new Output port.");
        }
        if (requestPortEntity.getComponent().getId() != null) {
            throw new IllegalArgumentException("Output port ID cannot be specified.");
        }
        PositionDTO proposedPosition = requestPortEntity.getComponent().getPosition();
        if (proposedPosition != null && (proposedPosition.getX() == null || proposedPosition.getY() == null)) {
            throw new IllegalArgumentException("The x and y coordinate of the proposed position must be specified.");
        }
        if (requestPortEntity.getComponent().getParentGroupId() != null && !groupId.equals(requestPortEntity.getComponent().getParentGroupId())) {
            throw new IllegalArgumentException(String.format("If specified, the parent process group id %s must be the same as specified in the URI %s", requestPortEntity.getComponent().getParentGroupId(), groupId));
        }
        requestPortEntity.getComponent().setParentGroupId(groupId);
        if (this.isReplicateRequest()) {
            return this.replicate("POST", (Object)requestPortEntity);
        }
        return this.withWriteLock(this.serviceFacade, (Entity)requestPortEntity, lookup -> {
            Authorizable processGroup = lookup.getProcessGroup(groupId).getAuthorizable();
            processGroup.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        }, null, portEntity -> {
            portEntity.getComponent().setId(this.generateUuid());
            Revision revision = this.getRevision((ComponentEntity)portEntity, portEntity.getComponent().getId());
            PortEntity entity = this.serviceFacade.createOutputPort(revision, groupId, portEntity.getComponent());
            this.outputPortResource.populateRemainingOutputPortEntityContent(entity);
            return this.clusterContext(this.generateCreatedResponse(URI.create(entity.getUri()), (Object)entity)).build();
        });
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}/output-ports")
    @ApiOperation(value="Gets all output ports", response=OutputPortsEntity.class, authorizations={@Authorization(value="Read - /process-groups/{uuid}", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getOutputPorts(@ApiParam(value="The process group id.", required=true) @PathParam(value="id") String groupId) {
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable processGroup = lookup.getProcessGroup(groupId).getAuthorizable();
            processGroup.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        });
        Set outputPorts = this.serviceFacade.getOutputPorts(groupId);
        OutputPortsEntity entity = new OutputPortsEntity();
        entity.setOutputPorts(this.outputPortResource.populateRemainingOutputPortEntitiesContent(outputPorts));
        return this.clusterContext(this.generateOkResponse((Object)entity)).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{id}/funnels")
    @ApiOperation(value="Creates a funnel", response=FunnelEntity.class, authorizations={@Authorization(value="Write - /process-groups/{uuid}", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response createFunnel(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The process group id.", required=true) @PathParam(value="id") String groupId, @ApiParam(value="The funnel configuration details.", required=true) FunnelEntity requestFunnelEntity) {
        if (requestFunnelEntity == null || requestFunnelEntity.getComponent() == null) {
            throw new IllegalArgumentException("Funnel details must be specified.");
        }
        if (requestFunnelEntity.getRevision() == null || requestFunnelEntity.getRevision().getVersion() == null || requestFunnelEntity.getRevision().getVersion() != 0L) {
            throw new IllegalArgumentException("A revision of 0 must be specified when creating a new Funnel.");
        }
        if (requestFunnelEntity.getComponent().getId() != null) {
            throw new IllegalArgumentException("Funnel ID cannot be specified.");
        }
        PositionDTO proposedPosition = requestFunnelEntity.getComponent().getPosition();
        if (proposedPosition != null && (proposedPosition.getX() == null || proposedPosition.getY() == null)) {
            throw new IllegalArgumentException("The x and y coordinate of the proposed position must be specified.");
        }
        if (requestFunnelEntity.getComponent().getParentGroupId() != null && !groupId.equals(requestFunnelEntity.getComponent().getParentGroupId())) {
            throw new IllegalArgumentException(String.format("If specified, the parent process group id %s must be the same as specified in the URI %s", requestFunnelEntity.getComponent().getParentGroupId(), groupId));
        }
        requestFunnelEntity.getComponent().setParentGroupId(groupId);
        if (this.isReplicateRequest()) {
            return this.replicate("POST", (Object)requestFunnelEntity);
        }
        return this.withWriteLock(this.serviceFacade, (Entity)requestFunnelEntity, lookup -> {
            Authorizable processGroup = lookup.getProcessGroup(groupId).getAuthorizable();
            processGroup.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        }, null, funnelEntity -> {
            funnelEntity.getComponent().setId(this.generateUuid());
            Revision revision = this.getRevision((ComponentEntity)funnelEntity, funnelEntity.getComponent().getId());
            FunnelEntity entity = this.serviceFacade.createFunnel(revision, groupId, funnelEntity.getComponent());
            this.funnelResource.populateRemainingFunnelEntityContent(entity);
            return this.clusterContext(this.generateCreatedResponse(URI.create(entity.getUri()), (Object)entity)).build();
        });
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}/funnels")
    @ApiOperation(value="Gets all funnels", response=FunnelsEntity.class, authorizations={@Authorization(value="Read - /process-groups/{uuid}", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getFunnels(@ApiParam(value="The process group id.", required=true) @PathParam(value="id") String groupId) {
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable processGroup = lookup.getProcessGroup(groupId).getAuthorizable();
            processGroup.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        });
        Set funnels = this.serviceFacade.getFunnels(groupId);
        FunnelsEntity entity = new FunnelsEntity();
        entity.setFunnels(this.funnelResource.populateRemainingFunnelEntitiesContent(funnels));
        return this.clusterContext(this.generateOkResponse((Object)entity)).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{id}/labels")
    @ApiOperation(value="Creates a label", response=LabelEntity.class, authorizations={@Authorization(value="Write - /process-groups/{uuid}", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response createLabel(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The process group id.", required=true) @PathParam(value="id") String groupId, @ApiParam(value="The label configuration details.", required=true) LabelEntity requestLabelEntity) {
        if (requestLabelEntity == null || requestLabelEntity.getComponent() == null) {
            throw new IllegalArgumentException("Label details must be specified.");
        }
        if (requestLabelEntity.getRevision() == null || requestLabelEntity.getRevision().getVersion() == null || requestLabelEntity.getRevision().getVersion() != 0L) {
            throw new IllegalArgumentException("A revision of 0 must be specified when creating a new Label.");
        }
        if (requestLabelEntity.getComponent().getId() != null) {
            throw new IllegalArgumentException("Label ID cannot be specified.");
        }
        PositionDTO proposedPosition = requestLabelEntity.getComponent().getPosition();
        if (proposedPosition != null && (proposedPosition.getX() == null || proposedPosition.getY() == null)) {
            throw new IllegalArgumentException("The x and y coordinate of the proposed position must be specified.");
        }
        if (requestLabelEntity.getComponent().getParentGroupId() != null && !groupId.equals(requestLabelEntity.getComponent().getParentGroupId())) {
            throw new IllegalArgumentException(String.format("If specified, the parent process group id %s must be the same as specified in the URI %s", requestLabelEntity.getComponent().getParentGroupId(), groupId));
        }
        requestLabelEntity.getComponent().setParentGroupId(groupId);
        if (this.isReplicateRequest()) {
            return this.replicate("POST", (Object)requestLabelEntity);
        }
        return this.withWriteLock(this.serviceFacade, (Entity)requestLabelEntity, lookup -> {
            Authorizable processGroup = lookup.getProcessGroup(groupId).getAuthorizable();
            processGroup.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        }, null, labelEntity -> {
            labelEntity.getComponent().setId(this.generateUuid());
            Revision revision = this.getRevision((ComponentEntity)labelEntity, labelEntity.getComponent().getId());
            LabelEntity entity = this.serviceFacade.createLabel(revision, groupId, labelEntity.getComponent());
            this.labelResource.populateRemainingLabelEntityContent(entity);
            return this.clusterContext(this.generateCreatedResponse(URI.create(entity.getUri()), (Object)entity)).build();
        });
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}/labels")
    @ApiOperation(value="Gets all labels", response=LabelsEntity.class, authorizations={@Authorization(value="Read - /process-groups/{uuid}", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getLabels(@ApiParam(value="The process group id.", required=true) @PathParam(value="id") String groupId) {
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable processGroup = lookup.getProcessGroup(groupId).getAuthorizable();
            processGroup.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        });
        Set labels = this.serviceFacade.getLabels(groupId);
        LabelsEntity entity = new LabelsEntity();
        entity.setLabels(this.labelResource.populateRemainingLabelEntitiesContent(labels));
        return this.clusterContext(this.generateOkResponse((Object)entity)).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{id}/remote-process-groups")
    @ApiOperation(value="Creates a new process group", response=RemoteProcessGroupEntity.class, authorizations={@Authorization(value="Write - /process-groups/{uuid}", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response createRemoteProcessGroup(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The process group id.", required=true) @PathParam(value="id") String groupId, @ApiParam(value="The remote process group configuration details.", required=true) RemoteProcessGroupEntity requestRemoteProcessGroupEntity) {
        if (requestRemoteProcessGroupEntity == null || requestRemoteProcessGroupEntity.getComponent() == null) {
            throw new IllegalArgumentException("Remote process group details must be specified.");
        }
        if (requestRemoteProcessGroupEntity.getRevision() == null || requestRemoteProcessGroupEntity.getRevision().getVersion() == null || requestRemoteProcessGroupEntity.getRevision().getVersion() != 0L) {
            throw new IllegalArgumentException("A revision of 0 must be specified when creating a new Remote process group.");
        }
        RemoteProcessGroupDTO requestRemoteProcessGroupDTO = requestRemoteProcessGroupEntity.getComponent();
        if (requestRemoteProcessGroupDTO.getId() != null) {
            throw new IllegalArgumentException("Remote process group ID cannot be specified.");
        }
        if (requestRemoteProcessGroupDTO.getTargetUri() == null) {
            throw new IllegalArgumentException("The URI of the process group must be specified.");
        }
        PositionDTO proposedPosition = requestRemoteProcessGroupDTO.getPosition();
        if (proposedPosition != null && (proposedPosition.getX() == null || proposedPosition.getY() == null)) {
            throw new IllegalArgumentException("The x and y coordinate of the proposed position must be specified.");
        }
        if (requestRemoteProcessGroupDTO.getParentGroupId() != null && !groupId.equals(requestRemoteProcessGroupDTO.getParentGroupId())) {
            throw new IllegalArgumentException(String.format("If specified, the parent process group id %s must be the same as specified in the URI %s", requestRemoteProcessGroupDTO.getParentGroupId(), groupId));
        }
        requestRemoteProcessGroupDTO.setParentGroupId(groupId);
        if (this.isReplicateRequest()) {
            return this.replicate("POST", (Object)requestRemoteProcessGroupEntity);
        }
        return this.withWriteLock(this.serviceFacade, (Entity)requestRemoteProcessGroupEntity, lookup -> {
            Authorizable processGroup = lookup.getProcessGroup(groupId).getAuthorizable();
            processGroup.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        }, null, remoteProcessGroupEntity -> {
            RemoteProcessGroupDTO remoteProcessGroupDTO = remoteProcessGroupEntity.getComponent();
            remoteProcessGroupDTO.setId(this.generateUuid());
            String targetUris = remoteProcessGroupDTO.getTargetUris();
            SiteToSiteRestApiClient.parseClusterUrls((String)targetUris);
            remoteProcessGroupDTO.setTargetUris(targetUris);
            Revision revision = this.getRevision((ComponentEntity)remoteProcessGroupEntity, remoteProcessGroupDTO.getId());
            RemoteProcessGroupEntity entity = this.serviceFacade.createRemoteProcessGroup(revision, groupId, remoteProcessGroupDTO);
            this.remoteProcessGroupResource.populateRemainingRemoteProcessGroupEntityContent(entity);
            return this.clusterContext(this.generateCreatedResponse(URI.create(entity.getUri()), (Object)entity)).build();
        });
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}/remote-process-groups")
    @ApiOperation(value="Gets all remote process groups", response=RemoteProcessGroupsEntity.class, authorizations={@Authorization(value="Read - /process-groups/{uuid}", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getRemoteProcessGroups(@ApiParam(value="The process group id.", required=true) @PathParam(value="id") String groupId) {
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable processGroup = lookup.getProcessGroup(groupId).getAuthorizable();
            processGroup.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        });
        Set remoteProcessGroups = this.serviceFacade.getRemoteProcessGroups(groupId);
        for (RemoteProcessGroupEntity remoteProcessGroupEntity : remoteProcessGroups) {
            if (remoteProcessGroupEntity.getComponent() == null) continue;
            remoteProcessGroupEntity.getComponent().setContents(null);
        }
        RemoteProcessGroupsEntity entity = new RemoteProcessGroupsEntity();
        entity.setRemoteProcessGroups(this.remoteProcessGroupResource.populateRemainingRemoteProcessGroupEntitiesContent(remoteProcessGroups));
        return this.clusterContext(this.generateOkResponse((Object)entity)).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{id}/connections")
    @ApiOperation(value="Creates a connection", response=ConnectionEntity.class, authorizations={@Authorization(value="Write - /process-groups/{uuid}", type=""), @Authorization(value="Write Source - /{component-type}/{uuid}", type=""), @Authorization(value="Write Destination - /{component-type}/{uuid}", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response createConnection(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The process group id.", required=true) @PathParam(value="id") String groupId, @ApiParam(value="The connection configuration details.", required=true) ConnectionEntity requestConnectionEntity) {
        ConnectableType destinationConnectableType;
        ConnectableType sourceConnectableType;
        if (requestConnectionEntity == null || requestConnectionEntity.getComponent() == null) {
            throw new IllegalArgumentException("Connection details must be specified.");
        }
        if (requestConnectionEntity.getRevision() == null || requestConnectionEntity.getRevision().getVersion() == null || requestConnectionEntity.getRevision().getVersion() != 0L) {
            throw new IllegalArgumentException("A revision of 0 must be specified when creating a new Connection.");
        }
        if (requestConnectionEntity.getComponent().getId() != null) {
            throw new IllegalArgumentException("Connection ID cannot be specified.");
        }
        List proposedBends = requestConnectionEntity.getComponent().getBends();
        if (proposedBends != null) {
            for (PositionDTO proposedBend : proposedBends) {
                if (proposedBend.getX() != null && proposedBend.getY() != null) continue;
                throw new IllegalArgumentException("The x and y coordinate of the each bend must be specified.");
            }
        }
        if (requestConnectionEntity.getComponent().getParentGroupId() != null && !groupId.equals(requestConnectionEntity.getComponent().getParentGroupId())) {
            throw new IllegalArgumentException(String.format("If specified, the parent process group id %s must be the same as specified in the URI %s", requestConnectionEntity.getComponent().getParentGroupId(), groupId));
        }
        requestConnectionEntity.getComponent().setParentGroupId(groupId);
        ConnectionDTO requestConnection = requestConnectionEntity.getComponent();
        if (requestConnection.getSource() == null || requestConnection.getSource().getId() == null) {
            throw new IllegalArgumentException("The source of the connection must be specified.");
        }
        if (requestConnection.getSource().getType() == null) {
            throw new IllegalArgumentException("The type of the source of the connection must be specified.");
        }
        try {
            sourceConnectableType = ConnectableType.valueOf((String)requestConnection.getSource().getType());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Unrecognized source type %s. Expected values are [%s]", requestConnection.getSource().getType(), StringUtils.join((Object[])ConnectableType.values(), (String)", ")));
        }
        if (requestConnection.getDestination() == null || requestConnection.getDestination().getId() == null) {
            throw new IllegalArgumentException("The destination of the connection must be specified.");
        }
        if (requestConnection.getDestination().getType() == null) {
            throw new IllegalArgumentException("The type of the destination of the connection must be specified.");
        }
        try {
            destinationConnectableType = ConnectableType.valueOf((String)requestConnection.getDestination().getType());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Unrecognized destination type %s. Expected values are [%s]", requestConnection.getDestination().getType(), StringUtils.join((Object[])ConnectableType.values(), (String)", ")));
        }
        if (this.isReplicateRequest()) {
            return this.replicate("POST", (Object)requestConnectionEntity);
        }
        return this.withWriteLock(this.serviceFacade, (Entity)requestConnectionEntity, lookup -> {
            Authorizable processGroup = lookup.getProcessGroup(groupId).getAuthorizable();
            processGroup.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
            Authorizable source = ConnectableType.REMOTE_OUTPUT_PORT.equals((Object)sourceConnectableType) ? lookup.getRemoteProcessGroup(requestConnection.getSource().getGroupId()) : lookup.getLocalConnectable(requestConnection.getSource().getId());
            if (source == null) {
                throw new ResourceNotFoundException("Cannot find source component with ID [" + requestConnection.getSource().getId() + "]");
            }
            source.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
            Authorizable destination = ConnectableType.REMOTE_INPUT_PORT.equals((Object)destinationConnectableType) ? lookup.getRemoteProcessGroup(requestConnection.getDestination().getGroupId()) : lookup.getLocalConnectable(requestConnection.getDestination().getId());
            if (destination == null) {
                throw new ResourceNotFoundException("Cannot find destination component with ID [" + requestConnection.getDestination().getId() + "]");
            }
            destination.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        }, () -> this.serviceFacade.verifyCreateConnection(groupId, requestConnection), connectionEntity -> {
            ConnectionDTO connection = connectionEntity.getComponent();
            connection.setId(this.generateUuid());
            Revision revision = this.getRevision((ComponentEntity)connectionEntity, connection.getId());
            ConnectionEntity entity = this.serviceFacade.createConnection(revision, groupId, connection);
            this.connectionResource.populateRemainingConnectionEntityContent(entity);
            String uri = entity.getUri();
            return this.clusterContext(this.generateCreatedResponse(URI.create(uri), (Object)entity)).build();
        });
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}/connections")
    @ApiOperation(value="Gets all connections", response=ConnectionsEntity.class, authorizations={@Authorization(value="Read - /process-groups/{uuid}", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getConnections(@ApiParam(value="The process group id.", required=true) @PathParam(value="id") String groupId) {
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable processGroup = lookup.getProcessGroup(groupId).getAuthorizable();
            processGroup.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        });
        Set connections = this.serviceFacade.getConnections(groupId);
        ConnectionsEntity entity = new ConnectionsEntity();
        entity.setConnections(this.connectionResource.populateRemainingConnectionEntitiesContent(connections));
        return this.clusterContext(this.generateOkResponse((Object)entity)).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{id}/snippet-instance")
    @ApiOperation(value="Copies a snippet and discards it.", response=FlowSnippetEntity.class, authorizations={@Authorization(value="Write - /process-groups/{uuid}", type=""), @Authorization(value="Read - /{component-type}/{uuid} - For each component in the snippet and their descendant components", type=""), @Authorization(value="Write - if the snippet contains any restricted Processors - /restricted-components", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response copySnippet(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The process group id.", required=true) @PathParam(value="id") String groupId, @ApiParam(value="The copy snippet request.", required=true) CopySnippetRequestEntity requestCopySnippetEntity) {
        if (requestCopySnippetEntity == null || requestCopySnippetEntity.getOriginX() == null || requestCopySnippetEntity.getOriginY() == null) {
            throw new IllegalArgumentException("The  origin position (x, y) must be specified");
        }
        if (requestCopySnippetEntity.getSnippetId() == null) {
            throw new IllegalArgumentException("The snippet id must be specified.");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("POST", (Object)requestCopySnippetEntity);
        }
        return this.withWriteLock(this.serviceFacade, (Entity)requestCopySnippetEntity, lookup -> {
            NiFiUser user = NiFiUserUtils.getNiFiUser();
            SnippetAuthorizable snippet = this.authorizeSnippetUsage(lookup, groupId, requestCopySnippetEntity.getSnippetId(), false);
            AtomicBoolean restrictedCheckPerformed = new AtomicBoolean(false);
            Consumer<ComponentAuthorizable> authorizeRestricted = authorizable -> {
                if (authorizable.isRestricted() && restrictedCheckPerformed.compareAndSet(false, true)) {
                    lookup.getRestrictedComponents().authorize(this.authorizer, RequestAction.WRITE, user);
                }
            };
            snippet.getSelectedProcessors().stream().forEach(authorizeRestricted);
            snippet.getSelectedProcessGroups().stream().forEach(processGroup -> processGroup.getEncapsulatedProcessors().forEach(authorizeRestricted));
        }, null, copySnippetRequestEntity -> {
            FlowEntity flowEntity = this.serviceFacade.copySnippet(groupId, copySnippetRequestEntity.getSnippetId(), copySnippetRequestEntity.getOriginX(), copySnippetRequestEntity.getOriginY(), (String)this.getIdGenerationSeed().orElse(null));
            FlowDTO flow = flowEntity.getFlow();
            for (ProcessGroupEntity childGroupEntity : flow.getProcessGroups()) {
                childGroupEntity.getComponent().setContents(null);
            }
            this.populateRemainingSnippetContent(flow);
            return this.clusterContext(this.generateCreatedResponse(this.getAbsolutePath(), (Object)flowEntity)).build();
        });
    }

    private void discoverCompatibleBundles(FlowSnippetDTO snippet) {
        if (snippet.getProcessors() != null) {
            snippet.getProcessors().forEach(processor -> {
                BundleCoordinate coordinate = BundleUtils.getCompatibleBundle((String)processor.getType(), (BundleDTO)processor.getBundle());
                processor.setBundle(new BundleDTO(coordinate.getGroup(), coordinate.getId(), coordinate.getVersion()));
            });
        }
        if (snippet.getControllerServices() != null) {
            snippet.getControllerServices().forEach(controllerService -> {
                BundleCoordinate coordinate = BundleUtils.getCompatibleBundle((String)controllerService.getType(), (BundleDTO)controllerService.getBundle());
                controllerService.setBundle(new BundleDTO(coordinate.getGroup(), coordinate.getId(), coordinate.getVersion()));
            });
        }
        if (snippet.getProcessGroups() != null) {
            snippet.getProcessGroups().forEach(processGroup -> this.discoverCompatibleBundles(processGroup.getContents()));
        }
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{id}/template-instance")
    @ApiOperation(value="Instantiates a template", response=FlowEntity.class, authorizations={@Authorization(value="Write - /process-groups/{uuid}", type=""), @Authorization(value="Read - /templates/{uuid}", type=""), @Authorization(value="Write - if the template contains any restricted components - /restricted-components", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response instantiateTemplate(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The process group id.", required=true) @PathParam(value="id") String groupId, @ApiParam(value="The instantiate template request.", required=true) InstantiateTemplateRequestEntity requestInstantiateTemplateRequestEntity) {
        if (requestInstantiateTemplateRequestEntity == null || requestInstantiateTemplateRequestEntity.getOriginX() == null || requestInstantiateTemplateRequestEntity.getOriginY() == null) {
            throw new IllegalArgumentException("The origin position (x, y) must be specified.");
        }
        if (requestInstantiateTemplateRequestEntity.getTemplateId() == null) {
            throw new IllegalArgumentException("The template id must be specified.");
        }
        if (requestInstantiateTemplateRequestEntity.getEncodingVersion() != null) {
            try {
                FlowEncodingVersion.parse((String)requestInstantiateTemplateRequestEntity.getEncodingVersion());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("The template encoding version is not valid. The expected format is <number>.<number>");
            }
        }
        if (requestInstantiateTemplateRequestEntity.getEncodingVersion() == null) {
            requestInstantiateTemplateRequestEntity.setEncodingVersion("1.1");
        }
        if (requestInstantiateTemplateRequestEntity.getSnippet() == null) {
            TemplateDTO requestedTemplate = this.serviceFacade.exportTemplate(requestInstantiateTemplateRequestEntity.getTemplateId());
            FlowSnippetDTO requestTemplateContents = requestedTemplate.getSnippet();
            this.discoverCompatibleBundles(requestTemplateContents);
            requestInstantiateTemplateRequestEntity.setEncodingVersion(requestedTemplate.getEncodingVersion());
            requestInstantiateTemplateRequestEntity.setSnippet(requestTemplateContents);
        }
        if (this.isReplicateRequest()) {
            return this.replicate("POST", (Object)requestInstantiateTemplateRequestEntity);
        }
        return this.withWriteLock(this.serviceFacade, (Entity)requestInstantiateTemplateRequestEntity, lookup -> {
            NiFiUser user = NiFiUserUtils.getNiFiUser();
            Authorizable processGroup = lookup.getProcessGroup(groupId).getAuthorizable();
            processGroup.authorize(this.authorizer, RequestAction.WRITE, user);
            Authorizable template = lookup.getTemplate(requestInstantiateTemplateRequestEntity.getTemplateId());
            template.authorize(this.authorizer, RequestAction.READ, user);
            TemplateContentsAuthorizable templateContents = lookup.getTemplateContents(requestInstantiateTemplateRequestEntity.getSnippet());
            AtomicBoolean restrictedCheckPerformed = new AtomicBoolean(false);
            Consumer<ComponentAuthorizable> authorizeRestricted = authorizable -> {
                if (authorizable.isRestricted() && restrictedCheckPerformed.compareAndSet(false, true)) {
                    lookup.getRestrictedComponents().authorize(this.authorizer, RequestAction.WRITE, user);
                }
            };
            templateContents.getEncapsulatedProcessors().forEach(authorizeRestricted);
            templateContents.getEncapsulatedControllerServices().forEach(authorizeRestricted);
        }, () -> this.serviceFacade.verifyComponentTypes(requestInstantiateTemplateRequestEntity.getSnippet()), instantiateTemplateRequestEntity -> {
            FlowEntity entity = this.serviceFacade.createTemplateInstance(groupId, instantiateTemplateRequestEntity.getOriginX(), instantiateTemplateRequestEntity.getOriginY(), instantiateTemplateRequestEntity.getEncodingVersion(), instantiateTemplateRequestEntity.getSnippet(), (String)this.getIdGenerationSeed().orElse(null));
            FlowDTO flowSnippet = entity.getFlow();
            for (ProcessGroupEntity childGroupEntity : flowSnippet.getProcessGroups()) {
                childGroupEntity.getComponent().setContents(null);
            }
            this.populateRemainingSnippetContent(flowSnippet);
            return this.clusterContext(this.generateCreatedResponse(this.getAbsolutePath(), (Object)entity)).build();
        });
    }

    private SnippetAuthorizable authorizeSnippetUsage(AuthorizableLookup lookup, String groupId, String snippetId, boolean authorizeTransitiveServices) {
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        lookup.getProcessGroup(groupId).getAuthorizable().authorize(this.authorizer, RequestAction.WRITE, user);
        SnippetAuthorizable snippet = lookup.getSnippet(snippetId);
        this.authorizeSnippet(snippet, this.authorizer, lookup, RequestAction.READ, true, authorizeTransitiveServices);
        return snippet;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{id}/templates")
    @ApiOperation(value="Creates a template and discards the specified snippet.", response=TemplateEntity.class, authorizations={@Authorization(value="Write - /process-groups/{uuid}", type=""), @Authorization(value="Read - /{component-type}/{uuid} - For each component in the snippet and their descendant components", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response createTemplate(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The process group id.", required=true) @PathParam(value="id") String groupId, @ApiParam(value="The create template request.", required=true) CreateTemplateRequestEntity requestCreateTemplateRequestEntity) {
        if (requestCreateTemplateRequestEntity.getSnippetId() == null) {
            throw new IllegalArgumentException("The snippet identifier must be specified.");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("POST", (Object)requestCreateTemplateRequestEntity);
        }
        return this.withWriteLock(this.serviceFacade, (Entity)requestCreateTemplateRequestEntity, lookup -> this.authorizeSnippetUsage(lookup, groupId, requestCreateTemplateRequestEntity.getSnippetId(), true), () -> this.serviceFacade.verifyCanAddTemplate(groupId, requestCreateTemplateRequestEntity.getName()), createTemplateRequestEntity -> {
            TemplateDTO template = this.serviceFacade.createTemplate(createTemplateRequestEntity.getName(), createTemplateRequestEntity.getDescription(), createTemplateRequestEntity.getSnippetId(), groupId, this.getIdGenerationSeed());
            this.templateResource.populateRemainingTemplateContent(template);
            TemplateEntity entity = new TemplateEntity();
            entity.setTemplate(template);
            return this.clusterContext(this.generateCreatedResponse(URI.create(template.getUri()), (Object)entity)).build();
        });
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/xml"})
    @Path(value="{id}/templates/upload")
    @ApiOperation(value="Uploads a template", response=TemplateEntity.class, authorizations={@Authorization(value="Write - /process-groups/{uuid}", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response uploadTemplate(@Context HttpServletRequest httpServletRequest, @Context UriInfo uriInfo, @ApiParam(value="The process group id.", required=true) @PathParam(value="id") String groupId, @FormDataParam(value="template") InputStream in) throws InterruptedException {
        TemplateDTO template;
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{TemplateDTO.class});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            JAXBElement templateElement = unmarshaller.unmarshal((Source)new StreamSource(in), TemplateDTO.class);
            template = (TemplateDTO)templateElement.getValue();
        }
        catch (JAXBException jaxbe) {
            logger.warn("An error occurred while parsing a template.", (Throwable)jaxbe);
            String responseXml = String.format("<errorResponse status=\"%s\" statusText=\"The specified template is not in a valid format.\"/>", Response.Status.BAD_REQUEST.getStatusCode());
            return Response.status((Response.Status)Response.Status.OK).entity((Object)responseXml).type("application/xml").build();
        }
        catch (IllegalArgumentException iae) {
            logger.warn("Unable to import template.", (Throwable)iae);
            String responseXml = String.format("<errorResponse status=\"%s\" statusText=\"%s\"/>", Response.Status.BAD_REQUEST.getStatusCode(), iae.getMessage());
            return Response.status((Response.Status)Response.Status.OK).entity((Object)responseXml).type("application/xml").build();
        }
        catch (Exception e) {
            logger.warn("An error occurred while importing a template.", (Throwable)e);
            String responseXml = String.format("<errorResponse status=\"%s\" statusText=\"Unable to import the specified template: %s\"/>", Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), e.getMessage());
            return Response.status((Response.Status)Response.Status.OK).entity((Object)responseXml).type("application/xml").build();
        }
        TemplateEntity entity = new TemplateEntity();
        entity.setTemplate(template);
        if (this.isReplicateRequest()) {
            UriBuilder uriBuilder = uriInfo.getBaseUriBuilder();
            uriBuilder.segment(new String[]{"process-groups", groupId, "templates", "import"});
            URI importUri = uriBuilder.build(new Object[0]);
            HashMap<String, String> headersToOverride = new HashMap<String, String>();
            headersToOverride.put("content-type", "application/xml");
            if (this.getReplicationTarget() == ApplicationResource.ReplicationTarget.CLUSTER_NODES) {
                return this.getRequestReplicator().replicate("POST", importUri, (Object)entity, this.getHeaders(headersToOverride)).awaitMergedResponse().getResponse();
            }
            return this.getRequestReplicator().forwardToCoordinator(this.getClusterCoordinatorNode(), "POST", importUri, (Object)entity, this.getHeaders(headersToOverride)).awaitMergedResponse().getResponse();
        }
        return this.importTemplate(httpServletRequest, groupId, entity);
    }

    @POST
    @Consumes(value={"application/xml"})
    @Produces(value={"application/xml"})
    @Path(value="{id}/templates/import")
    @ApiOperation(value="Imports a template", response=TemplateEntity.class, authorizations={@Authorization(value="Write - /process-groups/{uuid}", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response importTemplate(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The process group id.", required=true) @PathParam(value="id") String groupId, TemplateEntity requestTemplateEntity) {
        if (requestTemplateEntity == null || requestTemplateEntity.getTemplate() == null || requestTemplateEntity.getTemplate().getSnippet() == null) {
            throw new IllegalArgumentException("Template details must be specified.");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("POST", (Object)requestTemplateEntity);
        }
        return this.withWriteLock(this.serviceFacade, (Entity)requestTemplateEntity, lookup -> {
            Authorizable processGroup = lookup.getProcessGroup(groupId).getAuthorizable();
            processGroup.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        }, () -> this.serviceFacade.verifyCanAddTemplate(groupId, requestTemplateEntity.getTemplate().getName()), templateEntity -> {
            try {
                TemplateDTO template = this.serviceFacade.importTemplate(templateEntity.getTemplate(), groupId, this.getIdGenerationSeed());
                this.templateResource.populateRemainingTemplateContent(template);
                TemplateEntity entity = new TemplateEntity();
                entity.setTemplate(template);
                return this.clusterContext(this.generateCreatedResponse(URI.create(template.getUri()), (Object)entity)).build();
            }
            catch (IllegalArgumentException | IllegalStateException e) {
                logger.info("Unable to import template: " + e);
                String responseXml = String.format("<errorResponse status=\"%s\" statusText=\"%s\"/>", Response.Status.BAD_REQUEST.getStatusCode(), e.getMessage());
                return Response.status((Response.Status)Response.Status.OK).entity((Object)responseXml).type("application/xml").build();
            }
            catch (Exception e) {
                logger.warn("An error occurred while importing a template.", (Throwable)e);
                String responseXml = String.format("<errorResponse status=\"%s\" statusText=\"Unable to import the specified template: %s\"/>", Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), e.getMessage());
                return Response.status((Response.Status)Response.Status.OK).entity((Object)responseXml).type("application/xml").build();
            }
        });
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{id}/controller-services")
    @ApiOperation(value="Creates a new controller service", response=ControllerServiceEntity.class, authorizations={@Authorization(value="Write - /process-groups/{uuid}", type=""), @Authorization(value="Read - any referenced Controller Services - /controller-services/{uuid}", type=""), @Authorization(value="Write - if the Controller Service is restricted - /restricted-components", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response createControllerService(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The process group id.", required=true) @PathParam(value="id") String groupId, @ApiParam(value="The controller service configuration details.", required=true) ControllerServiceEntity requestControllerServiceEntity) {
        if (requestControllerServiceEntity == null || requestControllerServiceEntity.getComponent() == null) {
            throw new IllegalArgumentException("Controller service details must be specified.");
        }
        if (requestControllerServiceEntity.getRevision() == null || requestControllerServiceEntity.getRevision().getVersion() == null || requestControllerServiceEntity.getRevision().getVersion() != 0L) {
            throw new IllegalArgumentException("A revision of 0 must be specified when creating a new Controller service.");
        }
        ControllerServiceDTO requestControllerService = requestControllerServiceEntity.getComponent();
        if (requestControllerService.getId() != null) {
            throw new IllegalArgumentException("Controller service ID cannot be specified.");
        }
        if (StringUtils.isBlank((CharSequence)requestControllerService.getType())) {
            throw new IllegalArgumentException("The type of controller service to create must be specified.");
        }
        if (requestControllerService.getParentGroupId() != null && !groupId.equals(requestControllerService.getParentGroupId())) {
            throw new IllegalArgumentException(String.format("If specified, the parent process group id %s must be the same as specified in the URI %s", requestControllerService.getParentGroupId(), groupId));
        }
        requestControllerService.setParentGroupId(groupId);
        if (this.isReplicateRequest()) {
            return this.replicate("POST", (Object)requestControllerServiceEntity);
        }
        return this.withWriteLock(this.serviceFacade, (Entity)requestControllerServiceEntity, lookup -> {
            NiFiUser user = NiFiUserUtils.getNiFiUser();
            Authorizable processGroup = lookup.getProcessGroup(groupId).getAuthorizable();
            processGroup.authorize(this.authorizer, RequestAction.WRITE, user);
            ComponentAuthorizable authorizable = null;
            try {
                authorizable = lookup.getConfigurableComponent(requestControllerService.getType(), requestControllerService.getBundle());
                if (authorizable.isRestricted()) {
                    lookup.getRestrictedComponents().authorize(this.authorizer, RequestAction.WRITE, user);
                }
                if (requestControllerService.getProperties() != null) {
                    AuthorizeControllerServiceReference.authorizeControllerServiceReferences((Map)requestControllerService.getProperties(), (ComponentAuthorizable)authorizable, (Authorizer)this.authorizer, (AuthorizableLookup)lookup);
                }
            }
            finally {
                if (authorizable != null) {
                    authorizable.cleanUpResources();
                }
            }
        }, () -> this.serviceFacade.verifyCreateControllerService(requestControllerService), controllerServiceEntity -> {
            ControllerServiceDTO controllerService = controllerServiceEntity.getComponent();
            controllerService.setId(this.generateUuid());
            Revision revision = this.getRevision((ComponentEntity)controllerServiceEntity, controllerService.getId());
            ControllerServiceEntity entity = this.serviceFacade.createControllerService(revision, groupId, controllerService);
            this.controllerServiceResource.populateRemainingControllerServiceEntityContent(entity);
            return this.clusterContext(this.generateCreatedResponse(URI.create(entity.getUri()), (Object)entity)).build();
        });
    }

    public void setServiceFacade(NiFiServiceFacade serviceFacade) {
        this.serviceFacade = serviceFacade;
    }

    public void setProcessorResource(ProcessorResource processorResource) {
        this.processorResource = processorResource;
    }

    public void setInputPortResource(InputPortResource inputPortResource) {
        this.inputPortResource = inputPortResource;
    }

    public void setOutputPortResource(OutputPortResource outputPortResource) {
        this.outputPortResource = outputPortResource;
    }

    public void setFunnelResource(FunnelResource funnelResource) {
        this.funnelResource = funnelResource;
    }

    public void setLabelResource(LabelResource labelResource) {
        this.labelResource = labelResource;
    }

    public void setRemoteProcessGroupResource(RemoteProcessGroupResource remoteProcessGroupResource) {
        this.remoteProcessGroupResource = remoteProcessGroupResource;
    }

    public void setConnectionResource(ConnectionResource connectionResource) {
        this.connectionResource = connectionResource;
    }

    public void setTemplateResource(TemplateResource templateResource) {
        this.templateResource = templateResource;
    }

    public void setControllerServiceResource(ControllerServiceResource controllerServiceResource) {
        this.controllerServiceResource = controllerServiceResource;
    }

    public void setAuthorizer(Authorizer authorizer) {
        this.authorizer = authorizer;
    }
}

