/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.dao.impl;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.registry.flow.FlowRegistryBucket;
import org.apache.nifi.registry.flow.FlowRegistryClientNode;
import org.apache.nifi.registry.flow.FlowRegistryClientUserContext;
import org.apache.nifi.registry.flow.FlowRegistryException;
import org.apache.nifi.registry.flow.RegisteredFlow;
import org.apache.nifi.registry.flow.RegisteredFlowSnapshotMetadata;
import org.apache.nifi.util.BundleUtils;
import org.apache.nifi.web.NiFiCoreException;
import org.apache.nifi.web.ResourceNotFoundException;
import org.apache.nifi.web.api.dto.BundleDTO;
import org.apache.nifi.web.api.dto.FlowRegistryClientDTO;
import org.apache.nifi.web.dao.FlowRegistryDAO;
import org.apache.nifi.web.dao.impl.ComponentDAO;

public class StandardFlowRegistryDAO
extends ComponentDAO
implements FlowRegistryDAO {
    private FlowController flowController;

    public FlowRegistryClientNode createFlowRegistryClient(FlowRegistryClientDTO flowRegistryClientDto) {
        if (flowRegistryClientDto.getType() == null) {
            throw new IllegalArgumentException("The flow registry client type must be specified.");
        }
        this.verifyCreate(this.flowController.getExtensionManager(), flowRegistryClientDto.getType(), flowRegistryClientDto.getBundle());
        BundleCoordinate bundleCoordinate = BundleUtils.getBundle((ExtensionManager)this.flowController.getExtensionManager(), (String)flowRegistryClientDto.getType(), (BundleDTO)flowRegistryClientDto.getBundle());
        FlowRegistryClientNode flowRegistryClient = this.flowController.getFlowManager().createFlowRegistryClient(flowRegistryClientDto.getType(), flowRegistryClientDto.getId(), bundleCoordinate, Collections.emptySet(), true, true, null);
        this.configureFlowRegistry(flowRegistryClient, flowRegistryClientDto);
        return flowRegistryClient;
    }

    public FlowRegistryClientNode updateFlowRegistryClient(FlowRegistryClientDTO flowRegistryClientDto) {
        FlowRegistryClientNode client = this.getFlowRegistryClient(flowRegistryClientDto.getId());
        this.verifyUpdate(client, flowRegistryClientDto);
        this.configureFlowRegistry(client, flowRegistryClientDto);
        return client;
    }

    private void verifyUpdate(FlowRegistryClientNode client, FlowRegistryClientDTO flowRegistryClientDto) {
        boolean duplicateName = this.getFlowRegistryClients().stream().anyMatch(reg -> reg.getName().equals(flowRegistryClientDto.getName()) && !reg.getIdentifier().equals(flowRegistryClientDto.getId()));
        if (duplicateName) {
            throw new IllegalStateException("Cannot update Flow Registry because a Flow Registry already exists with the name " + flowRegistryClientDto.getName());
        }
    }

    public FlowRegistryClientNode getFlowRegistryClient(String registryId) {
        FlowRegistryClientNode registry = this.flowController.getFlowManager().getFlowRegistryClient(registryId);
        if (registry == null) {
            throw new ResourceNotFoundException("Unable to find Flow Registry with id '" + registryId + "'");
        }
        return registry;
    }

    public Set<FlowRegistryClientNode> getFlowRegistryClients() {
        return this.flowController.getFlowManager().getAllFlowRegistryClients();
    }

    public Set<FlowRegistryClientNode> getFlowRegistryClientsForUser(FlowRegistryClientUserContext context) {
        return this.getFlowRegistryClients();
    }

    public Set<FlowRegistryBucket> getBucketsForUser(FlowRegistryClientUserContext context, String registryId) {
        try {
            FlowRegistryClientNode flowRegistry = this.flowController.getFlowManager().getFlowRegistryClient(registryId);
            if (flowRegistry == null) {
                throw new IllegalArgumentException("The specified registry id is unknown to this NiFi.");
            }
            Set buckets = flowRegistry.getBuckets(context);
            TreeSet<FlowRegistryBucket> sortedBuckets = new TreeSet<FlowRegistryBucket>((b1, b2) -> b1.getName().compareTo(b2.getName()));
            sortedBuckets.addAll(buckets);
            return sortedBuckets;
        }
        catch (FlowRegistryException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        catch (IOException ioe) {
            throw new NiFiCoreException("Unable to obtain listing of buckets: " + ioe, (Throwable)ioe);
        }
    }

    public Set<RegisteredFlow> getFlowsForUser(FlowRegistryClientUserContext context, String registryId, String bucketId) {
        try {
            FlowRegistryClientNode flowRegistry = this.flowController.getFlowManager().getFlowRegistryClient(registryId);
            if (flowRegistry == null) {
                throw new IllegalArgumentException("The specified registry id is unknown to this NiFi.");
            }
            Set flows = flowRegistry.getFlows(context, bucketId);
            TreeSet<RegisteredFlow> sortedFlows = new TreeSet<RegisteredFlow>((f1, f2) -> f1.getName().compareTo(f2.getName()));
            sortedFlows.addAll(flows);
            return sortedFlows;
        }
        catch (IOException | FlowRegistryException ioe) {
            throw new NiFiCoreException("Unable to obtain listing of flows for bucket with ID " + bucketId + ": " + ioe, ioe);
        }
    }

    public RegisteredFlow getFlowForUser(FlowRegistryClientUserContext context, String registryId, String bucketId, String flowId) {
        try {
            FlowRegistryClientNode flowRegistry = this.flowController.getFlowManager().getFlowRegistryClient(registryId);
            if (flowRegistry == null) {
                throw new IllegalArgumentException("The specified registry id is unknown to this NiFi.");
            }
            return flowRegistry.getFlow(context, bucketId, flowId);
        }
        catch (IOException | FlowRegistryException ioe) {
            throw new NiFiCoreException("Unable to obtain listing of flows for bucket with ID " + bucketId + ": " + ioe, ioe);
        }
    }

    public Set<RegisteredFlowSnapshotMetadata> getFlowVersionsForUser(FlowRegistryClientUserContext context, String registryId, String bucketId, String flowId) {
        try {
            FlowRegistryClientNode flowRegistry = this.flowController.getFlowManager().getFlowRegistryClient(registryId);
            if (flowRegistry == null) {
                throw new IllegalArgumentException("The specified registry id is unknown to this NiFi.");
            }
            Set flowVersions = flowRegistry.getFlowVersions(context, bucketId, flowId);
            TreeSet<RegisteredFlowSnapshotMetadata> sortedFlowVersions = new TreeSet<RegisteredFlowSnapshotMetadata>((f1, f2) -> Integer.compare(f1.getVersion(), f2.getVersion()));
            sortedFlowVersions.addAll(flowVersions);
            return sortedFlowVersions;
        }
        catch (IOException | FlowRegistryException ioe) {
            throw new NiFiCoreException("Unable to obtain listing of versions for bucket with ID " + bucketId + " and flow with ID " + flowId + ": " + ioe, ioe);
        }
    }

    public FlowRegistryClientNode removeFlowRegistry(String registryId) {
        FlowRegistryClientNode flowRegistry = this.flowController.getFlowManager().getFlowRegistryClient(registryId);
        if (flowRegistry == null) {
            throw new IllegalArgumentException("The specified registry id is unknown to this NiFi.");
        }
        this.flowController.getFlowManager().removeFlowRegistryClientNode(flowRegistry);
        return flowRegistry;
    }

    public void setFlowController(FlowController flowController) {
        this.flowController = flowController;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureFlowRegistry(FlowRegistryClientNode node, FlowRegistryClientDTO dto) {
        String name = dto.getName();
        String description = dto.getDescription();
        Map properties = dto.getProperties();
        node.pauseValidationTrigger();
        try {
            if (this.isNotNull((Object)name)) {
                node.setName(name);
            }
            if (this.isNotNull((Object)description)) {
                node.setDescription(description);
            }
            if (this.isNotNull((Object)properties)) {
                Set sensitiveDynamicPropertyNames = Optional.ofNullable(dto.getSensitiveDynamicPropertyNames()).orElse(Collections.emptySet());
                node.setProperties(properties, false, sensitiveDynamicPropertyNames);
            }
        }
        finally {
            node.resumeValidationTrigger();
        }
    }
}

