/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web;

import java.net.URI;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.action.Component;
import org.apache.nifi.action.FlowChangeAction;
import org.apache.nifi.action.Operation;
import org.apache.nifi.action.component.details.FlowChangeExtensionDetails;
import org.apache.nifi.action.details.ActionDetails;
import org.apache.nifi.action.details.FlowChangeConfigureDetails;
import org.apache.nifi.admin.service.AuditService;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.cluster.coordination.ClusterCoordinator;
import org.apache.nifi.cluster.coordination.http.replication.RequestReplicator;
import org.apache.nifi.cluster.exception.NoClusterCoordinatorException;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.reporting.ReportingTaskProvider;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.registry.VariableRegistry;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.ClusterRequestException;
import org.apache.nifi.web.ComponentDetails;
import org.apache.nifi.web.ConfigurationAction;
import org.apache.nifi.web.InvalidRevisionException;
import org.apache.nifi.web.NiFiServiceFacade;
import org.apache.nifi.web.NiFiWebConfigurationContext;
import org.apache.nifi.web.NiFiWebConfigurationRequestContext;
import org.apache.nifi.web.NiFiWebRequestContext;
import org.apache.nifi.web.ResourceNotFoundException;
import org.apache.nifi.web.StandardNiFiWebConfigurationContext;
import org.apache.nifi.web.api.ApplicationResource;
import org.apache.nifi.web.util.ClientResponseUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardNiFiWebConfigurationContext
implements NiFiWebConfigurationContext {
    private static final Logger logger = LoggerFactory.getLogger(StandardNiFiWebConfigurationContext.class);
    private NiFiProperties properties;
    private NiFiServiceFacade serviceFacade;
    private ClusterCoordinator clusterCoordinator;
    private RequestReplicator requestReplicator;
    private ControllerServiceProvider controllerServiceProvider;
    private ReportingTaskProvider reportingTaskProvider;
    private AuditService auditService;
    private Authorizer authorizer;
    private VariableRegistry variableRegistry;

    private void authorizeFlowAccess(NiFiUser user) {
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable flow = lookup.getFlow();
            flow.authorize(this.authorizer, RequestAction.READ, user);
        });
    }

    public ControllerService getControllerService(String serviceIdentifier, String componentId) {
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        this.authorizeFlowAccess(user);
        return this.controllerServiceProvider.getControllerServiceForComponent(serviceIdentifier, componentId);
    }

    public void saveActions(NiFiWebRequestContext requestContext, Collection<ConfigurationAction> configurationActions) {
        block11: {
            Objects.requireNonNull(configurationActions, "Actions cannot be null.");
            if (requestContext.getExtensionType() == null) {
                throw new IllegalArgumentException("The UI extension type must be specified.");
            }
            Component componentType = null;
            switch (1.$SwitchMap$org$apache$nifi$web$UiExtensionType[requestContext.getExtensionType().ordinal()]) {
                case 1: {
                    this.serviceFacade.authorizeAccess(lookup -> {
                        Authorizable authorizable = lookup.getProcessor(requestContext.getId()).getAuthorizable();
                        authorizable.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
                    });
                    componentType = Component.Processor;
                    break;
                }
                case 2: {
                    this.serviceFacade.authorizeAccess(lookup -> {
                        Authorizable authorizable = lookup.getControllerService(requestContext.getId()).getAuthorizable();
                        authorizable.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
                    });
                    componentType = Component.ControllerService;
                    break;
                }
                case 3: {
                    this.serviceFacade.authorizeAccess(lookup -> {
                        Authorizable authorizable = lookup.getReportingTask(requestContext.getId()).getAuthorizable();
                        authorizable.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
                    });
                    componentType = Component.ReportingTask;
                }
            }
            if (componentType == null) {
                throw new IllegalArgumentException("UI extension type must support Processor, ControllerService, or ReportingTask configuration.");
            }
            Date now = new Date();
            HashSet<FlowChangeAction> actions = new HashSet<FlowChangeAction>(configurationActions.size());
            for (ConfigurationAction configurationAction : configurationActions) {
                FlowChangeExtensionDetails extensionDetails = new FlowChangeExtensionDetails();
                extensionDetails.setType(configurationAction.getType());
                FlowChangeConfigureDetails configureDetails = new FlowChangeConfigureDetails();
                configureDetails.setName(configurationAction.getName());
                configureDetails.setPreviousValue(configurationAction.getPreviousValue());
                configureDetails.setValue(configurationAction.getValue());
                FlowChangeAction action = new FlowChangeAction();
                action.setTimestamp(now);
                action.setSourceId(configurationAction.getId());
                action.setSourceName(configurationAction.getName());
                action.setSourceType(componentType);
                action.setOperation(Operation.Configure);
                action.setUserIdentity(this.getCurrentUserIdentity());
                action.setComponentDetails((org.apache.nifi.action.component.details.ComponentDetails)extensionDetails);
                action.setActionDetails((ActionDetails)configureDetails);
                actions.add(action);
            }
            if (!actions.isEmpty()) {
                try {
                    this.auditService.addActions(actions);
                }
                catch (Throwable t) {
                    logger.warn("Unable to record actions: " + t.getMessage());
                    if (!logger.isDebugEnabled()) break block11;
                    logger.warn("", t);
                }
            }
        }
    }

    public String getCurrentUserIdentity() {
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        this.authorizeFlowAccess(user);
        return user.getIdentity();
    }

    public ComponentDetails getComponentDetails(NiFiWebRequestContext requestContext) throws ResourceNotFoundException, ClusterRequestException {
        String id = requestContext.getId();
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new ResourceNotFoundException(String.format("Configuration request context config did not have a component ID.", new Object[0]));
        }
        if (requestContext.getExtensionType() == null) {
            throw new IllegalArgumentException("The UI extension type must be specified.");
        }
        ProcessorFacade componentFacade = null;
        switch (1.$SwitchMap$org$apache$nifi$web$UiExtensionType[requestContext.getExtensionType().ordinal()]) {
            case 1: {
                componentFacade = new ProcessorFacade(this, null);
                break;
            }
            case 2: {
                componentFacade = new ControllerServiceFacade(this, null);
                break;
            }
            case 3: {
                componentFacade = new ReportingTaskFacade(this, null);
            }
        }
        if (componentFacade == null) {
            throw new IllegalArgumentException("UI extension type must support Processor, ControllerService, or ReportingTask configuration.");
        }
        return componentFacade.getComponentDetails(requestContext);
    }

    public ComponentDetails updateComponent(NiFiWebConfigurationRequestContext requestContext, String annotationData, Map<String, String> properties) throws ResourceNotFoundException, InvalidRevisionException, ClusterRequestException {
        String id = requestContext.getId();
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new ResourceNotFoundException(String.format("Configuration request context did not have a component ID.", new Object[0]));
        }
        if (requestContext.getExtensionType() == null) {
            throw new IllegalArgumentException("The UI extension type must be specified.");
        }
        ProcessorFacade componentFacade = null;
        switch (1.$SwitchMap$org$apache$nifi$web$UiExtensionType[requestContext.getExtensionType().ordinal()]) {
            case 1: {
                componentFacade = new ProcessorFacade(this, null);
                break;
            }
            case 2: {
                componentFacade = new ControllerServiceFacade(this, null);
                break;
            }
            case 3: {
                componentFacade = new ReportingTaskFacade(this, null);
            }
        }
        if (componentFacade == null) {
            throw new IllegalArgumentException("UI extension type must support Processor, ControllerService, or ReportingTask configuration.");
        }
        if (this.properties.isClustered() && this.clusterCoordinator != null && !this.clusterCoordinator.isConnected() && !Boolean.TRUE.equals(requestContext.isDisconnectionAcknowledged())) {
            throw new IllegalArgumentException("This node is disconnected from its configured cluster. The requested change will only be allowed if the flag to acknowledge the disconnected node is set.");
        }
        return componentFacade.updateComponent(requestContext, annotationData, properties);
    }

    private ApplicationResource.ReplicationTarget getReplicationTarget() {
        return this.clusterCoordinator.isActiveClusterCoordinator() ? ApplicationResource.ReplicationTarget.CLUSTER_NODES : ApplicationResource.ReplicationTarget.CLUSTER_COORDINATOR;
    }

    private NodeResponse replicate(String method, URI uri, Object entity, Map<String, String> headers) throws InterruptedException {
        if (this.getReplicationTarget() == ApplicationResource.ReplicationTarget.CLUSTER_NODES) {
            return this.requestReplicator.replicate(method, uri, entity, headers).awaitMergedResponse();
        }
        NodeIdentifier coordinatorNode = this.clusterCoordinator.getElectedActiveCoordinatorNode();
        if (coordinatorNode == null) {
            throw new NoClusterCoordinatorException();
        }
        return this.requestReplicator.forwardToCoordinator(coordinatorNode, method, uri, entity, headers).awaitMergedResponse();
    }

    private Map<String, String> getHeaders(NiFiWebRequestContext config) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json,application/xml");
        return headers;
    }

    private void checkResponse(NodeResponse nodeResponse, String id) {
        if (nodeResponse.hasThrowable()) {
            ClientResponseUtils.drainClientResponse((Response)nodeResponse.getClientResponse());
            throw new ClusterRequestException(nodeResponse.getThrowable());
        }
        if (nodeResponse.getClientResponse().getStatus() == Response.Status.CONFLICT.getStatusCode()) {
            ClientResponseUtils.drainClientResponse((Response)nodeResponse.getClientResponse());
            throw new InvalidRevisionException(String.format("NiFi is unable to process the request at this time.", new Object[0]));
        }
        if (nodeResponse.getClientResponse().getStatus() == Response.Status.NOT_FOUND.getStatusCode()) {
            ClientResponseUtils.drainClientResponse((Response)nodeResponse.getClientResponse());
            throw new ResourceNotFoundException("Unable to find component with id: " + id);
        }
        if (nodeResponse.getClientResponse().getStatus() != Response.Status.OK.getStatusCode()) {
            ClientResponseUtils.drainClientResponse((Response)nodeResponse.getClientResponse());
            throw new ClusterRequestException("Method resulted in an unsuccessful HTTP response code: " + nodeResponse.getClientResponse().getStatus());
        }
    }

    public void setClusterCoordinator(ClusterCoordinator clusterCoordinator) {
        this.clusterCoordinator = clusterCoordinator;
    }

    public void setRequestReplicator(RequestReplicator requestReplicator) {
        this.requestReplicator = requestReplicator;
    }

    public void setProperties(NiFiProperties properties) {
        this.properties = properties;
    }

    public void setServiceFacade(NiFiServiceFacade serviceFacade) {
        this.serviceFacade = serviceFacade;
    }

    public void setAuditService(AuditService auditService) {
        this.auditService = auditService;
    }

    public void setControllerServiceProvider(ControllerServiceProvider controllerServiceProvider) {
        this.controllerServiceProvider = controllerServiceProvider;
    }

    public void setReportingTaskProvider(ReportingTaskProvider reportingTaskProvider) {
        this.reportingTaskProvider = reportingTaskProvider;
    }

    public void setAuthorizer(Authorizer authorizer) {
        this.authorizer = authorizer;
    }

    public void setVariableRegistry(VariableRegistry variableRegistry) {
        this.variableRegistry = variableRegistry;
    }

    static /* synthetic */ NiFiServiceFacade access$300(StandardNiFiWebConfigurationContext x0) {
        return x0.serviceFacade;
    }

    static /* synthetic */ NiFiProperties access$400(StandardNiFiWebConfigurationContext x0) {
        return x0.properties;
    }

    static /* synthetic */ ClusterCoordinator access$500(StandardNiFiWebConfigurationContext x0) {
        return x0.clusterCoordinator;
    }

    static /* synthetic */ Map access$600(StandardNiFiWebConfigurationContext x0, NiFiWebRequestContext x1) {
        return x0.getHeaders(x1);
    }

    static /* synthetic */ NodeResponse access$700(StandardNiFiWebConfigurationContext x0, String x1, URI x2, Object x3, Map x4) throws InterruptedException {
        return x0.replicate(x1, x2, x3, x4);
    }

    static /* synthetic */ void access$800(StandardNiFiWebConfigurationContext x0, NodeResponse x1, String x2) {
        x0.checkResponse(x1, x2);
    }

    static /* synthetic */ Authorizer access$900(StandardNiFiWebConfigurationContext x0) {
        return x0.authorizer;
    }
}

