/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.authorization;

import java.util.Map;
import java.util.Objects;
import org.apache.nifi.authorization.AuthorizableLookup;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.ComponentAuthorizable;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.parameter.ExpressionLanguageAgnosticParameterParser;
import org.apache.nifi.parameter.ParameterTokenList;
import org.apache.nifi.web.ResourceNotFoundException;

/*
 * Exception performing whole class analysis ignored.
 */
public final class AuthorizeControllerServiceReference {
    public static void authorizeControllerServiceReferences(ComponentAuthorizable authorizable, Authorizer authorizer, AuthorizableLookup lookup, boolean authorizeTransitiveServices) {
        authorizable.getPropertyDescriptors().forEach(descriptor -> {
            String serviceId;
            if (descriptor.getControllerServiceDefinition() != null && (serviceId = authorizable.getValue(descriptor)) != null) {
                try {
                    ComponentAuthorizable currentServiceAuthorizable = lookup.getControllerService(serviceId);
                    currentServiceAuthorizable.getAuthorizable().authorize(authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
                    if (authorizeTransitiveServices) {
                        AuthorizeControllerServiceReference.authorizeControllerServiceReferences((ComponentAuthorizable)currentServiceAuthorizable, (Authorizer)authorizer, (AuthorizableLookup)lookup, (boolean)authorizeTransitiveServices);
                    }
                }
                catch (ResourceNotFoundException resourceNotFoundException) {
                    // empty catch block
                }
            }
        });
    }

    public static void authorizeControllerServiceReferences(Map<String, String> proposedProperties, ComponentAuthorizable authorizable, Authorizer authorizer, AuthorizableLookup lookup) {
        if (proposedProperties != null) {
            NiFiUser user = NiFiUserUtils.getNiFiUser();
            for (Map.Entry<String, String> entry : proposedProperties.entrySet()) {
                boolean referencesParameter;
                String proposedValue;
                String currentValue;
                String propertyName = entry.getKey();
                PropertyDescriptor propertyDescriptor = authorizable.getPropertyDescriptor(propertyName);
                if (propertyDescriptor.getControllerServiceDefinition() == null || Objects.equals(currentValue = authorizable.getValue(propertyDescriptor), proposedValue = entry.getValue())) continue;
                if (currentValue != null) {
                    try {
                        Authorizable currentServiceAuthorizable = lookup.getControllerService(currentValue).getAuthorizable();
                        currentServiceAuthorizable.authorize(authorizer, RequestAction.READ, user);
                    }
                    catch (ResourceNotFoundException currentServiceAuthorizable) {
                        // empty catch block
                    }
                }
                if (proposedValue == null) continue;
                ExpressionLanguageAgnosticParameterParser parser = new ExpressionLanguageAgnosticParameterParser();
                ParameterTokenList tokenList = parser.parseTokens(proposedValue);
                boolean bl = referencesParameter = !tokenList.toReferenceList().isEmpty();
                if (referencesParameter) {
                    throw new IllegalArgumentException("The property '" + propertyDescriptor.getDisplayName() + "' cannot reference a Parameter because the property is a Controller Service reference. Allowing Controller Service references to make use of Parameters could result in security issues and a poor user experience. As a result, this is not allowed.");
                }
                Authorizable newServiceAuthorizable = lookup.getControllerService(proposedValue).getAuthorizable();
                newServiceAuthorizable.authorize(authorizer, RequestAction.READ, user);
            }
        }
    }
}

