/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.audit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.nifi.action.Action;
import org.apache.nifi.action.Component;
import org.apache.nifi.action.FlowChangeAction;
import org.apache.nifi.action.Operation;
import org.apache.nifi.action.component.details.ComponentDetails;
import org.apache.nifi.action.component.details.FlowChangeRemoteProcessGroupDetails;
import org.apache.nifi.action.details.ActionDetails;
import org.apache.nifi.audit.NiFiAuditor;
import org.apache.nifi.audit.RemoteProcessGroupAuditor;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.controller.AbstractPort;
import org.apache.nifi.groups.RemoteProcessGroup;
import org.apache.nifi.remote.RemoteGroupPort;
import org.apache.nifi.util.StringUtils;
import org.apache.nifi.web.api.dto.RemoteProcessGroupDTO;
import org.apache.nifi.web.api.dto.RemoteProcessGroupPortDTO;
import org.apache.nifi.web.dao.RemoteProcessGroupDAO;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@Aspect
public class RemoteProcessGroupAuditor
extends NiFiAuditor {
    private static final Logger logger = LoggerFactory.getLogger(RemoteProcessGroupAuditor.class);
    private static final Function<RemoteProcessGroupDTO, Boolean> IS_TRANSPORT_PROTOCOL_SET = dto -> dto.getTransportProtocol() != null;
    private static final List<ConfigurationRecorder<RemoteProcessGroup, RemoteProcessGroupDTO>> CONFIG_RECORDERS = Arrays.asList(new ConfigurationRecorder("Communications Timeout", dto -> dto.getCommunicationsTimeout() != null, RemoteProcessGroup::getCommunicationsTimeout, null), new ConfigurationRecorder("Yield Duration", dto -> dto.getYieldDuration() != null, RemoteProcessGroup::getYieldDuration, null), new ConfigurationRecorder("Transport Protocol", IS_TRANSPORT_PROTOCOL_SET, rpg -> rpg.getTransportProtocol().name(), null), new ConfigurationRecorder("Proxy Host", IS_TRANSPORT_PROTOCOL_SET, RemoteProcessGroup::getProxyHost, null), new ConfigurationRecorder("Proxy Port", IS_TRANSPORT_PROTOCOL_SET, RemoteProcessGroup::getProxyPort, null), new ConfigurationRecorder("Proxy User", IS_TRANSPORT_PROTOCOL_SET, RemoteProcessGroup::getProxyUser, null), ConfigurationRecorder.access$100((ConfigurationRecorder)new ConfigurationRecorder("Proxy Password", IS_TRANSPORT_PROTOCOL_SET, RemoteProcessGroup::getProxyPassword, null), v -> StringUtils.isEmpty((String)v) ? "" : "********"));
    private static final BiFunction<RemoteGroupPort, String, String> PORT_NAME_CONVERT = (updated, name) -> updated.getName() + "." + name;
    private static final List<ConfigurationRecorder<RemoteGroupPort, RemoteProcessGroupPortDTO>> PORT_CONFIG_RECORDERS = Arrays.asList(ConfigurationRecorder.access$100((ConfigurationRecorder)ConfigurationRecorder.access$200((ConfigurationRecorder)new ConfigurationRecorder("Transmission", dto -> dto.isTransmitting() != null, AbstractPort::isRunning, null), (BiFunction)PORT_NAME_CONVERT), v -> Boolean.valueOf(v) != false ? "enabled" : "disabled"), ConfigurationRecorder.access$200((ConfigurationRecorder)new ConfigurationRecorder("Concurrent Tasks", dto -> dto.getConcurrentlySchedulableTaskCount() != null, AbstractPort::getMaxConcurrentTasks, null), (BiFunction)PORT_NAME_CONVERT), ConfigurationRecorder.access$200((ConfigurationRecorder)new ConfigurationRecorder("Compressed", dto -> dto.getUseCompression() != null, RemoteGroupPort::isUseCompression, null), (BiFunction)PORT_NAME_CONVERT), ConfigurationRecorder.access$200((ConfigurationRecorder)new ConfigurationRecorder("Batch Count", dto -> dto.getBatchSettings() != null && dto.getBatchSettings().getCount() != null, RemoteGroupPort::getBatchCount, null), (BiFunction)PORT_NAME_CONVERT), ConfigurationRecorder.access$200((ConfigurationRecorder)new ConfigurationRecorder("Batch Size", dto -> dto.getBatchSettings() != null && dto.getBatchSettings().getSize() != null, RemoteGroupPort::getBatchSize, null), (BiFunction)PORT_NAME_CONVERT), ConfigurationRecorder.access$200((ConfigurationRecorder)new ConfigurationRecorder("Batch Duration", dto -> dto.getBatchSettings() != null && dto.getBatchSettings().getDuration() != null, RemoteGroupPort::getBatchDuration, null), (BiFunction)PORT_NAME_CONVERT));

    @Around(value="within(org.apache.nifi.web.dao.RemoteProcessGroupDAO+) && execution(org.apache.nifi.groups.RemoteProcessGroup createRemoteProcessGroup(java.lang.String, org.apache.nifi.web.api.dto.RemoteProcessGroupDTO))")
    public RemoteProcessGroup createRemoteProcessGroupAdvice(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        RemoteProcessGroup remoteProcessGroup = (RemoteProcessGroup)proceedingJoinPoint.proceed();
        Action action = this.generateAuditRecord(remoteProcessGroup, Operation.Add);
        if (action != null) {
            this.saveAction(action, logger);
        }
        return remoteProcessGroup;
    }

    @Around(value="within(org.apache.nifi.web.dao.RemoteProcessGroupDAO+) && execution(org.apache.nifi.groups.RemoteProcessGroup updateRemoteProcessGroup(org.apache.nifi.web.api.dto.RemoteProcessGroupDTO)) && args(remoteProcessGroupDTO) && target(remoteProcessGroupDAO)")
    public RemoteProcessGroup auditUpdateProcessGroupConfiguration(ProceedingJoinPoint proceedingJoinPoint, RemoteProcessGroupDTO remoteProcessGroupDTO, RemoteProcessGroupDAO remoteProcessGroupDAO) throws Throwable {
        RemoteProcessGroup remoteProcessGroup = remoteProcessGroupDAO.getRemoteProcessGroup(remoteProcessGroupDTO.getId());
        boolean transmissionState = remoteProcessGroup.isTransmitting();
        Map previousValues = ConfigurationRecorder.access$300((List)CONFIG_RECORDERS, (Object)remoteProcessGroup);
        RemoteProcessGroup updatedRemoteProcessGroup = (RemoteProcessGroup)proceedingJoinPoint.proceed();
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        if (user != null) {
            boolean updatedTransmissionState;
            ArrayList details = new ArrayList();
            ConfigurationRecorder.access$400((List)CONFIG_RECORDERS, (Object)remoteProcessGroupDTO, (Object)updatedRemoteProcessGroup, (Map)previousValues, details);
            Date timestamp = new Date();
            ArrayList<FlowChangeAction> actions = new ArrayList<FlowChangeAction>();
            FlowChangeRemoteProcessGroupDetails remoteProcessGroupDetails = this.createFlowChangeDetails(remoteProcessGroup);
            if (!details.isEmpty()) {
                for (ActionDetails detail : details) {
                    FlowChangeAction remoteProcessGroupAction = this.createFlowChangeAction(user, timestamp, updatedRemoteProcessGroup, remoteProcessGroupDetails);
                    remoteProcessGroupAction.setOperation(Operation.Configure);
                    remoteProcessGroupAction.setActionDetails(detail);
                    actions.add(remoteProcessGroupAction);
                }
            }
            if (transmissionState != (updatedTransmissionState = updatedRemoteProcessGroup.isTransmitting())) {
                FlowChangeAction remoteProcessGroupAction = this.createFlowChangeAction(user, timestamp, updatedRemoteProcessGroup, remoteProcessGroupDetails);
                if (updatedTransmissionState) {
                    remoteProcessGroupAction.setOperation(Operation.Start);
                } else {
                    remoteProcessGroupAction.setOperation(Operation.Stop);
                }
                actions.add(remoteProcessGroupAction);
            }
            if (!actions.isEmpty()) {
                this.saveActions(actions, logger);
            }
        }
        return updatedRemoteProcessGroup;
    }

    private FlowChangeAction createFlowChangeAction(NiFiUser user, Date timestamp, RemoteProcessGroup remoteProcessGroup, FlowChangeRemoteProcessGroupDetails remoteProcessGroupDetails) {
        FlowChangeAction remoteProcessGroupAction = new FlowChangeAction();
        remoteProcessGroupAction.setUserIdentity(user.getIdentity());
        remoteProcessGroupAction.setTimestamp(timestamp);
        remoteProcessGroupAction.setSourceId(remoteProcessGroup.getIdentifier());
        remoteProcessGroupAction.setSourceName(remoteProcessGroup.getName());
        remoteProcessGroupAction.setSourceType(Component.RemoteProcessGroup);
        remoteProcessGroupAction.setComponentDetails((ComponentDetails)remoteProcessGroupDetails);
        return remoteProcessGroupAction;
    }

    @Around(value="within(org.apache.nifi.web.dao.RemoteProcessGroupDAO+) && execution(void deleteRemoteProcessGroup(java.lang.String)) && args(remoteProcessGroupId) && target(remoteProcessGroupDAO)")
    public void removeRemoteProcessGroupAdvice(ProceedingJoinPoint proceedingJoinPoint, String remoteProcessGroupId, RemoteProcessGroupDAO remoteProcessGroupDAO) throws Throwable {
        RemoteProcessGroup remoteProcessGroup = remoteProcessGroupDAO.getRemoteProcessGroup(remoteProcessGroupId);
        proceedingJoinPoint.proceed();
        Action action = this.generateAuditRecord(remoteProcessGroup, Operation.Remove);
        if (action != null) {
            this.saveAction(action, logger);
        }
    }

    private RemoteGroupPort auditUpdateProcessGroupPortConfiguration(ProceedingJoinPoint proceedingJoinPoint, RemoteProcessGroupPortDTO remoteProcessGroupPortDto, RemoteProcessGroup remoteProcessGroup, RemoteGroupPort remoteProcessGroupPort) throws Throwable {
        Map previousValues = ConfigurationRecorder.access$300((List)PORT_CONFIG_RECORDERS, (Object)remoteProcessGroupPort);
        RemoteGroupPort updatedRemoteProcessGroupPort = (RemoteGroupPort)proceedingJoinPoint.proceed();
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        if (user != null) {
            ArrayList details = new ArrayList();
            ConfigurationRecorder.access$400((List)PORT_CONFIG_RECORDERS, (Object)remoteProcessGroupPortDto, (Object)updatedRemoteProcessGroupPort, (Map)previousValues, details);
            Date timestamp = new Date();
            ArrayList<FlowChangeAction> actions = new ArrayList<FlowChangeAction>();
            FlowChangeRemoteProcessGroupDetails remoteProcessGroupDetails = this.createFlowChangeDetails(remoteProcessGroup);
            for (ActionDetails detail : details) {
                FlowChangeAction remoteProcessGroupAction = this.createFlowChangeAction(user, timestamp, remoteProcessGroup, remoteProcessGroupDetails);
                remoteProcessGroupAction.setOperation(Operation.Configure);
                remoteProcessGroupAction.setActionDetails(detail);
                actions.add(remoteProcessGroupAction);
            }
            if (!actions.isEmpty()) {
                this.saveActions(actions, logger);
            }
        }
        return updatedRemoteProcessGroupPort;
    }

    @Around(value="within(org.apache.nifi.web.dao.RemoteProcessGroupDAO+) && execution(org.apache.nifi.remote.RemoteGroupPort updateRemoteProcessGroupInputPort(java.lang.String, org.apache.nifi.web.api.dto.RemoteProcessGroupPortDTO)) && args(remoteProcessGroupId, remoteProcessGroupPortDto) && target(remoteProcessGroupDAO)")
    public RemoteGroupPort auditUpdateProcessGroupInputPortConfiguration(ProceedingJoinPoint proceedingJoinPoint, String remoteProcessGroupId, RemoteProcessGroupPortDTO remoteProcessGroupPortDto, RemoteProcessGroupDAO remoteProcessGroupDAO) throws Throwable {
        RemoteProcessGroup remoteProcessGroup = remoteProcessGroupDAO.getRemoteProcessGroup(remoteProcessGroupId);
        RemoteGroupPort remoteProcessGroupPort = remoteProcessGroup.getInputPort(remoteProcessGroupPortDto.getId());
        return this.auditUpdateProcessGroupPortConfiguration(proceedingJoinPoint, remoteProcessGroupPortDto, remoteProcessGroup, remoteProcessGroupPort);
    }

    @Around(value="within(org.apache.nifi.web.dao.RemoteProcessGroupDAO+) && execution(org.apache.nifi.remote.RemoteGroupPort updateRemoteProcessGroupOutputPort(java.lang.String, org.apache.nifi.web.api.dto.RemoteProcessGroupPortDTO)) && args(remoteProcessGroupId, remoteProcessGroupPortDto) && target(remoteProcessGroupDAO)")
    public RemoteGroupPort auditUpdateProcessGroupOutputPortConfiguration(ProceedingJoinPoint proceedingJoinPoint, String remoteProcessGroupId, RemoteProcessGroupPortDTO remoteProcessGroupPortDto, RemoteProcessGroupDAO remoteProcessGroupDAO) throws Throwable {
        RemoteProcessGroup remoteProcessGroup = remoteProcessGroupDAO.getRemoteProcessGroup(remoteProcessGroupId);
        RemoteGroupPort remoteProcessGroupPort = remoteProcessGroup.getOutputPort(remoteProcessGroupPortDto.getId());
        return this.auditUpdateProcessGroupPortConfiguration(proceedingJoinPoint, remoteProcessGroupPortDto, remoteProcessGroup, remoteProcessGroupPort);
    }

    private FlowChangeRemoteProcessGroupDetails createFlowChangeDetails(RemoteProcessGroup remoteProcessGroup) {
        FlowChangeRemoteProcessGroupDetails remoteProcessGroupDetails = new FlowChangeRemoteProcessGroupDetails();
        remoteProcessGroupDetails.setUri(remoteProcessGroup.getTargetUri());
        return remoteProcessGroupDetails;
    }

    public Action generateAuditRecord(RemoteProcessGroup remoteProcessGroup, Operation operation) {
        return this.generateAuditRecord(remoteProcessGroup, operation, null);
    }

    public Action generateAuditRecord(RemoteProcessGroup remoteProcessGroup, Operation operation, ActionDetails actionDetails) {
        FlowChangeAction action = null;
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        if (user != null) {
            FlowChangeRemoteProcessGroupDetails remoteProcessGroupDetails = this.createFlowChangeDetails(remoteProcessGroup);
            action = new FlowChangeAction();
            action.setUserIdentity(user.getIdentity());
            action.setOperation(operation);
            action.setTimestamp(new Date());
            action.setSourceId(remoteProcessGroup.getIdentifier());
            action.setSourceName(remoteProcessGroup.getName());
            action.setSourceType(Component.RemoteProcessGroup);
            action.setComponentDetails((ComponentDetails)remoteProcessGroupDetails);
            if (actionDetails != null) {
                action.setActionDetails(actionDetails);
            }
        }
        return action;
    }
}

