/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.Response;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.cluster.coordination.ClusterCoordinator;
import org.apache.nifi.cluster.coordination.http.replication.RequestReplicator;
import org.apache.nifi.cluster.exception.NoClusterCoordinatorException;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.controller.ScheduledState;
import org.apache.nifi.controller.service.ControllerServiceState;
import org.apache.nifi.web.NiFiServiceFacade;
import org.apache.nifi.web.Revision;
import org.apache.nifi.web.api.ApplicationResource;
import org.apache.nifi.web.api.dto.AffectedComponentDTO;
import org.apache.nifi.web.api.dto.ControllerServiceDTO;
import org.apache.nifi.web.api.dto.DtoFactory;
import org.apache.nifi.web.api.dto.RevisionDTO;
import org.apache.nifi.web.api.dto.status.ProcessorStatusDTO;
import org.apache.nifi.web.api.entity.ActivateControllerServicesEntity;
import org.apache.nifi.web.api.entity.AffectedComponentEntity;
import org.apache.nifi.web.api.entity.ComponentEntity;
import org.apache.nifi.web.api.entity.ControllerServiceEntity;
import org.apache.nifi.web.api.entity.ControllerServicesEntity;
import org.apache.nifi.web.api.entity.ProcessorEntity;
import org.apache.nifi.web.api.entity.ProcessorsEntity;
import org.apache.nifi.web.api.entity.ScheduleComponentsEntity;
import org.apache.nifi.web.util.AffectedComponentUtils;
import org.apache.nifi.web.util.ClusterReplicationComponentLifecycle;
import org.apache.nifi.web.util.ComponentLifecycle;
import org.apache.nifi.web.util.InvalidComponentAction;
import org.apache.nifi.web.util.LifecycleManagementException;
import org.apache.nifi.web.util.Pause;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterReplicationComponentLifecycle
implements ComponentLifecycle {
    private static final Logger logger = LoggerFactory.getLogger(ClusterReplicationComponentLifecycle.class);
    private ClusterCoordinator clusterCoordinator;
    private RequestReplicator requestReplicator;
    private NiFiServiceFacade serviceFacade;
    private DtoFactory dtoFactory;

    public Set<AffectedComponentEntity> scheduleComponents(URI exampleUri, String groupId, Set<AffectedComponentEntity> components, ScheduledState desiredState, Pause pause, InvalidComponentAction invalidComponentAction) throws LifecycleManagementException {
        URI scheduleGroupUri;
        Set componentIds = components.stream().map(ComponentEntity::getId).collect(Collectors.toSet());
        Map componentMap = components.stream().collect(Collectors.toMap(ComponentEntity::getId, Function.identity()));
        Map componentRevisionMap = this.getRevisions(groupId, componentIds);
        Map<String, RevisionDTO> componentRevisionDtoMap = componentRevisionMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.dtoFactory.createRevisionDTO((Revision)entry.getValue())));
        ScheduleComponentsEntity scheduleProcessorsEntity = new ScheduleComponentsEntity();
        scheduleProcessorsEntity.setComponents(componentRevisionDtoMap);
        scheduleProcessorsEntity.setId(groupId);
        scheduleProcessorsEntity.setState(desiredState.name());
        try {
            scheduleGroupUri = new URI(exampleUri.getScheme(), exampleUri.getUserInfo(), exampleUri.getHost(), exampleUri.getPort(), "/nifi-api/flow/process-groups/" + groupId, null, exampleUri.getFragment());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("content-type", "application/json");
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        if (desiredState == ScheduledState.RUNNING) {
            try {
                this.waitForProcessorValidation(user, exampleUri, groupId, componentMap, pause);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new LifecycleManagementException("Interrupted while waiting for processors to complete validation");
            }
        }
        try {
            NodeResponse clusterResponse = this.getReplicationTarget() == ApplicationResource.ReplicationTarget.CLUSTER_NODES ? this.getRequestReplicator().replicate(user, "PUT", scheduleGroupUri, (Object)scheduleProcessorsEntity, headers).awaitMergedResponse() : this.getRequestReplicator().forwardToCoordinator(this.getClusterCoordinatorNode(), user, "PUT", scheduleGroupUri, (Object)scheduleProcessorsEntity, headers).awaitMergedResponse();
            int scheduleComponentStatus = clusterResponse.getStatus();
            if (scheduleComponentStatus != Response.Status.OK.getStatusCode()) {
                String explanation = (String)this.getResponseEntity(clusterResponse, String.class);
                throw new LifecycleManagementException("Failed to transition components to a state of " + desiredState + " due to " + explanation);
            }
            boolean processorsTransitioned = this.waitForProcessorStatus(user, exampleUri, groupId, componentMap, desiredState, pause, invalidComponentAction);
            if (!processorsTransitioned) {
                throw new LifecycleManagementException("Failed while waiting for components to transition to state of " + desiredState);
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new LifecycleManagementException("Interrupted while attempting to transition components to state of " + desiredState);
        }
        Set<AffectedComponentEntity> updatedEntities = components.stream().map(component -> AffectedComponentUtils.updateEntity((AffectedComponentEntity)component, (NiFiServiceFacade)this.serviceFacade, (DtoFactory)this.dtoFactory)).collect(Collectors.toSet());
        return updatedEntities;
    }

    private ApplicationResource.ReplicationTarget getReplicationTarget() {
        return this.clusterCoordinator.isActiveClusterCoordinator() ? ApplicationResource.ReplicationTarget.CLUSTER_NODES : ApplicationResource.ReplicationTarget.CLUSTER_COORDINATOR;
    }

    private RequestReplicator getRequestReplicator() {
        return this.requestReplicator;
    }

    protected NodeIdentifier getClusterCoordinatorNode() {
        NodeIdentifier activeClusterCoordinator = this.clusterCoordinator.getElectedActiveCoordinatorNode();
        if (activeClusterCoordinator != null) {
            return activeClusterCoordinator;
        }
        throw new NoClusterCoordinatorException();
    }

    private Map<String, Revision> getRevisions(String groupId, Set<String> componentIds) {
        Set processorRevisions = this.serviceFacade.getRevisionsFromGroup(groupId, group -> componentIds);
        return processorRevisions.stream().collect(Collectors.toMap(Revision::getComponentId, Function.identity()));
    }

    private boolean waitForProcessorValidation(NiFiUser user, URI originalUri, String groupId, Map<String, AffectedComponentEntity> processors, Pause pause) throws InterruptedException {
        URI groupUri;
        try {
            groupUri = new URI(originalUri.getScheme(), originalUri.getUserInfo(), originalUri.getHost(), originalUri.getPort(), "/nifi-api/process-groups/" + groupId + "/processors", "includeDescendantGroups=true", originalUri.getFragment());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        HashMap headers = new HashMap();
        MultivaluedHashMap requestEntity = new MultivaluedHashMap();
        boolean continuePolling = true;
        while (continuePolling) {
            NodeResponse clusterResponse = this.getReplicationTarget() == ApplicationResource.ReplicationTarget.CLUSTER_NODES ? this.getRequestReplicator().replicate(user, "GET", groupUri, (Object)requestEntity, headers).awaitMergedResponse() : this.getRequestReplicator().forwardToCoordinator(this.getClusterCoordinatorNode(), user, "GET", groupUri, (Object)requestEntity, headers).awaitMergedResponse();
            if (clusterResponse.getStatus() != Response.Status.OK.getStatusCode()) {
                return false;
            }
            ProcessorsEntity processorsEntity = (ProcessorsEntity)this.getResponseEntity(clusterResponse, ProcessorsEntity.class);
            Set processorEntities = processorsEntity.getProcessors();
            if (this.isProcessorValidationComplete(processorEntities, processors)) {
                logger.debug("All {} processors of interest now have been validated", (Object)processors.size());
                return true;
            }
            continuePolling = pause.pause();
        }
        return false;
    }

    private boolean isProcessorValidationComplete(Set<ProcessorEntity> processorEntities, Map<String, AffectedComponentEntity> affectedComponents) {
        this.updateAffectedProcessors(processorEntities, affectedComponents);
        for (ProcessorEntity entity : processorEntities) {
            if (!affectedComponents.containsKey(entity.getId()) || !"VALIDATING".equals(entity.getComponent().getValidationStatus())) continue;
            return false;
        }
        return true;
    }

    private boolean waitForProcessorStatus(NiFiUser user, URI originalUri, String groupId, Map<String, AffectedComponentEntity> processors, ScheduledState desiredState, Pause pause, InvalidComponentAction invalidComponentAction) throws InterruptedException, LifecycleManagementException {
        URI groupUri;
        try {
            groupUri = new URI(originalUri.getScheme(), originalUri.getUserInfo(), originalUri.getHost(), originalUri.getPort(), "/nifi-api/process-groups/" + groupId + "/processors", "includeDescendantGroups=true", originalUri.getFragment());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        HashMap headers = new HashMap();
        MultivaluedHashMap requestEntity = new MultivaluedHashMap();
        boolean continuePolling = true;
        while (continuePolling) {
            NodeResponse clusterResponse = this.getReplicationTarget() == ApplicationResource.ReplicationTarget.CLUSTER_NODES ? this.getRequestReplicator().replicate(user, "GET", groupUri, (Object)requestEntity, headers).awaitMergedResponse() : this.getRequestReplicator().forwardToCoordinator(this.getClusterCoordinatorNode(), user, "GET", groupUri, (Object)requestEntity, headers).awaitMergedResponse();
            if (clusterResponse.getStatus() != Response.Status.OK.getStatusCode()) {
                return false;
            }
            ProcessorsEntity processorsEntity = (ProcessorsEntity)this.getResponseEntity(clusterResponse, ProcessorsEntity.class);
            Set processorEntities = processorsEntity.getProcessors();
            if (this.isProcessorActionComplete(processorEntities, processors, desiredState, invalidComponentAction)) {
                logger.debug("All {} processors of interest now have the desired state of {}", (Object)processors.size(), (Object)desiredState);
                return true;
            }
            continuePolling = pause.pause();
        }
        return false;
    }

    private <T> T getResponseEntity(NodeResponse nodeResponse, Class<T> clazz) {
        Object entity = nodeResponse.getUpdatedEntity();
        if (entity == null) {
            entity = nodeResponse.getClientResponse().readEntity(clazz);
        }
        return (T)entity;
    }

    private void updateAffectedProcessors(Set<ProcessorEntity> processorEntities, Map<String, AffectedComponentEntity> affectedComponents) {
        processorEntities.stream().filter(entity -> affectedComponents.containsKey(entity.getId())).forEach(entity -> {
            AffectedComponentEntity affectedComponentEntity = (AffectedComponentEntity)affectedComponents.get(entity.getId());
            affectedComponentEntity.setRevision(entity.getRevision());
            if (Boolean.TRUE.equals(affectedComponentEntity.getPermissions().getCanRead())) {
                AffectedComponentDTO affectedComponent = affectedComponentEntity.getComponent();
                affectedComponent.setState(entity.getStatus().getAggregateSnapshot().getRunStatus());
                affectedComponent.setActiveThreadCount(entity.getStatus().getAggregateSnapshot().getActiveThreadCount());
                if (Boolean.TRUE.equals(entity.getPermissions().getCanRead())) {
                    affectedComponent.setValidationErrors(entity.getComponent().getValidationErrors());
                }
            }
        });
    }

    private boolean isProcessorActionComplete(Set<ProcessorEntity> processorEntities, Map<String, AffectedComponentEntity> affectedComponents, ScheduledState desiredState, InvalidComponentAction invalidComponentAction) throws LifecycleManagementException {
        String desiredStateName = desiredState.name();
        this.updateAffectedProcessors(processorEntities, affectedComponents);
        block5: for (ProcessorEntity entity : processorEntities) {
            String runStatus;
            boolean stateMatches;
            if (!affectedComponents.containsKey(entity.getId())) continue;
            ProcessorStatusDTO status = entity.getStatus();
            if ("INVALID".equals(entity.getComponent().getValidationStatus())) {
                switch (1.$SwitchMap$org$apache$nifi$web$util$InvalidComponentAction[invalidComponentAction.ordinal()]) {
                    case 1: {
                        return false;
                    }
                    case 2: {
                        continue block5;
                    }
                    case 3: {
                        String action = desiredState == ScheduledState.RUNNING ? "start" : "stop";
                        throw new LifecycleManagementException("Could not " + action + " " + entity.getComponent().getName() + " because it is invalid");
                    }
                }
            }
            if (!(stateMatches = desiredStateName.equalsIgnoreCase(runStatus = status.getAggregateSnapshot().getRunStatus()))) {
                return false;
            }
            if (desiredState != ScheduledState.STOPPED || status.getAggregateSnapshot().getActiveThreadCount() == 0) continue;
            return false;
        }
        return true;
    }

    public Set<AffectedComponentEntity> activateControllerServices(URI originalUri, String groupId, Set<AffectedComponentEntity> affectedServices, ControllerServiceState desiredState, Pause pause, InvalidComponentAction invalidComponentAction) throws LifecycleManagementException {
        URI controllerServicesUri;
        Set affectedServiceIds = affectedServices.stream().map(ComponentEntity::getId).collect(Collectors.toSet());
        Map serviceRevisionMap = this.getRevisions(groupId, affectedServiceIds);
        Map<String, RevisionDTO> serviceRevisionDtoMap = serviceRevisionMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.dtoFactory.createRevisionDTO((Revision)entry.getValue())));
        ActivateControllerServicesEntity activateServicesEntity = new ActivateControllerServicesEntity();
        activateServicesEntity.setComponents(serviceRevisionDtoMap);
        activateServicesEntity.setId(groupId);
        activateServicesEntity.setState(desiredState.name());
        try {
            controllerServicesUri = new URI(originalUri.getScheme(), originalUri.getUserInfo(), originalUri.getHost(), originalUri.getPort(), "/nifi-api/flow/process-groups/" + groupId + "/controller-services", null, originalUri.getFragment());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("content-type", "application/json");
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        if (desiredState == ControllerServiceState.ENABLED) {
            try {
                this.waitForControllerServiceValidation(user, originalUri, groupId, affectedServiceIds, pause);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new LifecycleManagementException("Interrupted while waiting for Controller Services to complete validation");
            }
        }
        try {
            NodeResponse clusterResponse = this.getReplicationTarget() == ApplicationResource.ReplicationTarget.CLUSTER_NODES ? this.getRequestReplicator().replicate(user, "PUT", controllerServicesUri, (Object)activateServicesEntity, headers).awaitMergedResponse() : this.getRequestReplicator().forwardToCoordinator(this.getClusterCoordinatorNode(), user, "PUT", controllerServicesUri, (Object)activateServicesEntity, headers).awaitMergedResponse();
            int disableServicesStatus = clusterResponse.getStatus();
            if (disableServicesStatus != Response.Status.OK.getStatusCode()) {
                String explanation = (String)this.getResponseEntity(clusterResponse, String.class);
                throw new LifecycleManagementException("Failed to update Controller Services to a state of " + desiredState + " due to " + explanation);
            }
            boolean serviceTransitioned = this.waitForControllerServiceStatus(user, originalUri, groupId, affectedServiceIds, desiredState, pause, invalidComponentAction);
            if (!serviceTransitioned) {
                throw new LifecycleManagementException("Failed while waiting for Controller Services to finish transitioning to a state of " + desiredState);
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new LifecycleManagementException("Interrupted while transitioning Controller Services to a state of " + desiredState);
        }
        return affectedServices.stream().map(componentEntity -> this.serviceFacade.getControllerService(componentEntity.getId())).map(arg_0 -> ((DtoFactory)this.dtoFactory).createAffectedComponentEntity(arg_0)).collect(Collectors.toSet());
    }

    private boolean waitForControllerServiceValidation(NiFiUser user, URI originalUri, String groupId, Set<String> serviceIds, Pause pause) throws InterruptedException {
        URI groupUri;
        try {
            groupUri = new URI(originalUri.getScheme(), originalUri.getUserInfo(), originalUri.getHost(), originalUri.getPort(), "/nifi-api/flow/process-groups/" + groupId + "/controller-services", "includeAncestorGroups=false,includeDescendantGroups=true", originalUri.getFragment());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        HashMap headers = new HashMap();
        MultivaluedHashMap requestEntity = new MultivaluedHashMap();
        boolean continuePolling = true;
        while (continuePolling) {
            NodeResponse clusterResponse = this.getReplicationTarget() == ApplicationResource.ReplicationTarget.CLUSTER_NODES ? this.getRequestReplicator().replicate(user, "GET", groupUri, (Object)requestEntity, headers).awaitMergedResponse() : this.getRequestReplicator().forwardToCoordinator(this.getClusterCoordinatorNode(), user, "GET", groupUri, (Object)requestEntity, headers).awaitMergedResponse();
            if (clusterResponse.getStatus() != Response.Status.OK.getStatusCode()) {
                return false;
            }
            ControllerServicesEntity controllerServicesEntity = (ControllerServicesEntity)this.getResponseEntity(clusterResponse, ControllerServicesEntity.class);
            Set serviceEntities = controllerServicesEntity.getControllerServices();
            Map<String, AffectedComponentEntity> affectedServices = serviceEntities.stream().collect(Collectors.toMap(ComponentEntity::getId, arg_0 -> ((DtoFactory)this.dtoFactory).createAffectedComponentEntity(arg_0)));
            if (this.isControllerServiceValidationComplete(serviceEntities, affectedServices)) {
                logger.debug("All {} controller services of interest have completed validation", (Object)affectedServices.size());
                return true;
            }
            continuePolling = pause.pause();
        }
        return false;
    }

    private boolean isControllerServiceValidationComplete(Set<ControllerServiceEntity> controllerServiceEntities, Map<String, AffectedComponentEntity> affectedComponents) {
        this.updateAffectedControllerServices(controllerServiceEntities, affectedComponents);
        for (ControllerServiceEntity entity : controllerServiceEntities) {
            if (!affectedComponents.containsKey(entity.getId()) || !"VALIDATING".equals(entity.getComponent().getValidationStatus())) continue;
            return false;
        }
        return true;
    }

    private boolean waitForControllerServiceStatus(NiFiUser user, URI originalUri, String groupId, Set<String> serviceIds, ControllerServiceState desiredState, Pause pause, InvalidComponentAction invalidComponentAction) throws InterruptedException, LifecycleManagementException {
        URI groupUri;
        try {
            groupUri = new URI(originalUri.getScheme(), originalUri.getUserInfo(), originalUri.getHost(), originalUri.getPort(), "/nifi-api/flow/process-groups/" + groupId + "/controller-services", "includeAncestorGroups=false,includeDescendantGroups=true", originalUri.getFragment());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        HashMap headers = new HashMap();
        MultivaluedHashMap requestEntity = new MultivaluedHashMap();
        boolean continuePolling = true;
        while (continuePolling) {
            NodeResponse clusterResponse = this.getReplicationTarget() == ApplicationResource.ReplicationTarget.CLUSTER_NODES ? this.getRequestReplicator().replicate(user, "GET", groupUri, (Object)requestEntity, headers).awaitMergedResponse() : this.getRequestReplicator().forwardToCoordinator(this.getClusterCoordinatorNode(), user, "GET", groupUri, (Object)requestEntity, headers).awaitMergedResponse();
            if (clusterResponse.getStatus() != Response.Status.OK.getStatusCode()) {
                return false;
            }
            ControllerServicesEntity controllerServicesEntity = (ControllerServicesEntity)this.getResponseEntity(clusterResponse, ControllerServicesEntity.class);
            Set serviceEntities = controllerServicesEntity.getControllerServices();
            Map<String, AffectedComponentEntity> affectedServices = serviceEntities.stream().collect(Collectors.toMap(ComponentEntity::getId, arg_0 -> ((DtoFactory)this.dtoFactory).createAffectedComponentEntity(arg_0)));
            this.updateAffectedControllerServices(serviceEntities, affectedServices);
            String desiredStateName = desiredState.name();
            boolean allReachedDesiredState = true;
            block8: for (ControllerServiceEntity serviceEntity : serviceEntities) {
                ControllerServiceDTO serviceDto = serviceEntity.getComponent();
                if (serviceDto == null || !serviceIds.contains(serviceDto.getId())) continue;
                String validationStatus = serviceDto.getValidationStatus();
                if ("INVALID".equals(validationStatus)) {
                    switch (1.$SwitchMap$org$apache$nifi$web$util$InvalidComponentAction[invalidComponentAction.ordinal()]) {
                        case 1: {
                            allReachedDesiredState = false;
                            break;
                        }
                        case 2: {
                            continue block8;
                        }
                        case 3: {
                            String action = desiredState == ControllerServiceState.ENABLED ? "enable" : "disable";
                            throw new LifecycleManagementException("Could not " + action + " " + serviceEntity.getComponent().getName() + " because it is invalid");
                        }
                    }
                }
                if (desiredStateName.equalsIgnoreCase(serviceDto.getState())) continue;
                allReachedDesiredState = false;
                break;
            }
            if (allReachedDesiredState) {
                logger.debug("All {} controller services of interest now have the desired state of {}", (Object)affectedServices.size(), (Object)desiredState);
                return true;
            }
            continuePolling = pause.pause();
        }
        return false;
    }

    private void updateAffectedControllerServices(Set<ControllerServiceEntity> serviceEntities, Map<String, AffectedComponentEntity> affectedServices) {
        serviceEntities.stream().filter(entity -> affectedServices.containsKey(entity.getId())).forEach(entity -> {
            AffectedComponentEntity affectedComponentEntity = (AffectedComponentEntity)affectedServices.get(entity.getId());
            affectedComponentEntity.setRevision(entity.getRevision());
            if (Boolean.TRUE.equals(affectedComponentEntity.getPermissions().getCanRead())) {
                AffectedComponentDTO affectedComponent = affectedComponentEntity.getComponent();
                affectedComponent.setState(entity.getComponent().getState());
                if (Boolean.TRUE.equals(entity.getPermissions().getCanRead())) {
                    affectedComponent.setValidationErrors(entity.getComponent().getValidationErrors());
                }
            }
        });
    }

    public void setClusterCoordinator(ClusterCoordinator clusterCoordinator) {
        this.clusterCoordinator = clusterCoordinator;
    }

    public void setRequestReplicator(RequestReplicator requestReplicator) {
        this.requestReplicator = requestReplicator;
    }

    public void setDtoFactory(DtoFactory dtoFactory) {
        this.dtoFactory = dtoFactory;
    }

    public void setServiceFacade(NiFiServiceFacade serviceFacade) {
        this.serviceFacade = serviceFacade;
    }
}

