/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api.config;

import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.apache.nifi.authorization.AccessDeniedException;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class AccessDeniedExceptionMapper
implements ExceptionMapper<AccessDeniedException> {
    private static final Logger logger = LoggerFactory.getLogger(AccessDeniedExceptionMapper.class);

    public Response toResponse(AccessDeniedException exception) {
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        Response.Status status = user == null || user.isAnonymous() ? Response.Status.UNAUTHORIZED : Response.Status.FORBIDDEN;
        String identity = user == null ? "<no user found>" : user.getIdentity();
        logger.info(String.format("%s does not have permission to access the requested resource. Returning %s response.", identity, status));
        if (logger.isDebugEnabled()) {
            logger.debug("", (Throwable)exception);
        }
        return Response.status((Response.Status)status).entity((Object)"Unable to perform the desired action due to insufficient permissions. Contact the system administrator.").type("text/plain").build();
    }
}

