/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import com.wordnik.swagger.annotations.Authorization;
import java.util.HashMap;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.authorization.AccessDeniedException;
import org.apache.nifi.authorization.AuthorizationRequest;
import org.apache.nifi.authorization.AuthorizationResult;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.UserContextKeys;
import org.apache.nifi.authorization.resource.ResourceFactory;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.web.NiFiServiceFacade;
import org.apache.nifi.web.api.ApplicationResource;
import org.apache.nifi.web.api.dto.SystemDiagnosticsDTO;
import org.apache.nifi.web.api.entity.SystemDiagnosticsEntity;

@Path(value="/system-diagnostics")
@Api(value="/system-diagnostics", description="Endpoint for accessing system diagnostics.")
public class SystemDiagnosticsResource
extends ApplicationResource {
    private NiFiServiceFacade serviceFacade;
    private Authorizer authorizer;

    private void authorizeSystem() {
        HashMap<String, String> userContext;
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        if (!StringUtils.isBlank((CharSequence)user.getClientAddress())) {
            userContext = new HashMap<String, String>();
            userContext.put(UserContextKeys.CLIENT_ADDRESS.name(), user.getClientAddress());
        } else {
            userContext = null;
        }
        AuthorizationRequest request = new AuthorizationRequest.Builder().resource(ResourceFactory.getSystemResource()).identity(user.getIdentity()).anonymous(Boolean.valueOf(user.isAnonymous())).accessAttempt(Boolean.valueOf(true)).action(RequestAction.READ).userContext(userContext).build();
        AuthorizationResult result = this.authorizer.authorize(request);
        if (!AuthorizationResult.Result.Approved.equals((Object)result.getResult())) {
            String message = StringUtils.isNotBlank((CharSequence)result.getExplanation()) ? result.getExplanation() : "Access is denied";
            throw new AccessDeniedException(message);
        }
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Gets the diagnostics for the system NiFi is running on", response=SystemDiagnosticsEntity.class, authorizations={@Authorization(value="Read - /system", type="")})
    @ApiResponses(value={@ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request.")})
    public Response getSystemDiagnostics(@ApiParam(value="Whether or not to include the breakdown per node. Optional, defaults to false", required=false) @QueryParam(value="nodewise") @DefaultValue(value="false") Boolean nodewise, @ApiParam(value="The id of the node where to get the status.", required=false) @QueryParam(value="clusterNodeId") String clusterNodeId) throws InterruptedException {
        this.authorizeSystem();
        if (Boolean.TRUE.equals(nodewise) && clusterNodeId != null) {
            throw new IllegalArgumentException("Nodewise requests cannot be directed at a specific node.");
        }
        if (this.isReplicateRequest()) {
            if (clusterNodeId == null) {
                NodeResponse nodeResponse = this.getReplicationTarget() == ApplicationResource.ReplicationTarget.CLUSTER_NODES ? this.getRequestReplicator().replicate("GET", this.getAbsolutePath(), (Object)this.getRequestParameters(), this.getHeaders()).awaitMergedResponse() : this.getRequestReplicator().forwardToCoordinator(this.getClusterCoordinatorNode(), "GET", this.getAbsolutePath(), (Object)this.getRequestParameters(), this.getHeaders()).awaitMergedResponse();
                SystemDiagnosticsEntity entity = (SystemDiagnosticsEntity)nodeResponse.getUpdatedEntity();
                if (entity != null && !nodewise.booleanValue()) {
                    entity.getSystemDiagnostics().setNodeSnapshots(null);
                }
                return nodeResponse.getResponse();
            }
            return this.replicate("GET");
        }
        SystemDiagnosticsDTO systemDiagnosticsDto = this.serviceFacade.getSystemDiagnostics();
        SystemDiagnosticsEntity entity = new SystemDiagnosticsEntity();
        entity.setSystemDiagnostics(systemDiagnosticsDto);
        return this.clusterContext(this.generateOkResponse((Object)entity)).build();
    }

    public void setServiceFacade(NiFiServiceFacade serviceFacade) {
        this.serviceFacade = serviceFacade;
    }

    public void setAuthorizer(Authorizer authorizer) {
        this.authorizer = authorizer;
    }
}

