/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api;

import com.sun.jersey.api.core.ResourceContext;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import com.wordnik.swagger.annotations.Authorization;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.authorization.AccessDeniedException;
import org.apache.nifi.authorization.AuthorizableLookup;
import org.apache.nifi.authorization.AuthorizationRequest;
import org.apache.nifi.authorization.AuthorizationResult;
import org.apache.nifi.authorization.AuthorizeControllerServiceReference;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.ControllerServiceReferencingComponentAuthorizable;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.UserContextKeys;
import org.apache.nifi.authorization.resource.ResourceFactory;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.web.IllegalClusterResourceRequestException;
import org.apache.nifi.web.NiFiServiceFacade;
import org.apache.nifi.web.Revision;
import org.apache.nifi.web.api.ApplicationResource;
import org.apache.nifi.web.api.ControllerResource;
import org.apache.nifi.web.api.ControllerServiceResource;
import org.apache.nifi.web.api.ReportingTaskResource;
import org.apache.nifi.web.api.dto.ClusterDTO;
import org.apache.nifi.web.api.dto.ControllerServiceDTO;
import org.apache.nifi.web.api.dto.NodeDTO;
import org.apache.nifi.web.api.dto.ReportingTaskDTO;
import org.apache.nifi.web.api.entity.ClusterEntity;
import org.apache.nifi.web.api.entity.ComponentEntity;
import org.apache.nifi.web.api.entity.ControllerConfigurationEntity;
import org.apache.nifi.web.api.entity.ControllerServiceEntity;
import org.apache.nifi.web.api.entity.Entity;
import org.apache.nifi.web.api.entity.HistoryEntity;
import org.apache.nifi.web.api.entity.NodeEntity;
import org.apache.nifi.web.api.entity.ReportingTaskEntity;
import org.apache.nifi.web.api.request.DateTimeParameter;

@Path(value="/controller")
@Api(value="/controller", description="Provides realtime command and control of this NiFi instance")
public class ControllerResource
extends ApplicationResource {
    private NiFiServiceFacade serviceFacade;
    private Authorizer authorizer;
    private ReportingTaskResource reportingTaskResource;
    private ControllerServiceResource controllerServiceResource;
    @Context
    private ResourceContext resourceContext;

    private void authorizeController(RequestAction action) {
        HashMap<String, String> userContext;
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        if (!StringUtils.isBlank((CharSequence)user.getClientAddress())) {
            userContext = new HashMap<String, String>();
            userContext.put(UserContextKeys.CLIENT_ADDRESS.name(), user.getClientAddress());
        } else {
            userContext = null;
        }
        AuthorizationRequest request = new AuthorizationRequest.Builder().resource(ResourceFactory.getControllerResource()).identity(user.getIdentity()).anonymous(Boolean.valueOf(user.isAnonymous())).accessAttempt(Boolean.valueOf(true)).action(action).userContext(userContext).build();
        AuthorizationResult result = this.authorizer.authorize(request);
        if (!AuthorizationResult.Result.Approved.equals((Object)result.getResult())) {
            String message = StringUtils.isNotBlank((CharSequence)result.getExplanation()) ? result.getExplanation() : "Access is denied";
            throw new AccessDeniedException(message);
        }
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="config")
    @ApiOperation(value="Retrieves the configuration for this NiFi Controller", response=ControllerConfigurationEntity.class, authorizations={@Authorization(value="Read - /controller", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getControllerConfig() {
        this.authorizeController(RequestAction.READ);
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        ControllerConfigurationEntity entity = this.serviceFacade.getControllerConfiguration();
        return this.clusterContext(this.generateOkResponse((Object)entity)).build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="config")
    @ApiOperation(value="Retrieves the configuration for this NiFi", response=ControllerConfigurationEntity.class, authorizations={@Authorization(value="Write - /controller", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response updateControllerConfig(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The controller configuration.", required=true) ControllerConfigurationEntity requestConfigEntity) {
        if (requestConfigEntity == null || requestConfigEntity.getComponent() == null) {
            throw new IllegalArgumentException("Controller configuration must be specified");
        }
        if (requestConfigEntity.getRevision() == null) {
            throw new IllegalArgumentException("Revision must be specified.");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("PUT", (Object)requestConfigEntity);
        }
        Revision requestRevision = this.getRevision(requestConfigEntity.getRevision(), FlowController.class.getSimpleName());
        return this.withWriteLock(this.serviceFacade, (Entity)requestConfigEntity, requestRevision, lookup -> this.authorizeController(RequestAction.WRITE), null, (revision, configEntity) -> {
            ControllerConfigurationEntity entity = this.serviceFacade.updateControllerConfiguration(revision, configEntity.getComponent());
            return this.clusterContext(this.generateOkResponse((Object)entity)).build();
        });
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="reporting-tasks")
    @ApiOperation(value="Creates a new reporting task", response=ReportingTaskEntity.class, authorizations={@Authorization(value="Write - /controller", type=""), @Authorization(value="Read - any referenced Controller Services - /controller-services/{uuid}", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response createReportingTask(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The reporting task configuration details.", required=true) ReportingTaskEntity requestReportingTaskEntity) {
        if (requestReportingTaskEntity == null || requestReportingTaskEntity.getComponent() == null) {
            throw new IllegalArgumentException("Reporting task details must be specified.");
        }
        if (requestReportingTaskEntity.getRevision() == null || requestReportingTaskEntity.getRevision().getVersion() == null || requestReportingTaskEntity.getRevision().getVersion() != 0L) {
            throw new IllegalArgumentException("A revision of 0 must be specified when creating a new Reporting task.");
        }
        ReportingTaskDTO requestReportingTask = requestReportingTaskEntity.getComponent();
        if (requestReportingTask.getId() != null) {
            throw new IllegalArgumentException("Reporting task ID cannot be specified.");
        }
        if (StringUtils.isBlank((CharSequence)requestReportingTask.getType())) {
            throw new IllegalArgumentException("The type of reporting task to create must be specified.");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("POST", (Object)requestReportingTaskEntity);
        }
        return this.withWriteLock(this.serviceFacade, (Entity)requestReportingTaskEntity, lookup -> {
            this.authorizeController(RequestAction.WRITE);
            if (requestReportingTask.getProperties() != null) {
                ControllerServiceReferencingComponentAuthorizable authorizable = lookup.getReportingTaskByType(requestReportingTask.getType());
                AuthorizeControllerServiceReference.authorizeControllerServiceReferences((Map)requestReportingTask.getProperties(), (ControllerServiceReferencingComponentAuthorizable)authorizable, (Authorizer)this.authorizer, (AuthorizableLookup)lookup);
            }
        }, null, reportingTaskEntity -> {
            ReportingTaskDTO reportingTask = reportingTaskEntity.getComponent();
            reportingTask.setId(this.generateUuid());
            Revision revision = this.getRevision((ComponentEntity)reportingTaskEntity, reportingTask.getId());
            ReportingTaskEntity entity = this.serviceFacade.createReportingTask(revision, reportingTask);
            this.reportingTaskResource.populateRemainingReportingTaskEntityContent(entity);
            return this.clusterContext(this.generateCreatedResponse(URI.create(entity.getUri()), (Object)entity)).build();
        });
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="controller-services")
    @ApiOperation(value="Creates a new controller service", response=ControllerServiceEntity.class, authorizations={@Authorization(value="Write - /controller", type=""), @Authorization(value="Read - any referenced Controller Services - /controller-services/{uuid}", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response createControllerService(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The controller service configuration details.", required=true) ControllerServiceEntity requestControllerServiceEntity) {
        if (requestControllerServiceEntity == null || requestControllerServiceEntity.getComponent() == null) {
            throw new IllegalArgumentException("Controller service details must be specified.");
        }
        if (requestControllerServiceEntity.getRevision() == null || requestControllerServiceEntity.getRevision().getVersion() == null || requestControllerServiceEntity.getRevision().getVersion() != 0L) {
            throw new IllegalArgumentException("A revision of 0 must be specified when creating a new Controller service.");
        }
        ControllerServiceDTO requestControllerService = requestControllerServiceEntity.getComponent();
        if (requestControllerService.getId() != null) {
            throw new IllegalArgumentException("Controller service ID cannot be specified.");
        }
        if (requestControllerService.getParentGroupId() != null) {
            throw new IllegalArgumentException("Parent process group ID cannot be specified.");
        }
        if (StringUtils.isBlank((CharSequence)requestControllerService.getType())) {
            throw new IllegalArgumentException("The type of controller service to create must be specified.");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("POST", (Object)requestControllerServiceEntity);
        }
        return this.withWriteLock(this.serviceFacade, (Entity)requestControllerServiceEntity, lookup -> {
            this.authorizeController(RequestAction.WRITE);
            if (requestControllerService.getProperties() != null) {
                ControllerServiceReferencingComponentAuthorizable authorizable = lookup.getControllerServiceByType(requestControllerService.getType());
                AuthorizeControllerServiceReference.authorizeControllerServiceReferences((Map)requestControllerService.getProperties(), (ControllerServiceReferencingComponentAuthorizable)authorizable, (Authorizer)this.authorizer, (AuthorizableLookup)lookup);
            }
        }, null, controllerServiceEntity -> {
            ControllerServiceDTO controllerService = controllerServiceEntity.getComponent();
            controllerService.setId(this.generateUuid());
            Revision revision = this.getRevision((ComponentEntity)controllerServiceEntity, controllerService.getId());
            ControllerServiceEntity entity = this.serviceFacade.createControllerService(revision, null, controllerService);
            this.controllerServiceResource.populateRemainingControllerServiceEntityContent(entity);
            return this.clusterContext(this.generateCreatedResponse(URI.create(entity.getUri()), (Object)entity)).build();
        });
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="cluster")
    @ApiOperation(value="Gets the contents of the cluster", notes="Returns the contents of the cluster including all nodes and their status.", response=ClusterEntity.class, authorizations={@Authorization(value="Read - /controller", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getCluster() {
        this.authorizeController(RequestAction.READ);
        if (!this.isConnectedToCluster()) {
            throw new IllegalClusterResourceRequestException("Only a node connected to a cluster can process the request.");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("GET", this.getClusterCoordinatorNode());
        }
        ClusterDTO dto = this.serviceFacade.getCluster();
        ClusterEntity entity = new ClusterEntity();
        entity.setCluster(dto);
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="cluster/nodes/{id}")
    @ApiOperation(value="Gets a node in the cluster", response=NodeEntity.class, authorizations={@Authorization(value="Read - /controller", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getNode(@ApiParam(value="The node id.", required=true) @PathParam(value="id") String id) {
        this.authorizeController(RequestAction.READ);
        if (!this.isConnectedToCluster()) {
            throw new IllegalClusterResourceRequestException("Only a node connected to a cluster can process the request.");
        }
        NodeDTO dto = this.serviceFacade.getNode(id);
        NodeEntity entity = new NodeEntity();
        entity.setNode(dto);
        return this.generateOkResponse((Object)entity).build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="cluster/nodes/{id}")
    @ApiOperation(value="Updates a node in the cluster", response=NodeEntity.class, authorizations={@Authorization(value="Write - /controller", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response updateNode(@ApiParam(value="The node id.", required=true) @PathParam(value="id") String id, @ApiParam(value="The node configuration. The only configuration that will be honored at this endpoint is the status or primary flag.", required=true) NodeEntity nodeEntity) {
        this.authorizeController(RequestAction.WRITE);
        if (!this.isConnectedToCluster()) {
            throw new IllegalClusterResourceRequestException("Only a node connected to a cluster can process the request.");
        }
        if (nodeEntity == null || nodeEntity.getNode() == null) {
            throw new IllegalArgumentException("Node details must be specified.");
        }
        NodeDTO requestNodeDTO = nodeEntity.getNode();
        if (!id.equals(requestNodeDTO.getNodeId())) {
            throw new IllegalArgumentException(String.format("The node id (%s) in the request body does not equal the node id of the requested resource (%s).", requestNodeDTO.getNodeId(), id));
        }
        if (this.isReplicateRequest()) {
            return this.replicateToCoordinator("PUT", (Object)nodeEntity);
        }
        NodeDTO node = this.serviceFacade.updateNode(requestNodeDTO);
        NodeEntity entity = new NodeEntity();
        entity.setNode(node);
        return this.generateOkResponse((Object)entity).build();
    }

    @DELETE
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="cluster/nodes/{id}")
    @ApiOperation(value="Removes a node from the cluster", response=NodeEntity.class, authorizations={@Authorization(value="Write - /controller", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response deleteNode(@ApiParam(value="The node id.", required=true) @PathParam(value="id") String id) {
        this.authorizeController(RequestAction.WRITE);
        if (!this.isConnectedToCluster()) {
            throw new IllegalClusterResourceRequestException("Only a node connected to a cluster can process the request.");
        }
        if (this.isReplicateRequest()) {
            return this.replicateToCoordinator("DELETE", (Object)this.getRequestParameters());
        }
        this.serviceFacade.deleteNode(id);
        NodeEntity entity = new NodeEntity();
        return this.generateOkResponse((Object)entity).build();
    }

    @DELETE
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="history")
    @ApiOperation(value="Purges history", response=HistoryEntity.class, authorizations={@Authorization(value="Write - /controller", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response deleteHistory(@Context HttpServletRequest httpServletRequest, @ApiParam(value="Purge actions before this date/time.", required=true) @QueryParam(value="endDate") DateTimeParameter endDate) {
        if (endDate == null) {
            throw new IllegalArgumentException("The end date must be specified.");
        }
        return this.withWriteLock(this.serviceFacade, (Entity)new EndDateEntity(this, endDate.getDateTime()), lookup -> this.authorizeController(RequestAction.WRITE), null, endDateEtity -> {
            this.serviceFacade.deleteActions(endDateEtity.getEndDate());
            return this.generateOkResponse((Object)new HistoryEntity()).build();
        });
    }

    public void setServiceFacade(NiFiServiceFacade serviceFacade) {
        this.serviceFacade = serviceFacade;
    }

    public void setReportingTaskResource(ReportingTaskResource reportingTaskResource) {
        this.reportingTaskResource = reportingTaskResource;
    }

    public void setControllerServiceResource(ControllerServiceResource controllerServiceResource) {
        this.controllerServiceResource = controllerServiceResource;
    }

    public void setAuthorizer(Authorizer authorizer) {
        this.authorizer = authorizer;
    }
}

