/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.authorization;

import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.authorization.AccessDeniedException;
import org.apache.nifi.authorization.AccessPolicy;
import org.apache.nifi.authorization.AuthorizableLookup;
import org.apache.nifi.authorization.ConnectionAuthorizable;
import org.apache.nifi.authorization.ControllerServiceReferencingComponentAuthorizable;
import org.apache.nifi.authorization.ProcessGroupAuthorizable;
import org.apache.nifi.authorization.StandardAuthorizableLookup;
import org.apache.nifi.authorization.resource.AccessPolicyAuthorizable;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.resource.DataAuthorizable;
import org.apache.nifi.authorization.resource.DataTransferAuthorizable;
import org.apache.nifi.authorization.resource.ResourceType;
import org.apache.nifi.authorization.resource.TenantAuthorizable;
import org.apache.nifi.connectable.Connection;
import org.apache.nifi.controller.ConfiguredComponent;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.ReportingTaskNode;
import org.apache.nifi.controller.Snippet;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.ControllerServiceReference;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.groups.RemoteProcessGroup;
import org.apache.nifi.web.ResourceNotFoundException;
import org.apache.nifi.web.controller.ControllerFacade;
import org.apache.nifi.web.dao.AccessPolicyDAO;
import org.apache.nifi.web.dao.ConnectionDAO;
import org.apache.nifi.web.dao.ControllerServiceDAO;
import org.apache.nifi.web.dao.FunnelDAO;
import org.apache.nifi.web.dao.LabelDAO;
import org.apache.nifi.web.dao.PortDAO;
import org.apache.nifi.web.dao.ProcessGroupDAO;
import org.apache.nifi.web.dao.ProcessorDAO;
import org.apache.nifi.web.dao.RemoteProcessGroupDAO;
import org.apache.nifi.web.dao.ReportingTaskDAO;
import org.apache.nifi.web.dao.SnippetDAO;
import org.apache.nifi.web.dao.TemplateDAO;

class StandardAuthorizableLookup
implements AuthorizableLookup {
    private static final TenantAuthorizable TENANT_AUTHORIZABLE = new TenantAuthorizable();
    private static final Authorizable POLICIES_AUTHORIZABLE = new /* Unavailable Anonymous Inner Class!! */;
    private static final Authorizable PROVENANCE_AUTHORIZABLE = new /* Unavailable Anonymous Inner Class!! */;
    private static final Authorizable COUNTERS_AUTHORIZABLE = new /* Unavailable Anonymous Inner Class!! */;
    private ControllerFacade controllerFacade;
    private ProcessorDAO processorDAO;
    private ProcessGroupDAO processGroupDAO;
    private RemoteProcessGroupDAO remoteProcessGroupDAO;
    private LabelDAO labelDAO;
    private FunnelDAO funnelDAO;
    private SnippetDAO snippetDAO;
    private PortDAO inputPortDAO;
    private PortDAO outputPortDAO;
    private ConnectionDAO connectionDAO;
    private ControllerServiceDAO controllerServiceDAO;
    private ReportingTaskDAO reportingTaskDAO;
    private TemplateDAO templateDAO;
    private AccessPolicyDAO accessPolicyDAO;

    StandardAuthorizableLookup() {
    }

    public Authorizable getController() {
        return this.controllerFacade;
    }

    public ControllerServiceReferencingComponentAuthorizable getProcessor(String id) {
        ProcessorNode processorNode = this.processorDAO.getProcessor(id);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public ControllerServiceReferencingComponentAuthorizable getProcessorByType(String type) {
        try {
            ProcessorNode processorNode = this.controllerFacade.createTemporaryProcessor(type);
            return new /* Unavailable Anonymous Inner Class!! */;
        }
        catch (Exception e) {
            throw new AccessDeniedException("Unable to create processor to verify if it references any Controller Services.");
        }
    }

    public Authorizable getInputPort(String id) {
        return this.inputPortDAO.getPort(id);
    }

    public Authorizable getOutputPort(String id) {
        return this.outputPortDAO.getPort(id);
    }

    public ConnectionAuthorizable getConnection(String id) {
        Connection connection = this.connectionDAO.getConnection(id);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public ProcessGroupAuthorizable getProcessGroup(String id) {
        ProcessGroup processGroup = this.processGroupDAO.getProcessGroup(id);
        HashSet encapsulatedAuthorizables = new HashSet();
        processGroup.findAllProcessors().forEach(processor -> encapsulatedAuthorizables.add(processor));
        processGroup.findAllConnections().forEach(connection -> encapsulatedAuthorizables.add(connection));
        processGroup.findAllInputPorts().forEach(inputPort -> encapsulatedAuthorizables.add(inputPort));
        processGroup.findAllOutputPorts().forEach(outputPort -> encapsulatedAuthorizables.add(outputPort));
        processGroup.findAllFunnels().forEach(funnel -> encapsulatedAuthorizables.add(funnel));
        processGroup.findAllLabels().forEach(label -> encapsulatedAuthorizables.add(label));
        processGroup.findAllProcessGroups().forEach(childGroup -> encapsulatedAuthorizables.add(childGroup));
        processGroup.findAllRemoteProcessGroups().forEach(remoteProcessGroup -> encapsulatedAuthorizables.add(remoteProcessGroup));
        processGroup.findAllTemplates().forEach(template -> encapsulatedAuthorizables.add(template));
        processGroup.findAllControllerServices().forEach(controllerService -> encapsulatedAuthorizables.add(controllerService));
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public Authorizable getRemoteProcessGroup(String id) {
        return this.remoteProcessGroupDAO.getRemoteProcessGroup(id);
    }

    public Authorizable getRemoteProcessGroupInputPort(String remoteProcessGroupId, String id) {
        RemoteProcessGroup remoteProcessGroup = this.remoteProcessGroupDAO.getRemoteProcessGroup(remoteProcessGroupId);
        return remoteProcessGroup.getInputPort(id);
    }

    public Authorizable getRemoteProcessGroupOutputPort(String remoteProcessGroupId, String id) {
        RemoteProcessGroup remoteProcessGroup = this.remoteProcessGroupDAO.getRemoteProcessGroup(remoteProcessGroupId);
        return remoteProcessGroup.getOutputPort(id);
    }

    public Authorizable getLabel(String id) {
        return this.labelDAO.getLabel(id);
    }

    public Authorizable getFunnel(String id) {
        return this.funnelDAO.getFunnel(id);
    }

    public ControllerServiceReferencingComponentAuthorizable getControllerService(String id) {
        ControllerServiceNode controllerService = this.controllerServiceDAO.getControllerService(id);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public ControllerServiceReferencingComponentAuthorizable getControllerServiceByType(String type) {
        try {
            ControllerServiceNode controllerService = this.controllerFacade.createTemporaryControllerService(type);
            return new /* Unavailable Anonymous Inner Class!! */;
        }
        catch (Exception e) {
            throw new AccessDeniedException("Unable to create controller service to verify if it references any Controller Services.");
        }
    }

    public Authorizable getProvenance() {
        return PROVENANCE_AUTHORIZABLE;
    }

    public Authorizable getCounters() {
        return COUNTERS_AUTHORIZABLE;
    }

    private ConfiguredComponent findControllerServiceReferencingComponent(ControllerServiceReference referencingComponents, String id) {
        ConfiguredComponent reference = null;
        for (ConfiguredComponent component : referencingComponents.getReferencingComponents()) {
            ControllerServiceNode refControllerService;
            if (component.getIdentifier().equals(id)) {
                reference = component;
                break;
            }
            if (!(component instanceof ControllerServiceNode) || (reference = this.findControllerServiceReferencingComponent((refControllerService = (ControllerServiceNode)component).getReferences(), id)) == null) continue;
            break;
        }
        return reference;
    }

    public Authorizable getControllerServiceReferencingComponent(String controllerSeriveId, String id) {
        ControllerServiceNode controllerService = this.controllerServiceDAO.getControllerService(controllerSeriveId);
        ControllerServiceReference referencingComponents = controllerService.getReferences();
        ConfiguredComponent reference = this.findControllerServiceReferencingComponent(referencingComponents, id);
        if (reference == null) {
            throw new ResourceNotFoundException("Unable to find referencing component with id " + id);
        }
        return reference;
    }

    public ControllerServiceReferencingComponentAuthorizable getReportingTask(String id) {
        ReportingTaskNode reportingTaskNode = this.reportingTaskDAO.getReportingTask(id);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public ControllerServiceReferencingComponentAuthorizable getReportingTaskByType(String type) {
        try {
            ReportingTaskNode reportingTask = this.controllerFacade.createTemporaryReportingTask(type);
            return new /* Unavailable Anonymous Inner Class!! */;
        }
        catch (Exception e) {
            throw new AccessDeniedException("Unable to create reporting to verify if it references any Controller Services.");
        }
    }

    public Snippet getSnippet(String id) {
        return this.snippetDAO.getSnippet(id);
    }

    public Authorizable getTenant() {
        return TENANT_AUTHORIZABLE;
    }

    public Authorizable getData(String id) {
        return this.controllerFacade.getDataAuthorizable(id);
    }

    public Authorizable getPolicies() {
        return POLICIES_AUTHORIZABLE;
    }

    public Authorizable getAccessPolicyById(String id) {
        AccessPolicy policy = this.accessPolicyDAO.getAccessPolicy(id);
        return this.getAccessPolicyByResource(policy.getResource());
    }

    public Authorizable getAccessPolicyByResource(String resource) {
        try {
            return new AccessPolicyAuthorizable(this.getAuthorizableFromResource(resource));
        }
        catch (ResourceNotFoundException e) {
            return POLICIES_AUTHORIZABLE;
        }
    }

    public Authorizable getAuthorizableFromResource(String resource) {
        ResourceType resourceType = null;
        for (ResourceType type : ResourceType.values()) {
            if (!resource.equals(type.getValue()) && !resource.startsWith(type.getValue() + "/")) continue;
            resourceType = type;
        }
        if (resourceType == null) {
            throw new ResourceNotFoundException("Unrecognized resource: " + resource);
        }
        if (ResourceType.Policy.equals(resourceType) || ResourceType.Data.equals(resourceType) || ResourceType.DataTransfer.equals((Object)resourceType)) {
            ResourceType primaryResourceType = resourceType;
            resource = StringUtils.substringAfter((String)resource, (String)resourceType.getValue());
            for (ResourceType type : ResourceType.values()) {
                if (!resource.equals(type.getValue()) && !resource.startsWith(type.getValue() + "/")) continue;
                resourceType = type;
            }
            if (resourceType == null) {
                throw new ResourceNotFoundException("Unrecognized resource: " + resource);
            }
            if (ResourceType.Policy.equals((Object)primaryResourceType)) {
                return new AccessPolicyAuthorizable(this.getAccessPolicy(resourceType, resource));
            }
            if (ResourceType.Data.equals((Object)primaryResourceType)) {
                return new DataAuthorizable(this.getAccessPolicy(resourceType, resource));
            }
            return new DataTransferAuthorizable(this.getAccessPolicy(resourceType, resource));
        }
        return this.getAccessPolicy(resourceType, resource);
    }

    private Authorizable getAccessPolicy(ResourceType resourceType, String resource) {
        String slashComponentId = StringUtils.substringAfter((String)resource, (String)resourceType.getValue());
        if (slashComponentId.startsWith("/")) {
            return this.getAccessPolicyByResource(resourceType, slashComponentId.substring(1));
        }
        return this.getAccessPolicyByResource(resourceType);
    }

    private Authorizable getAccessPolicyByResource(ResourceType resourceType, String componentId) {
        Authorizable authorizable = null;
        switch (19.$SwitchMap$org$apache$nifi$authorization$resource$ResourceType[resourceType.ordinal()]) {
            case 1: {
                authorizable = this.getControllerService(componentId).getAuthorizable();
                break;
            }
            case 2: {
                authorizable = this.getFunnel(componentId);
                break;
            }
            case 3: {
                authorizable = this.getInputPort(componentId);
                break;
            }
            case 4: {
                authorizable = this.getLabel(componentId);
                break;
            }
            case 5: {
                authorizable = this.getOutputPort(componentId);
                break;
            }
            case 6: {
                authorizable = this.getProcessor(componentId).getAuthorizable();
                break;
            }
            case 7: {
                authorizable = this.getProcessGroup(componentId).getAuthorizable();
                break;
            }
            case 8: {
                authorizable = this.getRemoteProcessGroup(componentId);
                break;
            }
            case 9: {
                authorizable = this.getReportingTask(componentId).getAuthorizable();
                break;
            }
            case 10: {
                authorizable = this.getTemplate(componentId);
                break;
            }
            case 11: {
                authorizable = this.controllerFacade.getDataAuthorizable(componentId);
            }
        }
        if (authorizable == null) {
            throw new IllegalArgumentException("An unexpected type of resource in this policy " + resourceType.getValue());
        }
        return authorizable;
    }

    private Authorizable getAccessPolicyByResource(ResourceType resourceType) {
        Authorizable authorizable = null;
        switch (19.$SwitchMap$org$apache$nifi$authorization$resource$ResourceType[resourceType.ordinal()]) {
            case 12: {
                authorizable = this.getController();
                break;
            }
            case 13: {
                authorizable = new /* Unavailable Anonymous Inner Class!! */;
                break;
            }
            case 14: {
                authorizable = new /* Unavailable Anonymous Inner Class!! */;
                break;
            }
            case 15: {
                authorizable = new /* Unavailable Anonymous Inner Class!! */;
                break;
            }
            case 16: {
                authorizable = new /* Unavailable Anonymous Inner Class!! */;
                break;
            }
            case 17: {
                authorizable = POLICIES_AUTHORIZABLE;
                break;
            }
            case 18: {
                authorizable = new /* Unavailable Anonymous Inner Class!! */;
                break;
            }
            case 19: {
                authorizable = new /* Unavailable Anonymous Inner Class!! */;
                break;
            }
            case 20: {
                authorizable = new /* Unavailable Anonymous Inner Class!! */;
                break;
            }
            case 21: {
                authorizable = this.getTenant();
            }
        }
        if (authorizable == null) {
            throw new IllegalArgumentException("An unexpected type of resource in this policy " + resourceType.getValue());
        }
        return authorizable;
    }

    public Authorizable getTemplate(String id) {
        return this.templateDAO.getTemplate(id);
    }

    public Authorizable getConnectable(String id) {
        ProcessGroup group = this.processGroupDAO.getProcessGroup(this.controllerFacade.getRootGroupId());
        return group.findConnectable(id);
    }

    public void setProcessorDAO(ProcessorDAO processorDAO) {
        this.processorDAO = processorDAO;
    }

    public void setProcessGroupDAO(ProcessGroupDAO processGroupDAO) {
        this.processGroupDAO = processGroupDAO;
    }

    public void setRemoteProcessGroupDAO(RemoteProcessGroupDAO remoteProcessGroupDAO) {
        this.remoteProcessGroupDAO = remoteProcessGroupDAO;
    }

    public void setLabelDAO(LabelDAO labelDAO) {
        this.labelDAO = labelDAO;
    }

    public void setFunnelDAO(FunnelDAO funnelDAO) {
        this.funnelDAO = funnelDAO;
    }

    public void setSnippetDAO(SnippetDAO snippetDAO) {
        this.snippetDAO = snippetDAO;
    }

    public void setInputPortDAO(PortDAO inputPortDAO) {
        this.inputPortDAO = inputPortDAO;
    }

    public void setOutputPortDAO(PortDAO outputPortDAO) {
        this.outputPortDAO = outputPortDAO;
    }

    public void setConnectionDAO(ConnectionDAO connectionDAO) {
        this.connectionDAO = connectionDAO;
    }

    public void setControllerServiceDAO(ControllerServiceDAO controllerServiceDAO) {
        this.controllerServiceDAO = controllerServiceDAO;
    }

    public void setReportingTaskDAO(ReportingTaskDAO reportingTaskDAO) {
        this.reportingTaskDAO = reportingTaskDAO;
    }

    public void setTemplateDAO(TemplateDAO templateDAO) {
        this.templateDAO = templateDAO;
    }

    public void setAccessPolicyDAO(AccessPolicyDAO accessPolicyDAO) {
        this.accessPolicyDAO = accessPolicyDAO;
    }

    public void setControllerFacade(ControllerFacade controllerFacade) {
        this.controllerFacade = controllerFacade;
    }
}

