/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.audit;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.apache.nifi.action.Action;
import org.apache.nifi.action.Component;
import org.apache.nifi.action.FlowChangeAction;
import org.apache.nifi.action.Operation;
import org.apache.nifi.action.component.details.ComponentDetails;
import org.apache.nifi.action.component.details.FlowChangeRemoteProcessGroupDetails;
import org.apache.nifi.action.details.ActionDetails;
import org.apache.nifi.action.details.FlowChangeConfigureDetails;
import org.apache.nifi.audit.NiFiAuditor;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.groups.RemoteProcessGroup;
import org.apache.nifi.remote.RemoteGroupPort;
import org.apache.nifi.web.api.dto.RemoteProcessGroupContentsDTO;
import org.apache.nifi.web.api.dto.RemoteProcessGroupDTO;
import org.apache.nifi.web.api.dto.RemoteProcessGroupPortDTO;
import org.apache.nifi.web.dao.RemoteProcessGroupDAO;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class RemoteProcessGroupAuditor
extends NiFiAuditor {
    private static final Logger logger = LoggerFactory.getLogger(RemoteProcessGroupAuditor.class);

    @Around(value="within(org.apache.nifi.web.dao.RemoteProcessGroupDAO+) && execution(org.apache.nifi.groups.RemoteProcessGroup createRemoteProcessGroup(java.lang.String, org.apache.nifi.web.api.dto.RemoteProcessGroupDTO))")
    public RemoteProcessGroup createRemoteProcessGroupAdvice(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        RemoteProcessGroup remoteProcessGroup = (RemoteProcessGroup)proceedingJoinPoint.proceed();
        Action action = this.generateAuditRecord(remoteProcessGroup, Operation.Add);
        if (action != null) {
            this.saveAction(action, logger);
        }
        return remoteProcessGroup;
    }

    @Around(value="within(org.apache.nifi.web.dao.RemoteProcessGroupDAO+) && execution(org.apache.nifi.groups.RemoteProcessGroup updateRemoteProcessGroup(org.apache.nifi.web.api.dto.RemoteProcessGroupDTO)) && args(remoteProcessGroupDTO) && target(remoteProcessGroupDAO)")
    public RemoteProcessGroup auditUpdateProcessGroupConfiguration(ProceedingJoinPoint proceedingJoinPoint, RemoteProcessGroupDTO remoteProcessGroupDTO, RemoteProcessGroupDAO remoteProcessGroupDAO) throws Throwable {
        RemoteProcessGroup remoteProcessGroup = remoteProcessGroupDAO.getRemoteProcessGroup(remoteProcessGroupDTO.getId());
        boolean transmissionState = remoteProcessGroup.isTransmitting();
        String communicationsTimeout = remoteProcessGroup.getCommunicationsTimeout();
        String yieldDuration = remoteProcessGroup.getYieldDuration();
        HashMap<String, Integer> concurrentTasks = new HashMap<String, Integer>();
        HashMap<String, Boolean> compression = new HashMap<String, Boolean>();
        for (RemoteGroupPort remotePort : remoteProcessGroup.getInputPorts()) {
            concurrentTasks.put(remotePort.getIdentifier(), remotePort.getMaxConcurrentTasks());
            compression.put(remotePort.getIdentifier(), remotePort.isUseCompression());
        }
        for (RemoteGroupPort remotePort : remoteProcessGroup.getOutputPorts()) {
            concurrentTasks.put(remotePort.getIdentifier(), remotePort.getMaxConcurrentTasks());
            compression.put(remotePort.getIdentifier(), remotePort.isUseCompression());
        }
        RemoteProcessGroup updatedRemoteProcessGroup = (RemoteProcessGroup)proceedingJoinPoint.proceed();
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        if (user != null) {
            boolean updatedTransmissionState;
            FlowChangeConfigureDetails configDetails;
            ArrayList<FlowChangeConfigureDetails> details = new ArrayList<FlowChangeConfigureDetails>();
            if (remoteProcessGroupDTO.getCommunicationsTimeout() != null && !updatedRemoteProcessGroup.getCommunicationsTimeout().equals(communicationsTimeout)) {
                configDetails = new FlowChangeConfigureDetails();
                configDetails.setName("Communications Timeout");
                configDetails.setValue(updatedRemoteProcessGroup.getCommunicationsTimeout());
                configDetails.setPreviousValue(communicationsTimeout);
                details.add(configDetails);
            }
            if (remoteProcessGroupDTO.getYieldDuration() != null && !updatedRemoteProcessGroup.getYieldDuration().equals(yieldDuration)) {
                configDetails = new FlowChangeConfigureDetails();
                configDetails.setName("Yield Duration");
                configDetails.setValue(updatedRemoteProcessGroup.getYieldDuration());
                configDetails.setPreviousValue(yieldDuration);
                details.add(configDetails);
            }
            if (remoteProcessGroupDTO.getContents() != null) {
                FlowChangeConfigureDetails compressionDetails;
                FlowChangeConfigureDetails concurrentTasksDetails;
                Object remotePort;
                RemoteProcessGroupContentsDTO contents = remoteProcessGroupDTO.getContents();
                if (contents.getInputPorts() != null) {
                    for (RemoteProcessGroupPortDTO remotePortDTO : contents.getInputPorts()) {
                        Boolean bl;
                        Integer n;
                        remotePort = updatedRemoteProcessGroup.getInputPort(remotePortDTO.getId());
                        if (remotePort == null) continue;
                        if (remotePortDTO.getConcurrentlySchedulableTaskCount() != null && (n = (Integer)concurrentTasks.get(remotePortDTO.getId())) != null && remotePort.getMaxConcurrentTasks() != n.intValue()) {
                            concurrentTasksDetails = new FlowChangeConfigureDetails();
                            concurrentTasksDetails.setName("Concurrent Tasks");
                            concurrentTasksDetails.setValue(String.valueOf(remotePort.getMaxConcurrentTasks()));
                            concurrentTasksDetails.setPreviousValue(String.valueOf(n));
                            details.add(concurrentTasksDetails);
                        }
                        if (remotePortDTO.getUseCompression() == null || (bl = (Boolean)compression.get(remotePortDTO.getId())) == null || remotePort.isUseCompression() == bl.booleanValue()) continue;
                        compressionDetails = new FlowChangeConfigureDetails();
                        compressionDetails.setName("Compressed");
                        compressionDetails.setValue(String.valueOf(remotePort.isUseCompression()));
                        compressionDetails.setPreviousValue(String.valueOf(bl));
                        details.add(compressionDetails);
                    }
                }
                if (contents.getOutputPorts() != null) {
                    for (RemoteProcessGroupPortDTO remotePortDTO : contents.getOutputPorts()) {
                        Boolean bl;
                        Integer n;
                        remotePort = updatedRemoteProcessGroup.getOutputPort(remotePortDTO.getId());
                        if (remotePort == null) continue;
                        if (remotePortDTO.getConcurrentlySchedulableTaskCount() != null && (n = (Integer)concurrentTasks.get(remotePortDTO.getId())) != null && remotePort.getMaxConcurrentTasks() != n.intValue()) {
                            concurrentTasksDetails = new FlowChangeConfigureDetails();
                            concurrentTasksDetails.setName("Concurrent Tasks");
                            concurrentTasksDetails.setValue(String.valueOf(remotePort.getMaxConcurrentTasks()));
                            concurrentTasksDetails.setPreviousValue(String.valueOf(n));
                            details.add(concurrentTasksDetails);
                        }
                        if (remotePortDTO.getUseCompression() == null || (bl = (Boolean)compression.get(remotePortDTO.getId())) == null || remotePort.isUseCompression() == bl.booleanValue()) continue;
                        compressionDetails = new FlowChangeConfigureDetails();
                        compressionDetails.setName("Compressed");
                        compressionDetails.setValue(String.valueOf(remotePort.isUseCompression()));
                        compressionDetails.setPreviousValue(String.valueOf(bl));
                        details.add(compressionDetails);
                    }
                }
            }
            ArrayList<FlowChangeAction> actions = new ArrayList<FlowChangeAction>();
            FlowChangeRemoteProcessGroupDetails remoteProcessGroupDetails = new FlowChangeRemoteProcessGroupDetails();
            remoteProcessGroupDetails.setUri(remoteProcessGroup.getTargetUri().toString());
            if (!details.isEmpty()) {
                Date timestamp = new Date();
                for (ActionDetails actionDetails : details) {
                    FlowChangeAction remoteProcessGroupAction = new FlowChangeAction();
                    remoteProcessGroupAction.setUserIdentity(user.getIdentity());
                    remoteProcessGroupAction.setOperation(Operation.Configure);
                    remoteProcessGroupAction.setTimestamp(timestamp);
                    remoteProcessGroupAction.setSourceId(updatedRemoteProcessGroup.getIdentifier());
                    remoteProcessGroupAction.setSourceName(updatedRemoteProcessGroup.getName());
                    remoteProcessGroupAction.setSourceType(Component.RemoteProcessGroup);
                    remoteProcessGroupAction.setComponentDetails((ComponentDetails)remoteProcessGroupDetails);
                    remoteProcessGroupAction.setActionDetails(actionDetails);
                    actions.add(remoteProcessGroupAction);
                }
            }
            if (transmissionState != (updatedTransmissionState = updatedRemoteProcessGroup.isTransmitting())) {
                FlowChangeAction remoteProcessGroupAction = new FlowChangeAction();
                remoteProcessGroupAction.setUserIdentity(user.getIdentity());
                remoteProcessGroupAction.setTimestamp(new Date());
                remoteProcessGroupAction.setSourceId(updatedRemoteProcessGroup.getIdentifier());
                remoteProcessGroupAction.setSourceName(updatedRemoteProcessGroup.getName());
                remoteProcessGroupAction.setSourceType(Component.RemoteProcessGroup);
                remoteProcessGroupAction.setComponentDetails((ComponentDetails)remoteProcessGroupDetails);
                if (updatedTransmissionState) {
                    remoteProcessGroupAction.setOperation(Operation.Start);
                } else {
                    remoteProcessGroupAction.setOperation(Operation.Stop);
                }
                actions.add(remoteProcessGroupAction);
            }
            if (!actions.isEmpty()) {
                this.saveActions(actions, logger);
            }
        }
        return updatedRemoteProcessGroup;
    }

    @Around(value="within(org.apache.nifi.web.dao.RemoteProcessGroupDAO+) && execution(void deleteRemoteProcessGroup(java.lang.String)) && args(remoteProcessGroupId) && target(remoteProcessGroupDAO)")
    public void removeRemoteProcessGroupAdvice(ProceedingJoinPoint proceedingJoinPoint, String remoteProcessGroupId, RemoteProcessGroupDAO remoteProcessGroupDAO) throws Throwable {
        RemoteProcessGroup remoteProcessGroup = remoteProcessGroupDAO.getRemoteProcessGroup(remoteProcessGroupId);
        proceedingJoinPoint.proceed();
        Action action = this.generateAuditRecord(remoteProcessGroup, Operation.Remove);
        if (action != null) {
            this.saveAction(action, logger);
        }
    }

    public Action generateAuditRecord(RemoteProcessGroup remoteProcessGroup, Operation operation) {
        return this.generateAuditRecord(remoteProcessGroup, operation, null);
    }

    public Action generateAuditRecord(RemoteProcessGroup remoteProcessGroup, Operation operation, ActionDetails actionDetails) {
        FlowChangeAction action = null;
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        if (user != null) {
            FlowChangeRemoteProcessGroupDetails remoteProcessGroupDetails = new FlowChangeRemoteProcessGroupDetails();
            remoteProcessGroupDetails.setUri(remoteProcessGroup.getTargetUri().toString());
            action = new FlowChangeAction();
            action.setUserIdentity(user.getIdentity());
            action.setOperation(operation);
            action.setTimestamp(new Date());
            action.setSourceId(remoteProcessGroup.getIdentifier());
            action.setSourceName(remoteProcessGroup.getName());
            action.setSourceType(Component.RemoteProcessGroup);
            action.setComponentDetails((ComponentDetails)remoteProcessGroupDetails);
            if (actionDetails != null) {
                action.setActionDetails(actionDetails);
            }
        }
        return action;
    }
}

