/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.result.nifi;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.nifi.toolkit.cli.api.ResultType;
import org.apache.nifi.toolkit.cli.impl.result.AbstractWritableResult;
import org.apache.nifi.toolkit.cli.impl.result.writer.DynamicTableWriter;
import org.apache.nifi.toolkit.cli.impl.result.writer.Table;
import org.apache.nifi.web.api.dto.NodeDTO;
import org.apache.nifi.web.api.entity.ClusterEntity;
import org.glassfish.jersey.internal.guava.Lists;

public class NodesResult
extends AbstractWritableResult<ClusterEntity> {
    private final ClusterEntity clusterEntity;

    public NodesResult(ResultType resultType, ClusterEntity clusterEntity) {
        super(resultType);
        this.clusterEntity = Objects.requireNonNull(clusterEntity);
    }

    @Override
    public ClusterEntity getResult() {
        return this.clusterEntity;
    }

    @Override
    protected void writeSimpleResult(PrintStream output) throws IOException {
        Table table = new Table.Builder().column("#", 3, 3, false).column("Node ID", 36, 36, false).column("Node Address", 36, 36, true).column("API Port", 8, 8, false).column("Node Status", 13, 13, false).build();
        ArrayList nodes = Lists.newArrayList((Iterable)this.clusterEntity.getCluster().getNodes());
        for (int i = 0; i < nodes.size(); ++i) {
            NodeDTO nodeDTO = (NodeDTO)nodes.get(i);
            table.addRow(String.valueOf(i), nodeDTO.getNodeId(), nodeDTO.getAddress(), String.valueOf(nodeDTO.getApiPort()), nodeDTO.getStatus());
        }
        DynamicTableWriter tableWriter = new DynamicTableWriter();
        tableWriter.write(table, output);
    }
}

