/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.params;

import java.io.IOException;
import java.util.Collections;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.toolkit.cli.api.CommandException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.AbstractNiFiCommand;
import org.apache.nifi.toolkit.cli.impl.result.StringResult;
import org.apache.nifi.toolkit.client.NiFiClient;
import org.apache.nifi.toolkit.client.NiFiClientException;
import org.apache.nifi.toolkit.client.ParamContextClient;
import org.apache.nifi.web.api.dto.ParameterContextDTO;
import org.apache.nifi.web.api.entity.ParameterContextEntity;

public class CreateParamContext
extends AbstractNiFiCommand<StringResult> {
    public CreateParamContext() {
        super("create-param-context", StringResult.class);
    }

    @Override
    public String getDescription() {
        return "Creates a parameter context with the given name. After creating the parameter context, parameters can be added using the set-param command.";
    }

    @Override
    protected void doInitialize(Context context) {
        super.doInitialize(context);
        this.addOption(CommandOption.PARAM_CONTEXT_NAME.createOption());
        this.addOption(CommandOption.PARAM_CONTEXT_DESC.createOption());
    }

    @Override
    public StringResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, MissingOptionException, CommandException {
        String paramContextName = this.getRequiredArg(properties, CommandOption.PARAM_CONTEXT_NAME);
        String paramContextDesc = this.getArg(properties, CommandOption.PARAM_CONTEXT_DESC);
        ParameterContextDTO paramContextDTO = new ParameterContextDTO();
        paramContextDTO.setName(paramContextName);
        paramContextDTO.setParameters(Collections.emptySet());
        if (!StringUtils.isBlank((CharSequence)paramContextDesc)) {
            paramContextDTO.setDescription(paramContextDesc);
        }
        ParameterContextEntity paramContextEntity = new ParameterContextEntity();
        paramContextEntity.setComponent(paramContextDTO);
        paramContextEntity.setRevision(this.getInitialRevisionDTO());
        ParamContextClient paramContextClient = client.getParamContextClient();
        ParameterContextEntity createdParamContext = paramContextClient.createParamContext(paramContextEntity);
        return new StringResult(createdParamContext.getId(), this.isInteractive());
    }
}

