/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.result.registry;

import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.apache.nifi.registry.extension.component.TagCount;
import org.apache.nifi.toolkit.cli.api.ResultType;
import org.apache.nifi.toolkit.cli.impl.result.AbstractWritableResult;
import org.apache.nifi.toolkit.cli.impl.result.writer.DynamicTableWriter;
import org.apache.nifi.toolkit.cli.impl.result.writer.Table;

public class TagCountResult
extends AbstractWritableResult<List<TagCount>> {
    private final List<TagCount> tagCounts;

    public TagCountResult(ResultType resultType, List<TagCount> tagCounts) {
        super(resultType);
        this.tagCounts = tagCounts;
        Validate.notNull(this.tagCounts);
    }

    @Override
    protected void writeSimpleResult(PrintStream output) throws IOException {
        if (this.tagCounts.isEmpty()) {
            return;
        }
        Table table = new Table.Builder().column("Tag", 20, 200, false).column("Count", 5, 20, false).build();
        for (int i = 0; i < this.tagCounts.size(); ++i) {
            TagCount tagCount = this.tagCounts.get(i);
            table.addRow(tagCount.getTag(), String.valueOf(tagCount.getCount()));
        }
        DynamicTableWriter tableWriter = new DynamicTableWriter();
        tableWriter.write(table, output);
    }

    @Override
    public List<TagCount> getResult() {
        return this.tagCounts;
    }
}

